/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

class HardElementInfo
implements SmartPointerElementInfo {
    private final PsiElement myElement;
    private final Project myProject;

    public HardElementInfo(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/HardElementInfo.<init> must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/smartPointers/HardElementInfo.<init> must not be null");
        }
        this.myElement = element;
        this.myProject = project;
    }

    @Override
    public Document getDocumentToSynchronize() {
        return null;
    }

    @Override
    public void fastenBelt(int offset, RangeMarker[] cachedRangeMarker) {
    }

    @Override
    public void unfastenBelt(int offset) {
    }

    @Override
    public PsiElement restoreElement() {
        return this.myElement;
    }

    @Override
    public int elementHashCode() {
        return this.myElement.hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/HardElementInfo.pointsToTheSameElementAs must not be null");
        }
        return Comparing.equal(this.myElement, other.restoreElement());
    }

    @Override
    public VirtualFile getVirtualFile() {
        return PsiUtilCore.getVirtualFile(this.myElement);
    }

    @Override
    public Segment getRange() {
        return this.myElement.getTextRange();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/HardElementInfo.getProject must not return null");
        }
        return project;
    }
}

