/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import org.jetbrains.annotations.NotNull;

class FileElementInfo
implements SmartPointerElementInfo {
    protected final VirtualFile myVirtualFile;
    protected final Project myProject;
    protected final Language myLanguage;

    public FileElementInfo(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/FileElementInfo.<init> must not be null");
        }
        this(file.getProject(), file.getVirtualFile(), file.getLanguage());
    }

    protected FileElementInfo(@NotNull Project project, VirtualFile virtualFile) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/FileElementInfo.<init> must not be null");
        }
        this(project, virtualFile, null);
    }

    protected FileElementInfo(@NotNull Project project, VirtualFile virtualFile, Language lang) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/FileElementInfo.<init> must not be null");
        }
        this.myVirtualFile = virtualFile;
        this.myProject = project;
        this.myLanguage = lang;
    }

    @Override
    public Document getDocumentToSynchronize() {
        return null;
    }

    @Override
    public void fastenBelt(int offset, RangeMarker[] cachedRangeMarker) {
    }

    @Override
    public void unfastenBelt(int offset) {
    }

    @Override
    public PsiElement restoreElement() {
        return SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, this.myLanguage);
    }

    @Override
    public int elementHashCode() {
        return this.myVirtualFile.hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/FileElementInfo.pointsToTheSameElementAs must not be null");
        }
        if (other instanceof FileElementInfo) {
            return Comparing.equal(this.myVirtualFile, ((FileElementInfo)other).myVirtualFile);
        }
        return Comparing.equal(this.restoreElement(), other.restoreElement());
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Override
    public Segment getRange() {
        return new TextRange(0, (int)this.myVirtualFile.getLength());
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/FileElementInfo.getProject must not return null");
        }
        return project;
    }
}

