/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NotNull;

public class ClsReferenceParameterListImpl
extends ClsElementImpl
implements PsiReferenceParameterList {
    private final PsiElement myParent;
    private final ClsTypeElementImpl[] myTypeParameters;
    private volatile PsiType[] myTypeParametersCachedTypes = null;

    public ClsReferenceParameterListImpl(PsiElement parent, String[] classParameters) {
        this.myParent = parent;
        int length = classParameters.length;
        this.myTypeParameters = new ClsTypeElementImpl[length];
        for (int i = 0; i < length; ++i) {
            String s = classParameters[length - i - 1];
            char variance = '\u0000';
            if (s.startsWith("?extends")) {
                variance = '+';
                s = s.substring("?extends".length());
            } else if (s.startsWith("?super")) {
                variance = '-';
                s = s.substring("?super".length());
            } else if (StringUtil.startsWithChar(s, '?')) {
                variance = '*';
                s = s.substring(1);
            }
            this.myTypeParameters[i] = new ClsTypeElementImpl(this, s, variance);
        }
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsReferenceParameterListImpl.appendMirrorText must not be null");
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsReferenceParameterListImpl.setMirror must not be null");
        }
    }

    @Override
    @NotNull
    public PsiTypeElement[] getTypeParameterElements() {
        if (this.myTypeParameters == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsReferenceParameterListImpl.getTypeParameterElements must not return null");
        }
        return this.myTypeParameters;
    }

    @Override
    @NotNull
    public PsiType[] getTypeArguments() {
        PsiType[] cachedTypes = this.myTypeParametersCachedTypes;
        if (cachedTypes == null) {
            cachedTypes = this.myTypeParameters.length == 0 ? PsiType.EMPTY_ARRAY : new PsiType[this.myTypeParameters.length];
            for (int i = 0; i < cachedTypes.length; ++i) {
                cachedTypes[cachedTypes.length - i - 1] = this.myTypeParameters[i].getType();
            }
            this.myTypeParametersCachedTypes = cachedTypes;
        }
        if (cachedTypes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsReferenceParameterListImpl.getTypeArguments must not return null");
        }
        return cachedTypes;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        if (this.myTypeParameters == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsReferenceParameterListImpl.getChildren must not return null");
        }
        return this.myTypeParameters;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }
}

