/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.messages.MessageBus;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class PsiModificationTrackerImpl
implements PsiTreeChangePreprocessor,
PsiModificationTracker {
    private final AtomicLong myModificationCount = new AtomicLong(0L);
    private final AtomicLong myOutOfCodeBlockModificationCount = new AtomicLong(0L);
    private final AtomicLong myJavaStructureModificationCount = new AtomicLong(0L);
    private final PsiModificationTracker.Listener myPublisher;

    public PsiModificationTrackerImpl(Project project) {
        MessageBus bus = project.getMessageBus();
        this.myPublisher = (PsiModificationTracker.Listener)bus.syncPublisher(TOPIC);
        bus.connect().subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        PsiModificationTrackerImpl.this.incCounter();
                    }
                });
            }

            public void exitDumbMode() {
                this.enteredDumbMode();
            }
        });
    }

    public void incCounter() {
        this.myModificationCount.getAndIncrement();
        this.myJavaStructureModificationCount.getAndIncrement();
        this.myOutOfCodeBlockModificationCount.getAndIncrement();
        this.myPublisher.modificationCountChanged();
    }

    public void incOutOfCodeBlockModificationCounter() {
        this.myModificationCount.getAndIncrement();
        this.myOutOfCodeBlockModificationCount.getAndIncrement();
        this.myPublisher.modificationCountChanged();
    }

    @Override
    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiModificationTrackerImpl.treeChanged must not be null");
        }
        this.myModificationCount.getAndIncrement();
        if (event.getParent() instanceof PsiDirectory) {
            this.myOutOfCodeBlockModificationCount.getAndIncrement();
        }
        this.myPublisher.modificationCountChanged();
    }

    @Override
    public long getModificationCount() {
        return this.myModificationCount.get();
    }

    @Override
    public long getOutOfCodeBlockModificationCount() {
        return this.myOutOfCodeBlockModificationCount.get();
    }

    @Override
    public long getJavaStructureModificationCount() {
        return this.myJavaStructureModificationCount.get();
    }
}

