/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaHighlightingUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaUtil {
    private static final Logger LOG = Logger.getInstance("#" + LambdaUtil.class.getName());
    @NonNls
    public static final String JAVA_LANG_FUNCTIONAL_INTERFACE = "java.lang.FunctionalInterface";

    @Nullable
    public static PsiType getFunctionalInterfaceReturnType(PsiLambdaExpression expr) {
        return LambdaUtil.getFunctionalInterfaceReturnType(expr.getFunctionalInterfaceType());
    }

    @Nullable
    public static PsiType getFunctionalInterfaceReturnType(@Nullable PsiType functionalInterfaceType) {
        MethodSignature methodSignature;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null && (methodSignature = LambdaUtil.getFunction(psiClass)) != null) {
            PsiType returnType = LambdaUtil.getReturnType(psiClass, methodSignature);
            return resolveResult.getSubstitutor().substitute(returnType);
        }
        return null;
    }

    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(@Nullable PsiType functionalInterfaceType) {
        return LambdaUtil.getFunctionalInterfaceMethod(PsiUtil.resolveGenericsClassInType(functionalInterfaceType));
    }

    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(PsiClassType.ClassResolveResult result) {
        MethodSignature methodSignature;
        PsiClass psiClass = result.getElement();
        if (psiClass != null && (methodSignature = LambdaUtil.getFunction(psiClass)) != null) {
            return LambdaUtil.getMethod(psiClass, methodSignature);
        }
        return null;
    }

    public static PsiSubstitutor getSubstitutor(@NotNull PsiMethod method, @NotNull PsiClassType.ClassResolveResult resolveResult) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/LambdaUtil.getSubstitutor must not be null");
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/LambdaUtil.getSubstitutor must not be null");
        }
        PsiClass derivedClass = resolveResult.getElement();
        LOG.assertTrue(derivedClass != null);
        PsiClass methodContainingClass = method.getContainingClass();
        LOG.assertTrue(methodContainingClass != null);
        PsiSubstitutor initialSubst = resolveResult.getSubstitutor();
        PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(methodContainingClass, derivedClass, PsiSubstitutor.EMPTY);
        for (PsiTypeParameter param : superClassSubstitutor.getSubstitutionMap().keySet()) {
            PsiType substitute = superClassSubstitutor.substitute(param);
            if (substitute == null) continue;
            initialSubst = initialSubst.put(param, initialSubst.substitute(substitute));
        }
        return initialSubst;
    }

    public static boolean isValidLambdaContext(PsiElement context) {
        return context instanceof PsiTypeCastExpression || context instanceof PsiAssignmentExpression || context instanceof PsiVariable || context instanceof PsiLambdaExpression || context instanceof PsiReturnStatement || context instanceof PsiExpressionList || context instanceof PsiParenthesizedExpression || context instanceof PsiArrayInitializerExpression || context instanceof PsiConditionalExpression;
    }

    public static boolean isLambdaFullyInferred(PsiLambdaExpression expression, PsiType functionalInterfaceType) {
        boolean hasParams;
        boolean bl = hasParams = expression.getParameterList().getParametersCount() > 0;
        if (hasParams || LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType) != PsiType.VOID) {
            if (hasParams && !LambdaUtil.checkRawAcceptable(expression, functionalInterfaceType)) {
                return false;
            }
            return !LambdaUtil.dependsOnTypeParams(functionalInterfaceType, functionalInterfaceType, expression, new PsiTypeParameter[0]);
        }
        return true;
    }

    private static boolean checkRawAcceptable(PsiLambdaExpression expression, PsiType functionalInterfaceType) {
        PsiElement parent = expression.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiExpressionList) {
            PsiElement gParent = parent.getParent();
            if (gParent instanceof PsiMethodCallExpression) {
                PsiType type;
                PsiExpression qualifierExpression = ((PsiMethodCallExpression)gParent).getMethodExpression().getQualifierExpression();
                PsiType psiType = type = qualifierExpression != null ? qualifierExpression.getType() : null;
                if (type instanceof PsiClassType && ((PsiClassType)type).isRaw()) {
                    return true;
                }
                PsiMethod method = ((PsiMethodCallExpression)gParent).resolveMethod();
                if (method != null) {
                    int lambdaIdx = LambdaUtil.getLambdaIdx((PsiExpressionList)parent, expression);
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    PsiType normalizedType = LambdaUtil.getNormalizedType(parameters[LambdaUtil.adjustLambdaIdx(lambdaIdx, method, parameters)]);
                    if (normalizedType instanceof PsiClassType && ((PsiClassType)normalizedType).isRaw()) {
                        return true;
                    }
                }
            }
            if (functionalInterfaceType instanceof PsiClassType && ((PsiClassType)functionalInterfaceType).isRaw()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isAcceptable(PsiLambdaExpression lambdaExpression, PsiType leftType, boolean checkReturnType) {
        PsiType[] parameterTypes;
        if (leftType instanceof PsiIntersectionType) {
            for (PsiType conjunctType : ((PsiIntersectionType)leftType).getConjuncts()) {
                if (!LambdaUtil.isAcceptable(lambdaExpression, conjunctType, checkReturnType)) continue;
                return true;
            }
            return false;
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(GenericsUtil.eliminateWildcards(leftType));
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass instanceof PsiAnonymousClass) {
            return LambdaUtil.isAcceptable(lambdaExpression, ((PsiAnonymousClass)psiClass).getBaseClassType(), checkReturnType);
        }
        MethodSignature methodSignature = LambdaUtil.getFunction(psiClass);
        if (methodSignature == null) {
            return false;
        }
        PsiParameter[] lambdaParameters = lambdaExpression.getParameterList().getParameters();
        if (lambdaParameters.length != (parameterTypes = methodSignature.getParameterTypes()).length) {
            return false;
        }
        int length = lambdaParameters.length;
        for (int lambdaParamIdx = 0; lambdaParamIdx < length; ++lambdaParamIdx) {
            PsiParameter parameter = lambdaParameters[lambdaParamIdx];
            PsiTypeElement typeElement = parameter.getTypeElement();
            if (typeElement == null) continue;
            PsiType lambdaFormalType = typeElement.getType();
            PsiType methodParameterType = parameterTypes[lambdaParamIdx];
            if (lambdaFormalType instanceof PsiPrimitiveType) {
                if (methodParameterType instanceof PsiPrimitiveType) {
                    return methodParameterType.equals(lambdaFormalType);
                }
                return false;
            }
            if (TypeConversionUtil.erasure(lambdaFormalType).isAssignableFrom(TypeConversionUtil.erasure(GenericsUtil.eliminateWildcards(resolveResult.getSubstitutor().substitute(methodSignature.getSubstitutor().substitute(methodParameterType)))))) continue;
            return false;
        }
        if (checkReturnType) {
            String uniqueVarName = JavaCodeStyleManager.getInstance(lambdaExpression.getProject()).suggestUniqueVariableName("l", (PsiElement)lambdaExpression, true);
            String canonicalText = leftType.getCanonicalText();
            if (leftType instanceof PsiEllipsisType) {
                canonicalText = ((PsiEllipsisType)leftType).toArrayType().getCanonicalText();
            }
            PsiStatement assignmentFromText = JavaPsiFacade.getElementFactory(lambdaExpression.getProject()).createStatementFromText(canonicalText + " " + uniqueVarName + " = " + lambdaExpression.getText(), lambdaExpression);
            PsiLocalVariable localVariable = (PsiLocalVariable)((PsiDeclarationStatement)assignmentFromText).getDeclaredElements()[0];
            LOG.assertTrue(psiClass != null);
            PsiType methodReturnType = LambdaUtil.getReturnType(psiClass, methodSignature);
            if (methodReturnType != null) {
                methodReturnType = resolveResult.getSubstitutor().substitute(methodSignature.getSubstitutor().substitute(methodReturnType));
                return LambdaHighlightingUtil.checkReturnTypeCompatible((PsiLambdaExpression)localVariable.getInitializer(), methodReturnType) == null;
            }
        }
        return true;
    }

    @Nullable
    static MethodSignature getFunction(PsiClass psiClass) {
        if (psiClass == null) {
            return null;
        }
        List<MethodSignature> functions = LambdaUtil.findFunctionCandidates(psiClass);
        if (functions != null && functions.size() == 1) {
            return functions.get(0);
        }
        return null;
    }

    private static boolean overridesPublicObjectMethod(PsiMethod psiMethod) {
        boolean overrideObject = false;
        for (PsiMethod superMethod : psiMethod.findDeepestSuperMethods()) {
            PsiClass containingClass = superMethod.getContainingClass();
            if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName()) || !superMethod.hasModifierProperty("public")) continue;
            overrideObject = true;
            break;
        }
        return overrideObject;
    }

    private static MethodSignature getMethodSignature(PsiMethod method, PsiClass psiClass, PsiClass containingClass) {
        MethodSignature methodSignature = containingClass != null && containingClass != psiClass ? method.getSignature(TypeConversionUtil.getSuperClassSubstitutor(containingClass, psiClass, PsiSubstitutor.EMPTY)) : method.getSignature(PsiSubstitutor.EMPTY);
        return methodSignature;
    }

    @Nullable
    private static List<MethodSignature> hasSubsignature(List<MethodSignature> signatures) {
        for (MethodSignature signature : signatures) {
            boolean subsignature = true;
            for (MethodSignature methodSignature : signatures) {
                if (signature.equals(methodSignature) || MethodSignatureUtil.isSubsignature(signature, methodSignature)) continue;
                subsignature = false;
                break;
            }
            if (!subsignature) continue;
            return Collections.singletonList(signature);
        }
        return signatures;
    }

    @Nullable
    static List<MethodSignature> findFunctionCandidates(PsiClass psiClass) {
        if (psiClass instanceof PsiAnonymousClass) {
            psiClass = PsiUtil.resolveClassInType(((PsiAnonymousClass)psiClass).getBaseClassType());
        }
        if (psiClass != null && psiClass.isInterface()) {
            ArrayList<MethodSignature> methods = new ArrayList<MethodSignature>();
            Collection<HierarchicalMethodSignature> visibleSignatures = psiClass.getVisibleSignatures();
            for (HierarchicalMethodSignature signature : visibleSignatures) {
                PsiMethod psiMethod = signature.getMethod();
                if (!psiMethod.hasModifierProperty("abstract") || psiMethod.hasModifierProperty("static") || LambdaUtil.overridesPublicObjectMethod(psiMethod)) continue;
                methods.add(signature);
            }
            return LambdaUtil.hasSubsignature(methods);
        }
        return null;
    }

    @Nullable
    private static PsiType getReturnType(PsiClass psiClass, MethodSignature methodSignature) {
        PsiMethod method = LambdaUtil.getMethod(psiClass, methodSignature);
        if (method != null) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            return TypeConversionUtil.getSuperClassSubstitutor(containingClass, psiClass, PsiSubstitutor.EMPTY).substitute(method.getReturnType());
        }
        return null;
    }

    @Nullable
    private static PsiMethod getMethod(PsiClass psiClass, MethodSignature methodSignature) {
        PsiMethod[] methodsByName;
        for (PsiMethod psiMethod : methodsByName = psiClass.findMethodsByName(methodSignature.getName(), true)) {
            if (!MethodSignatureUtil.areSignaturesEqual(LambdaUtil.getMethodSignature(psiMethod, psiClass, psiMethod.getContainingClass()), methodSignature)) continue;
            return psiMethod;
        }
        return null;
    }

    public static int getLambdaIdx(PsiExpressionList expressionList, PsiElement element) {
        PsiExpression[] expressions = expressionList.getExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression expression = expressions[i];
            if (!PsiTreeUtil.isAncestor(expression, element, false)) continue;
            return i;
        }
        return -1;
    }

    public static boolean dependsOnTypeParams(PsiType type, PsiLambdaExpression expr, PsiTypeParameter param2Check) {
        return LambdaUtil.depends(type, new TypeParamsChecker(expr), param2Check);
    }

    public static boolean dependsOnTypeParams(PsiType type, PsiType functionalInterfaceType, PsiElement lambdaExpression, PsiTypeParameter ... param2Check) {
        return LambdaUtil.depends(type, new TypeParamsChecker(lambdaExpression, PsiUtil.resolveClassInType(functionalInterfaceType)), param2Check);
    }

    public static boolean dependsOnTypeParams(PsiType type, PsiClass aClass, PsiMethod aMethod) {
        return LambdaUtil.depends(type, new TypeParamsChecker(aMethod, aClass), new PsiTypeParameter[0]);
    }

    static boolean depends(PsiType type, TypeParamsChecker visitor, PsiTypeParameter ... param2Check) {
        if (!visitor.startedInference()) {
            return false;
        }
        Boolean accept = type.accept(visitor);
        if (param2Check.length > 0) {
            return visitor.used(param2Check);
        }
        return accept != null && accept != false;
    }

    public static boolean isFreeFromTypeInferenceArgs(final PsiParameter[] methodParameters, final PsiLambdaExpression lambdaExpression, PsiExpression expression, final PsiSubstitutor subst, final PsiType functionalInterfaceType, PsiTypeParameter typeParam) {
        PsiTypeElement[] typeParameterElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference;
        if (expression instanceof PsiCallExpression && ((PsiCallExpression)expression).getTypeArguments().length > 0) {
            return true;
        }
        if (expression instanceof PsiNewExpression && (classReference = ((PsiNewExpression)expression).getClassOrAnonymousClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (typeParameterElements = parameterList.getTypeParameterElements()).length > 0 && !(typeParameterElements[0].getType() instanceof PsiDiamondType)) {
            return true;
        }
        final PsiParameter[] lambdaParams = lambdaExpression.getParameterList().getParameters();
        if (lambdaParams.length != methodParameters.length) {
            return false;
        }
        final boolean[] independent = new boolean[]{true};
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(functionalInterfaceType);
        if (interfaceMethod == null) {
            return false;
        }
        final TypeParamsChecker paramsChecker = new TypeParamsChecker(lambdaExpression);
        for (PsiParameter parameter : interfaceMethod.getParameterList().getParameters()) {
            subst.substitute(parameter.getType()).accept(paramsChecker);
        }
        paramsChecker.myUsedTypeParams.add(typeParam);
        expression.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitConditionalExpression(PsiConditionalExpression expression) {
                PsiExpression elseExpression;
                PsiExpression thenExpression = expression.getThenExpression();
                if (thenExpression != null) {
                    thenExpression.accept(this);
                }
                if ((elseExpression = expression.getElseExpression()) != null) {
                    elseExpression.accept(this);
                }
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                int usedParamIdx = -1;
                for (int i = 0; i < lambdaParams.length; ++i) {
                    PsiParameter param = lambdaParams[i];
                    if (!expression.isReferenceTo(param)) continue;
                    usedParamIdx = i;
                    break;
                }
                if (usedParamIdx > -1 && LambdaUtil.dependsOnTypeParams(subst.substitute(methodParameters[usedParamIdx].getType()), functionalInterfaceType, lambdaExpression, paramsChecker.myUsedTypeParams.toArray(new PsiTypeParameter[paramsChecker.myUsedTypeParams.size()]))) {
                    independent[0] = false;
                }
            }
        });
        return independent[0];
    }

    @Nullable
    public static PsiType getFunctionalInterfaceType(PsiElement expression, boolean tryToSubstitute) {
        return LambdaUtil.getFunctionalInterfaceType(expression, tryToSubstitute, -1);
    }

    @Nullable
    public static PsiType getFunctionalInterfaceType(PsiElement expression, boolean tryToSubstitute, int paramIdx) {
        PsiElement parent = expression.getParent();
        PsiElement element = expression;
        while (!(!(parent instanceof PsiParenthesizedExpression) && !(parent instanceof PsiConditionalExpression) || parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getThenExpression() != element && ((PsiConditionalExpression)parent).getElseExpression() != element)) {
            element = parent;
            parent = parent.getParent();
        }
        if (parent instanceof PsiArrayInitializerExpression) {
            PsiType psiType = ((PsiArrayInitializerExpression)parent).getType();
            if (psiType instanceof PsiArrayType) {
                return ((PsiArrayType)psiType).getComponentType();
            }
        } else {
            PsiType parentInterfaceType;
            if (parent instanceof PsiTypeCastExpression) {
                return ((PsiTypeCastExpression)parent).getType();
            }
            if (parent instanceof PsiVariable) {
                return ((PsiVariable)parent).getType();
            }
            if (parent instanceof PsiAssignmentExpression && expression instanceof PsiExpression && !PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression)) {
                PsiExpression lExpression = ((PsiAssignmentExpression)parent).getLExpression();
                return lExpression.getType();
            }
            if (parent instanceof PsiExpressionList) {
                PsiExpressionList expressionList = (PsiExpressionList)parent;
                int lambdaIdx = LambdaUtil.getLambdaIdx(expressionList, expression);
                if (lambdaIdx > -1) {
                    PsiElement gParent;
                    Pair<PsiMethod, PsiSubstitutor> method;
                    PsiType cachedType = null;
                    Map<PsiElement, Pair<PsiMethod, PsiSubstitutor>> currentMethodCandidates = MethodCandidateInfo.CURRENT_CANDIDATE.get();
                    Pair<PsiMethod, PsiSubstitutor> pair = method = currentMethodCandidates != null ? currentMethodCandidates.get(parent) : null;
                    if (method != null) {
                        PsiParameter[] parameters = ((PsiMethod)method.first).getParameterList().getParameters();
                        PsiType psiType = cachedType = lambdaIdx < parameters.length ? ((PsiSubstitutor)method.second).substitute(LambdaUtil.getNormalizedType(parameters[LambdaUtil.adjustLambdaIdx(lambdaIdx, (PsiMethod)method.first, parameters)])) : null;
                        if (!tryToSubstitute) {
                            return cachedType;
                        }
                    }
                    if ((gParent = expressionList.getParent()) instanceof PsiCall) {
                        PsiParameter[] parameters;
                        int finalLambdaIdx;
                        PsiCall contextCall = (PsiCall)gParent;
                        final JavaResolveResult resolveResult = contextCall.resolveMethodGenerics();
                        PsiElement resolve = resolveResult.getElement();
                        if (resolve instanceof PsiMethod && (finalLambdaIdx = LambdaUtil.adjustLambdaIdx(lambdaIdx, (PsiMethod)resolve, parameters = ((PsiMethod)resolve).getParameterList().getParameters())) < parameters.length) {
                            PsiMethod interfaceMethod;
                            if (!tryToSubstitute) {
                                return LambdaUtil.getNormalizedType(parameters[finalLambdaIdx]);
                            }
                            if (cachedType != null && paramIdx > -1 && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(cachedType)) != null) {
                                PsiClassType.ClassResolveResult cachedResult = PsiUtil.resolveGenericsClassInType(cachedType);
                                PsiType interfaceMethodParameterType = interfaceMethod.getParameterList().getParameters()[paramIdx].getType();
                                if (!LambdaUtil.dependsOnTypeParams(cachedResult.getSubstitutor().substitute(interfaceMethodParameterType), cachedType, expression, new PsiTypeParameter[0])) {
                                    return cachedType;
                                }
                            }
                            return PsiResolveHelper.ourGuard.doPreventingRecursion(expression, true, new Computable<PsiType>(){

                                @Override
                                public PsiType compute() {
                                    return resolveResult.getSubstitutor().substitute(LambdaUtil.getNormalizedType(parameters[finalLambdaIdx]));
                                }
                            });
                        }
                        return null;
                    }
                }
            } else if (parent instanceof PsiReturnStatement) {
                PsiMethod method = PsiTreeUtil.getParentOfType(parent, PsiMethod.class);
                if (method != null) {
                    return method.getReturnType();
                }
            } else if (parent instanceof PsiLambdaExpression && (parentInterfaceType = ((PsiLambdaExpression)parent).getFunctionalInterfaceType()) != null) {
                return LambdaUtil.getFunctionalInterfaceReturnType(parentInterfaceType);
            }
        }
        return null;
    }

    private static int adjustLambdaIdx(int lambdaIdx, PsiMethod resolve, PsiParameter[] parameters) {
        int finalLambdaIdx = resolve.isVarArgs() && lambdaIdx >= parameters.length ? parameters.length - 1 : lambdaIdx;
        return finalLambdaIdx;
    }

    private static PsiType getNormalizedType(PsiParameter parameter) {
        PsiType type = parameter.getType();
        if (type instanceof PsiEllipsisType) {
            return ((PsiEllipsisType)type).getComponentType();
        }
        return type;
    }

    public static PsiType getLambdaParameterType(PsiParameter param) {
        PsiLambdaExpression lambdaExpression;
        int parameterIndex;
        PsiElement paramParent = param.getParent();
        if (paramParent instanceof PsiParameterList && (parameterIndex = ((PsiParameterList)paramParent).getParameterIndex(param)) > -1 && (lambdaExpression = PsiTreeUtil.getParentOfType((PsiElement)param, PsiLambdaExpression.class)) != null) {
            PsiParameterList parameterList = lambdaExpression.getParameterList();
            PsiType type = LambdaUtil.getFunctionalInterfaceType(lambdaExpression, true, parameterIndex);
            if (type == null) {
                type = LambdaUtil.getFunctionalInterfaceType(lambdaExpression, false);
            }
            if (type instanceof PsiIntersectionType) {
                PsiType[] conjuncts;
                for (PsiType conjunct : conjuncts = ((PsiIntersectionType)type).getConjuncts()) {
                    PsiType lambdaParameterFromType = LambdaUtil.getLambdaParameterFromType(parameterIndex, lambdaExpression, conjunct);
                    if (lambdaParameterFromType == null) continue;
                    return lambdaParameterFromType;
                }
            } else {
                PsiType lambdaParameterFromType = LambdaUtil.getLambdaParameterFromType(parameterIndex, lambdaExpression, type);
                if (lambdaParameterFromType != null) {
                    return lambdaParameterFromType;
                }
            }
        }
        return new PsiLambdaParameterType(param);
    }

    private static PsiType getLambdaParameterFromType(int parameterIndex, PsiLambdaExpression lambdaExpression, PsiType conjunct) {
        PsiType psiType;
        PsiParameter[] parameters;
        PsiMethod method;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(conjunct);
        if (resolveResult != null && (method = LambdaUtil.getFunctionalInterfaceMethod(conjunct)) != null && parameterIndex < (parameters = method.getParameterList().getParameters()).length && !LambdaUtil.dependsOnTypeParams(psiType = LambdaUtil.getSubstitutor(method, resolveResult).substitute(parameters[parameterIndex].getType()), conjunct, lambdaExpression, new PsiTypeParameter[0])) {
            return GenericsUtil.eliminateWildcards(psiType);
        }
        return null;
    }

    public static PsiSubstitutor inferFromReturnType(PsiTypeParameter[] typeParameters, PsiType returnType, @Nullable PsiType interfaceMethodReturnType, PsiSubstitutor psiSubstitutor, LanguageLevel languageLevel, Project project) {
        if (interfaceMethodReturnType == null) {
            return psiSubstitutor;
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(project).getResolveHelper();
        for (PsiTypeParameter typeParameter : typeParameters) {
            PsiClassType[] bounds;
            PsiType constraint = resolveHelper.getSubstitutionForTypeParameter(typeParameter, returnType, interfaceMethodReturnType, false, languageLevel);
            if (constraint == PsiType.NULL || constraint == null) continue;
            PsiType inferredType = null;
            for (PsiClassType classTypeBound : bounds = typeParameter.getExtendsListTypes()) {
                if (!TypeConversionUtil.isAssignable(classTypeBound, constraint)) continue;
                inferredType = constraint;
                break;
            }
            if (bounds.length == 0) {
                inferredType = constraint;
            }
            if (inferredType == null) continue;
            psiSubstitutor = psiSubstitutor.put(typeParameter, inferredType);
        }
        return psiSubstitutor;
    }

    public static boolean notInferredType(PsiType typeByExpression) {
        return typeByExpression instanceof PsiMethodReferenceType || typeByExpression instanceof PsiLambdaExpressionType || typeByExpression instanceof PsiLambdaParameterType;
    }

    public static List<PsiReturnStatement> getReturnStatements(PsiLambdaExpression lambdaExpression) {
        PsiElement body = lambdaExpression.getBody();
        final ArrayList<PsiReturnStatement> result = new ArrayList<PsiReturnStatement>();
        if (body != null) {
            body.accept(new JavaRecursiveElementVisitor(){

                @Override
                public void visitReturnStatement(PsiReturnStatement statement) {
                    result.add(statement);
                }

                @Override
                public void visitClass(PsiClass aClass) {
                }

                @Override
                public void visitLambdaExpression(PsiLambdaExpression expression) {
                }
            });
        }
        return result;
    }

    public static List<PsiExpression> getReturnExpressions(PsiLambdaExpression lambdaExpression) {
        PsiElement body = lambdaExpression.getBody();
        if (body instanceof PsiExpression) {
            return Collections.singletonList((PsiExpression)body);
        }
        ArrayList<PsiExpression> result = new ArrayList<PsiExpression>();
        for (PsiReturnStatement returnStatement : LambdaUtil.getReturnStatements(lambdaExpression)) {
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) continue;
            result.add(returnValue);
        }
        return result;
    }

    public static void checkMoreSpecificReturnType(List<CandidateInfo> conflicts, PsiType[] actualParameterTypes) {
        CandidateInfo[] newConflictsArray = conflicts.toArray(new CandidateInfo[conflicts.size()]);
        block0: for (int i = 1; i < newConflictsArray.length; ++i) {
            CandidateInfo method = newConflictsArray[i];
            for (int j = 0; j < i; ++j) {
                CandidateInfo conflict = newConflictsArray[j];
                assert (conflict != method);
                int moreSpecific = 0;
                PsiMethod methodElement = (PsiMethod)method.getElement();
                PsiMethod conflictElement = (PsiMethod)conflict.getElement();
                if (methodElement.isVarArgs() != conflictElement.isVarArgs()) continue;
                for (int functionalInterfaceIdx = 0; functionalInterfaceIdx < actualParameterTypes.length; ++functionalInterfaceIdx) {
                    PsiType interfaceReturnType = LambdaUtil.getReturnType(functionalInterfaceIdx, method);
                    PsiType interfaceReturnType1 = LambdaUtil.getReturnType(functionalInterfaceIdx, conflict);
                    if (actualParameterTypes[functionalInterfaceIdx] instanceof PsiLambdaExpressionType || actualParameterTypes[functionalInterfaceIdx] instanceof PsiMethodReferenceType) {
                        if (interfaceReturnType == null || interfaceReturnType1 == null || Comparing.equal(interfaceReturnType, interfaceReturnType1)) continue;
                        int moreSpecific1 = LambdaUtil.isMoreSpecific(interfaceReturnType, interfaceReturnType1, actualParameterTypes[functionalInterfaceIdx]);
                        if (moreSpecific < 0 && moreSpecific1 > 0 || moreSpecific > 0 && moreSpecific1 < 0) {
                            moreSpecific = 0;
                            break;
                        }
                        moreSpecific = moreSpecific1;
                        continue;
                    }
                    if (interfaceReturnType == null || interfaceReturnType1 == null) continue;
                    moreSpecific = 0;
                    break;
                }
                if (moreSpecific > 0 && conflictElement.getParameterList().getParametersCount() <= actualParameterTypes.length) {
                    conflicts.remove(method);
                    continue block0;
                }
                if (moreSpecific >= 0 || methodElement.getParameterList().getParametersCount() > actualParameterTypes.length) continue;
                conflicts.remove(conflict);
            }
        }
    }

    private static int isMoreSpecific(PsiType returnType, PsiType returnType1, PsiType lambdaType) {
        PsiElement referencedElement;
        if (returnType == PsiType.VOID || returnType1 == PsiType.VOID) {
            return 0;
        }
        TypeKind typeKind = TypeKind.PRIMITIVE;
        if (lambdaType instanceof PsiLambdaExpressionType) {
            typeKind = LambdaUtil.areLambdaReturnExpressionsPrimitive((PsiLambdaExpressionType)lambdaType);
        } else if (lambdaType instanceof PsiMethodReferenceType && (referencedElement = ((PsiMethodReferenceType)lambdaType).getExpression().resolve()) instanceof PsiMethod && !(((PsiMethod)referencedElement).getReturnType() instanceof PsiPrimitiveType)) {
            typeKind = TypeKind.REFERENCE;
        }
        if (typeKind != TypeKind.NONE_DETERMINED) {
            if (returnType instanceof PsiPrimitiveType) {
                int moreSpecific;
                int n = moreSpecific = typeKind == TypeKind.PRIMITIVE ? 1 : -1;
                if (!(returnType1 instanceof PsiPrimitiveType)) {
                    return -moreSpecific;
                }
                return TypeConversionUtil.isAssignable(returnType, returnType1) ? moreSpecific : -moreSpecific;
            }
            if (returnType1 instanceof PsiPrimitiveType) {
                return typeKind == TypeKind.PRIMITIVE ? 1 : -1;
            }
        }
        PsiClassType.ClassResolveResult r = PsiUtil.resolveGenericsClassInType(GenericsUtil.eliminateWildcards(returnType));
        PsiClass rClass = r.getElement();
        PsiClassType.ClassResolveResult r1 = PsiUtil.resolveGenericsClassInType(GenericsUtil.eliminateWildcards(returnType1));
        PsiClass rClass1 = r1.getElement();
        if (rClass != null && rClass1 != null) {
            if (rClass == rClass1) {
                int moreSpecific = 0;
                for (PsiTypeParameter parameter : rClass.getTypeParameters()) {
                    PsiType t = r.getSubstitutor().substituteWithBoundsPromotion(parameter);
                    PsiType t1 = r1.getSubstitutor().substituteWithBoundsPromotion(parameter);
                    if (t == null || t1 == null) continue;
                    if (t1.isAssignableFrom(t) && !GenericsUtil.eliminateWildcards(t1).equals(t)) {
                        if (moreSpecific == 1) {
                            return 0;
                        }
                        moreSpecific = -1;
                        continue;
                    }
                    if (t.isAssignableFrom(t1) && !GenericsUtil.eliminateWildcards(t).equals(t1)) {
                        if (moreSpecific == -1) {
                            return 0;
                        }
                        moreSpecific = 1;
                        continue;
                    }
                    return 0;
                }
                return moreSpecific;
            }
            if (rClass1.isInheritor(rClass, true)) {
                return 1;
            }
            if (rClass.isInheritor(rClass1, true)) {
                return -1;
            }
        }
        return 0;
    }

    private static TypeKind areLambdaReturnExpressionsPrimitive(PsiLambdaExpressionType lambdaType) {
        List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(lambdaType.getExpression());
        TypeKind typeKind = TypeKind.NONE_DETERMINED;
        for (PsiExpression expression : returnExpressions) {
            PsiType returnExprType = expression.getType();
            if (returnExprType instanceof PsiPrimitiveType) {
                if (typeKind == TypeKind.REFERENCE) {
                    typeKind = TypeKind.NONE_DETERMINED;
                    break;
                }
                typeKind = TypeKind.PRIMITIVE;
                continue;
            }
            if (typeKind == TypeKind.PRIMITIVE) {
                typeKind = TypeKind.NONE_DETERMINED;
                break;
            }
            typeKind = TypeKind.REFERENCE;
        }
        return typeKind;
    }

    @Nullable
    private static PsiType getReturnType(int functionalTypeIdx, CandidateInfo method) {
        PsiParameter[] methodParameters = ((PsiMethod)method.getElement()).getParameterList().getParameters();
        if (methodParameters.length == 0) {
            return null;
        }
        PsiParameter param = functionalTypeIdx < methodParameters.length ? methodParameters[functionalTypeIdx] : methodParameters[methodParameters.length - 1];
        PsiType functionalInterfaceType = method.getSubstitutor().substitute(param.getType());
        return LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType);
    }

    @Nullable
    public static String checkFunctionalInterface(PsiAnnotation annotation) {
        PsiElement parent;
        PsiAnnotationOwner owner;
        if (PsiUtil.isLanguageLevel8OrHigher(annotation) && Comparing.strEqual(annotation.getQualifiedName(), JAVA_LANG_FUNCTIONAL_INTERFACE) && (owner = annotation.getOwner()) instanceof PsiModifierList && (parent = ((PsiModifierList)owner).getParent()) instanceof PsiClass) {
            return LambdaHighlightingUtil.checkInterfaceFunctional((PsiClass)parent, ((PsiClass)parent).getName() + " is not a functional interface");
        }
        return null;
    }

    public static boolean isValidQualifier4InterfaceStaticMethodCall(@NotNull PsiMethod method, @NotNull PsiReferenceExpression methodReferenceExpression) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/LambdaUtil.isValidQualifier4InterfaceStaticMethodCall must not be null");
        }
        if (methodReferenceExpression == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/LambdaUtil.isValidQualifier4InterfaceStaticMethodCall must not be null");
        }
        if (PsiUtil.isLanguageLevel8OrHigher(methodReferenceExpression)) {
            PsiExpression qualifierExpression = methodReferenceExpression.getQualifierExpression();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null && containingClass.isInterface() && method.hasModifierProperty("static")) {
                return qualifierExpression == null && PsiTreeUtil.isAncestor(containingClass, methodReferenceExpression, true) || qualifierExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression).resolve() == containingClass;
            }
        }
        return true;
    }

    static class TypeParamsChecker
    extends PsiTypeVisitor<Boolean> {
        private PsiMethod myMethod;
        private final PsiClass myClass;
        private final Set<PsiTypeParameter> myUsedTypeParams = new HashSet<PsiTypeParameter>();

        private TypeParamsChecker(PsiMethod method, PsiClass aClass) {
            this.myMethod = method;
            this.myClass = aClass;
        }

        public TypeParamsChecker(PsiElement expression) {
            this(expression, PsiUtil.resolveGenericsClassInType(LambdaUtil.getFunctionalInterfaceType(expression, false)).getElement());
        }

        public TypeParamsChecker(PsiElement expression, PsiClass aClass) {
            PsiElement gParent;
            PsiElement parent;
            this.myClass = aClass;
            PsiElement psiElement = parent = expression != null ? expression.getParent() : null;
            while (parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiExpressionList && (gParent = parent.getParent()) instanceof PsiCall) {
                Pair<PsiMethod, PsiSubstitutor> pair;
                Map<PsiElement, Pair<PsiMethod, PsiSubstitutor>> map = MethodCandidateInfo.CURRENT_CANDIDATE.get();
                this.myMethod = map != null ? ((pair = map.get(parent)) != null ? (PsiMethod)pair.first : null) : null;
                if (this.myMethod == null) {
                    this.myMethod = ((PsiCall)gParent).resolveMethod();
                }
                if (this.myMethod != null && PsiTreeUtil.isAncestor(this.myMethod, expression, false)) {
                    this.myMethod = null;
                }
            }
        }

        public boolean startedInference() {
            return this.myMethod != null;
        }

        @Override
        public Boolean visitClassType(PsiClassType classType) {
            PsiTypeParameter typeParameter;
            boolean used = false;
            for (PsiType paramType : classType.getParameters()) {
                Boolean paramAccepted = paramType.accept(this);
                used |= paramAccepted != null && paramAccepted != false;
            }
            PsiClass resolve = classType.resolve();
            if (resolve instanceof PsiTypeParameter && this.check(typeParameter = (PsiTypeParameter)resolve)) {
                this.myUsedTypeParams.add(typeParameter);
                return true;
            }
            return used;
        }

        @Override
        @Nullable
        public Boolean visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (bound != null) {
                return bound.accept(this);
            }
            return false;
        }

        @Override
        @Nullable
        public Boolean visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
            return this.visitWildcardType(capturedWildcardType.getWildcard());
        }

        @Override
        @Nullable
        public Boolean visitLambdaExpressionType(PsiLambdaExpressionType lambdaExpressionType) {
            return true;
        }

        @Override
        @Nullable
        public Boolean visitArrayType(PsiArrayType arrayType) {
            return arrayType.getComponentType().accept(this);
        }

        @Override
        public Boolean visitType(PsiType type) {
            return false;
        }

        private boolean check(PsiTypeParameter check) {
            PsiTypeParameterListOwner owner = check.getOwner();
            if (owner == this.myMethod) {
                return true;
            }
            return owner == this.myClass;
        }

        public boolean used(PsiTypeParameter ... parameters) {
            for (PsiTypeParameter parameter : parameters) {
                if (!this.myUsedTypeParams.contains(parameter)) continue;
                return true;
            }
            return false;
        }
    }

    static enum TypeKind {
        PRIMITIVE,
        REFERENCE,
        NONE_DETERMINED;

    }
}

