/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;

public class IdentitySmartPointer<T extends PsiElement>
implements SmartPsiElementPointer<T> {
    private final T myElement;
    private final PsiFile myFile;

    public IdentitySmartPointer(@NotNull T element, @NotNull PsiFile file) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/IdentitySmartPointer.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/IdentitySmartPointer.<init> must not be null");
        }
        this.myElement = element;
        this.myFile = file;
    }

    public IdentitySmartPointer(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/IdentitySmartPointer.<init> must not be null");
        }
        this(element, element.getContainingFile());
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myFile.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/IdentitySmartPointer.getProject must not return null");
        }
        return project;
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myFile.getVirtualFile();
    }

    @Override
    public T getElement() {
        T element = this.myElement;
        return (T)(element.isValid() ? element : null);
    }

    public int hashCode() {
        T elt = this.getElement();
        return elt == null ? 0 : elt.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof SmartPsiElementPointer && SmartPointerManager.getInstance(this.getProject()).pointToTheSameElement(this, (SmartPsiElementPointer)obj);
    }

    @Override
    public PsiFile getContainingFile() {
        return this.myFile;
    }

    @Override
    public Segment getRange() {
        return this.myElement.getTextRange();
    }
}

