/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileManager
implements ModificationTracker {
    public static final Topic<BulkFileListener> VFS_CHANGES = new Topic<BulkFileListener>("NewVirtualFileSystem changes", BulkFileListener.class);

    @NotNull
    public static VirtualFileManager getInstance() {
        VirtualFileManager virtualFileManager = ApplicationManager.getApplication().getComponent(VirtualFileManager.class);
        if (virtualFileManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFileManager.getInstance must not return null");
        }
        return virtualFileManager;
    }

    public abstract VirtualFileSystem getFileSystem(String var1);

    @Nullable
    public abstract VirtualFile findFileByUrl(@NonNls @NotNull String var1);

    @NotNull
    public static String constructUrl(@NotNull String protocol, @NotNull String path) {
        if (protocol == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileManager.constructUrl must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileManager.constructUrl must not be null");
        }
        String string = protocol + "://" + path;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFileManager.constructUrl must not return null");
        }
        return string;
    }

    @Nullable
    public static String extractProtocol(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileManager.extractProtocol must not be null");
        }
        int index = url.indexOf("://");
        if (index < 0) {
            return null;
        }
        return url.substring(0, index);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String extractPath(@NotNull String url) {
        String string;
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFileManager.extractPath must not be null");
        }
        int index = url.indexOf("://");
        if (index < 0) {
            string = url;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFileManager.extractPath must not return null");
            return string;
        }
        string = url.substring(index + "://".length());
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFileManager.extractPath must not return null");
    }

    public abstract void notifyPropertyChanged(VirtualFile var1, String var2, Object var3, Object var4);
}

