/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShutDownTracker
implements Runnable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.ShutDownTracker");
    private final List<Thread> myThreads = new ArrayList<Thread>();
    private final LinkedList<Thread> myShutdownThreads = new LinkedList();
    private final LinkedList<Runnable> myShutdownTasks = new LinkedList();
    private volatile boolean myIsShutdownHookRunning = false;

    private ShutDownTracker() {
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)this, "Shutdown tracker"));
    }

    @NotNull
    public static ShutDownTracker getInstance() {
        ShutDownTracker shutDownTracker = ShutDownTrackerHolder.ourInstance;
        if (shutDownTracker == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/ShutDownTracker.getInstance must not return null");
        }
        return shutDownTracker;
    }

    public static boolean isShutdownHookRunning() {
        return ShutDownTracker.getInstance().myIsShutdownHookRunning;
    }

    @Override
    public void run() {
        this.myIsShutdownHookRunning = true;
        this.ensureStopperThreadsFinished();
        Runnable task = this.removeLast(this.myShutdownTasks);
        while (task != null) {
            try {
                task.run();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            task = this.removeLast(this.myShutdownTasks);
        }
        Thread thread = this.removeLast(this.myShutdownThreads);
        while (thread != null) {
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            thread = this.removeLast(this.myShutdownThreads);
        }
    }

    public final void ensureStopperThreadsFinished() {
        Thread[] threads = this.getStopperThreads();
        long started = System.currentTimeMillis();
        while (threads.length > 0) {
            Thread thread = threads[0];
            if (!thread.isAlive()) {
                if (this.isRegistered(thread)) {
                    LOG.error("Thread '" + thread.getName() + "' did not unregister itself from ShutDownTracker.");
                    this.unregisterStopperThread(thread);
                }
            } else {
                long totalTimeWaited = System.currentTimeMillis() - started;
                if (totalTimeWaited > 3000L) {
                    thread.interrupt();
                }
                try {
                    thread.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            threads = this.getStopperThreads();
        }
    }

    private synchronized boolean isRegistered(@NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ShutDownTracker.isRegistered must not be null");
        }
        return this.myThreads.contains(thread);
    }

    @NotNull
    private synchronized Thread[] getStopperThreads() {
        Thread[] threadArray = this.myThreads.toArray(new Thread[this.myThreads.size()]);
        if (threadArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/ShutDownTracker.getStopperThreads must not return null");
        }
        return threadArray;
    }

    public synchronized void unregisterStopperThread(@NotNull Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ShutDownTracker.unregisterStopperThread must not be null");
        }
        this.myThreads.remove(thread);
    }

    private synchronized <T> T removeLast(@NotNull LinkedList<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ShutDownTracker.removeLast must not be null");
        }
        return list.isEmpty() ? null : (T)list.removeLast();
    }

    private static class ShutDownTrackerHolder {
        private static final ShutDownTracker ourInstance = new ShutDownTracker();
    }
}

