/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconLoader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.IconLoader");
    public static boolean STRICT = false;
    private static boolean USE_DARK_ICONS = UIUtil.isUnderDarcula();
    private static final ConcurrentMap<URL, CachedImageIcon> ourIconsCache = new ConcurrentHashMap<URL, CachedImageIcon>(100, 0.9f, 2);
    private static final Map<Icon, Icon> ourIcon2DisabledIcon = new WeakHashMap<Icon, Icon>(200);
    @NonNls
    private static final Map<String, String> ourDeprecatedIconsReplacements = new HashMap<String, String>();
    private static final ImageIcon EMPTY_ICON;
    private static boolean ourIsActivated;

    private IconLoader() {
    }

    @Deprecated
    public static Icon getIcon(@NotNull Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/IconLoader.getIcon must not be null");
        }
        return new MyImageIcon(image);
    }

    @NotNull
    public static Icon getIcon(@NonNls @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/IconLoader.getIcon must not be null");
        }
        int stackFrameCount = 2;
        Class callerClass = ReflectionUtil.findCallerClass(stackFrameCount);
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = ReflectionUtil.findCallerClass(++stackFrameCount);
        }
        if (callerClass == null) {
            callerClass = ReflectionUtil.findCallerClass(1);
        }
        assert (callerClass != null) : path;
        Icon icon = IconLoader.getIcon(path, callerClass);
        if (icon == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/IconLoader.getIcon must not return null");
        }
        return icon;
    }

    @Nullable
    private static Icon getReflectiveIcon(@NotNull String path, ClassLoader classLoader) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/IconLoader.getReflectiveIcon must not be null");
        }
        try {
            String pckg = path.startsWith("AllIcons.") ? "com.intellij.icons." : "icons.";
            Class<?> cur = Class.forName(pckg + path.substring(0, path.lastIndexOf(46)).replace('.', '$'), true, classLoader);
            Field field = cur.getField(path.substring(path.lastIndexOf(46) + 1));
            return (Icon)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static Icon getIcon(@NotNull String path, @NotNull Class aClass) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/IconLoader.getIcon must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/IconLoader.getIcon must not be null");
        }
        Icon icon = IconLoader.findIcon(path, aClass);
        if (icon == null) {
            LOG.error("Icon cannot be found in '" + path + "', aClass='" + aClass + "'");
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/IconLoader.getIcon must not return null");
        }
        return icon2;
    }

    private static boolean isLoaderDisabled() {
        return !ourIsActivated;
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/IconLoader.findIcon must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/IconLoader.findIcon must not be null");
        }
        return IconLoader.findIcon(path, aClass, false);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass, boolean computeNow) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/IconLoader.findIcon must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/IconLoader.findIcon must not be null");
        }
        if (IconLoader.isReflectivePath(path = IconLoader.undeprecate(path))) {
            return IconLoader.getReflectiveIcon(path, aClass.getClassLoader());
        }
        URL myURL = aClass.getResource(path);
        if (myURL == null) {
            if (STRICT) {
                throw new RuntimeException("Can't find icon in '" + path + "' near " + aClass);
            }
            return null;
        }
        return IconLoader.findIcon(myURL);
    }

    @NotNull
    private static String undeprecate(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/IconLoader.undeprecate must not be null");
        }
        String replacement = ourDeprecatedIconsReplacements.get(path);
        String string = replacement == null ? path : replacement;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/IconLoader.undeprecate must not return null");
        }
        return string;
    }

    private static boolean isReflectivePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/IconLoader.isReflectivePath must not be null");
        }
        List<String> paths = StringUtil.split(path, ".");
        return paths.size() > 1 && paths.get(0).endsWith("Icons");
    }

    @Nullable
    public static Icon findIcon(URL url) {
        if (url == null) {
            return null;
        }
        CachedImageIcon icon = (CachedImageIcon)ourIconsCache.get(url);
        if (icon == null) {
            icon = new CachedImageIcon(url);
            icon = ConcurrencyUtil.cacheOrGet(ourIconsCache, url, icon);
        }
        return icon;
    }

    @Nullable
    private static Icon checkIcon(Image image, @NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/IconLoader.checkIcon must not be null");
        }
        if (image == null || image.getHeight(LabelHolder.ourFakeComponent) < 1) {
            return null;
        }
        Icon icon = IconLoader.getIcon(image);
        if (icon != null && !IconLoader.isGoodSize(icon)) {
            LOG.error("Invalid icon: " + url);
            return EMPTY_ICON;
        }
        return icon;
    }

    public static boolean isGoodSize(@NotNull Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/IconLoader.isGoodSize must not be null");
        }
        return icon.getIconWidth() > 0 && icon.getIconHeight() > 0;
    }

    static {
        ourDeprecatedIconsReplacements.put("/general/toolWindowDebugger.png", "AllIcons.Toolwindows.ToolWindowDebugger");
        ourDeprecatedIconsReplacements.put("/general/toolWindowChanges.png", "AllIcons.Toolwindows.ToolWindowChanges");
        ourDeprecatedIconsReplacements.put("/actions/showSettings.png", "AllIcons.General.ProjectSettings");
        ourDeprecatedIconsReplacements.put("/general/ideOptions.png", "AllIcons.General.Settings");
        ourDeprecatedIconsReplacements.put("/general/applicationSettings.png", "AllIcons.General.Settings");
        ourDeprecatedIconsReplacements.put("/toolbarDecorator/add.png", "AllIcons.General.Add");
        ourDeprecatedIconsReplacements.put("/vcs/customizeView.png", "AllIcons.General.Settings");
        ourDeprecatedIconsReplacements.put("/vcs/refresh.png", "AllIcons.Actions.Refresh");
        ourDeprecatedIconsReplacements.put("/actions/sync.png", "AllIcons.Actions.Refresh");
        ourDeprecatedIconsReplacements.put("/actions/refreshUsages.png", "AllIcons.Actions.Rerun");
        ourDeprecatedIconsReplacements.put("/compiler/error.png", "AllIcons.General.Error");
        ourDeprecatedIconsReplacements.put("/compiler/hideWarnings.png", "AllIcons.General.HideWarnings");
        ourDeprecatedIconsReplacements.put("/compiler/information.png", "AllIcons.General.Information");
        ourDeprecatedIconsReplacements.put("/compiler/warning.png", "AllIcons.General.Warning");
        ourDeprecatedIconsReplacements.put("/ide/errorSign.png", "AllIcons.General.Error");
        ourDeprecatedIconsReplacements.put("/ant/filter.png", "AllIcons.General.Filter");
        ourDeprecatedIconsReplacements.put("/inspector/useFilter.png", "AllIcons.General.Filter");
        ourDeprecatedIconsReplacements.put("/actions/showSource.png", "AllIcons.Actions.Preview");
        ourDeprecatedIconsReplacements.put("/actions/consoleHistory.png", "AllIcons.General.MessageHistory");
        ourDeprecatedIconsReplacements.put("/vcs/messageHistory.png", "AllIcons.General.MessageHistory");
        EMPTY_ICON = new ImageIcon(UIUtil.createImage(1, 1, 5)){

            @Override
            @NonNls
            public String toString() {
                return "Empty icon " + super.toString();
            }
        };
        ourIsActivated = false;
    }

    private static class LabelHolder {
        private static final JComponent ourFakeComponent = new JLabel();
    }

    private static final class MyImageIcon
    extends ImageIcon {
        public MyImageIcon(Image image) {
            super(image);
        }

        @Override
        public final synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            ImageObserver observer = this.getImageObserver();
            UIUtil.drawImage(g, this.getImage(), x, y, observer == null ? c : observer);
        }
    }

    private static final class CachedImageIcon
    implements Icon {
        private Object myRealIcon;
        @NotNull
        private final URL myUrl;

        public CachedImageIcon(@NotNull URL url) {
            if (url == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/IconLoader$CachedImageIcon.<init> must not be null");
            }
            this.myUrl = url;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        private synchronized Icon getRealIcon() {
            Icon icon;
            Icon icon2;
            if (IconLoader.isLoaderDisabled()) {
                icon2 = EMPTY_ICON;
                if (icon2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/IconLoader$CachedImageIcon.getRealIcon must not return null");
                return icon2;
            }
            SoftReference<Icon> realIcon = this.myRealIcon;
            if (realIcon instanceof Icon) {
                icon2 = (Icon)((Object)realIcon);
                if (icon2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/IconLoader$CachedImageIcon.getRealIcon must not return null");
                return icon2;
            }
            if (realIcon instanceof Reference && (icon = (Icon)((Reference)realIcon).get()) != null) {
                icon2 = icon;
                if (icon2 == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/IconLoader$CachedImageIcon.getRealIcon must not return null");
                return icon2;
            }
            Image image = ImageLoader.loadFromUrl(this.myUrl);
            icon = IconLoader.checkIcon(image, this.myUrl);
            if (icon != null) {
                realIcon = icon.getIconWidth() < 50 && icon.getIconHeight() < 50 ? icon : new SoftReference<Icon>(icon);
                this.myRealIcon = realIcon;
            }
            if ((icon2 = icon == null ? EMPTY_ICON : icon) != null) return icon2;
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/IconLoader$CachedImageIcon.getRealIcon must not return null");
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.getRealIcon().paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.getRealIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getRealIcon().getIconHeight();
        }

        public String toString() {
            return this.myUrl.toString();
        }
    }
}

