/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class DumbService {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.project.DumbService");
    public static final Topic<DumbModeListener> DUMB_MODE = new Topic<DumbModeListener>("dumb mode", DumbModeListener.class);
    private static final NotNullLazyKey<DumbService, Project> INSTANCE_KEY = ServiceManager.createLazyKey(DumbService.class);

    public abstract boolean isDumb();

    public static DumbService getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/project/DumbService.getInstance must not be null");
        }
        return INSTANCE_KEY.getValue(project);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public <T> List<T> filterByDumbAwareness(@NotNull Collection<T> collection) {
        ArrayList<T> arrayList;
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/project/DumbService.filterByDumbAwareness must not be null");
        }
        if (this.isDumb()) {
            ArrayList<T> result = new ArrayList<T>(collection);
            Iterator<T> iterator = result.iterator();
            while (iterator.hasNext()) {
                if (DumbService.isDumbAware(iterator.next())) continue;
                iterator.remove();
            }
            arrayList = result;
            if (arrayList == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/project/DumbService.filterByDumbAwareness must not return null");
            return arrayList;
        }
        if (collection instanceof List) {
            arrayList = (ArrayList<T>)collection;
            if (arrayList == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/project/DumbService.filterByDumbAwareness must not return null");
            return arrayList;
        }
        arrayList = new ArrayList<T>(collection);
        if (arrayList != null) return arrayList;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/project/DumbService.filterByDumbAwareness must not return null");
    }

    public static boolean isDumbAware(Object o) {
        if (o instanceof PossiblyDumbAware) {
            return ((PossiblyDumbAware)o).isDumbAware();
        }
        return o instanceof DumbAware;
    }

    public static interface DumbModeListener {
    }
}

