/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extension;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;

public class ExtensionPointImpl<T>
implements ExtensionPoint<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.extensions.impl.ExtensionPointImpl");
    private final LogProvider myLogger;
    private final AreaInstance myArea;
    private final String myName;
    private final String myClassName;
    private final ExtensionPoint.Kind myKind;
    private final List<T> myExtensions;
    private volatile T[] myExtensionsCache;
    private final ExtensionsAreaImpl myOwner;
    private final PluginDescriptor myDescriptor;
    private final Set<ExtensionComponentAdapter> myExtensionAdapters;
    private final List<ExtensionPointListener<T>> myEPListeners;
    private final List<ExtensionComponentAdapter> myLoadedAdapters;
    private Class<T> myExtensionClass;
    private static final StringInterner INTERNER = new StringInterner();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensionPointImpl(@NotNull String name, @NotNull String className, @NotNull ExtensionPoint.Kind kind, @NotNull ExtensionsAreaImpl owner, AreaInstance area, @NotNull LogProvider logger, @NotNull PluginDescriptor descriptor) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.<init> must not be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.<init> must not be null");
        }
        if (kind == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.<init> must not be null");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.<init> must not be null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.<init> must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 6 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.<init> must not be null");
        }
        this.myExtensions = new ArrayList<T>();
        this.myExtensionAdapters = new LinkedHashSet<ExtensionComponentAdapter>();
        this.myEPListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myLoadedAdapters = new ArrayList<ExtensionComponentAdapter>();
        StringInterner stringInterner = INTERNER;
        synchronized (stringInterner) {
            this.myName = INTERNER.intern(name);
        }
        this.myClassName = className;
        this.myKind = kind;
        this.myOwner = owner;
        this.myArea = area;
        this.myLogger = logger;
        this.myDescriptor = descriptor;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/impl/ExtensionPointImpl.getName must not return null");
        }
        return string;
    }

    @Override
    public void registerExtension(@NotNull T extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.registerExtension must not be null");
        }
        this.registerExtension(extension, LoadingOrder.ANY);
    }

    public synchronized void registerExtension(@NotNull T extension, @NotNull LoadingOrder order) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.registerExtension must not be null");
        }
        if (order == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.registerExtension must not be null");
        }
        assert (this.myExtensions.size() == this.myLoadedAdapters.size());
        ObjectComponentAdapter adapter = new ObjectComponentAdapter(extension, order);
        this.assertClass(extension.getClass());
        if (LoadingOrder.ANY == order) {
            ExtensionComponentAdapter lastAdapter;
            int index = this.myLoadedAdapters.size();
            if (index > 0 && (lastAdapter = this.myLoadedAdapters.get(index - 1)).getOrder() == LoadingOrder.LAST) {
                --index;
            }
            this.internalRegisterExtension(extension, adapter, index, true);
        } else {
            this.myExtensionAdapters.add(adapter);
            this.processAdapters();
        }
        this.clearCache();
    }

    private void internalRegisterExtension(@NotNull T extension, @NotNull ExtensionComponentAdapter adapter, int index, boolean runNotifications) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.internalRegisterExtension must not be null");
        }
        if (adapter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.internalRegisterExtension must not be null");
        }
        if (this.myExtensions.contains(extension)) {
            this.myLogger.error("Extension was already added: " + extension);
            return;
        }
        this.myExtensions.add(index, extension);
        this.myLoadedAdapters.add(index, adapter);
        if (runNotifications) {
            if (extension instanceof Extension) {
                try {
                    ((Extension)extension).extensionAdded(this);
                }
                catch (Throwable e) {
                    this.myLogger.error(e);
                }
            }
            this.clearCache();
            this.notifyListenersOnAdd(extension, adapter.getPluginDescriptor());
        }
    }

    private void notifyListenersOnAdd(@NotNull T extension, PluginDescriptor pluginDescriptor) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.notifyListenersOnAdd must not be null");
        }
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            try {
                listener.extensionAdded(extension, pluginDescriptor);
            }
            catch (Throwable e) {
                this.myLogger.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public T[] getExtensions() {
        Object[] result = this.myExtensionsCache;
        if (result == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                result = this.myExtensionsCache;
                if (result == null) {
                    this.processAdapters();
                    Class<T> extensionClass = this.getExtensionClass();
                    Object[] a = (Object[])Array.newInstance(extensionClass, this.myExtensions.size());
                    result = this.myExtensions.toArray(a);
                    for (int i = result.length - 1; i >= 0; --i) {
                        T t = result[i];
                        if (i > 0 && result[i] == result[i - 1]) {
                            LOG.error("Duplicate extension found: " + t + "; " + " Result:      " + Arrays.toString(result) + ";\n" + " extensions: " + this.myExtensions + ";\n" + " getExtensionClass(): " + extensionClass + ";\n" + " size:" + this.myExtensions.size() + ";" + result.length);
                        }
                        if (extensionClass.isAssignableFrom(t.getClass())) continue;
                        LOG.error("Extension '" + t.getClass() + "' must be an instance of '" + extensionClass + "'", new ExtensionException(t.getClass()));
                        result = ArrayUtil.remove(result, i);
                    }
                    this.myExtensionsCache = result;
                }
            }
        }
        if (result == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/impl/ExtensionPointImpl.getExtensions must not return null");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAnyExtensions() {
        T[] cache = this.myExtensionsCache;
        if (cache != null) {
            return cache.length > 0;
        }
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            return this.myExtensionAdapters.size() + this.myLoadedAdapters.size() > 0;
        }
    }

    private void processAdapters() {
        int totalSize = this.myExtensionAdapters.size() + this.myLoadedAdapters.size();
        if (totalSize != 0) {
            ArrayList<ExtensionComponentAdapter> allAdapters = new ArrayList<ExtensionComponentAdapter>(totalSize);
            allAdapters.addAll(this.myExtensionAdapters);
            allAdapters.addAll(this.myLoadedAdapters);
            this.myExtensions.clear();
            ExtensionComponentAdapter[] loadedAdapters = this.myLoadedAdapters.isEmpty() ? ExtensionComponentAdapter.EMPTY_ARRAY : this.myLoadedAdapters.toArray(new ExtensionComponentAdapter[this.myLoadedAdapters.size()]);
            this.myLoadedAdapters.clear();
            LoadingOrder.Orderable[] adapters = allAdapters.toArray(new ExtensionComponentAdapter[this.myExtensionAdapters.size()]);
            LoadingOrder.sort(adapters);
            ArrayList<Object> extensions = new ArrayList<Object>(adapters.length);
            for (LoadingOrder.Orderable adapter : adapters) {
                Object extension = ((ExtensionComponentAdapter)adapter).getExtension();
                this.assertClass(extension.getClass());
                extensions.add(extension);
            }
            for (int i = 0; i < extensions.size(); ++i) {
                Object extension = extensions.get(i);
                this.internalRegisterExtension(extension, (ExtensionComponentAdapter)adapters[i], this.myExtensions.size(), ArrayUtilRt.find(loadedAdapters, adapters[i]) == -1);
            }
            this.myExtensionAdapters.clear();
        }
    }

    @Override
    public synchronized void unregisterExtension(@NotNull T extension) {
        MutablePicoContainer[] pluginContainers;
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.unregisterExtension must not be null");
        }
        int index = this.getExtensionIndex(extension);
        ExtensionComponentAdapter adapter = this.myLoadedAdapters.get(index);
        this.myOwner.getMutablePicoContainer().unregisterComponent(adapter.getComponentKey());
        for (MutablePicoContainer pluginContainer : pluginContainers = this.myOwner.getPluginContainers()) {
            pluginContainer.unregisterComponent(adapter.getComponentKey());
        }
        this.processAdapters();
        this.internalUnregisterExtension(extension, null);
    }

    private int getExtensionIndex(@NotNull T extension) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.getExtensionIndex must not be null");
        }
        int i = this.myExtensions.indexOf(extension);
        if (i == -1) {
            throw new IllegalArgumentException("Extension to be removed not found: " + extension);
        }
        return i;
    }

    private void internalUnregisterExtension(@NotNull T extension, PluginDescriptor pluginDescriptor) {
        if (extension == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.internalUnregisterExtension must not be null");
        }
        int index = this.getExtensionIndex(extension);
        this.myExtensions.remove(index);
        this.myLoadedAdapters.remove(index);
        this.clearCache();
        this.notifyListenersOnRemove(extension, pluginDescriptor);
        if (extension instanceof Extension) {
            Extension o = (Extension)extension;
            try {
                o.extensionRemoved(this);
            }
            catch (Throwable e) {
                this.myLogger.error(e);
            }
        }
    }

    private void notifyListenersOnRemove(@NotNull T extensionObject, PluginDescriptor pluginDescriptor) {
        if (extensionObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.notifyListenersOnRemove must not be null");
        }
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            try {
                listener.extensionRemoved(extensionObject, pluginDescriptor);
            }
            catch (Throwable e) {
                this.myLogger.error(e);
            }
        }
    }

    @Override
    public synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.addExtensionPointListener must not be null");
        }
        this.processAdapters();
        if (this.myEPListeners.add(listener)) {
            for (ExtensionComponentAdapter componentAdapter : this.myLoadedAdapters.toArray(new ExtensionComponentAdapter[this.myLoadedAdapters.size()])) {
                try {
                    Object extension = componentAdapter.getExtension();
                    listener.extensionAdded(extension, componentAdapter.getPluginDescriptor());
                }
                catch (Throwable e) {
                    this.myLogger.error(e);
                }
            }
        }
    }

    @Override
    public synchronized void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.removeExtensionPointListener must not be null");
        }
        for (ExtensionComponentAdapter componentAdapter : this.myLoadedAdapters.toArray(new ExtensionComponentAdapter[this.myLoadedAdapters.size()])) {
            try {
                Object extension = componentAdapter.getExtension();
                listener.extensionRemoved(extension, componentAdapter.getPluginDescriptor());
            }
            catch (Throwable e) {
                this.myLogger.error(e);
            }
        }
        boolean success = this.myEPListeners.remove(listener);
        assert (success);
    }

    @NotNull
    public Class<T> getExtensionClass() {
        Class<Object> extensionClass = this.myExtensionClass;
        if (extensionClass == null) {
            try {
                ClassLoader pluginClassLoader = this.myDescriptor.getPluginClassLoader();
                Class<?> extClass = pluginClassLoader == null ? Class.forName(this.myClassName) : Class.forName(this.myClassName, true, pluginClassLoader);
                this.myExtensionClass = extensionClass = extClass;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        Class<T> clazz = extensionClass;
        if (clazz == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/impl/ExtensionPointImpl.getExtensionClass must not return null");
        }
        return clazz;
    }

    public String toString() {
        return this.getName();
    }

    private void assertClass(@NotNull Class<?> extensionClass) {
        if (extensionClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl.assertClass must not be null");
        }
        Class<T> expectedClass = this.getExtensionClass();
        assert (expectedClass.isAssignableFrom(extensionClass)) : "Expected: " + expectedClass + "; Actual: " + extensionClass;
    }

    private void clearCache() {
        this.myExtensionsCache = null;
    }

    final synchronized void notifyAreaReplaced(ExtensionsArea area) {
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            if (!(listener instanceof ExtensionPointAndAreaListener)) continue;
            ((ExtensionPointAndAreaListener)listener).areaReplaced(area);
        }
    }

    private static class ObjectComponentAdapter
    extends ExtensionComponentAdapter {
        private final Object myExtension;
        private final LoadingOrder myLoadingOrder;

        private ObjectComponentAdapter(@NotNull Object extension, @NotNull LoadingOrder loadingOrder) {
            if (extension == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter.<init> must not be null");
            }
            if (loadingOrder == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter.<init> must not be null");
            }
            super(Object.class.getName(), null, null, null, false);
            this.myExtension = extension;
            this.myLoadingOrder = loadingOrder;
        }

        @Override
        public Object getExtension() {
            return this.myExtension;
        }

        @Override
        public LoadingOrder getOrder() {
            return this.myLoadingOrder;
        }

        @Override
        @Nullable
        public String getOrderId() {
            return null;
        }

        @Override
        @NonNls
        public Element getDescribingElement() {
            return new Element("RuntimeExtension: " + this.myExtension);
        }
    }
}

