/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathManager {
    @NonNls
    private static String ourHomePath;
    @NonNls
    private static String ourSystemPath;

    public static String getHomePath() {
        if (ourHomePath != null) {
            return ourHomePath;
        }
        if (System.getProperty("idea.home.path") != null) {
            ourHomePath = PathManager.getAbsolutePath(System.getProperty("idea.home.path"));
        } else {
            ourHomePath = PathManager.getHomePathFor(PathManager.class);
            if (ourHomePath == null) {
                if (SystemInfo.isMac) {
                    throw new RuntimeException("Could not find installation home path. Please reinstall the software.");
                }
                throw new RuntimeException("Could not find IDEA home path. Please make sure bin/idea.properties is present in the installation directory.");
            }
        }
        try {
            if (!SystemInfo.isFileSystemCaseSensitive) {
                ourHomePath = ourHomePath == null ? null : new File(ourHomePath).getCanonicalPath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ourHomePath;
    }

    @Nullable
    public static String getHomePathFor(Class aClass) {
        String rootPath = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class");
        if (rootPath != null) {
            String parent;
            File root = new File(rootPath).getAbsoluteFile();
            do {
                if ((parent = root.getParent()) != null) continue;
                return null;
            } while ((root = new File(parent).getAbsoluteFile()) != null && !PathManager.isIdeaHome(root));
            return root != null ? root.getAbsolutePath() : null;
        }
        return null;
    }

    private static boolean isIdeaHome(File root) {
        return new File(root, FileUtil.toSystemDependentName("bin/idea.properties")).exists() || new File(root, FileUtil.toSystemDependentName("community/bin/idea.properties")).exists() || new File(root, FileUtil.toSystemDependentName("Contents/Info.plist")).exists();
    }

    private static String trimPathQuotes(String path) {
        if (path == null || path.length() < 3) {
            return path;
        }
        if (StringUtil.startsWithChar(path, '\"') && StringUtil.endsWithChar(path, '\"')) {
            return path.substring(1, path.length() - 1);
        }
        return path;
    }

    public static String getSystemPath() {
        if (ourSystemPath != null) {
            return ourSystemPath;
        }
        if (System.getProperty("idea.system.path") != null) {
            ourSystemPath = PathManager.getAbsolutePath(PathManager.trimPathQuotes(System.getProperty("idea.system.path")));
        } else if (PathManager.getPathsSelector() != null) {
            String selector = PathManager.getPathsSelector();
            ourSystemPath = SystemProperties.getUserHome() + (SystemInfo.isMac ? "/Library/Caches/" + selector : File.separator + "." + selector + File.separator + "system");
        } else {
            ourSystemPath = PathManager.getHomePath() + File.separator + "system";
        }
        try {
            File file = new File(ourSystemPath);
            file.mkdirs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ourSystemPath;
    }

    public static String getPathsSelector() {
        return System.getProperty("idea.paths.selector");
    }

    public static File getIndexRoot() {
        File file = new File(PathManager.getIndexRootDir());
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        file.mkdirs();
        return file;
    }

    private static String getIndexRootDir() {
        String dir = System.getProperty("index_root_path");
        return dir == null ? PathManager.getSystemPath() + "/index" : dir;
    }

    @NotNull
    private static String getAbsolutePath(String path) {
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = SystemProperties.getUserHome() + path.substring(1);
        }
        String string = new File(path).getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/application/PathManager.getAbsolutePath must not return null");
        }
        return string;
    }

    @Nullable
    public static String getResourceRoot(Class context, @NonNls String path) {
        URL url = context.getResource(path);
        if (url == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        if (url == null) {
            return null;
        }
        return PathManager.extractRoot(url, path);
    }

    @Nullable
    @NonNls
    private static String extractRoot(URL resourceURL, String resourcePath) {
        Pair<String, String> paths;
        if (!StringUtil.startsWithChar(resourcePath, '/') && !StringUtil.startsWithChar(resourcePath, '\\')) {
            System.err.println("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path = resourceURL.getFile();
            String testPath = path.replace('\\', '/');
            if (StringUtil.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol) && (paths = URLUtil.splitJarUrl(resourceURL.getFile())) != null) {
            resultPath = (String)paths.first;
        }
        if (resultPath == null) {
            System.err.println("cannot extract: " + resultPath + " from " + resourceURL);
            return null;
        }
        resultPath = StringUtil.trimEnd(resultPath, File.separator);
        resultPath = URLUtil.unescapePercentSequences(resultPath);
        return resultPath;
    }
}

