/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScopeBuilder;
import com.intellij.psi.search.ProjectScopeImpl;
import org.jetbrains.annotations.NotNull;

public class CoreProjectScopeBuilder
extends ProjectScopeBuilder {
    private final Project myProject;
    private final FileIndexFacade myFileIndexFacade;
    private final CoreLibrariesScope myLibrariesScope;

    public CoreProjectScopeBuilder(Project project, FileIndexFacade fileIndexFacade) {
        this.myFileIndexFacade = fileIndexFacade;
        this.myProject = project;
        this.myLibrariesScope = new CoreLibrariesScope();
    }

    @Override
    @NotNull
    public GlobalSearchScope buildLibrariesScope() {
        CoreLibrariesScope coreLibrariesScope = this.myLibrariesScope;
        if (coreLibrariesScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/core/CoreProjectScopeBuilder.buildLibrariesScope must not return null");
        }
        return coreLibrariesScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope buildAllScope() {
        EverythingGlobalScope everythingGlobalScope = new EverythingGlobalScope();
        if (everythingGlobalScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/core/CoreProjectScopeBuilder.buildAllScope must not return null");
        }
        return everythingGlobalScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope buildProjectScope() {
        ProjectScopeImpl projectScopeImpl = new ProjectScopeImpl(this.myProject, this.myFileIndexFacade);
        if (projectScopeImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/core/CoreProjectScopeBuilder.buildProjectScope must not return null");
        }
        return projectScopeImpl;
    }

    @Override
    @NotNull
    public GlobalSearchScope buildContentScope() {
        ContentSearchScope contentSearchScope = new ContentSearchScope(this.myProject, this.myFileIndexFacade);
        if (contentSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/core/CoreProjectScopeBuilder.buildContentScope must not return null");
        }
        return contentSearchScope;
    }

    public static class ContentSearchScope
    extends GlobalSearchScope {
        private final FileIndexFacade myFileIndexFacade;

        public ContentSearchScope(Project project, FileIndexFacade fileIndexFacade) {
            super(project);
            this.myFileIndexFacade = fileIndexFacade;
        }

        @Override
        public boolean contains(VirtualFile file) {
            return this.myFileIndexFacade.isInContent(file);
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreProjectScopeBuilder$ContentSearchScope.isSearchInModuleContent must not be null");
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }
    }

    private class CoreLibrariesScope
    extends GlobalSearchScope {
        private CoreLibrariesScope() {
        }

        @Override
        public boolean contains(VirtualFile file) {
            return CoreProjectScopeBuilder.this.myFileIndexFacade.isInLibraryClasses(file) || CoreProjectScopeBuilder.this.myFileIndexFacade.isInLibrarySource(file);
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreProjectScopeBuilder$CoreLibrariesScope.isSearchInModuleContent must not be null");
            }
            return false;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }
    }
}

