/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreJavaFileManager
implements JavaFileManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.core.CoreJavaFileManager");
    private final List<VirtualFile> myClasspath = new ArrayList<VirtualFile>();
    private final PsiManager myPsiManager;

    public CoreJavaFileManager(PsiManager psiManager) {
        this.myPsiManager = psiManager;
    }

    private List<VirtualFile> roots() {
        return this.myClasspath;
    }

    @Override
    public PsiPackage findPackage(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaFileManager.findPackage must not be null");
        }
        List<VirtualFile> files = this.findDirectoriesByPackageName(packageName);
        if (files.size() > 0) {
            return new PsiPackageImpl(this.myPsiManager, packageName);
        }
        return null;
    }

    private List<VirtualFile> findDirectoriesByPackageName(String packageName) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        String dirName = packageName.replace(".", "/");
        for (VirtualFile root : this.roots()) {
            VirtualFile classDir = root.findFileByRelativePath(dirName);
            if (classDir == null) continue;
            result.add(classDir);
        }
        return result;
    }

    @Nullable
    public PsiPackage getPackage(PsiDirectory dir) {
        VirtualFile file = dir.getVirtualFile();
        for (VirtualFile root : this.myClasspath) {
            String relativePath;
            if (!VfsUtilCore.isAncestor(root, file, false) || (relativePath = FileUtil.getRelativePath(FileUtilRt.toSystemIndependentName(root.getPath()), FileUtilRt.toSystemIndependentName(file.getPath()), '/')) == null) continue;
            return new PsiPackageImpl(this.myPsiManager, relativePath.replace('/', '.'));
        }
        return null;
    }

    @Override
    public PsiClass findClass(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaFileManager.findClass must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/core/CoreJavaFileManager.findClass must not be null");
        }
        for (VirtualFile root : this.roots()) {
            PsiClass psiClass = CoreJavaFileManager.findClassInClasspathRoot(qName, root, this.myPsiManager);
            if (psiClass == null) continue;
            return psiClass;
        }
        return null;
    }

    @Nullable
    public static PsiClass findClassInClasspathRoot(String qName, VirtualFile root, PsiManager psiManager) {
        String rootClassName;
        String pathComponent;
        VirtualFile child;
        int dot;
        String pathRest = qName;
        VirtualFile cur = root;
        while ((dot = pathRest.indexOf(46)) >= 0 && (child = cur.findChild(pathComponent = pathRest.substring(0, dot))) != null) {
            pathRest = pathRest.substring(dot + 1);
            cur = child;
        }
        String className = pathRest.replace('.', '$');
        int bucks = className.indexOf(36);
        if (bucks < 0) {
            rootClassName = className;
        } else {
            rootClassName = className.substring(0, bucks);
            className = className.substring(bucks + 1);
        }
        VirtualFile vFile = cur.findChild(rootClassName + ".class");
        if (vFile == null) {
            vFile = cur.findChild(rootClassName + ".java");
        }
        if (vFile != null) {
            PsiClass[] classes;
            if (!vFile.isValid()) {
                LOG.error("Invalid child of valid parent: " + vFile.getPath() + "; " + root.isValid() + " path=" + root.getPath());
                return null;
            }
            PsiFile file = psiManager.findFile(vFile);
            if (file instanceof PsiClassOwner && (classes = ((PsiClassOwner)file).getClasses()).length == 1) {
                PsiClass curClass = classes[0];
                if (bucks > 0) {
                    int newComponentStart = 0;
                    int lookupStart = 0;
                    while (lookupStart <= className.length()) {
                        int b = className.indexOf("$", lookupStart);
                        b = b < 0 ? className.length() : b;
                        String component = className.substring(newComponentStart, b);
                        PsiClass inner = curClass.findInnerClassByName(component, false);
                        lookupStart = b + 1;
                        if (inner == null) continue;
                        newComponentStart = lookupStart;
                        curClass = inner;
                    }
                    if (lookupStart != newComponentStart) {
                        return null;
                    }
                }
                return curClass;
            }
        }
        return null;
    }

    @Override
    public PsiClass[] findClasses(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/core/CoreJavaFileManager.findClasses must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/core/CoreJavaFileManager.findClasses must not be null");
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (VirtualFile file : this.roots()) {
            PsiClass psiClass = CoreJavaFileManager.findClassInClasspathRoot(qName, file, this.myPsiManager);
            if (psiClass == null) continue;
            result.add(psiClass);
        }
        return result.toArray(new PsiClass[result.size()]);
    }

    @Override
    public Collection<String> getNonTrivialPackagePrefixes() {
        return Collections.emptyList();
    }

    @Override
    public void initialize() {
    }

    public void addToClasspath(VirtualFile root) {
        this.myClasspath.add(root);
    }
}

