/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.diagnostics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticFactoryToRendererMap;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.Renderer;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ConflictingJvmDeclarationsData;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;

public class DefaultErrorMessagesJvm
implements DefaultErrorMessages.Extension {
    private static final Renderer<ConflictingJvmDeclarationsData> CONFLICTING_JVM_DECLARATIONS_DATA = new Renderer<ConflictingJvmDeclarationsData>(){

        @Override
        @NotNull
        public String render(@NotNull ConflictingJvmDeclarationsData data2) {
            if (data2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/kotlin/resolve/jvm/diagnostics/DefaultErrorMessagesJvm$1", "render"));
            }
            StringBuilder sb = new StringBuilder();
            for (JvmDeclarationOrigin origin : data2.getSignatureOrigins()) {
                DeclarationDescriptor descriptor2 = origin.getDescriptor();
                if (descriptor2 == null) continue;
                sb.append("    ").append(DescriptorRenderer.COMPACT.render(descriptor2)).append("\n");
            }
            String string = ("The following declarations have the same JVM signature (" + data2.getSignature().getName() + data2.getSignature().getDesc() + "):\n" + sb).trim();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/diagnostics/DefaultErrorMessagesJvm$1", "render"));
            }
            return string;
        }
    };
    public static final DiagnosticFactoryToRendererMap MAP = new DiagnosticFactoryToRendererMap();

    @Override
    @NotNull
    public DiagnosticFactoryToRendererMap getMap() {
        DiagnosticFactoryToRendererMap diagnosticFactoryToRendererMap = MAP;
        if (diagnosticFactoryToRendererMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/diagnostics/DefaultErrorMessagesJvm", "getMap"));
        }
        return diagnosticFactoryToRendererMap;
    }

    static {
        MAP.put(ErrorsJvm.CONFLICTING_JVM_DECLARATIONS, "Platform declaration clash: {0}", CONFLICTING_JVM_DECLARATIONS_DATA);
        MAP.put(ErrorsJvm.ACCIDENTAL_OVERRIDE, "Accidental override: {0}", CONFLICTING_JVM_DECLARATIONS_DATA);
        MAP.put(ErrorsJvm.JVM_STATIC_NOT_IN_OBJECT, "Only functions in named objects and companion objects of classes can be annotated with 'JvmStatic'");
        MAP.put(ErrorsJvm.OVERRIDE_CANNOT_BE_STATIC, "Override member cannot be 'JvmStatic' in object");
        MAP.put(ErrorsJvm.OVERLOADS_WITHOUT_DEFAULT_ARGUMENTS, "''JvmOverloads'' annotation has no effect for methods without default arguments");
        MAP.put(ErrorsJvm.OVERLOADS_ABSTRACT, "''JvmOverloads'' annotation cannot be used on abstract methods");
        MAP.put(ErrorsJvm.OVERLOADS_PRIVATE, "''JvmOverloads'' annotation has no effect on private and local declarations");
        MAP.put(ErrorsJvm.INAPPLICABLE_JVM_NAME, "''JvmName'' annotation is not applicable to this declaration");
        MAP.put(ErrorsJvm.ILLEGAL_JVM_NAME, "Illegal JVM name");
        MAP.put(ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_BE_ABSTRACT, "External declaration can not be abstract");
        MAP.put(ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_HAVE_BODY, "External declaration can not have a body");
        MAP.put(ErrorsJvm.EXTERNAL_DECLARATION_IN_TRAIT, "Members of interfaces can not be external");
        MAP.put(ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_BE_INLINED, "Members of interfaces can not be external");
        MAP.put(ErrorsJvm.POSITIONED_VALUE_ARGUMENT_FOR_JAVA_ANNOTATION, "Only named arguments are available for Java annotations");
        MAP.put(ErrorsJvm.DEPRECATED_ANNOTATION_METHOD_CALL, "Annotation methods are deprecated. Use property instead");
        MAP.put(ErrorsJvm.DEPRECATED_JAVA_ANNOTATION, "This annotation is deprecated in Kotlin. Use ''{0}'' instead", Renderers.TO_STRING);
        MAP.put(ErrorsJvm.NON_SOURCE_REPEATED_ANNOTATION, "Only annotations with SOURCE retention can be repeated on JVM version before 1.8");
        MAP.put(ErrorsJvm.ANNOTATION_IS_NOT_APPLICABLE_TO_MULTIFILE_CLASSES, "Annotation {0} is not applicable to the multi-file classes", Renderers.TO_STRING);
        MAP.put(ErrorsJvm.NO_REFLECTION_IN_CLASS_PATH, "Call uses reflection API which is not found in compilation classpath. Make sure you have kotlin-reflect.jar in the classpath");
        MAP.put(ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS, "Expected type does not accept nulls in {0}, but the value may be null in {1}", Renderers.TO_STRING, Renderers.TO_STRING);
        MAP.put(ErrorsJvm.TRAIT_CANT_CALL_DEFAULT_METHOD_VIA_SUPER, "Interfaces can't call Java default methods via super");
        MAP.put(ErrorsJvm.WHEN_ENUM_CAN_BE_NULL_IN_JAVA, "Enum argument can be null in Java, but exhaustive when contains no null branch");
        MAP.put(ErrorsJvm.INAPPLICABLE_PUBLIC_FIELD, "publicField annotation is not applicable to this declaration");
        MAP.put(ErrorsJvm.JAVA_CLASS_ON_COMPANION, "The resulting type of this ''javaClass'' call is {0} and not {1}. Please use the more clear ''::class.java'' syntax to avoid confusion", Renderers.RENDER_TYPE, Renderers.RENDER_TYPE);
        MAP.put(ErrorsJvm.JAVA_TYPE_MISMATCH, "Java type mismatch expected {1} but found {0}. Use explicit cast", Renderers.RENDER_TYPE, Renderers.RENDER_TYPE);
        MAP.put(ErrorsJvm.DUPLICATE_CLASS_NAMES, "Duplicate JVM class name ''{0}'' generated from: {1}", Renderers.TO_STRING, Renderers.TO_STRING);
        MAP.put(ErrorsJvm.UPPER_BOUND_CANNOT_BE_ARRAY, "Upper bound of a type parameter cannot be an array");
    }
}

