/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.callResolverUtil;

import com.google.common.collect.Lists;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetMultiDeclarationEntry;
import org.jetbrains.kotlin.psi.JetOperationReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetSuperExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\u0002\u0010)Ar-\u001a;FM\u001a,7\r^5wK\u0016C\b/Z2uK\u0012$\u0016\u0010]3\u000b'A\f'/Y7fi\u0016\u0014H)Z:de&\u0004Ho\u001c:\u000b1Y\u000bG.^3QCJ\fW.\u001a;fe\u0012+7o\u0019:jaR|'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015-!Wm]2sSB$xN]:\u000b\u0011\u0005\u0014x-^7f]RTQBV1mk\u0016\f%oZ;nK:$(b\u00019tS*9!*\u001a;UsB,'\"\u0002;za\u0016\u001c(BE\"bY2\u0014Vm]8mm\u0016\u0014X\u000b^5m\u0017RTQcZ3u\u000bJ\f7/\u001a3SK\u000e,\u0017N^3s)f\u0004XMC\u000esK\u000e,\u0017N^3s!\u0006\u0014\u0018-\\3uKJ$Um]2sSB$xN\u001d\u0006\u001c%\u0016\u001cW-\u001b<feB\u000b'/Y7fi\u0016\u0014H)Z:de&\u0004Ho\u001c:\u000b\u0015\u0011,7o\u0019:jaR|'O\u0003\nDC2d\u0017M\u00197f\t\u0016\u001c8M]5qi>\u0014(bI4fiB\u000b'/Y7fi\u0016\u0014\u0018I]4v[\u0016tGo](g\u0007\u0006dG.\u00192mKRK\b/\u001a\u0006\u0005if\u0004XM\u0003\u0003MSN$(B\u0004+za\u0016\u0004&o\u001c6fGRLwN\u001c\u0006\u0018W>$H.\u001b8/UZlg\u0006\u00157bi\u001a|'/\u001c+za\u0016TAA[1wC*!Q\u000f^5m\u0015a9W\r\u001e*fiV\u0014h\u000eV=qK\u001a{'oQ1mY\u0006\u0014G.\u001a\u0006\b\u001d>$h*\u001e7m\u0015-\tgN\\8uCRLwN\\:\u000b-\u001d,GoU;qKJ\u001c\u0015\r\u001c7FqB\u0014Xm]:j_:TAaY1mY*!1)\u00197m\u0015IQU\r^*va\u0016\u0014X\t\u001f9sKN\u001c\u0018n\u001c8\u000b7!\f7/\u00168l]><hNR;oGRLwN\u001c)be\u0006lW\r^3s\u0015\u001d\u0011un\u001c7fC:TA\u0003[1t+:\\gn\\<o%\u0016$XO\u001d8UsB,'\u0002E5t\u0007>tg/\u001a8uS>t7)\u00197m\u0015%J7/\u00138w_.,7)\u00197m\u001f:,\u0005\u0010\u001d:fgNLwN\\,ji\"\u0014u\u000e\u001e5SK\u000e,\u0017N^3sg*1\u0012n]%om>\\WmQ1mY>sg+\u0019:jC\ndWM\u0003\rjg>\u0013xJ^3se&$Wm]*z]RDWm]5{K\u0012T\u0001dQ1mY\u0006\u0014G.Z'f[\n,'\u000fR3tGJL\u0007\u000f^8s\u0015i\u0011X\r\u001d7bG\u0016\u0014V\r^;s]RK\b/\u001a\"z+:\\gn\\<o\u0015Q\u0011X\r\u001d7bG\u0016$\u0016\u0010]3Be\u001e,X.\u001a8ug*aa.Z<Be\u001e,X.\u001a8ug*Y!*\u001a;UsB,\u0017*\u001c9m\u0015UA\u0017m]%oM\u0016\u0014(/\u001a3SKR,(O\u001c+za\u0016T\u0001cY8ogR\u0014\u0018-\u001b8u'f\u001cH/Z7\u000b!\r{gn\u001d;sC&tGoU=ti\u0016l'b\u0002:fg>dg/\u001a\u0006\u0006G\u0006dGn\u001d\u0006\nS:4WM]3oG\u0016T\u0001\u0006[1t%\u0016$XO\u001d8UsB,G)\u001a9f]\u0012,g\u000e^(o+:LgNZ3se\u0016$\u0007+\u0019:b[NT A\u0003\u0002\u0011\u0007)!\u0001\u0002\u0001\t\u0005\u0015\u0011A\u0011\u0001E\u0003\u000b\t!\u0011\u0001C\u0002\u0006\u0007\u0011\r\u0001\"\u0001\u0007\u0001\u000b\t!\u0011\u0001#\u0003\u0006\u0007\u0011\u0015\u0001\u0002\u0002\u0007\u0001\u000b\t!\u0011\u0001c\u0003\u0006\u0007\u0011\u001d\u0001\"\u0002\u0007\u0001\u000b\t!9\u0001C\u0003\u0006\u0005\u0011\r\u0001\"A\u0003\u0003\t\u000bAA!B\u0002\u0005\u0004!=A\u0002A\u0003\u0004\t\u0007A\t\u0002\u0004\u0001\u0006\u0005\u0011\r\u0001rB\u0003\u0003\t\u0007A\t\"B\u0001\t\u0006\u0015\u0019A\u0001\u0003\u0005\u000b\u0019\u0001)1\u0001b\u0002\t\u00161\u0001Q!\u0001E\f\u000b\t!\u0019\u0002\u0003\u0007\u0006\u0005\u0011Q\u0001BC\u0003\u0003\t\u0003AY\"B\u0002\u0005\u0017!iA\u0002A\u0003\u0004\t\u000bAq\u0002\u0004\u0001\u0006\u0007\u0011\u0015\u0001r\u0004\u0007\u0001\u000b\t!)\u0001c\b\u0006\u0005\u0011\u0015\u0001bD\u0003\u0004\t!A\t\u0003\u0004\u0001\u0006\u0007\u0011\r\u0001r\u0005\u0007\u0001\u000b\t!\u0019\u0001c\n\u0006\u0007\u0011\u001d\u00012\u0006\u0007\u0001\u000b\t!9\u0001c\u000b\u0006\u0005\u0011\t\u0001rF\u0003\u0003\tCA\u0001$\u0002\u0002\u0005#!ERa\u0001C\u0012\u0011]a\u0001!\u0002\u0002\u0005$!9R!\t\u0003\u00041\u0001iz\u0001\u0002\u0001\t\u00025\u0019Q!\u0001\u0005\u00031\t\u00016\u0001AO\b\t\u0001A9!D\u0002\u0006\u0003!\u0019\u0001d\u0001)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u00051\u0011\t6a\u0002\u0003\u0001\u0013\u0005AI!D\u0001\t\u000b5\t\u00012\u0002-\u0004\r\u0015\tCa\u0001M\u0007;\u001f!\u0001\u0001C\u0004\u000e\u0007\u0015\t\u0001B\u0002\r\u0007!\u000e\u0001Qt\u0002\u0003\u0001\u0011!i1!B\u0001\t\u000ea5\u0001k!\u0001\"\u0007\u0015\t\u0001\u0002\u0002\r\u0005#\u000e9AQB\u0005\u0002\u0011\u0013i\u0011\u0001C\u0004\u000e\u0003!=\u0001l\u0001\u0004\u0006D\u0011\t\u0001$CO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!!\u0001\u0004\u0002)\u0004\u0001\u0005rQ!\u0001E\t\u0013)I\u0011\"B\u0001\t\u0013AYQ\u0003B\u0003\u0002\u0011%a\t\u0001G\u0005\u0019\u0013aE\u0011kA\u0003\u0005\u0013%\t\u0001RC\u0007\u0002\u0011\u0013A6AB\u0003\u001a\t\u0005AJ\"h\u0004\u0005\u0001!MQbA\u0003\u0002\u0011\u0011AB\u0001U\u0002\u0001C\u0017)\u0011\u0001\u0003\u0003\u0019\tE\u001b\u0011\u0001b\u0006R\u0007\u0015!I\"C\u0001\t\n5\t\u0001\u0012\u0002-\u0004\r\u0015=Ba\u0001\r\u000f;\u001f!\u0001\u0001#\b\u000e\u0007\u0015\t\u0001\u0002\u0004\r\r!\u000e\u0001\u0011\u0005B\u0003\u0002\u00113a\t\u0001'\u0007R\u0007\u0015!a\"C\u0001\t\u001b5\t\u00012\u0004-\u0004\r\u00155Ba\u0001\r\u0011;\u001f!\u0001\u0001c\u0005\u000e\u0007\u0015\t\u0001\u0002\u0002\r\u0005!\u000e\u0001\u0011eA\u0003\u0002\u00119Ab\"U\u0002\u0006\tAI\u0011\u0001\"\u0001\u000e\u0003!%\u0001l\u0001\u0004\u0006.\u0011\u0019\u0001$EO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!!\u0001\u0004\u0002)\u0004\u0001\u0005\u001aQ!\u0001\u0005\u000f19\t6!\u0002\u0003\u0012\u0013\u0005!\t!D\u0001\t\na\u001ba!\"\f\u0005\u0007a\rRt\u0002\u0003\u0001\u0011;i1!B\u0001\t\u0019aa\u0001k\u0001\u0001\"\u0007\u0015\t\u0001B\u0004\r\u000f#\u000e)A1E\u0005\u0002\t\u0003i\u0011\u0001c\u0007Y\u0007\u0019)i\u0003B\u0002\u0019%u=A\u0001\u0001E\u000f\u001b\r)\u0011\u0001\u0003\u0007\u0019\u0019A\u001b\u0001!I\u0002\u0006\u0003!q\u0001DD)\u0004\u000b\u0011\u0011\u0012\"\u0001C\u0001\u001b\u0005AY\u0002W\u0002\u0007\u000b[!1\u0001'\n\u001e\u0010\u0011\u0001\u0001RD\u0007\u0004\u000b\u0005AA\u0002\u0007\u0007Q\u0007\u0001\t3!B\u0001\t\u001daq\u0011kA\u0003\u0005&%\tA\u0011A\u0007\u0002\u00117A6ABC\u0017\t\rA2#h\u0004\u0005\u0001!AQbA\u0003\u0002\u0011;Aj\u0002U\u0002\u0001C\r)\u0011\u0001\u0003\b\u0019\u001dE\u001bQ\u0001B\n\n\u0003\u0011\u0005Q\"\u0001\u0005\u00101\u000e1QQ\u0006\u0003\u00041Qiz\u0001\u0002\u0001\t\u00145\u0019Q!\u0001\u0005\u00051\u0011\u00016\u0001A\u0011\u0004\u000b\u0005AA\u0001\u0007\u0003R\u0007\u0015!A#C\u0001\t\n5\t\u0001\u0012\u0002-\u0004\r\u00151C!\u0001M\u0015;\u001f!\u0001\u0001c\u0005\u000e\u0007\u0015\t\u0001\u0002\u0002\r\u0005!\u000e\u0001Q\u0014\u0004\u0003\u0001\u0011Ui\u0001\"B\u0001\t\u0012%!\u0011bA\u0003\u0002\u0011%A\u0012\u0002'\u0005Q\u0007\u0003\t3!B\u0001\t a}\u0011kA\u0004\u0005*%\t\u0001\u0002E\u0007\u0002\u0011\u0013i\u0011\u0001#\u0006Y\u0007\u0019)I\u0004B\u0002\u0016\u0007\u0015\t\u0001R\u0002M\u00071Yiz\u0001\u0002\u0001\t.5\u0019Q!\u0001\u0005\u00131I\u00016\u0011A\u0011\u0004\u000b\u0005Aa\u0002\u0007\bR\u0007\u001d!a#C\u0001\u0005\u00025\t\u0001rB\u0007\u0002\u0011KA6ABC\u001d\t\u0005)2!B\u0001\t\u000ea5\u0001$GO\b\t\u0001Ai#D\u0002\u0006\u0003!\u0011\u0002D\u0005)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u000f19\t6a\u0002\u0003\u001a\u0013\u0005!\t!D\u0001\t\u00105\t\u0001R\u0005-\u0004\r\u0001"})
public final class CallResolverUtilKt {
    public static final boolean hasUnknownFunctionParameter(@NotNull JetType type2) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull(type2, "type");
            boolean value = ReflectionTypes.Companion.isCallableType(type2);
            if (PreconditionsKt.getASSERTIONS_ENABLED() && !value) {
                String message = "type " + type2 + " is not a function or property";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            Iterable $receiver = CallResolverUtilKt.getParameterArgumentsOfCallableType(type2);
            for (Object element : $receiver) {
                TypeProjection it2 = (TypeProjection)element;
                if (!(TypeUtils.containsSpecialType(it2.getType(), TypeUtils.DONT_CARE) || ErrorUtils.containsUninferredParameter(it2.getType()))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean hasUnknownReturnType(@NotNull JetType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        boolean value = ReflectionTypes.Companion.isCallableType(type2);
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value) {
            String message = "type " + type2 + " is not a function or property";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        return ErrorUtils.containsErrorType(CallResolverUtilKt.getReturnTypeForCallable(type2));
    }

    @NotNull
    public static final JetType replaceReturnTypeByUnknown(@NotNull JetType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        boolean value = ReflectionTypes.Companion.isCallableType(type2);
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value) {
            String message = "type " + type2 + " is not a function or property";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        ArrayList<TypeProjectionImpl> newArguments = Lists.newArrayList();
        newArguments.addAll((Collection)CallResolverUtilKt.getParameterArgumentsOfCallableType(type2));
        newArguments.add(new TypeProjectionImpl(Variance.INVARIANT, TypeUtils.DONT_CARE));
        List list = newArguments;
        Intrinsics.checkExpressionValueIsNotNull(list, "newArguments");
        return CallResolverUtilKt.replaceTypeArguments(type2, list);
    }

    @NotNull
    public static final JetTypeImpl replaceTypeArguments(@NotNull JetType type2, @NotNull List<? extends TypeProjection> newArguments) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(newArguments, "newArguments");
        Annotations annotations2 = type2.getAnnotations();
        Intrinsics.checkExpressionValueIsNotNull(annotations2, "type.getAnnotations()");
        TypeConstructor typeConstructor2 = type2.getConstructor();
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "type.getConstructor()");
        boolean bl = type2.isMarkedNullable();
        JetScope jetScope = type2.getMemberScope();
        Intrinsics.checkExpressionValueIsNotNull(jetScope, "type.getMemberScope()");
        return JetTypeImpl.Companion.create(annotations2, typeConstructor2, bl, newArguments, jetScope);
    }

    @NotNull
    public static final List<TypeProjection> getParameterArgumentsOfCallableType(@NotNull JetType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return CollectionsKt.dropLast(type2.getArguments(), 1);
    }

    @NotNull
    public static final JetType getReturnTypeForCallable(@NotNull JetType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return CollectionsKt.last(type2.getArguments()).getType();
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean hasReturnTypeDependentOnUninferredParams(CallableDescriptor $receiver, @NotNull ConstraintSystem constraintSystem) {
        boolean bl;
        block3: {
            void $receiver2;
            Iterable receiver;
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Intrinsics.checkParameterIsNotNull(constraintSystem, "constraintSystem");
            JetType jetType = $receiver.getReturnType();
            if (jetType == null) {
                return false;
            }
            JetType returnType2 = jetType;
            ConstraintSystem constraintSystem2 = constraintSystem;
            if (constraintSystem2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl");
            }
            ConstraintSystemImpl constraintSystemImpl = (ConstraintSystemImpl)constraintSystem2;
            ConstraintSystemImpl $receiver3 = (ConstraintSystemImpl)((Object)receiver);
            List nestedTypeVariables = ConstraintSystemImpl.getNestedTypeVariables$default($receiver3, returnType2, false, 1);
            receiver = nestedTypeVariables;
            for (Object element : $receiver2) {
                TypeParameterDescriptor it2 = (TypeParameterDescriptor)element;
                if (!(((ConstraintSystemImpl)constraintSystem).getTypeBounds(it2).getValue() == null)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean hasInferredReturnType(CallableDescriptor $receiver, @NotNull ConstraintSystem constraintSystem) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(constraintSystem, "constraintSystem");
        if (CallResolverUtilKt.hasReturnTypeDependentOnUninferredParams($receiver, constraintSystem)) {
            return false;
        }
        return !constraintSystem.getStatus().hasOnlyErrorsDerivedFrom(ConstraintPositionKind.EXPECTED_TYPE_POSITION);
    }

    @NotNull
    public static final JetType getErasedReceiverType(@NotNull ReceiverParameterDescriptor receiverParameterDescriptor, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(receiverParameterDescriptor, "receiverParameterDescriptor");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        JetType receiverType = receiverParameterDescriptor.getType();
        for (TypeParameterDescriptor typeParameter : descriptor2.getTypeParameters()) {
            if (!Intrinsics.areEqual(typeParameter.getTypeConstructor(), receiverType.getConstructor())) continue;
            receiverType = typeParameter.getUpperBoundsAsType();
        }
        List fakeTypeArguments = ContainerUtil.newSmartList();
        for (TypeProjection typeProjection : receiverType.getArguments()) {
            fakeTypeArguments.add(new TypeProjectionImpl(typeProjection.getProjectionKind(), TypeUtils.DONT_CARE));
        }
        Annotations annotations2 = receiverType.getAnnotations();
        Intrinsics.checkExpressionValueIsNotNull(annotations2, "receiverType.getAnnotations()");
        TypeConstructor typeConstructor2 = receiverType.getConstructor();
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "receiverType.getConstructor()");
        boolean bl = receiverType.isMarkedNullable();
        List list = fakeTypeArguments;
        Intrinsics.checkExpressionValueIsNotNull(list, "fakeTypeArguments");
        JetScope jetScope = ErrorUtils.createErrorScope("Error scope for erased receiver type", true);
        Intrinsics.checkExpressionValueIsNotNull(jetScope, "ErrorUtils.createErrorSc\u2026/*throwExceptions=*/true)");
        return JetTypeImpl.Companion.create(annotations2, typeConstructor2, bl, list, jetScope);
    }

    public static final boolean isOrOverridesSynthesized(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (Intrinsics.areEqual((Object)descriptor2.getKind(), (Object)CallableMemberDescriptor.Kind.SYNTHESIZED)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)descriptor2.getKind(), (Object)CallableMemberDescriptor.Kind.FAKE_OVERRIDE)) {
            boolean bl;
            block3: {
                Iterable $receiver = descriptor2.getOverriddenDescriptors();
                for (Object element : $receiver) {
                    CallableMemberDescriptor it2;
                    CallableMemberDescriptor callableMemberDescriptor = it2 = (CallableMemberDescriptor)element;
                    Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "it");
                    if (CallResolverUtilKt.isOrOverridesSynthesized(callableMemberDescriptor)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public static final boolean isConventionCall(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        if (call instanceof CallTransformer.CallForImplicitInvoke) {
            return true;
        }
        JetElement callElement = call.getCallElement();
        if (callElement instanceof JetArrayAccessExpression || callElement instanceof JetMultiDeclarationEntry) {
            return true;
        }
        JetExpression jetExpression = call.getCalleeExpression();
        if (!(jetExpression instanceof JetOperationReferenceExpression)) {
            jetExpression = null;
        }
        JetOperationReferenceExpression jetOperationReferenceExpression = (JetOperationReferenceExpression)jetExpression;
        if (jetOperationReferenceExpression == null) {
            return false;
        }
        JetOperationReferenceExpression calleeExpression = jetOperationReferenceExpression;
        return calleeExpression.getNameForConventionalOperation() != null;
    }

    public static final boolean isInvokeCallOnVariable(@NotNull Call call) {
        ReceiverValue dispatchReceiver;
        Intrinsics.checkParameterIsNotNull(call, "call");
        if (call.getCallType() != Call.CallType.INVOKE) {
            return false;
        }
        ReceiverValue receiverValue = dispatchReceiver = call.getDispatchReceiver();
        if (receiverValue == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver");
        }
        JetExpression expression = ((ExpressionReceiver)receiverValue).getExpression();
        return expression instanceof JetSimpleNameExpression;
    }

    public static final boolean isInvokeCallOnExpressionWithBothReceivers(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        if (call.getCallType() != Call.CallType.INVOKE || CallResolverUtilKt.isInvokeCallOnVariable(call)) {
            return false;
        }
        return call.getExplicitReceiver().exists() && call.getDispatchReceiver().exists();
    }

    @Nullable
    public static final JetSuperExpression getSuperCallExpression(@NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(call, "call");
        ReceiverValue receiverValue = call.getExplicitReceiver();
        if (!(receiverValue instanceof ExpressionReceiver)) {
            receiverValue = null;
        }
        ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
        JetExpression jetExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        if (!(jetExpression instanceof JetSuperExpression)) {
            jetExpression = null;
        }
        return (JetSuperExpression)jetExpression;
    }

    @NotNull
    public static final JetType getEffectiveExpectedType(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument) {
        Intrinsics.checkParameterIsNotNull(parameterDescriptor, "parameterDescriptor");
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        if (argument.getSpreadElement() != null) {
            if (parameterDescriptor.getVarargElementType() == null) {
                JetType jetType = TypeUtils.DONT_CARE;
                Intrinsics.checkExpressionValueIsNotNull(jetType, "DONT_CARE");
                return jetType;
            }
            JetType jetType = parameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull(jetType, "parameterDescriptor.getType()");
            return jetType;
        }
        JetType varargElementType = parameterDescriptor.getVarargElementType();
        if (varargElementType != null) {
            return varargElementType;
        }
        JetType jetType = parameterDescriptor.getType();
        Intrinsics.checkExpressionValueIsNotNull(jetType, "parameterDescriptor.getType()");
        return jetType;
    }
}

