/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsRootScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.gwt.dev.js.parserExceptions.AbortParsingException;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCodeErrorReporter;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.JetValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.TypeUtils;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={";\u0006)i!j]\"bY2\u001c\u0005.Z2lKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0003UNTqA]3t_24XMC\u0006eS\u0006<gn\\:uS\u000e\u001c(bC\"bY2\u001c\u0005.Z2lKJTQaY1mYNT\u0001b\u00195fG.,'o\u001d\u0006\u0007y%t\u0017\u000e\u001e \u000b7\r|gn\u001d;b]R,\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8s\u0015m\u0019uN\\:uC:$X\t\u001f9sKN\u001c\u0018n\u001c8Fm\u0006dW/\u0019;pe*I1m\u001c8ti\u0006tGo\u001d\u0006\tKZ\fG.^1uK*\taI\u0003\nDC2d\u0017M\u00197f\t\u0016\u001c8M]5qi>\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNTQa\u00195fG.TAB]3t_24X\rZ\"bY2TABU3t_24X\rZ\"bY2TQ!\\8eK2TqaY8oi\u0016DHO\u0003\u000eCCNL7mQ1mYJ+7o\u001c7vi&|gnQ8oi\u0016DHO\u0003\u0003V]&$(\"C\"p[B\fg.[8oA\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015QA\u0001\u0003\u0003\u0011\r)1\u0001\"\u0002\t\u00011\u0001QA\u0001\u0003\u0002\u0011\u000b)!\u0001b\u0002\t\t\u0015\u0011A\u0001\u0002E\u0005\u000b\r!I\u0001c\u0002\r\u0001\u0015\u0011Aq\u0001E\u0007\u000b\t!Y\u0001C\u0004\u0006\u0007\u00111\u0001B\u0002\u0007\u0001\u000b\t!a\u0001\u0003\u0004\u0006\u0005\u0011\t\u0001\u0012C\u0003\u0004\t\u001fA\u0001\u0002\u0004\u0001\u0006\u0005\u0011!\u0001RC\u0003\u0004\t#A!\u0002\u0004\u0001\u0006\u0005\u0011!\u0001bC\u0003\u0004\t'A9\u0002\u0004\u0001\u0006\u0003!\rQa\u0001C\u000b\u00111a\u0001!\u0002\u0002\u0005\u0012!QQA\u0001C\n\u0011/!1\u0001D\u0002\u0011\u001ae\u0019Q!\u0001\u0005\u00061\u0015i\n\u0011D\u0017\r\t\u0005$\u00014B\u0011\u0004\u000b\u0005Ai\u0001'\u0004V\u0007\u0011)1\u0001b\u0003\n\u0003!9Q\u0016\f\u0003\f#\u0019!\u0001\u0001c\u0004\u0016\u0007\u0015\t\u0001\u0002\u0003\r\t1%iZ\u0002\u0002\u0001\t\u00145IQ!\u0001\u0005\n\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001\r\n!\u000e\u0001Qt\u0002\u0003\u0001\u0011-i1!B\u0001\t\u0015aQ\u0001k!\u0001\"\u0007\u0015\t\u0001b\u0003\r\f#\u000e9A!C\u0005\u0002\t\u0001i\u0011\u0001c\u0006\u000e\u0003!aQWFC\u0016\t\r\b\u0001$BO\b\t\u0001AY!D\u0002\u0006\u0003!5\u0001T\u0002)\u0004\u0001\u0005\u001aQ!\u0001\u0005\u00041\r\t6!\u0002\u0003\u0006\u0013\u0005!\u0001!D\u0001\t\u000f\u0001"})
public final class JsCallChecker
implements CallChecker {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final DescriptorPredicate JS_PATTERN;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(JsCallChecker.class);
        Companion companion = Companion = new Companion(null);
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern("kotlin.js.js(String)");
        Intrinsics.checkExpressionValueIsNotNull(descriptorPredicate, "PatternBuilder.pattern(\"kotlin.js.js(String)\")");
        JS_PATTERN = descriptorPredicate;
    }

    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (context.isAnnotationContext || !Companion.isJsCall(resolvedCall)) {
            return;
        }
        JetElement expression = resolvedCall.getCall().getCallElement();
        if (!(expression instanceof JetCallExpression)) {
            return;
        }
        JetValueArgumentList jetValueArgumentList = ((JetCallExpression)expression).getValueArgumentList();
        List<JetValueArgument> arguments2 = jetValueArgumentList != null ? jetValueArgumentList.getArguments() : null;
        List<JetValueArgument> list = arguments2;
        if (list == null || (list = CollectionsKt.firstOrNull(list)) == null || (list = ((JetValueArgument)((Object)list)).getArgumentExpression()) == null) {
            return;
        }
        List<JetValueArgument> argument = list;
        TemporaryBindingTrace trace = TemporaryBindingTrace.create(context.trace, "JsCallChecker");
        List<JetValueArgument> list2 = argument;
        Intrinsics.checkExpressionValueIsNotNull(list2, "argument");
        BindingTrace bindingTrace = trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "trace");
        CompileTimeConstant<?> evaluationResult = this.constantExpressionEvaluator.evaluateExpression((JetExpression)((Object)list2), bindingTrace, TypeUtils.NO_EXPECTED_TYPE);
        String code = Companion.extractStringValue(evaluationResult);
        if (code == null) {
            context.trace.report(ErrorsJs.JSCODE_ARGUMENT_SHOULD_BE_CONSTANT.on((JetExpression)((PsiElement)((Object)argument))));
            return;
        }
        trace.commit();
        List<JetValueArgument> list3 = argument;
        Intrinsics.checkExpressionValueIsNotNull(list3, "argument");
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace2, "context.trace");
        JsCodeErrorReporter errorReporter = new JsCodeErrorReporter((JetExpression)((Object)list3), code, bindingTrace2);
        try {
            JsFunctionScope parserScope = new JsFunctionScope(new JsRootScope(new JsProgram("<js checker>")), "<js fun>");
            List<JsStatement> statements = ParserUtilsKt.parse(code, errorReporter, parserScope);
            if (statements.size() == 0) {
                context.trace.report(ErrorsJs.JSCODE_NO_JAVASCRIPT_PRODUCED.on((JetExpression)((PsiElement)((Object)argument))));
            }
        }
        catch (AbortParsingException e) {
            // empty catch block
        }
    }

    public JsCallChecker(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator) {
        Intrinsics.checkParameterIsNotNull(constantExpressionEvaluator, "constantExpressionEvaluator");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
    }

    @JvmStatic
    public static final <F extends CallableDescriptor> boolean isJsCall(ResolvedCall<F> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return Companion.isJsCall($receiver);
    }

    @JvmStatic
    @Nullable
    public static final String extractStringValue(@Nullable CompileTimeConstant<?> compileTimeConstant) {
        return Companion.extractStringValue(compileTimeConstant);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"<\u0006)I1i\\7qC:LwN\u001c\u0006\u000e\u0015N\u001c\u0015\r\u001c7DQ\u0016\u001c7.\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T!A[:\u000b\u000fI,7o\u001c7wK*YA-[1h]>\u001cH/[2t\u0015\r\te.\u001f\u0006\u000b\u0015N{\u0006+\u0011+U\u000bJs%b\u0005#fg\u000e\u0014\u0018\u000e\u001d;peB\u0013X\rZ5dCR,'\u0002\u00039biR,'O\\:\u000b\u001b\u001d,GOS*`!\u0006#F+\u0012*O\u0015I)\u0007\u0010\u001e:bGR\u001cFO]5oOZ\u000bG.^3\u000b'\r|W\u000e]5mKRKW.Z\"p]N$\u0018M\u001c;\u000b'\r{W\u000e]5mKRKW.Z\"p]N$\u0018M\u001c;\u000b\u0013\r|gn\u001d;b]R\u001c(BB*ue&twM\u0003\u0003kCZ\f'\u0002\u00027b]\u001eT\u0011A\u0012\u0006\u0013\u0007\u0006dG.\u00192mK\u0012+7o\u0019:jaR|'OC\u0006eKN\u001c'/\u001b9u_J\u001c(\u0002\u0004*fg>dg/\u001a3DC2d'\"B2bY2\u001c(\"B7pI\u0016d'\u0002C5t\u0015N\u001c\u0015\r\u001c7\u000b\u000f\t{w\u000e\\3b]R\u000e!B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!\u0002\u0002\u0005\u0005!\u001dQa\u0001C\u0003\u0011\u0003a\u0001!B\u0002\u0005\u0007!\u0001A\u0002A\u0003\u0002\u0011\t)1\u0001\u0002\u0003\t\t1\u0001QA\u0001C\u0002\u0011\u0017)1\u0001B\u0003\t\u000b1\u0001QA\u0001\u0003\u0006\u0011\u0015)!\u0001B\u0001\t\u0007\u0015\u0011AQ\u0002\u0005\t\u000b\r!q\u0001c\u0004\r\u0001\u0015\u0019A\u0001\u0002E\t\u0019\u0001)\u0011\u0001C\u0005\u0006\u0005\u0011E\u00012C\u0003\u0003\t%A\t\"\u0002\u0002\u0005\u000f!=QA\u0001\u0003\u0002\u0011-)1\u0001\"\u0006\t\u00161\u0001QA\u0001C\u0007\u00111)!\u0001b\u0006\t\u001a\u0015\u0019A\u0001\u0004E\f\u0019\u0001)1\u0001\u0002\u0003\t\u001c1\u0001QA\u0001\u0003\r\u0011/!19\u0001G\u00043\r)\u0011\u0001#\u0003\u0019\n5\nB!\u0019\u0003\u0019\n\u0005\u001aQ!\u0001E\u00061\u0017)6!C\u0003\u0005\t\u0013I\u0011\u0001\u0003\u0004\r\u00025\u0019AAB\u0005\u0002\u0011\u0019i\u0013\u0004b\u0002\u0019\u000euUA\u0001\u0001\u0005\b\u001b\u0019)\u0011\u0001c\u0004\n\u0003\u0011\rA\u0012\u0001M\b!\u000e\u0001\u0011\u0005B\u0003\u0002\u0011!a\t\u0001\u0007\u0005R\u0007\u0015!i!C\u0001\t\u00145\t\u0001BCW\u001f\t\u000f\tr\u0001\u0002\u0001\t\u0015U!Q!\u0001\u0005\f\u0019\u0003A2\"F\u0005\u0006\u0003!e\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001ae\u0001$D\u0011\u0004\u000b\u0005AQ\u0002G\u0007R\u0007\u0015!Q\"C\u0001\u0005\u00025\t\u00012D\u001b\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        private final DescriptorPredicate getJS_PATTERN() {
            return JS_PATTERN;
        }

        @JvmStatic
        public final <F extends CallableDescriptor> boolean isJsCall(ResolvedCall<F> $receiver) {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            F descriptor2 = $receiver.getResultingDescriptor();
            return descriptor2 instanceof SimpleFunctionDescriptor && this.getJS_PATTERN().apply((FunctionDescriptor)descriptor2);
        }

        @JvmStatic
        @Nullable
        public final String extractStringValue(@Nullable CompileTimeConstant<?> compileTimeConstant) {
            CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
            if (!(compileTimeConstant2 instanceof TypedCompileTimeConstant)) {
                compileTimeConstant2 = null;
            }
            TypedCompileTimeConstant typedCompileTimeConstant = (TypedCompileTimeConstant)compileTimeConstant2;
            ConstantValue constantValue = typedCompileTimeConstant != null ? typedCompileTimeConstant.getConstantValue() : null;
            if (!(constantValue instanceof StringValue)) {
                constantValue = null;
            }
            StringValue stringValue = (StringValue)constantValue;
            return stringValue != null ? (String)stringValue.getValue() : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

