/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.repl.messages;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.repl.messages.DiagnosticMessageHolder;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"*\u0006)q\"+\u001a9m\u0013\u0012,G)[1h]>\u001cH/[2NKN\u001c\u0018mZ3I_2$WM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*\u00191\r\\5\u000b\u0007)4XN\u0003\u0003sKBd'\u0002C7fgN\fw-Z:\u000b/\u0011K\u0017m\u001a8pgRL7-T3tg\u0006<W\rS8mI\u0016\u0014(B\u0002\u001fj]&$hHC\u0006eS\u0006<gn\\:uS\u000e\u001c(\"C!se\u0006LH*[:u\u0015\u0011Q\u0017M^1\u000b\tU$\u0018\u000e\u001c\u0006\u0005!\u0006L'O\u0003\u0006ES\u0006<gn\\:uS\u000eTaa\u0015;sS:<'b\u0005:f]\u0012,'/\u001a3ES\u0006<gn\\:uS\u000e\u001c(BF4fiJ+g\u000eZ3sK\u0012$\u0015.Y4o_N$\u0018nY:\u000b\t1\fgn\u001a\u0006\u0007e\u0016\u0004xN\u001d;\u000b\u0015\u0011L\u0017m\u001a8pgRL7M\u0003\u0003gS2,'b\u0002)tS\u001aKG.\u001a\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u0007A\u001c\u0018N\u0003\u0004sK:$WM\u001d\u0006\u0005+:LGOk\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\t!!\u0001C\u0002\u0006\u0005\u0011\u0015\u0001rA\u0003\u0004\t\rA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\u0019\u0001\u0002\u0002\u0007\u0001\u000b\u0005Aa!\u0002\u0002\u0005\n!5Qa\u0001\u0003\u0006\u0011\u0017a\u0001!B\u0001\t\u0004\u0015\u0019AA\u0002\u0005\b\u0019\u0001)!\u0001B\u0001\t\u000b\u0015\u0019Aa\u0002E\b\u0019\u0001)1\u0001\u0002\u0004\t\u00111\u0001QA\u0001\u0003\u0006\u0011\u0017)!\u0001\"\u0003\t\u0014\u0015\u0011A!\u0003\u0005\t\u000b\u0005AA\"\u0002\u0002\u0005\u0015!eQA\u0001C\u000b\u00115)1\u0001B\u0006\t\u00181\u0001Qa\u0001\u0003\u0007\u00119a\u0001!\u0002\u0002\u0005\u000f!=QA\u0001\u0003\f\u0011/!1\u0001d\u0002\u001a\u0007\u0015\t\u0001\u0002\u0002\r\u0005[m!\u0011\r\u0002\r\u0006CI)\u0011\u0001c\u0003\n\u001d%iQ!\u0001E\u0007\u0013\u0011I1!B\u0001\t\u0010a=\u0011\u0002B\u0005\u0004\u000b\u0005A\u0001\u0002\u0007\u0005\u0019\u000ea-Qk\u0001\u0003\u0006\u0007\u0011)\u0011\"\u0001E\t[5!1\u000e\u0002M\tC\r)\u0011\u0001\u0003\u0005\u0019\u0011\u0011ZSk\u0001\u0003\u000e\u0007\u0011I\u0011\"\u0001E\n[)\"1\u0002\u0007\u0006\u001e\u0010\u0011\u0001\u0001RC\u0007\u0004\u000b\u0005Ay\u0001g\u0004Q\u0007\u0001iz\u0001\u0002\u0001\t\u00175\u0019Q!\u0001E\f1/\u00016\u0011AO\b\t\u0001AY\"D\u0002\u0006\u0003!A\u0001\u0004\u0003)\u0004\u0003\u0005\u001aQ!\u0001\u0005\r11\t6!\u0003\u0003\u000b\u0013\u0005!\u0001!D\u0001\t\u001a5\t\u0001\"D\u0007\u0002\u0011')D\"B\u0006\u0005G\u0004AJ!I\u0002\u0006\u0003!\u001d\u0001tA)\u0004\u0007\u0011%\u0011\"\u0001\u0003\u0001"})
public final class ReplIdeDiagnosticMessageHolder
implements DiagnosticMessageHolder {
    public static final /* synthetic */ KClass $kotlinClass;
    private final ArrayList<Pair<? extends Diagnostic, ? extends String>> diagnostics = CollectionsKt.arrayListOf(new Pair[0]);

    static {
        $kotlinClass = Reflection.createKotlinClass(ReplIdeDiagnosticMessageHolder.class);
    }

    @Override
    public void report(@NotNull Diagnostic diagnostic, @NotNull PsiFile file, @NotNull String render) {
        Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(render, "render");
        this.diagnostics.add(new Pair<Diagnostic, String>(diagnostic, render));
    }

    @Override
    @NotNull
    public String getRenderedDiagnostics() {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document errorReport = docBuilder.newDocument();
        Element rootElement = errorReport.createElement("report");
        errorReport.appendChild(rootElement);
        for (Pair<? extends Diagnostic, ? extends String> pair : this.diagnostics) {
            Diagnostic diagnostic = pair.component1();
            String message = pair.component2();
            TextRange errorRange = DiagnosticUtils.firstRange(diagnostic.getTextRanges());
            Element reportEntry = errorReport.createElement("reportEntry");
            reportEntry.setAttribute("severity", diagnostic.getSeverity().toString());
            reportEntry.setAttribute("rangeStart", String.valueOf(errorRange.getStartOffset()));
            reportEntry.setAttribute("rangeEnd", String.valueOf(errorRange.getEndOffset()));
            reportEntry.appendChild(errorReport.createTextNode(StringUtil.escapeXml(message)));
            rootElement.appendChild(reportEntry);
        }
        DOMImplementation dOMImplementation = errorReport.getImplementation();
        if (dOMImplementation == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.ls.DOMImplementationLS");
        }
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)dOMImplementation);
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        String string = lsSerializer.writeToString(errorReport);
        Intrinsics.checkExpressionValueIsNotNull(string, "lsSerializer.writeToString(errorReport)");
        return string;
    }
}

