/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.ILightStubElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.containers.Stack;
import gnu.trove.TIntStack;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LightStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.stubs.LightStubBuilder");
    public static final ThreadLocal<LighterAST> FORCED_AST = new ThreadLocal();

    @Override
    public StubElement buildStubTree(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        LighterAST tree = FORCED_AST.get();
        if (tree == null) {
            FileType fileType = file.getFileType();
            if (!(fileType instanceof LanguageFileType)) {
                LOG.error("File is not of LanguageFileType: " + fileType + ", " + file);
                return null;
            }
            Language language = ((LanguageFileType)fileType).getLanguage();
            IFileElementType contentType = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language)).getFileNodeType();
            if (!(contentType instanceof IStubFileElementType)) {
                LOG.error("File is not of IStubFileElementType: " + contentType + ", " + file);
                return null;
            }
            FileASTNode node = file.getNode();
            tree = contentType instanceof ILightStubFileElementType ? node.getLighterAST() : new TreeBackedLighterAST(node);
        } else {
            FORCED_AST.set(null);
        }
        if (tree == null) {
            return null;
        }
        StubElement rootStub = this.createStubForFile(file, tree);
        this.buildStubTree(tree, tree.getRoot(), rootStub);
        return rootStub;
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file, @NotNull LighterAST tree) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/LightStubBuilder", "createStubForFile"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/stubs/LightStubBuilder", "createStubForFile"));
        }
        PsiFileStubImpl<PsiFile> psiFileStubImpl = new PsiFileStubImpl<PsiFile>(file);
        if (psiFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/LightStubBuilder", "createStubForFile"));
        }
        return psiFileStubImpl;
    }

    protected void buildStubTree(@NotNull LighterAST tree, @NotNull LighterASTNode root, @NotNull StubElement rootStub) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        if (rootStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootStub", "com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        Stack<LighterASTNode> parents = new Stack<LighterASTNode>();
        TIntStack childNumbers = new TIntStack();
        Stack<List> kinderGarden = new Stack<List>();
        Stack<StubElement> parentStubs = new Stack<StubElement>();
        LighterASTNode parent = null;
        LighterASTNode element = root;
        List children = null;
        int childNumber = 0;
        StubElement parentStub = rootStub;
        block0: while (element != null) {
            List kids;
            StubElement stub = this.createStub(tree, element, parentStub);
            if (!(parent != null && this.skipNode(tree, parent, element) || (kids = tree.getChildren(element)).isEmpty())) {
                if (parent != null) {
                    parents.push(parent);
                    childNumbers.push(childNumber);
                    kinderGarden.push(children);
                    parentStubs.push(parentStub);
                }
                parent = element;
                children = kids;
                childNumber = 0;
                element = children.get(0);
                parentStub = stub;
                if (!this.skipNode(tree, parent, element)) continue;
            }
            while (children != null && ++childNumber < children.size()) {
                element = children.get(childNumber);
                if (this.skipNode(tree, parent, element)) continue;
                continue block0;
            }
            element = null;
            while (!parents.isEmpty()) {
                parent = (LighterASTNode)parents.pop();
                childNumber = childNumbers.pop();
                if (children != null && children.size() > 0) {
                    tree.disposeChildren(children);
                }
                children = (List)kinderGarden.pop();
                parentStub = (StubElement)parentStubs.pop();
                while (++childNumber < children.size()) {
                    element = (LighterASTNode)children.get(childNumber);
                    if (this.skipNode(tree, parent, element)) continue;
                    continue block0;
                }
                element = null;
            }
        }
    }

    protected StubElement createStub(LighterAST tree, LighterASTNode element, StubElement parentStub) {
        IElementType elementType = element.getTokenType();
        if (elementType instanceof IStubElementType) {
            if (elementType instanceof ILightStubElementType) {
                ILightStubElementType lightElementType = (ILightStubElementType)elementType;
                if (lightElementType.shouldCreateStub(tree, element, parentStub)) {
                    return lightElementType.createStub(tree, element, parentStub);
                }
            } else {
                LOG.error("Element is not of ILightStubElementType: " + LogUtil.objectAndClass(elementType) + ", " + element);
            }
        }
        return parentStub;
    }

    private boolean skipNode(@NotNull LighterAST tree, @NotNull LighterASTNode parent, @NotNull LighterASTNode node) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/stubs/LightStubBuilder", "skipNode"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/stubs/LightStubBuilder", "skipNode"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/stubs/LightStubBuilder", "skipNode"));
        }
        if (tree instanceof TreeBackedLighterAST) {
            return this.skipChildProcessingWhenBuildingStubs(((TreeBackedLighterAST)tree).unwrap(parent), ((TreeBackedLighterAST)tree).unwrap(node));
        }
        return this.skipChildProcessingWhenBuildingStubs(tree, parent, node);
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull LighterAST tree, @NotNull LighterASTNode parent, @NotNull LighterASTNode node) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }
}

