/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.rmi.service;

import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import kotlin.KotlinPackage;
import kotlin.Lazy;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.rmi.CompileService;
import org.jetbrains.kotlin.rmi.CompilerId;
import org.jetbrains.kotlin.rmi.DaemonParamsKt;
import org.jetbrains.kotlin.rmi.LoopbackNetworkInterface;
import org.jetbrains.kotlin.rmi.RemoteOutputStream;
import org.jetbrains.kotlin.rmi.service.CompileServiceImpl;
import org.jetbrains.kotlin.rmi.service.CompileServiceImpl$WhenMappings;
import org.jetbrains.kotlin.rmi.service.CompileServiceImplKt;
import org.jetbrains.kotlin.rmi.service.RemoteIncrementalCacheClient;
import org.jetbrains.kotlin.rmi.service.RemoteOutputStreamClient;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\u0016\u0014)\u00112i\\7qS2,7+\u001a:wS\u000e,\u0017*\u001c9m\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u0001:nS*91/\u001a:wS\u000e,'\u0002C\"p[BLG.\u001a:\u000b\u0017\rc\u0015jQ8na&dWM\u001d\u0006\u0004G2L'BB2p[6|gN\u0003\bD_6\u0004\u0018\u000e\\3TKJ4\u0018nY3\u000b'Us\u0017nY1tiJ+Wn\u001c;f\u001f\nTWm\u0019;\u000b\t)\fg/\u0019\u0006\u0007g\u0016\u0014h/\u001a:\u000b\rqJg.\u001b;?\u0015!\u0011XmZ5tiJL(\u0002\u0003*fO&\u001cHO]=\u000b\u0011\r|W\u000e]5mKJTab]3mM\u000e{W\u000e]5mKJLEM\u0003\u0006D_6\u0004\u0018\u000e\\3s\u0013\u0012TA\u0001]8si*\u0019\u0011J\u001c;\u000b!}c\u0017m\u001d;Vg\u0016$7+Z2p]\u0012\u001c(\u0002\u0002'p]\u001eTQ!\u00197jm\u0016TqAQ8pY\u0016\fgNC\u0006hKR\u001cu.\u001c9jY\u0016\u0014(b\u00047bgR,6/\u001a3TK\u000e|g\u000eZ:\u000b%\u001d,G\u000fT1tiV\u001bX\rZ*fG>tGm\u001d\u0006\u0004Y><'B\u0002'pO\u001e,'O\u0003\u0003vi&d'b\u00027pO\u001eLgn\u001a\u0006\u0018W>$H.\u001b8/UZlg\u0006\u00157bi\u001a|'/\u001c+za\u0016TA\u0002\\8hI\u0011,G.Z4bi\u0016TA\u0001T1{s*1q-\u001a;M_\u001eT1bZ3u%\u0016<\u0017n\u001d;ss*1!o\u001e7pG.TaCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m\u001b\u0006\u000bG>t7-\u001e:sK:$(\"\u00027pG.\u001c(\"E4fiN+GNZ\"p[BLG.\u001a:JI*\t!KC\u0002B]fTab\u00195fG.,GmQ8na&dWM\u0003\u0003be\u001e\u001c(\"B!se\u0006L(BB*ue&twM\u0003\u0006tKJ4\u0018nY3PkRT1\u0002\u0015:j]R\u001cFO]3b[*\u0011\u0011n\u001c\u0006\u0005E>$\u0017PC\u0005Gk:\u001cG/[8oa)!A.\u00198h\u0015\u0019y%M[3di*\u0019!N^7\u000b\u0013\u0019,hn\u0019;j_:\u001c(\"F2sK\u0006$XmQ8na&dWmU3sm&\u001cWm\u001d\u0006\u0012S:\u001c'/Z7f]R\fGnQ1dQ\u0016\u001c(bA'ba*AA+\u0019:hKRLEMC\u0004n_\u0012,H.Z:\u000b-I+Wn\u001c;f\u0013:\u001c'/Z7f]R\fGnQ1dQ\u0016T\u0001bU3sm&\u001cWm\u001d\u0006\u0007G>tg-[4\u000b\u0013\u0011|7i\\7qS2,'bG2p[BLG.\u001a:NKN\u001c\u0018mZ3t'R\u0014X-Y7Qe>D\u0018P\u0003\nSK6|G/Z(viB,Ho\u0015;sK\u0006l'\u0002G:feZL7-Z(viB,Ho\u0015;sK\u0006l\u0007K]8ys*Ia)\u001e8di&|g.\r\u0006\t\u000bbLGoQ8eK*iq-\u001a;D_6\u0004\u0018\u000e\\3s\u0013\u0012TQbZ3u+N,G-T3n_JL(bB5g\u00032Lg/\u001a\u0006\u0011S\u001a\fE.\u001b<f\u000bb\u001cG.^:jm\u0016TQB]3n_R,7i\\7qS2,'\u0002F2p[BLG.\u001a:PkR\u0004X\u000f^*ue\u0016\fWN\u0003\u0007pkR\u0004X\u000f\u001e$pe6\fGO\u0003\u0007PkR\u0004X\u000f\u001e$pe6\fGOC\ntKJ4\u0018nY3PkR\u0004X\u000f^*ue\u0016\fWNC\u000eD_6\u0004\u0018\u000e\\3TKJ4\u0018nY3%\u001fV$\b/\u001e;G_Jl\u0017\r\u001e\u0006\u0019e\u0016lw\u000e^3J]\u000e\u0014X-\\3oi\u0006d7i\\7qS2,'BB2bG\",7O\u0003\u000bd_6\u0004\u0018\u000e\\3s\u001fV$\b/\u001e;G_Jl\u0017\r\u001e\u0006\tg\",H\u000fZ8x]*!QK\\5u\u0015\r\u0019\b/\u001f\u0006\u0004[N<'BC;tK\u0012lU-\\8ss*aA\u000b\u001b:fC\u0012l\u0005LQ3b]*QQ.\u00198bO\u0016lWM\u001c;\u000b\u001bQD'/Z1e\u0007B,H+[7f\u00159!\bN]3bIV\u001bXM\u001d+j[\u0016TA%\u00138de\u0016lWM\u001c;bY\u000e{W\u000e]5mCRLwN\\\"p[B|g.\u001a8ug&k\u0007\u000f\u001c[\u0004\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)!\u0001B\u0001\t\t\u0015\u0011Aa\u0001E\u0005\u000b\r!9\u0001c\u0002\r\u0001\u0015\u0019A1\u0001\u0005\u0006\u0019\u0001)\u0011\u0001\u0003\u0004\u0006\u0005\u0011)\u0001BA\u0003\u0003\t\u0017Ai!B\u0002\u0005\r!-A\u0002A\u0003\u0003\t\u0017Ay!B\u0002\u0005\u000f!AA\u0002A\u0003\u0004\t\u0007A\u0019\u0002\u0004\u0001\u0006\u0003!\rQa\u0001C\t\u0011+a\u0001!\u0002\u0002\u0005\u000f!AQA\u0001C\u0004\u0011\u000f)!\u0001b\u0001\t\u0014\u0015\u0019A\u0011\u0003E\f\u0019\u0001)1\u0001\"\u0005\t\u001a1\u0001QA\u0001\u0003\u0006\u0011?)!\u0001\u0002\u0007\t!\u0015\u0019A\u0011\u0004\u0005\u0010\u0019\u0001)!\u0001\"\u0005\t$\u0015\u0011A\u0011\u0004\u0005\u0010\u000b\t!A\u0002\u0003\u000b\u0006\u0005\u0011u\u0001\u0012F\u0003\u0004\t=A9\u0003\u0004\u0001\u0006\u0005\u0011y\u0001rE\u0003\u0004\t#Aa\u0003\u0004\u0001\u0006\u0007\u0011E\u0001r\u0006\u0007\u0001\u000b\r!\t\u0002\u0003\r\r\u0001\u0015\u0011A!\u0002E\u001a\u000b\r!!\u0003C\r\r\u0001\u0015\u0019A\u0011\u0003E\u001b\u0019\u0001)!\u0001B\u0003\t7\u0015\u0011Aq\u0005E\u001c\u000b\t!9\u0003\u0003\r\u0006\u0005\u0011\u0011\u0002\"G\u0003\u0003\t#AA$\u0002\u0002\u0005,!eRA\u0001\u0003\u0017\u0011k)1\u0001\"\u0005\t=1\u0001QA\u0001\u0003\u0002\u0011})1\u0001b\f\t>1\u0001Qa\u0001C\u0005\u0011\u007fa\u0001!\u0002\u0002\u0005\u0003!\u0005Sa\u0001\u0003\u001a\u0011\u0001b\u0001!\u0002\u0002\u00053!\u0001SA\u0001\u0003\r\u0011y)1\u0001b\u0001\tE1\u0001Qa\u0001C\t\u0011\rb\u0001!B\u0002\u0005\b!\u001dC\u0002A\u0003\u0003\t\u0007A!%\u0002\u0002\u0005-!\u0019Sa\u0001C\u0005\u0011\u001fb\u0001!\u0002\u0002\u0005\u0004!ESa\u0001C\t\u0011-b\u0001!\u0002\u0002\u0005(!mSa\u0001\u0003 \u00115b\u0001!\u0002\u0002\u0005?!iCa\u0001G\u0003+!!\u0001\u0001C\u0002\u0016\u000b\u0015\t\u0001\u0002B\u0005\u0002\t\u0007AB!G\u0002\u0006\u0003!%\u0001\u0014B\r\u0004\u000b\u0005Ai\u0001'\u0004\u001e\u0002=jc\u0002ba\r1-\t3!B\u0001\t\u0017aYA%\u0001\u0015\u0002+\u000e!Qa\u0001\u0003\f\u0013\u0005!9!\f\u0007\u0005\u00034AB\"I\u0002\u0006\u0003!]\u0001tC+\u0004\t\u0015\u0019A\u0001D\u0005\u0002\t\u0003i\u0013\u0003B2\u00051#\tC!\u0002\u0002\u0005\u0002!\u0001A\u0004A+\u0004\u0011\u0015\u0019A\u0011C\u0005\u0002\u0011)i1\u0001B\u0007\n\u0003!QQ&\u0004\u0003d\tam\u0011eA\u0003\u0002\u0011-A2\u0002J\u0012V\u0007\u0011i1\u0001\u0002\b\n\u0003\u0011\u001dQf\u0006\u0003d\tau\u0011%C\u0003\u0002\u00115\u0001\n#\u0006\u0003\u0006\u0003!iA\u0012\u0001\r\u000e15!3%V\u0002\t\u000b\r!\u0011#C\u0001\t\u001c5\u0019AAE\u0005\u0002\u00119i\u0003\u0003B2\u00051\u001f\t3!B\u0001\t\u0010a=Qk\u0001\u0005\u0006\u0007\u0011=\u0011\"\u0001E\n\u001b\r!)#C\u0001\t\u00145bA!\u0019\u0003\u0019'\u0005\u001aQ!\u0001E\u00101?)6\u0001B\u0003\u0004\tMI\u0011\u0001\u0003\t.!\u0011\u0019G\u0001G\u0005\"\u0007\u0015\t\u0001\u0002\u0003\r\t+\u000eAQa\u0001\u0003\n\u0013\u0005A)\"D\u0002\u0005+%\t\u0001RC\u0017A\u0002\u0011\u0019\u0011c\u0002C\u0001\u0011W)B!B\u0001\t\"1\u0005\u0001\u0014\u0005M\u0017;7!\u0001\u0001C\f\u000e\u0013\u0015\t\u0001\"E\u0005\u0006\t\u0003I1!B\u0001\t$a\r\u0002$\u0005)\u0004\u0001u=A\u0001\u0001E\u0019\u001b\r)\u0011\u0001#\n\u0019&A\u001b\t!h\u0007\u0005\u0001!QR\"C\u0003\u0002\u0011MIQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0012\u0001O\u00011M\u00016!A\u0011\u0005\u000b\t!\t\u0001#\u0001\u001d\u0002E\u001b!\u0002\"\f\n\u0003!!RB\u0001E\u0015\u0019\u0003i\u0011\u0001C\u000b\u000e\u0003!5Rf\b\u0003\u00021ui\u001a\u0003\u0002\u0001\t<5iQ!\u0001\u0005\u0018\u0013\u0011I1!B\u0001\t1aA\u0012\u0002B\u0005\u0004\u000b\u0005A\t\u0004'\r\u0019/A\u001b\u0001!I\u0002\u0006\u0003!M\u00024G)\u0004\u000b\u0011i\u0012\"\u0001\u0005\u001b\u001b\u0005A)$lc\u0001\t\u0005A\u0012%h\u0007\u0005\u0001!9R\"C\u0003\u0002\u0011EIQ\u0001\"\u0001\n\u0007\u0015\t\u00012\u0005M\u00121E\u00016\u0001AO\b\t\u0001A\u0019%D\u0002\u0006\u0003!Y\u0002d\u0007)\u0004\u0002u=A\u0001\u0001E#\u001b\r)\u0011\u0001C\u000e\u00197A\u001b\u0011!h\t\u0005\u0001!QR\"D\u0003\u0002\u0011oIA!C\u0002\u0006\u0003!\u0015\u0002TE\u0005\u0005\u0013\r)\u0011\u0001\u0003\u000f\u00199a]\u0002ka\u0001\"\u0007\u0015\t\u0001\"\u0003\r\n#\u000eaA!I\u0005\u0002\t\u000bi!\u0001#\u000b\r\u00025\t\u0001\u0012H\u0007\u0002\u0011si\u0011\u0001C\u000f.\u0016\u0011Y\u0001\u0004J\u0011\u0004\u000b\u0005A\u0001\u0002\u0007\u0005R\u0007\r!A%C\u0001\t\u00165VAa\u0003M%C\r)\u0011\u0001C\u0006\u0019\u0017E\u001b1\u0001\"\u0013\n\u0003\u0011\u001dQ\u0006\n\u0003\u0004#\u001d!\t\u0001c\u000b\u0016\t\u0015\t\u0001\u0012\u0005G\u00011CAR%h\u0007\u0005\u0001!QR\"C\u0003\u0002\u0011MIQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0012\u0001O\u00011M\u00016\u0001A\u0011\u0005\u000b\t!\t\u0001#\u0001\u001d\u0002E\u001bQ\u0001B\u0013\n\u0003!!R\"\u0001E\u0017[\u0011\"1!E\u0004\u0005\u0002!-R\u0003B\u0003\u0002\u0011Ca\t\u0001'\t\u0019LumA\u0001\u0001\u0005\u001b\u001b%)\u0011\u0001C\n\n\u000b%!QA\u0001C\u0001\u0011\u0003a\n\u0001G\nQ\u0007\u0001\tC!\u0002\u0002\u0005\u0002!\u0005A\u0014A)\u0004\u000b\u0011-\u0013\"\u0001\u0005\u0015\u001b\u0005Ai#l\u001e\u0005\u0017a1S4\u0004\u0003\u0001\u0011]i\u0011\"B\u0001\t#%)A\u0011A\u0005\u0004\u000b\u0005A\u0019\u0003g\t\u0019#A\u001b\u0001!h\u0004\u0005\u0001!5SbA\u0003\u0002\u0011mA2\u0004UB\u0001;\u001f!\u0001\u0001C\u0014\u000e\u0007\u0015\t\u00012\bM\u001e!\u000e\tQt\u0002\u0003\u0001\u0011!j1!B\u0001\t7aY\u0002ka\u0001\"\u0007\u0015\t\u0001\"\u0003\r\n#\u000eaAAJ\u0005\u0002\t\u000bi!\u0001#\u000b\r\u00025\t\u0001\u0012H\u0007\u0002\u0011yi\u0011\u0001#\u000f.!\u0004!1\u0002G\u0015\u001e\u001c\u0011\u0001\u0001bF\u0007\n\u000b\u0005A\u0011#C\u0003\u0005\u0002%\u0019Q!\u0001E\u00121GA\u0012\u0003U\u0002\u0001;G!\u0001\u0001c\u0015\u000e\u001b\u0015\t\u0001bF\u0005\u0005\u0013\r)\u0011\u0001\u0003\r\u00191%!\u0011bA\u0003\u0002\u0011cA\n\u0004G\fQ\u0007\u0003iz\u0001\u0002\u0001\tN5\u0019Q!\u0001\u0005\u001c1m\u00016!AO\b\t\u0001A!&D\u0002\u0006\u0003!m\u00024\b)\u0004\u0004u=A\u0001\u0001\u0005)\u001b\r)\u0011\u0001C\u000e\u00197A\u001b!!I\u0002\u0006\u0003!I\u0001$C)\u0004\u001d\u0011I\u0013\"\u0001C\u0003\u001b\tAI\u0003$\u0001\u000e\u0003!UR\"\u0001E\u001d\u001b\u0005Aa$D\u0001\t:5VAa\u0003M+C\r)\u0011\u0001#\u0010\u0019>E\u001b1\u0001\"\u0016\n\u0003\u0011\u0001QV\f\u0003\u0004#\u001d!\t\u0001c\u000b\u0016\t\u0015\t\u0001\u0012\u0005G\u00011CA:&h\u0004\u0005\u0001!aSbA\u0003\u0002\u0011GA\u001a\u0003U\u0002\u0001;7!\u0001\u0001\u0003\u000e\u000e\u0013\u0015\t\u0001bE\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0002q\u0005\u0001d\u0005)\u0004\u0002\u0005\"QA\u0001C\u0001\u0011\u0003a\n!U\u0002\b\t/J\u0011\u0001\u0003\u000b\u000e\u0003!%R\"\u0001E\u0017[+!1\u0001'\u0017\"\u0007\u0015\t\u0001b\u0003\r\f#\u000e\u0019A\u0011L\u0005\u0002\t\u000fi\u000b\u0003B\u0002\u0016\u0007\u0015\t\u0001r\bM 19\n3!B\u0001\t\u0017aY\u0011kA\u0003\u0005]%\tAqA\u0007\u0002\u0011\u0001j\u000b\u0003B\u0002\u0016\u0007\u0015\t\u0001r\bM 1;\n3!B\u0001\t\u0017aY\u0011kA\u0003\u0005^%\tAqA\u0007\u0002\u0011\u0001*l\u0019A\u0003F\u0002\u0011\u0019\u000f!\u0005\u0005\u0005\u0001!\u0019Q#B\u0003\u0002\u0011\u0011I\u0011\u0001b\u0001\u0019\ta9Qt\u0002\u0003\u0001\u0011\u001fi1!B\u0001\t\u0010a=\u0001k\u0001\u0001\u001e\u0012\u0011\u0001\u0001\u0012C\u0007\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001A\u001b\t!h\u0004\u0005\u0001!IQbA\u0003\u0002\u0011!A\u0002\u0002U\u0002\u0002;\u001f!\u0001\u0001\u0003\u0006\u000e\u0007\u0015\t\u0001\"\u0003\r\n!\u000e\r\u0011%C\u0003\u0002\u0011\u000bIQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u00011\u000b\t6a\u0003\u0003\b\u0013\u0005!\u0001!D\u0001\t\u00145\t\u0001BC\u0007\u0002\u0011+i\u0011\u0001\"\u0002"})
public final class CompileServiceImpl<Compiler extends CLICompiler<?>>
extends UnicastRemoteObject
implements CompileService {
    public static final /* synthetic */ KClass $kotlinClass;
    private volatile long _lastUsedSeconds;
    private final Lazy<? extends Logger> log$delegate;
    private final ReentrantReadWriteLock rwlock;
    private boolean alive;
    @NotNull
    private final Registry registry;
    @NotNull
    private final Compiler compiler;
    @NotNull
    private final CompilerId selfCompilerId;
    private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;

    static {
        $kotlinClass = Reflection.createKotlinClass(CompileServiceImpl.class);
        $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("log")};
    }

    @Override
    @NotNull
    public CompilerId getCompilerId() {
        return (CompilerId)this.ifAlive((Function0)new Function0<CompilerId>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            @NotNull
            public final CompilerId invoke() {
                return this.this$0.getSelfCompilerId();
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        });
    }

    @Override
    public long getUsedMemory() {
        return ((Number)this.ifAlive((Function0)new Function0<Long>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            public final long invoke() {
                return this.this$0.usedMemory();
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        })).longValue();
    }

    @Override
    public void shutdown() {
        this.ifAliveExclusive((Function0)new Function0<Unit>(this){
            final /* synthetic */ CompileServiceImpl this$0;

            public final void invoke() {
                this.this$0.getLog().info("Shutdown started");
                CompileServiceImpl.access$setAlive$0(this.this$0, false);
                UnicastRemoteObject.unexportObject(this.this$0, true);
                this.this$0.getLog().info("Shutdown complete");
            }
            {
                this.this$0 = compileServiceImpl;
                super(0);
            }
        });
    }

    @Override
    public int remoteCompile(@NotNull String[] args, @NotNull RemoteOutputStream compilerOutputStream, @NotNull CompileService.OutputFormat outputFormat, @NotNull RemoteOutputStream serviceOutputStream) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        Intrinsics.checkParameterIsNotNull(compilerOutputStream, "compilerOutputStream");
        Intrinsics.checkParameterIsNotNull(outputFormat, "outputFormat");
        Intrinsics.checkParameterIsNotNull(serviceOutputStream, "serviceOutputStream");
        return this.doCompile(args, compilerOutputStream, serviceOutputStream, (Function1<PrintStream, ExitCode>)new Function1<PrintStream, ExitCode>(this, outputFormat, args){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ CompileService.OutputFormat $outputFormat;
            final /* synthetic */ String[] $args;

            @NotNull
            public final ExitCode invoke(@NotNull PrintStream printStream) {
                ExitCode exitCode;
                Intrinsics.checkParameterIsNotNull(printStream, "printStream");
                switch (CompileServiceImpl$WhenMappings.$EnumSwitchMapping$0[this.$outputFormat.ordinal()]) {
                    case 1: {
                        ExitCode exitCode2 = ((CLICompiler)this.this$0.getCompiler()).exec(printStream, this.$args);
                        exitCode = exitCode2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode2), "compiler.exec(printStream, *args)");
                        break;
                    }
                    case 2: {
                        ExitCode exitCode3 = ((CLICompiler)this.this$0.getCompiler()).execAndOutputXml(printStream, Services.Companion.getEMPTY(), this.$args);
                        exitCode = exitCode3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode3), "compiler.execAndOutputXm\u2026m, Services.EMPTY, *args)");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode), "when (outputFormat) {\n  \u2026 *args)\n                }");
                return exitCode;
            }
            {
                this.this$0 = compileServiceImpl;
                this.$outputFormat = outputFormat;
                this.$args = stringArray;
                super(1);
            }
        });
    }

    @Override
    public int remoteIncrementalCompile(@NotNull String[] args, @NotNull Map<TargetId, ? extends CompileService.RemoteIncrementalCache> caches, @NotNull RemoteOutputStream compilerOutputStream, @NotNull CompileService.OutputFormat compilerOutputFormat, @NotNull RemoteOutputStream serviceOutputStream) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        Intrinsics.checkParameterIsNotNull(caches, "caches");
        Intrinsics.checkParameterIsNotNull(compilerOutputStream, "compilerOutputStream");
        Intrinsics.checkParameterIsNotNull(compilerOutputFormat, "compilerOutputFormat");
        Intrinsics.checkParameterIsNotNull(serviceOutputStream, "serviceOutputStream");
        return this.doCompile(args, compilerOutputStream, serviceOutputStream, (Function1<PrintStream, ExitCode>)new Function1<PrintStream, ExitCode>(this, compilerOutputFormat, caches, args){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ CompileService.OutputFormat $compilerOutputFormat;
            final /* synthetic */ Map $caches;
            final /* synthetic */ String[] $args;

            @NotNull
            public final ExitCode invoke(@NotNull PrintStream printStream) {
                ExitCode exitCode;
                Intrinsics.checkParameterIsNotNull(printStream, "printStream");
                switch (CompileServiceImpl$WhenMappings.$EnumSwitchMapping$1[this.$compilerOutputFormat.ordinal()]) {
                    case 1: {
                        throw (Throwable)new NotImplementedError("Only XML output is supported in remote incremental compilation");
                    }
                    case 2: {
                        exitCode = ((CLICompiler)this.this$0.getCompiler()).execAndOutputXml(printStream, CompileServiceImpl.access$createCompileServices$1(this.this$0, this.$caches), this.$args);
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode), "compiler.execAndOutputXm\u2026eServices(caches), *args)");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)exitCode), "when (compilerOutputForm\u2026 *args)\n                }");
                return exitCode;
            }
            {
                this.this$0 = compileServiceImpl;
                this.$compilerOutputFormat = outputFormat;
                this.$caches = map2;
                this.$args = stringArray;
                super(1);
            }
        });
    }

    public final long getLastUsedSeconds() {
        return this.rwlock.isWriteLocked() || this.rwlock.getReadLockCount() - this.rwlock.getReadHoldCount() > 0 ? CompileServiceImplKt.nowSeconds() : this._lastUsedSeconds;
    }

    public final Logger getLog() {
        return KotlinPackage.get(this.log$delegate, this, $propertyMetadata[0]);
    }

    private final int doCompile(String[] args, RemoteOutputStream compilerMessagesStreamProxy, RemoteOutputStream serviceOutputStreamProxy, Function1<? super PrintStream, ? extends ExitCode> body) {
        return ((Number)this.ifAlive((Function0)new Function0<Integer>(this, compilerMessagesStreamProxy, serviceOutputStreamProxy, args, body){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ RemoteOutputStream $compilerMessagesStreamProxy;
            final /* synthetic */ RemoteOutputStream $serviceOutputStreamProxy;
            final /* synthetic */ String[] $args;
            final /* synthetic */ Function1 $body;

            public final int invoke() {
                PrintStream compilerMessagesStream = new PrintStream(new RemoteOutputStreamClient(this.$compilerMessagesStreamProxy));
                PrintStream serviceOutputStream = new PrintStream(new RemoteOutputStreamClient(this.$serviceOutputStreamProxy));
                return ((Number)this.this$0.checkedCompile(this.$args, serviceOutputStream, (Function0)new Function0<Integer>(this, compilerMessagesStream){
                    final /* synthetic */ doCompile.1 this$0;
                    final /* synthetic */ PrintStream $compilerMessagesStream;

                    /*
                     * WARNING - void declaration
                     */
                    public final int invoke() {
                        void var1_1;
                        int res = ((ExitCode)((Object)this.this$0.$body.invoke(this.$compilerMessagesStream))).getCode();
                        CompileServiceImpl.access$set_lastUsedSeconds$2(this.this$0.this$0, CompileServiceImplKt.nowSeconds());
                        return (int)var1_1;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$compilerMessagesStream = printStream;
                        super(0);
                    }
                })).intValue();
            }
            {
                this.this$0 = compileServiceImpl;
                this.$compilerMessagesStreamProxy = remoteOutputStream;
                this.$serviceOutputStreamProxy = remoteOutputStream2;
                this.$args = stringArray;
                this.$body = function1;
                super(0);
            }
        })).intValue();
    }

    private final Services createCompileServices(Map<TargetId, ? extends CompileService.RemoteIncrementalCache> incrementalCaches) {
        return new Services.Builder().register(IncrementalCompilationComponents.class, new IncrementalCompilationComponentsImpl(incrementalCaches)).build();
    }

    public final long usedMemory() {
        System.gc();
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }

    public final long threadCpuTime(ThreadMXBean $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.isCurrentThreadCpuTimeSupported() ? $receiver.getCurrentThreadCpuTime() : 0L;
    }

    public final long threadUserTime(ThreadMXBean $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.isCurrentThreadCpuTimeSupported() ? $receiver.getCurrentThreadUserTime() : 0L;
    }

    /*
     * WARNING - void declaration
     */
    public final <R> R checkedCompile(@NotNull String[] args, @NotNull PrintStream serviceOut, @NotNull Function0<? extends R> body) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        Intrinsics.checkParameterIsNotNull(serviceOut, "serviceOut");
        Intrinsics.checkParameterIsNotNull(body, "body");
        try {
            Unit unit;
            if (KotlinPackage.none((Object[])args)) {
                throw (Throwable)new IllegalArgumentException("Error: empty arguments list.");
            }
            this.getLog().info("Starting compilation with args: " + KotlinPackage.joinToString$default(args, " ", null, null, 0, null, null, 62));
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            Intrinsics.checkExpressionValueIsNotNull(threadMXBean, "ManagementFactory.getThreadMXBean()");
            ThreadMXBean threadMXBean2 = threadMXBean;
            long startMem = this.usedMemory() / (long)1024;
            long startTime = System.nanoTime();
            long startThreadTime = this.threadCpuTime(threadMXBean2);
            long startThreadUserTime = this.threadUserTime(threadMXBean2);
            R res = body.invoke();
            long endTime = System.nanoTime();
            long endThreadTime = this.threadCpuTime(threadMXBean2);
            long endThreadUserTime = this.threadUserTime(threadMXBean2);
            long endMem = this.usedMemory() / (long)1024;
            this.getLog().info("Done with result " + String.valueOf(res));
            long elapsed = TimeUnit.NANOSECONDS.toMillis(endTime - startTime);
            long elapsedThread = TimeUnit.NANOSECONDS.toMillis(endThreadTime - startThreadTime);
            long elapsedThreadUser = TimeUnit.NANOSECONDS.toMillis(endThreadUserTime - startThreadUserTime);
            this.getLog().info("Elapsed time: " + elapsed + " ms (thread user: " + elapsedThreadUser + " ms sys: " + (elapsedThread - elapsedThreadUser) + " ms)");
            this.getLog().info("Used memory: " + endMem + " kb (" + KotlinPackage.format("%+d", endMem - startMem) + " kb)");
            String string = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_REPORT_PERF_PROPERTY());
            if (string != null) {
                void $receiver;
                String string2 = string;
                String it2 = (String)$receiver;
                serviceOut.println("PERF: Compile on daemon: " + elapsed + " ms (thread user: " + elapsedThreadUser + " ms sys: " + (elapsedThread - elapsedThreadUser) + " ms); memory: " + endMem + " kb (" + KotlinPackage.format("%+d", endMem - startMem) + " kb)");
                unit = Unit.INSTANCE$;
            } else {
                unit = null;
            }
            return res;
        }
        catch (Exception e) {
            this.getLog().info("Error: " + e);
            throw (Throwable)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R ifAlive(@NotNull Function0<? extends R> body) {
        R r;
        Intrinsics.checkParameterIsNotNull(body, "body");
        ReentrantReadWriteLock $receiver = this.rwlock;
        ReentrantReadWriteLock.ReadLock rl = $receiver.readLock();
        rl.lock();
        try {
            if (!this.alive) {
                throw (Throwable)new IllegalStateException("Kotlin Compiler Service is not in alive state");
            }
            r = body.invoke();
        }
        finally {
            rl.unlock();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final <R> R ifAliveExclusive(@NotNull Function0<? extends R> body) {
        int index2;
        R r;
        int it2;
        Intrinsics.checkParameterIsNotNull(body, "body");
        ReentrantReadWriteLock $receiver = this.rwlock;
        ReentrantReadWriteLock.ReadLock rl = $receiver.readLock();
        int readCount = $receiver.getWriteHoldCount() == 0 ? $receiver.getReadHoldCount() : 0;
        int n = 0;
        int n2 = readCount - 1;
        if (n <= n2) {
            void index3;
            do {
                it2 = ++index3;
                rl.unlock();
            } while (index3 != n2);
        }
        ReentrantReadWriteLock.WriteLock wl = $receiver.writeLock();
        wl.lock();
        try {
            if (!this.alive) {
                throw (Throwable)new IllegalStateException("Kotlin Compiler Service is not in alive state");
            }
            r = body.invoke();
        }
        catch (Throwable throwable) {
            index2 = 0;
            int n3 = readCount - 1;
            if (index2 <= n3) {
                do {
                    int it3 = ++index2;
                    rl.lock();
                } while (index2 != n3);
            }
            wl.unlock();
            throw throwable;
        }
        it2 = 0;
        int n4 = readCount - 1;
        if (it2 <= n4) {
            do {
                int it4 = ++index2;
                rl.lock();
            } while (index2 != n4);
        }
        wl.unlock();
        return r;
    }

    public final <R> R spy(@NotNull String msg, @NotNull Function0<? extends R> body) {
        Intrinsics.checkParameterIsNotNull(msg, "msg");
        Intrinsics.checkParameterIsNotNull(body, "body");
        R res = body.invoke();
        this.getLog().info(msg + " = " + String.valueOf(res));
        return res;
    }

    @NotNull
    public final Registry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final Compiler getCompiler() {
        return this.compiler;
    }

    @NotNull
    public final CompilerId getSelfCompilerId() {
        return this.selfCompilerId;
    }

    public CompileServiceImpl(@NotNull Registry registry, @NotNull Compiler compiler, @NotNull CompilerId selfCompilerId, int port) {
        Intrinsics.checkParameterIsNotNull(registry, "registry");
        Intrinsics.checkParameterIsNotNull(compiler, "compiler");
        Intrinsics.checkParameterIsNotNull(selfCompilerId, "selfCompilerId");
        this.registry = registry;
        this.compiler = compiler;
        this.selfCompilerId = selfCompilerId;
        this._lastUsedSeconds = CompileServiceImplKt.nowSeconds();
        this.log$delegate = KotlinPackage.lazy(log.1.INSTANCE$);
        this.rwlock = new ReentrantReadWriteLock();
        try {
            UnicastRemoteObject.unexportObject(this, false);
        }
        catch (NoSuchObjectException e) {
            // empty catch block
        }
        Remote remote = UnicastRemoteObject.exportObject(this, port, LoopbackNetworkInterface.INSTANCE$.getClientLoopbackSocketFactory(), LoopbackNetworkInterface.INSTANCE$.getServerLoopbackSocketFactory());
        if (remote == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.rmi.CompileService");
        }
        CompileService stub = (CompileService)remote;
        this.registry.rebind(DaemonParamsKt.getCOMPILER_SERVICE_RMI_NAME(), stub);
        this.alive = true;
    }

    public static final /* synthetic */ void access$setAlive$0(CompileServiceImpl<Compiler> $this, boolean bl) {
        $this.alive = bl;
    }

    @NotNull
    public static final /* synthetic */ Services access$createCompileServices$1(CompileServiceImpl<Compiler> $this, @NotNull Map<TargetId, ? extends CompileService.RemoteIncrementalCache> incrementalCaches) {
        return super.createCompileServices(incrementalCaches);
    }

    public static final /* synthetic */ long access$get_lastUsedSeconds$2(CompileServiceImpl<Compiler> $this) {
        return $this._lastUsedSeconds;
    }

    public static final /* synthetic */ void access$set_lastUsedSeconds$2(CompileServiceImpl<Compiler> $this, long l) {
        $this._lastUsedSeconds = l;
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"g\u0006)!\u0013J\\2sK6,g\u000e^1m\u0007>l\u0007/\u001b7bi&|gnQ8na>tWM\u001c;t\u00136\u0004HN\u0003\nD_6\u0004\u0018\u000e\\3TKJ4\u0018nY3J[Bd'bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\u0007Il\u0017NC\u0004tKJ4\u0018nY3\u000bA%s7M]3nK:$\u0018\r\\\"p[BLG.\u0019;j_:\u001cu.\u001c9p]\u0016tGo\u001d\u0006\u0005Y>\fGMC\u0006j]\u000e\u0014X-\\3oi\u0006d'BC2p[B|g.\u001a8ug*1A(\u001b8jizRQ\u0002^1sO\u0016$Hk\\\"bG\",'bA'ba*AA+\u0019:hKRLEMC\u0004n_\u0012,H.Z:\u000b-I+Wn\u001c;f\u0013:\u001c'/Z7f]R\fGnQ1dQ\u0016TabQ8na&dWmU3sm&\u001cWM\u0003\u0003kCZ\f'\u0002B;uS2T\u0001cZ3u)\u0006\u0014x-\u001a;U_\u000e\u000b7\r[3\u000b'\u001d,G/\u00138de\u0016lWM\u001c;bY\u000e\u000b7\r[3\u000b\rQ\f'oZ3u\u0015AIen\u0019:f[\u0016tG/\u00197DC\u000eDWM\u0003\thKRdun\\6vaR\u0013\u0018mY6fe*iAj\\8lkB$&/Y2lKJ$\u001cA\u0003\u0002\u0011\u0005)!\u0001\u0002\u0001\t\u0004\u0015\u0011A\u0011\u0001\u0005\u0003\u000b\t!\u0011\u0001#\u0002\u0006\u0005\u0011\r\u0001bA\u0003\u0004\t\tA\t\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0003\u0006\u0005\u0011\u001d\u0001BA\u0003\u0003\t\u0011AI!\u0002\u0002\u0005\n!)Qa\u0001\u0003\u0006\u0011\u000fa\u0001!B\u0001\t\u0005\u0015\u0019AA\u0002E\u0007\u0019\u0001)!\u0001B\u0001\t\u0010\u0015\u0019Aa\u0002\u0005\b\u0019\u0001)1\u0001b\u0001\t\u00121\u0001Qa\u0001\u0003\t\u0011!a\u0001!B\u0001\t\u0013\u0015\u0011A!\u0003E\n\u000b\t!\u0019\u0002#\u0004\u0006\u0007\u0011)\u0001r\u0003\u0007\u0001\u000b\t!Q\u0001c\u0006\u0006\u0005\u00119\u0001bB\u0003\u0003\t\u0005AI!\u0002\u0002\u0005\u0019!)Qa\u0001C\r\u00113a\u0001!\u0002\u0002\u0005\u001a!eA!\u0001\u0007\u00043\r)\u0011\u0001c\u0003\u0019\f5RBa\u0019\u0003\u0019\r\u0005jQ!\u0001E\u0007\u0013\u0011I1!B\u0001\t\u0010a=\u0011\u0002B\u0005\u0004\u000b\u0005A\t\u0002'\u0005\u0019\u000eU\u001b\u0001\"B\u0002\u0005\r%\t\u0001BC\u0007\u0004\t)I\u0011\u0001\u0003\u0006.+\u0011Y\u0001TCO\b\t\u0001A1\"D\u0002\u0006\u0003!=\u0001t\u0002)\u0004\u0001\u0005\u001aQ!\u0001E\u000b1+\t6!\u0002C\u000b\u0013\u0005A1\"D\u0001\t\u00185VAa\u0003\r\rC\r)\u0011\u0001C\u0007\u0019\u001bE\u001b1\u0001\u0002\u0007\n\u0003!mQ\u0017IC \t\r\b\u00014BO\u0012\t\u0001Aa!D\u0007\u0006\u0003!5\u0011\u0002B\u0005\u0004\u000b\u0005Ay\u0001g\u0004\n\t%\u0019Q!\u0001E\t1#Aj\u0001U\u0002\u0001C\r)\u0011\u0001C\u0002\u0019\u0007E\u001bQ\u0001b\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\u000b"})
    private static final class IncrementalCompilationComponentsImpl
    implements IncrementalCompilationComponents {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final Map<TargetId, ? extends CompileService.RemoteIncrementalCache> targetToCache;

        static {
            $kotlinClass = Reflection.createKotlinClass(IncrementalCompilationComponentsImpl.class);
        }

        @Override
        @NotNull
        public IncrementalCache getIncrementalCache(@NotNull TargetId target) {
            Intrinsics.checkParameterIsNotNull(target, "target");
            CompileService.RemoteIncrementalCache remoteIncrementalCache = this.targetToCache.get(target);
            if (remoteIncrementalCache == null) {
                Intrinsics.throwNpe();
            }
            return new RemoteIncrementalCacheClient(remoteIncrementalCache);
        }

        @Override
        @NotNull
        public LookupTracker getLookupTracker() {
            return LookupTracker.Companion.getDO_NOTHING();
        }

        @NotNull
        public final Map<TargetId, CompileService.RemoteIncrementalCache> getTargetToCache() {
            return this.targetToCache;
        }

        public IncrementalCompilationComponentsImpl(@NotNull Map<TargetId, ? extends CompileService.RemoteIncrementalCache> targetToCache) {
            Intrinsics.checkParameterIsNotNull(targetToCache, "targetToCache");
            this.targetToCache = targetToCache;
        }
    }
}

