/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.kotlinSignature;

import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ComparatorUtil;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.components.ExternalAnnotationResolver;
import org.jetbrains.kotlin.load.java.structure.JavaField;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.AlternativeSignatureMismatchException;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.ElementAlternativeSignatureData;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.SignaturesUtil;
import org.jetbrains.kotlin.types.JetType;

public class AlternativeFieldSignatureData
extends ElementAlternativeSignatureData {
    private JetType altReturnType;

    public AlternativeFieldSignatureData(@NotNull ExternalAnnotationResolver externalAnnotationResolver, @NotNull JavaField field, @NotNull JetType originalReturnType, @NotNull Project project, boolean isVar) {
        if (externalAnnotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalAnnotationResolver", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeFieldSignatureData", "<init>"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeFieldSignatureData", "<init>"));
        }
        if (originalReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalReturnType", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeFieldSignatureData", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeFieldSignatureData", "<init>"));
        }
        String signature = SignaturesUtil.getKotlinSignature(externalAnnotationResolver, field);
        if (signature == null) {
            this.setAnnotated(false);
            return;
        }
        this.setAnnotated(true);
        JetProperty altPropertyDeclaration = PsiPackage.JetPsiFactory(project).createProperty(signature);
        try {
            AlternativeFieldSignatureData.checkForSyntaxErrors(altPropertyDeclaration);
            AlternativeFieldSignatureData.checkFieldAnnotation(altPropertyDeclaration, field, isVar);
            this.altReturnType = AlternativeFieldSignatureData.computeReturnType(originalReturnType, altPropertyDeclaration.getTypeReference(), new HashMap<TypeParameterDescriptor, TypeParameterDescriptorImpl>());
        }
        catch (AlternativeSignatureMismatchException e) {
            this.setError(e.getMessage());
        }
    }

    @NotNull
    public JetType getReturnType() {
        this.checkForErrors();
        JetType jetType = this.altReturnType;
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeFieldSignatureData", "getReturnType"));
        }
        return jetType;
    }

    private static void checkFieldAnnotation(@NotNull JetProperty altProperty, @NotNull JavaField field, boolean isVar) {
        if (altProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "altProperty", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeFieldSignatureData", "checkFieldAnnotation"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/resolve/jvm/kotlinSignature/AlternativeFieldSignatureData", "checkFieldAnnotation"));
        }
        if (!ComparatorUtil.equalsNullable(field.getName().asString(), altProperty.getName())) {
            throw new AlternativeSignatureMismatchException("Field name mismatch, original: %s, alternative: %s", field.getName().asString(), altProperty.getName());
        }
        if (altProperty.getTypeReference() == null) {
            throw new AlternativeSignatureMismatchException("Field annotation for shouldn't have type reference");
        }
        if (altProperty.getGetter() != null || altProperty.getSetter() != null) {
            throw new AlternativeSignatureMismatchException("Field annotation for shouldn't have getters and setters");
        }
        if (altProperty.isVar() != isVar) {
            throw new AlternativeSignatureMismatchException("Wrong mutability in annotation for field");
        }
        if (altProperty.hasInitializer()) {
            throw new AlternativeSignatureMismatchException("Default value is not expected in annotation for field");
        }
    }
}

