/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.RetinaImage;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class ImageLoader
implements Serializable {
    public static final Component ourComponent = new Component(){};
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ImageLoader");

    private static boolean waitForImage(Image image) {
        if (image == null) {
            return false;
        }
        if (image.getWidth(null) > 0) {
            return true;
        }
        MediaTracker mediatracker = new MediaTracker(ourComponent);
        mediatracker.addImage(image, 1);
        try {
            mediatracker.waitForID(1, 5000L);
        }
        catch (InterruptedException ex) {
            LOG.info(ex);
        }
        return !mediatracker.isErrorID(1);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/ImageLoader", "loadFromUrl"));
        }
        return ImageLoader.loadFromUrl(url, true);
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url, boolean allowFloatScaling) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/ImageLoader", "loadFromUrl"));
        }
        for (Pair<String, Integer> each : ImageLoader.getFileNames(url.toString())) {
            try {
                float scale;
                Image image = ImageLoader.loadFromStream(URLUtil.openStream(new URL((String)each.first)), (Integer)each.second);
                float f = allowFloatScaling ? JBUI.scale(1.0f) : (scale = JBUI.scale(1.0f) > 1.5f ? 2.0f : 1.0f);
                if (image != null && JBUI.isHiDPI() && !((String)each.first).contains("@2x")) {
                    image = ImageLoader.upscale(image, scale);
                } else if (image != null && JBUI.scale(1.0f) >= 1.5f && JBUI.scale(1.0f) < 2.0f && ((String)each.first).contains("@2x")) {
                    image = ImageLoader.downscale(image, scale);
                }
                return image;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    @NotNull
    private static Image upscale(Image image, float scale) {
        int width = (int)(scale * (float)image.getWidth(null));
        int height = (int)(scale * (float)image.getHeight(null));
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ImageLoader", "upscale"));
        }
        return bufferedImage;
    }

    @NotNull
    private static Image downscale(Image image, float scale) {
        int width = (int)((float)image.getWidth(null) / 2.0f * scale);
        int height = (int)((float)image.getHeight(null) / 2.0f * scale);
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ImageLoader", "downscale"));
        }
        return bufferedImage;
    }

    public static List<Pair<String, Integer>> getFileNames(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/ImageLoader", "getFileNames"));
        }
        return ImageLoader.getFileNames(file, UIUtil.isUnderDarcula(), UIUtil.isRetina() || JBUI.scale(1.0f) >= 1.5f);
    }

    public static List<Pair<String, Integer>> getFileNames(@NotNull String file, boolean dark, boolean retina) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/ImageLoader", "getFileNames"));
        }
        if (retina || dark) {
            ArrayList<Pair<String, Integer>> answer = new ArrayList<Pair<String, Integer>>(4);
            String name = FileUtil.getNameWithoutExtension(file);
            String ext = FileUtilRt.getExtension(file);
            if (dark && retina) {
                answer.add(Pair.create(name + "@2x_dark." + ext, 2));
            }
            if (dark) {
                answer.add(Pair.create(name + "_dark." + ext, 1));
            }
            if (retina) {
                answer.add(Pair.create(name + "@2x." + ext, 2));
            }
            answer.add(Pair.create(file, 1));
            return answer;
        }
        return Collections.singletonList(Pair.create(file, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadFromStream(@NotNull InputStream inputStream, int scale) {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/ImageLoader", "loadFromStream"));
        }
        if (scale <= 0) {
            throw new IllegalArgumentException("Scale must 1 or more");
        }
        try {
            BufferExposingByteArrayOutputStream outputStream = new BufferExposingByteArrayOutputStream();
            try {
                int n;
                byte[] buffer = new byte[1024];
                while ((n = inputStream.read(buffer)) >= 0) {
                    outputStream.write(buffer, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(outputStream.getInternalBuffer(), 0, outputStream.size());
            ImageLoader.waitForImage(image);
            if (UIUtil.isRetina() && scale > 1) {
                image = RetinaImage.createFrom(image, scale, ourComponent);
            }
            return image;
        }
        catch (Exception ex) {
            LOG.error(ex);
            return null;
        }
    }
}

