/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HashSetUtil {
    @NotNull
    public static <T> Set<T> linkedHashSet(@NotNull Set<T> set, @NotNull EqualityPolicy<T> policy) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "org/jetbrains/kotlin/utils/HashSetUtil", "linkedHashSet"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "org/jetbrains/kotlin/utils/HashSetUtil", "linkedHashSet"));
        }
        LinkedHashMap<T, String> map2 = new LinkedHashMap<T, String>(policy);
        for (T t : set) {
            map2.put(t, "");
        }
        Set set2 = map2.keySet();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/utils/HashSetUtil", "linkedHashSet"));
        }
        return set2;
    }
}

