/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.platform;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={")\u0006)QrJ^3sY>\fGm]!o]>$\u0018\r^5p]\u000eCWmY6fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0004sKN|GN^3\u000b\u0007)4XN\u0003\u0005qY\u0006$hm\u001c:n\u0015I!Um\u00197be\u0006$\u0018n\u001c8DQ\u0016\u001c7.\u001a:\u000b\rqJg.\u001b;?\u0015\u0015\u0019\u0007.Z2l\u0015-!Wm\u00197be\u0006$\u0018n\u001c8\u000b\u001d)+G\u000fR3dY\u0006\u0014\u0018\r^5p]*\u0019\u0001o]5\u000b\u0015\u0011,7o\u0019:jaR|'OC\u000bEK\u000ed\u0017M]1uS>tG)Z:de&\u0004Ho\u001c:\u000b\u0017\u0011,7o\u0019:jaR|'o\u001d\u0006\u0011I&\fwM\\8ti&\u001c\u0007j\u001c7eKJTa\u0002R5bO:|7\u000f^5d'&t7NC\u0006eS\u0006<gn\\:uS\u000e\u001c(B\u00042j]\u0012LgnZ\"p]R,\u0007\u0010\u001e\u0006\u000f\u0005&tG-\u001b8h\u0007>tG/\u001a=u\u0015\u0011)f.\u001b;\u000b!\rDWmY6EK\u000ed\u0017M]1uS>t\u00072\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0005\u0011\u0011\u0001bA\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001r\u0001\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0004\u0006\u0007\u0011!\u00012\u0002\u0007\u0001\u000b\t!\u0011\u0001c\u0004\u0006\u0007\u0011)\u0001b\u0002\u0007\u0001\u000b\t!\u0011\u0001C\u0005\u0006\u0007\u00111\u0001\u0012\u0003\u0007\u0001\u000b\r!\u0019\u0001\u0003\u0006\r\u0001\u0015\t\u00012A\u0003\u0004\t\u001fA)\u0002\u0004\u0001\u0006\u0005\u0011!\u00012B\u0003\u0003\t\u0015Aq!\u0002\u0002\u0005\r!EQA\u0001C\u0002\u0011)!1\u0001D\u0002\u001a\u0007\u0015\t\u0001r\u0001M\u0004[S\"1\u0002'\u0003\u001e\u0010\u0011\u0001\u0001\"B\u0007\u0004\u000b\u0005AI\u0001'\u0003Q\u0007\u0001iz\u0001\u0002\u0001\t\u000e5\u0019Q!\u0001E\u00061\u0017\u00016\u0011AO\b\t\u0001A\u0001\"D\u0002\u0006\u0003!5\u0001T\u0002)\u0004\u0003u=A\u0001\u0001E\n\u001b\r)\u0011\u0001C\u0004\u0019\u000fA\u001b\u0019!I\u0002\u0006\u0003!A\u0001\u0004C)\u0004\u0017\u0011%\u0011\"\u0001\u0003\u0001\u001b\u0005A\t\"D\u0001\t\u00135\t\u00012C\u0007\u0002\u0011)i#\u0006B\u0001\u0019\u0017u=A\u0001\u0001\u0005\u0006\u001b\r)\u0011\u0001#\u0003\u0019\nA\u001b\u0001!h\u0004\u0005\u0001!5QbA\u0003\u0002\u0011\u0017AZ\u0001UB\u0001;\u001f!\u0001\u0001\u0003\u0005\u000e\u0007\u0015\t\u0001R\u0002M\u0007!\u000e\t\u0011eA\u0003\u0002\u0011!A\u0002\"U\u0002\n\t-I\u0011\u0001\u0002\u0001\u000e\u0003!EQ\"\u0001\u0005\n\u001b\u0005A\u0019\"\u000e\u0007\u0006\u0017\u0011\u0019\u000f\u0001\u0007\u0003\"\u0007\u0015\t\u0001b\u0001\r\u0004#\u000e\u0019A\u0001B\u0005\u0002\t\u0001\u0001"})
public final class OverloadsAnnotationChecker
implements DeclarationChecker {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(OverloadsAnnotationChecker.class);
    }

    @Override
    public void check(@NotNull JetDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        if (AnnotationUtilKt.hasJvmOverloadsAnnotation(descriptor2)) {
            this.checkDeclaration(declaration, descriptor2, diagnosticHolder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDeclaration(JetDeclaration declaration, DeclarationDescriptor descriptor2, DiagnosticSink diagnosticHolder) {
        if (!(descriptor2 instanceof CallableDescriptor)) {
            return;
        }
        if (descriptor2 instanceof FunctionDescriptor && Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor2).getModality(), (Object)Modality.ABSTRACT)) {
            diagnosticHolder.report(ErrorsJvm.OVERLOADS_ABSTRACT.on((JetDeclaration)((PsiElement)declaration)));
        } else if (!((CallableDescriptor)descriptor2).getVisibility().getIsPublicAPI() && Intrinsics.areEqual(((CallableDescriptor)descriptor2).getVisibility(), Visibilities.INTERNAL) ^ true || DescriptorUtils.isLocal(descriptor2)) {
            diagnosticHolder.report(ErrorsJvm.OVERLOADS_PRIVATE.on((JetDeclaration)((PsiElement)declaration)));
        } else {
            boolean bl;
            block7: {
                void $receiver;
                Iterable iterable = ((CallableDescriptor)descriptor2).getValueParameters();
                for (Object element : $receiver) {
                    ValueParameterDescriptor it2 = (ValueParameterDescriptor)element;
                    if (!it2.declaresDefaultValue()) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            if (bl) {
                diagnosticHolder.report(ErrorsJvm.OVERLOADS_WITHOUT_DEFAULT_ARGUMENTS.on((JetDeclaration)((PsiElement)declaration)));
            }
        }
    }
}

