/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaDeprecatedAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaRetentionAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.components.JavaTargetAnnotationDescriptor;
import org.jetbrains.kotlin.load.java.lazy.LazyJavaResolverContext;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaAnnotationDescriptorKt;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationOwner;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\u0000\b)!\"*\u0019<b\u0003:tw\u000e^1uS>tW*\u00199qKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0005Y>\fGM\u0003\u0003kCZ\f'BC2p[B|g.\u001a8ug*\u0019\u0011I\\=\u000b/)\u000be+Q0E\u000bB\u0013ViQ!U\u000b\u0012{f)U0O\u00036+%B\u0002$r\u001d\u0006lWM\u0003\u0003oC6,'b\u0006&B-\u0006{FiT\"V\u001b\u0016sE+\u0012#`\rF{f*Q'F\u0015]Q\u0015IV!`%\u0016\u0003V)\u0011+B\u00052+uLR)`\u001d\u0006kUI\u0003\fK\u0003Z\u000buLU#U\u000b:#\u0016j\u0014(`\rF{f*Q'F\u0015MQ\u0015IV!`)\u0006\u0013v)\u0012+`\rF{f*Q'F\u0015MQ\u0017M^1U_.{G\u000f\\5o\u001d\u0006lW-T1q\u0015\ri\u0015\r\u001d\u0006\u0005kRLGN\u0003\fhKRT\u0015M^1U_.{G\u000f\\5o\u001d\u0006lW-T1q\u0015MYw\u000e\u001e7j]R{'*\u0019<b\u001d\u0006lW-T1q\u0015a1\u0017N\u001c3NCB\u0004X\r\u001a&bm\u0006\feN\\8uCRLwN\u001c\u0006\u000bW>$H.\u001b8OC6,'bD1o]>$\u0018\r^5p]>;h.\u001a:\u000b')\u000bg/Y!o]>$\u0018\r^5p]>;h.\u001a:\u000b\u0013M$(/^2ukJ,'\"A2\u000b/1\u000b'0\u001f&bm\u0006\u0014Vm]8mm\u0016\u00148i\u001c8uKb$(\u0002\u00027bufTA#\u00118o_R\fG/[8o\t\u0016\u001c8M]5qi>\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNT1\"\u00198o_R\fG/[8og*QR.\u00199PeJ+7o\u001c7wK*\u000bg/Y!o]>$\u0018\r^5p]*Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u001d)\u000bg/Y!o]>$\u0018\r^5p]J\u000e!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019Qa\u0001C\u0003\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019Aq\u0001E\u0004\u0019\u0001)!\u0001B\u0001\t\u000b\u0015\u0019A\u0011\u0002E\u0005\u0019\u0001)!\u0001\"\u0003\t\n\u0015\u0019Aq\u0001\u0005\t\u0019\u0001)\u0011\u0001#\u0002\u0006\u0005\u00115\u0001\u0012C\u0003\u0003\t\u001dA\u0001\"\u0002\u0002\u0005\u0005!aQa\u0001\u0003\t\u0011/a\u0001!\u0002\u0002\u0005\u0005!mQa\u0001\u0003\n\u00115a\u0001!\u0002\u0002\u0005\u0003!uQA\u0001\u0003\u000b\u0011=)1\u0001\"\u0006\t\u001d1\u0001QA\u0001C\u000b\u00119)!\u0001\u0002\u0005\t\u0018\u0015\u0011A!\u0003\u0005\u000e\u000b\r!\u0001\u0002#\t\r\u0001\u0015\u0011A\u0001\u0003E\u0011\t\r\fAbA\r\u0004\u000b\u0005AA\u0001\u0007\u0003.\u0019\u0011\tG\u0001\u0007\u0003\"\u0007\u0015\t\u0001\"\u0002\r\u0006+\u000e!Qa\u0001\u0003\u0005\u0013\u0005AY!\f\u0007\u0005C\u0012AZ!I\u0002\u0006\u0003!)\u0001$B+\u0004\t\u0015\u0019A1B\u0005\u0002\u0011\u0017iC\u0002B1\u00051\u0019\t3!B\u0001\t\u000ba)Qk\u0001\u0003\u0006\u0007\u00111\u0011\"\u0001E\u0006[1!\u0011\r\u0002M\u0007C\r)\u0011\u0001C\u0003\u0019\u000bU\u001bA!B\u0002\u0005\u000e%\t\u00012B\u0017\r\t\u0005$\u0001dB\u0011\u0004\u000b\u0005AQ\u0001G\u0003V\u0007\u0011)1\u0001B\u0004\n\u0003!-QF\u0007\u0003d\ta=\u0011%D\u0003\u0002\u0011\u0019IA!C\u0002\u0006\u0003!)\u0001$B\u0005\u0005\u0013\r)\u0011\u0001C\u0003\u0019\u000ba1Qk\u0001\u0005\u0006\u0007\u0011=\u0011\"\u0001E\b\u001b\r!\u0011\"C\u0001\t\u001052B!\u0019\u0003\u0019\u0014\u0005jQ!\u0001\u0005\u0007\u0013\u0011I1!B\u0001\t\u000ba)\u0011\u0002B\u0005\u0004\u000b\u0005AQ\u0001G\u0003\u0019\rU\u001bA!B\u0002\u0005\u0014%\t\u0001rB\u0017,\t\rA\"\"h\u0004\u0005\u0001!UQbA\u0003\u0002\u0011\u0015AR\u0001U\u0002\u0001;\u001f!\u0001\u0001C\u0006\u000e\u0007\u0015\t\u0001\u0012\u0003M\t!\u000e\u0005Qt\u0002\u0003\u0001\u00113i1!B\u0001\t\u0014aM\u0001kA\u0001\"\t\u0015\t\u0001b\u0003G\u00011-\t6!\u0003\u0003\u000b\u0013\u0005A9\"D\u0001\t\f5\t\u0001\u0002D\u0007\u0002\u00113i\u000b\u0005B\u0002\u0019 u=A\u0001\u0001\u0005\u0011\u001b\r)\u0011\u0001C\u0007\u0019\u001bA\u001b\u0001!h\u0004\u0005\u0001!eQbA\u0003\u0002\u0011'A\u001a\u0002UB\u0001C\u0011)\u0011\u0001C\u0006\r\u0002aY\u0011kA\u0004\u0005 %\t\u0001rC\u0007\u0002\u00117i\u0011\u0001#\u00076\u0001\u0001"})
public final class JavaAnnotationMapper {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final FqName JAVA_TARGET_FQ_NAME;
    private static final FqName JAVA_RETENTION_FQ_NAME;
    private static final FqName JAVA_DEPRECATED_FQ_NAME;
    private static final FqName JAVA_DOCUMENTED_FQ_NAME;
    private static final FqName JAVA_REPEATABLE_FQ_NAME;
    private static final Map<FqName, ? extends FqName> kotlinToJavaNameMap;
    @NotNull
    public static final Map<FqName, ? extends FqName> javaToKotlinNameMap;
    public static final JavaAnnotationMapper INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(JavaAnnotationMapper.class);
        new JavaAnnotationMapper();
    }

    @Nullable
    public final AnnotationDescriptor mapOrResolveJavaAnnotation(@NotNull JavaAnnotation annotation2, @NotNull LazyJavaResolverContext c) {
        AnnotationDescriptor annotationDescriptor;
        Intrinsics.checkParameterIsNotNull(annotation2, "annotation");
        Intrinsics.checkParameterIsNotNull(c, "c");
        ClassId classId = annotation2.getClassId();
        if (Intrinsics.areEqual(classId, ClassId.topLevel(JAVA_TARGET_FQ_NAME))) {
            annotationDescriptor = new JavaTargetAnnotationDescriptor(annotation2, c);
        } else if (Intrinsics.areEqual(classId, ClassId.topLevel(JAVA_RETENTION_FQ_NAME))) {
            annotationDescriptor = new JavaRetentionAnnotationDescriptor(annotation2, c);
        } else if (Intrinsics.areEqual(classId, ClassId.topLevel(JAVA_REPEATABLE_FQ_NAME))) {
            ClassDescriptor classDescriptor = c.getModule().getBuiltIns().getRepeatableAnnotation();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "c.module.builtIns.repeatableAnnotation");
            annotationDescriptor = new JavaAnnotationDescriptor(c, annotation2, classDescriptor);
        } else if (Intrinsics.areEqual(classId, ClassId.topLevel(JAVA_DOCUMENTED_FQ_NAME))) {
            ClassDescriptor classDescriptor = c.getModule().getBuiltIns().getMustBeDocumentedAnnotation();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "c.module.builtIns.mustBeDocumentedAnnotation");
            annotationDescriptor = new JavaAnnotationDescriptor(c, annotation2, classDescriptor);
        } else {
            annotationDescriptor = Intrinsics.areEqual(classId, ClassId.topLevel(JAVA_DEPRECATED_FQ_NAME)) ? (AnnotationDescriptor)null : (AnnotationDescriptor)LazyJavaAnnotationDescriptorKt.resolveAnnotation(c, annotation2);
        }
        return annotationDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final AnnotationDescriptor findMappedJavaAnnotation(@NotNull FqName kotlinName, @NotNull JavaAnnotationOwner annotationOwner, @NotNull LazyJavaResolverContext c) {
        AnnotationDescriptor annotationDescriptor;
        Object javaAnnotation;
        Intrinsics.checkParameterIsNotNull(kotlinName, "kotlinName");
        Intrinsics.checkParameterIsNotNull(annotationOwner, "annotationOwner");
        Intrinsics.checkParameterIsNotNull(c, "c");
        if (Intrinsics.areEqual(kotlinName, KotlinBuiltIns.FQ_NAMES.deprecated) && ((javaAnnotation = annotationOwner.findAnnotation(JAVA_DEPRECATED_FQ_NAME)) != null || annotationOwner.isDeprecatedInJavaDoc())) {
            return new JavaDeprecatedAnnotationDescriptor((JavaAnnotation)javaAnnotation, c);
        }
        FqName fqName2 = kotlinToJavaNameMap.get(kotlinName);
        if (fqName2 != null) {
            AnnotationDescriptor annotationDescriptor2;
            void $receiver;
            javaAnnotation = fqName2;
            FqName it2 = (FqName)$receiver;
            JavaAnnotation javaAnnotation2 = annotationOwner.findAnnotation(it2);
            if (javaAnnotation2 != null) {
                void $receiver2;
                JavaAnnotation it3;
                JavaAnnotation javaAnnotation3 = javaAnnotation2;
                JavaAnnotation javaAnnotation4 = it3 = (JavaAnnotation)$receiver2;
                Intrinsics.checkExpressionValueIsNotNull(javaAnnotation4, "it");
                annotationDescriptor2 = INSTANCE$.mapOrResolveJavaAnnotation(javaAnnotation4, c);
            } else {
                annotationDescriptor2 = null;
            }
            annotationDescriptor = annotationDescriptor2;
        } else {
            annotationDescriptor = null;
        }
        return annotationDescriptor;
    }

    @NotNull
    public final Map<FqName, FqName> getJavaToKotlinNameMap() {
        return javaToKotlinNameMap;
    }

    JavaAnnotationMapper() {
        INSTANCE$ = this;
        JAVA_TARGET_FQ_NAME = new FqName(Target.class.getCanonicalName());
        JAVA_RETENTION_FQ_NAME = new FqName(Retention.class.getCanonicalName());
        JAVA_DEPRECATED_FQ_NAME = new FqName(Deprecated.class.getCanonicalName());
        JAVA_DOCUMENTED_FQ_NAME = new FqName(Documented.class.getCanonicalName());
        JAVA_REPEATABLE_FQ_NAME = new FqName("java.lang.annotation.Repeatable");
        kotlinToJavaNameMap = KotlinPackage.mapOf(KotlinPackage.to(KotlinBuiltIns.FQ_NAMES.target, JAVA_TARGET_FQ_NAME), KotlinPackage.to(KotlinBuiltIns.FQ_NAMES.retention, JAVA_RETENTION_FQ_NAME), KotlinPackage.to(KotlinBuiltIns.FQ_NAMES.repeatable, JAVA_REPEATABLE_FQ_NAME), KotlinPackage.to(KotlinBuiltIns.FQ_NAMES.mustBeDocumented, JAVA_DOCUMENTED_FQ_NAME));
        javaToKotlinNameMap = KotlinPackage.mapOf(KotlinPackage.to(JAVA_TARGET_FQ_NAME, KotlinBuiltIns.FQ_NAMES.target), KotlinPackage.to(JAVA_RETENTION_FQ_NAME, KotlinBuiltIns.FQ_NAMES.retention), KotlinPackage.to(JAVA_DEPRECATED_FQ_NAME, KotlinBuiltIns.FQ_NAMES.deprecated), KotlinPackage.to(JAVA_REPEATABLE_FQ_NAME, KotlinBuiltIns.FQ_NAMES.repeatable), KotlinPackage.to(JAVA_DOCUMENTED_FQ_NAME, KotlinBuiltIns.FQ_NAMES.mustBeDocumented));
    }
}

