/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.AbstractNativeAnnotationsChecker;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"n\u0006)a\u0012IY:ue\u0006\u001cGOT1uSZ,\u0017J\u001c3fq\u0016\u00148\t[3dW\u0016\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\u0005)\u001c(b\u0002:fg>dg/\u001a\u0006!\u0003\n\u001cHO]1di:\u000bG/\u001b<f\u0003:tw\u000e^1uS>t7o\u00115fG.,'O\u0003\u0004=S:LGO\u0010\u0006\u0013e\u0016\fX/\u001b:fI\u0006sgn\u001c;bi&|gN\u0003\u000bQe\u0016$WMZ5oK\u0012\feN\\8uCRLwN\u001c\u0006\fS:$W\r_3s\u0017&tGM\u0003\u0004TiJLgn\u001a\u0006\u0018e\u0016\fX/\u001b:fIB\u000b'/Y7fi\u0016\u00148oQ8v]RT1!\u00138u\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u0010C\u0012$\u0017\u000e^5p]\u0006d7\t[3dW*YA-Z2mCJ\fG/[8o\u0015AQU\r\u001e(b[\u0016$g)\u001e8di&|gNC\u0002qg&T!\u0002Z3tGJL\u0007\u000f^8s\u0015I1UO\\2uS>tG)Z:de&\u0004Ho\u001c:\u000b\u0017\u0011,7o\u0019:jaR|'o\u001d\u0006\u0011I&\fwM\\8ti&\u001c\u0007j\u001c7eKJTa\u0002R5bO:|7\u000f^5d'&t7NC\u0006eS\u0006<gn\\:uS\u000e\u001c(\u0002B+oSR\u0014\u001bA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001b\u0001\u0007\u0001\u000b\r!\u0019\u0001#\u0003\r\u0001\u0015\t\u00012A\u0003\u0004\t\u0011AY\u0001\u0004\u0001\u0006\u0007\u0011!\u0001R\u0002\u0007\u0001\u000b\t!\u0019\u0001#\u0003\u0006\u0003!9QA\u0001\u0003\u0007\u0011\u001f)!\u0001\"\u0004\t\f\u0015\u0011A!\u0001E\n\u000b\r!y\u0001C\u0005\r\u0001\u0015\u0011A!\u0001\u0005\f\u000b\r!\t\u0002#\u0006\r\u0001\u0015\u0011A!\u0001E\r\u000b\r!\u0019\u0002\u0003\u0007\r\u0001\u0015\u0019A\u0001\u0002\u0005\u000e\u0019\u0001)!\u0001b\u0004\t\u0013\u0015\u0011A\u0011\u0003E\u000b\u000b\t!\u0019\u0002\u0003\u0007\u0005#1\u0015\u0011dA\u0003\u0002\u0011\rA2!\f\u0007\u0005C\u0012AR!I\u0002\u0006\u0003!%\u0001\u0014B+\u0004\t\u0015\u0019A!B\u0005\u0002\u0011\u001diC\u0002B1\u00051\u0019\t3!B\u0001\t\u000ba)Qk\u0001\u0003\u0006\u0007\u00111\u0011\"\u0001C\u0003[)\"1\u0002\u0007\u0005\u001e\u0010\u0011\u0001\u0001\u0012C\u0007\u0004\u000b\u0005A\u0001\u0002\u0007\u0005Q\u0007\u0001iz\u0001\u0002\u0001\t\u00155\u0019Q!\u0001\u0005\n1%\u00016\u0011AO\b\t\u0001A9\"D\u0002\u0006\u0003!Q\u0001D\u0003)\u0004\u0003\u0005\u001aQ!\u0001E\u000b1+\t6!\u0003\u0003\t\u0013\u0005!\u0001!D\u0001\t\u00175\t\u0001rC\u0007\u0002\u00111)<&\"\u0016\u0005G\u0004A:!h\u0004\u0005\u0001!!QbA\u0003\u0002\u0011\u000fA:\u0001U\u0002\u0001;\u001f!\u0001\u0001C\u0003\u000e\u0007\u0015\t\u0001\u0012\u0002M\u0005!\u000e\u0005Qt\u0002\u0003\u0001\u0011\u0019i1!B\u0001\t\u000ba)\u0001kA\u0001\"\u0007\u0015\t\u0001R\u0001M\u0003#\u000eIAqA\u0005\u0002\t\u0001i\u0011\u0001c\u0003\u000e\u0003!9Q\"\u0001C\u0003"})
public abstract class AbstractNativeIndexerChecker
extends AbstractNativeAnnotationsChecker {
    public static final /* synthetic */ KClass $kotlinClass;
    private final String indexerKind;
    private final int requiredParametersCount;

    static {
        $kotlinClass = Reflection.createKotlinClass(AbstractNativeIndexerChecker.class);
    }

    @Override
    public void additionalCheck(@NotNull JetNamedFunction declaration, @NotNull FunctionDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder) {
        ClassDescriptor firstParamClassDescriptor;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        List<ValueParameterDescriptor> parameters2 = descriptor2.getValueParameters();
        if (parameters2.size() > 0 && Intrinsics.areEqual(firstParamClassDescriptor = DescriptorUtils.getClassDescriptorForType(parameters2.get(0).getType()), KotlinBuiltIns.getInstance().getString()) ^ true && !DescriptorUtils.isSubclass(firstParamClassDescriptor, KotlinBuiltIns.getInstance().getNumber())) {
            diagnosticHolder.report(ErrorsJs.NATIVE_INDEXER_KEY_SHOULD_BE_STRING_OR_NUMBER.on((JetElement)((PsiElement)KotlinPackage.firstOrNull(declaration.getValueParameters())), this.indexerKind));
        }
        if (parameters2.size() != this.requiredParametersCount) {
            diagnosticHolder.report(ErrorsJs.NATIVE_INDEXER_WRONG_PARAMETER_COUNT.on((JetElement)((PsiElement)declaration), this.requiredParametersCount, this.indexerKind));
        }
        for (JetParameter parameter : declaration.getValueParameters()) {
            if (!parameter.hasDefaultValue()) continue;
            diagnosticHolder.report(ErrorsJs.NATIVE_INDEXER_CAN_NOT_HAVE_DEFAULT_ARGUMENTS.on((JetElement)((PsiElement)parameter), this.indexerKind));
        }
    }

    public AbstractNativeIndexerChecker(@NotNull PredefinedAnnotation requiredAnnotation, @NotNull String indexerKind, int requiredParametersCount) {
        Intrinsics.checkParameterIsNotNull((Object)requiredAnnotation, "requiredAnnotation");
        Intrinsics.checkParameterIsNotNull(indexerKind, "indexerKind");
        super(requiredAnnotation);
        this.indexerKind = indexerKind;
        this.requiredParametersCount = requiredParametersCount;
    }
}

