/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.repl;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;

public class ReplMessageCollectorWrapper {
    private static final Charset UTF8 = Charset.forName("utf-8");
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private final MessageCollector actualCollector = new PrintingMessageCollector(new PrintStream(this.outputStream), MessageRenderer.PLAIN_FULL_PATHS, false);

    @NotNull
    public MessageCollector getMessageCollector() {
        MessageCollector messageCollector = this.actualCollector;
        if (messageCollector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplMessageCollectorWrapper", "getMessageCollector"));
        }
        return messageCollector;
    }

    @NotNull
    public String getString() {
        String string = UTF8.decode(ByteBuffer.wrap(this.outputStream.toByteArray())).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplMessageCollectorWrapper", "getString"));
        }
        return string;
    }
}

