/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.calls.inference;

import java.util.Collection;
import java.util.Set;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.constraintPosition.ConstraintPosition;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypeBounds {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(TypeBounds.class);
    }

    @NotNull
    public Variance getVarianceOfPosition();

    @NotNull
    public TypeParameterDescriptor getTypeVariable();

    @NotNull
    public Collection<Bound> getBounds();

    @Nullable
    public JetType getValue();

    @NotNull
    public Collection<JetType> getValues();

    public static final class BoundKind
    extends Enum<BoundKind> {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final /* enum */ BoundKind LOWER_BOUND;
        public static final /* enum */ BoundKind EXACT_BOUND;
        public static final /* enum */ BoundKind UPPER_BOUND;
        private static final /* synthetic */ BoundKind[] $VALUES;

        static {
            $kotlinClass = Reflection.createKotlinClass(BoundKind.class);
            BoundKind[] boundKindArray = new BoundKind[3];
            BoundKind[] boundKindArray2 = boundKindArray;
            boundKindArray[0] = LOWER_BOUND = new BoundKind();
            boundKindArray[1] = EXACT_BOUND = new BoundKind();
            boundKindArray[2] = UPPER_BOUND = new BoundKind();
            $VALUES = boundKindArray;
        }

        public static BoundKind[] values() {
            return (BoundKind[])$VALUES.clone();
        }

        public static BoundKind valueOf(String string) {
            return Enum.valueOf(BoundKind.class, string);
        }
    }

    public static final class Bound {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final TypeParameterDescriptor typeVariable;
        @NotNull
        private final JetType constrainingType;
        @NotNull
        private final BoundKind kind;
        @NotNull
        private final ConstraintPosition position;
        private final boolean isProper;
        @NotNull
        private final Set<? extends TypeParameterDescriptor> derivedFrom;

        static {
            $kotlinClass = Reflection.createKotlinClass(Bound.class);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
                return false;
            }
            Object object = other;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.TypeBounds.Bound");
            }
            Bound bound = (Bound)object;
            if (Intrinsics.areEqual(this.typeVariable, bound.typeVariable) ^ true) {
                return false;
            }
            if (Intrinsics.areEqual(this.constrainingType, bound.constrainingType) ^ true) {
                return false;
            }
            if (Intrinsics.areEqual((Object)this.kind, (Object)bound.kind) ^ true) {
                return false;
            }
            return this.position.isStrong() == bound.position.isStrong();
        }

        public int hashCode() {
            int result2 = this.typeVariable.hashCode();
            result2 = 31 * result2 + this.constrainingType.hashCode();
            result2 = 31 * result2 + this.kind.hashCode();
            result2 = 31 * result2 + (this.position.isStrong() ? 1 : 0);
            return result2;
        }

        @NotNull
        public String toString() {
            return "Bound(" + this.constrainingType + ", " + (Object)((Object)this.kind) + ", " + this.position + ", isProper = " + this.isProper + ")";
        }

        @NotNull
        public final TypeParameterDescriptor getTypeVariable() {
            return this.typeVariable;
        }

        @NotNull
        public final JetType getConstrainingType() {
            return this.constrainingType;
        }

        @NotNull
        public final BoundKind getKind() {
            return this.kind;
        }

        @NotNull
        public final ConstraintPosition getPosition() {
            return this.position;
        }

        public final boolean getIsProper() {
            return this.isProper;
        }

        @NotNull
        public final Set<TypeParameterDescriptor> getDerivedFrom() {
            return this.derivedFrom;
        }

        public Bound(@NotNull TypeParameterDescriptor typeVariable, @NotNull JetType constrainingType, @NotNull BoundKind kind, @NotNull ConstraintPosition position, boolean isProper2, @NotNull Set<? extends TypeParameterDescriptor> derivedFrom) {
            Intrinsics.checkParameterIsNotNull(typeVariable, "typeVariable");
            Intrinsics.checkParameterIsNotNull(constrainingType, "constrainingType");
            Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
            Intrinsics.checkParameterIsNotNull(position, "position");
            Intrinsics.checkParameterIsNotNull(derivedFrom, "derivedFrom");
            this.typeVariable = typeVariable;
            this.constrainingType = constrainingType;
            this.kind = kind;
            this.position = position;
            this.isProper = isProper2;
            this.derivedFrom = derivedFrom;
        }
    }
}

