/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.conflictResolvers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodsConflictResolver
implements PsiConflictResolver {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver");
    private final PsiElement myArgumentsList;
    private final PsiType[] myActualParameterTypes;
    protected LanguageLevel myLanguageLevel;

    public JavaMethodsConflictResolver(@NotNull PsiExpressionList list, @NotNull LanguageLevel languageLevel) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        this(list, null, languageLevel);
    }

    public JavaMethodsConflictResolver(@NotNull PsiElement argumentsList, PsiType[] actualParameterTypes, @NotNull LanguageLevel languageLevel) {
        if (argumentsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentsList", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "<init>"));
        }
        this.myArgumentsList = argumentsList;
        this.myActualParameterTypes = actualParameterTypes;
        this.myLanguageLevel = languageLevel;
    }

    @Override
    public final CandidateInfo resolveConflict(final @NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "resolveConflict"));
        }
        return MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion(this.myArgumentsList, true, new Computable<CandidateInfo>(){

            @Override
            public CandidateInfo compute() {
                return JavaMethodsConflictResolver.this.guardedOverloadResolution(conflicts);
            }
        });
    }

    @Nullable
    protected CandidateInfo guardedOverloadResolution(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "guardedOverloadResolution"));
        }
        if (conflicts.isEmpty()) {
            return null;
        }
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        boolean atLeastOneMatch = this.checkParametersNumber(conflicts, this.getActualParametersLength(), true);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        FactoryMap<MethodCandidateInfo, PsiSubstitutor> map2 = new FactoryMap<MethodCandidateInfo, PsiSubstitutor>(){

            @Override
            @Nullable
            protected PsiSubstitutor create(MethodCandidateInfo key) {
                return key.getSubstitutor(false);
            }
        };
        this.checkSameSignatures(conflicts, map2);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkAccessStaticLevels(conflicts, true);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkParametersNumber(conflicts, this.getActualParametersLength(), false);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        int applicabilityLevel = this.checkApplicability(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        if (!atLeastOneMatch) {
            return null;
        }
        this.checkSpecifics(conflicts, applicabilityLevel, map2, this.myLanguageLevel);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkPrimitiveVarargs(conflicts, this.getActualParametersLength());
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkAccessStaticLevels(conflicts, false);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        THashSet<CandidateInfo> uniques = new THashSet<CandidateInfo>(conflicts);
        if (uniques.size() == 1) {
            return (CandidateInfo)uniques.iterator().next();
        }
        return null;
    }

    public void checkSpecifics(@NotNull List<CandidateInfo> conflicts, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel, @NotNull LanguageLevel languageLevel) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSpecifics"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSpecifics"));
        }
        this.checkSpecifics(conflicts, applicabilityLevel, null, languageLevel);
    }

    public void checkSpecifics(@NotNull List<CandidateInfo> conflicts, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel, FactoryMap<MethodCandidateInfo, PsiSubstitutor> map2, @NotNull LanguageLevel languageLevel) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSpecifics"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSpecifics"));
        }
        boolean applicable = applicabilityLevel > 1;
        int conflictsCount = conflicts.size();
        if (applicable) {
            CandidateInfo[] newConflictsArray = conflicts.toArray(new CandidateInfo[conflicts.size()]);
            for (int i = 1; i < conflictsCount; ++i) {
                CandidateInfo method = newConflictsArray[i];
                block5: for (int j = 0; j < i; ++j) {
                    ProgressManager.checkCanceled();
                    CandidateInfo conflict = newConflictsArray[j];
                    if (this.nonComparable(method, conflict, applicabilityLevel == 3)) continue;
                    switch (this.isMoreSpecific((MethodCandidateInfo)method, (MethodCandidateInfo)conflict, applicabilityLevel, map2, languageLevel)) {
                        case FIRST: {
                            conflicts.remove(conflict);
                            continue block5;
                        }
                        case SECOND: {
                            conflicts.remove(method);
                            continue block5;
                        }
                    }
                }
            }
        }
    }

    protected boolean nonComparable(@NotNull CandidateInfo method, @NotNull CandidateInfo conflict, boolean fixedArity) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "nonComparable"));
        }
        if (conflict == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflict", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "nonComparable"));
        }
        assert (method != conflict);
        return false;
    }

    protected static void checkAccessStaticLevels(@NotNull List<CandidateInfo> conflicts, boolean checkAccessible) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkAccessStaticLevels"));
        }
        int conflictsCount = conflicts.size();
        int maxCheckLevel = -1;
        int[] checkLevels = new int[conflictsCount];
        int index2 = 0;
        for (CandidateInfo conflict : conflicts) {
            ProgressManager.checkCanceled();
            MethodCandidateInfo method = (MethodCandidateInfo)conflict;
            int level = checkAccessible ? JavaMethodsConflictResolver.getCheckAccessLevel(method) : JavaMethodsConflictResolver.getCheckStaticLevel(method);
            checkLevels[index2++] = level;
            maxCheckLevel = Math.max(maxCheckLevel, level);
        }
        for (int i = conflictsCount - 1; i >= 0; --i) {
            if (checkLevels[i] >= maxCheckLevel) continue;
            conflicts.remove(i);
        }
    }

    protected void checkSameSignatures(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSameSignatures"));
        }
        this.checkSameSignatures(conflicts, null);
    }

    protected void checkSameSignatures(@NotNull List<CandidateInfo> conflicts, FactoryMap<MethodCandidateInfo, PsiSubstitutor> map2) {
        PsiMethod method;
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkSameSignatures"));
        }
        THashMap<MethodSignature, CandidateInfo> signatures = new THashMap<MethodSignature, CandidateInfo>(conflicts.size());
        HashSet<PsiMethod> superMethods = new HashSet<PsiMethod>();
        for (CandidateInfo conflict : conflicts) {
            method = ((MethodCandidateInfo)conflict).getElement();
            PsiClass containingClass = method.getContainingClass();
            boolean isInterface = containingClass != null && containingClass.isInterface();
            for (HierarchicalMethodSignature methodSignature : method.getHierarchicalMethodSignature().getSuperSignatures()) {
                PsiMethod superMethod = methodSignature.getMethod();
                if (!isInterface) {
                    superMethods.add(superMethod);
                    continue;
                }
                PsiClass aClass = superMethod.getContainingClass();
                if (aClass == null || "java.lang.Object".equals(aClass.getQualifiedName())) continue;
                superMethods.add(superMethod);
            }
        }
        block2: for (int i = 0; i < conflicts.size(); ++i) {
            PsiReferenceExpression expression;
            PsiExpression qualifierExpression;
            PsiClass currentClass;
            ProgressManager.checkCanceled();
            CandidateInfo info = conflicts.get(i);
            method = (PsiMethod)info.getElement();
            if (!method.hasModifierProperty("static") && superMethods.contains(method)) {
                conflicts.remove(i);
                --i;
                continue;
            }
            PsiClass class1 = method.getContainingClass();
            PsiSubstitutor infoSubstitutor = JavaMethodsConflictResolver.getSubstitutor((MethodCandidateInfo)info, map2);
            MethodSignature signature = method.getSignature(infoSubstitutor);
            CandidateInfo existing = (CandidateInfo)signatures.get(signature);
            if (existing == null) {
                signatures.put(signature, info);
                continue;
            }
            PsiMethod existingMethod = (PsiMethod)existing.getElement();
            PsiClass existingClass = existingMethod.getContainingClass();
            if (class1 != null && existingClass != null) {
                if (class1.isInterface() && "java.lang.Object".equals(existingClass.getQualifiedName())) {
                    signatures.put(signature, info);
                    continue;
                }
                if (existingClass.isInterface() && "java.lang.Object".equals(class1.getQualifiedName())) {
                    conflicts.remove(info);
                    --i;
                    continue;
                }
            }
            if (method == existingMethod) {
                PsiElement scope1 = info.getCurrentFileResolveScope();
                PsiElement scope2 = existing.getCurrentFileResolveScope();
                if (scope1 instanceof PsiClass && scope2 instanceof PsiClass && PsiTreeUtil.isAncestor(scope1, scope2, true) && !existing.isAccessible()) {
                    signatures.put(signature, info);
                    continue;
                }
            }
            boolean existingTypeParamAgree = JavaMethodsConflictResolver.areTypeParametersAgree(existing);
            boolean infoTypeParamAgree = JavaMethodsConflictResolver.areTypeParametersAgree(info);
            if (existingTypeParamAgree && !infoTypeParamAgree && !PsiSuperMethodImplUtil.isSuperMethodSmart(method, existingMethod)) {
                conflicts.remove(i);
                --i;
                continue;
            }
            if (!existingTypeParamAgree && infoTypeParamAgree && !PsiSuperMethodImplUtil.isSuperMethodSmart(existingMethod, method)) {
                signatures.put(signature, info);
                int index2 = conflicts.indexOf(existing);
                conflicts.remove(index2);
                --i;
                continue;
            }
            if (InheritanceUtil.isInheritorOrSelf(class1, existingClass, true) || InheritanceUtil.isInheritorOrSelf(existingClass, class1, true)) {
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                PsiParameter[] existingParameters = existingMethod.getParameterList().getParameters();
                int parametersLength = parameters2.length;
                for (int i1 = 0; i1 < parametersLength; ++i1) {
                    if (!(parameters2[i1].getType() instanceof PsiArrayType) || existingParameters[i1].getType() instanceof PsiArrayType) continue;
                    signatures.put(signature, info);
                    continue block2;
                }
                PsiType returnType1 = method.getReturnType();
                PsiType returnType2 = existingMethod.getReturnType();
                if (returnType1 != null && returnType2 != null && !(returnType1 = infoSubstitutor.substitute(returnType1)).equals(returnType2 = JavaMethodsConflictResolver.getSubstitutor((MethodCandidateInfo)existing, map2).substitute(returnType2)) && returnType1.isAssignableFrom(returnType2)) {
                    conflicts.remove(i);
                    --i;
                    continue;
                }
                signatures.put(signature, info);
                continue;
            }
            PsiMethodCallExpression methodCallExpression = PsiTreeUtil.getParentOfType(this.myArgumentsList, PsiMethodCallExpression.class);
            if (methodCallExpression == null || (currentClass = (qualifierExpression = (expression = methodCallExpression.getMethodExpression()).getQualifierExpression()) != null ? PsiUtil.resolveClassInClassTypeOnly(qualifierExpression.getType()) : PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class)) == null || existingClass == null || class1 == null) continue;
            PsiSubstitutor eSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(existingClass, currentClass, PsiSubstitutor.EMPTY, null);
            PsiSubstitutor cSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(class1, currentClass, PsiSubstitutor.EMPTY, null);
            if (eSubstitutor == null || cSubstitutor == null || !MethodSignatureUtil.areSignaturesEqual(existingMethod.getSignature(eSubstitutor), method.getSignature(cSubstitutor))) continue;
            PsiType returnType2 = eSubstitutor.substitute(existingMethod.getReturnType());
            PsiType returnType1 = cSubstitutor.substitute(method.getReturnType());
            if (returnType2 == null || returnType1 == null || returnType1.equals(returnType2)) continue;
            if (TypeConversionUtil.isAssignable(returnType2, returnType1, false)) {
                if (class1.isInterface() && !existingClass.isInterface()) continue;
                conflicts.remove(existing);
            } else {
                if (!TypeConversionUtil.isAssignable(returnType1, returnType2, false)) continue;
                conflicts.remove(i);
            }
            --i;
            break;
        }
    }

    @NotNull
    private static PsiSubstitutor getSubstitutor(MethodCandidateInfo existing, FactoryMap<MethodCandidateInfo, PsiSubstitutor> map2) {
        PsiSubstitutor psiSubstitutor = map2 != null ? map2.get(existing) : existing.getSubstitutor(false);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    private static boolean areTypeParametersAgree(@NotNull CandidateInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "areTypeParametersAgree"));
        }
        return ((MethodCandidateInfo)info).getPertinentApplicabilityLevel() != 1;
    }

    public boolean checkParametersNumber(@NotNull List<CandidateInfo> conflicts, int argumentsCount, boolean ignoreIfStaticsProblem) {
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkParametersNumber"));
        }
        boolean atLeastOneMatch = false;
        TIntArrayList unmatchedIndices = null;
        for (int i = 0; i < conflicts.size(); ++i) {
            ProgressManager.checkCanceled();
            CandidateInfo info = conflicts.get(i);
            if (ignoreIfStaticsProblem && !info.isStaticsScopeCorrect()) {
                return true;
            }
            if (!(info instanceof MethodCandidateInfo)) continue;
            PsiMethod method = ((MethodCandidateInfo)info).getElement();
            int parametersCount = method.getParameterList().getParametersCount();
            if ((this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) ? ((MethodCandidateInfo)info).isVarargs() : method.isVarArgs()) && parametersCount - 1 <= argumentsCount || parametersCount == argumentsCount) {
                if (unmatchedIndices != null) {
                    for (int u = unmatchedIndices.size() - 1; u >= 0; --u) {
                        int index2 = unmatchedIndices.get(u);
                        conflicts.remove(index2);
                        --i;
                    }
                    unmatchedIndices = null;
                }
                atLeastOneMatch = true;
                continue;
            }
            if (atLeastOneMatch) {
                conflicts.remove(i);
                --i;
                continue;
            }
            if (unmatchedIndices == null) {
                unmatchedIndices = new TIntArrayList(conflicts.size() - i);
            }
            unmatchedIndices.add(i);
        }
        return atLeastOneMatch;
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public int checkApplicability(@NotNull List<CandidateInfo> conflicts) {
        int level;
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkApplicability"));
        }
        int maxApplicabilityLevel = 0;
        boolean toFilter = false;
        for (CandidateInfo conflict : conflicts) {
            ProgressManager.checkCanceled();
            level = this.getPertinentApplicabilityLevel((MethodCandidateInfo)conflict);
            if (maxApplicabilityLevel > 0 && maxApplicabilityLevel != level) {
                toFilter = true;
            }
            if (level <= maxApplicabilityLevel) continue;
            maxApplicabilityLevel = level;
        }
        if (toFilter) {
            Iterator<CandidateInfo> iterator2 = conflicts.iterator();
            while (iterator2.hasNext()) {
                ProgressManager.checkCanceled();
                CandidateInfo info = iterator2.next();
                level = this.getPertinentApplicabilityLevel((MethodCandidateInfo)info);
                if (level >= maxApplicabilityLevel) continue;
                iterator2.remove();
            }
        }
        return maxApplicabilityLevel;
    }

    protected int getPertinentApplicabilityLevel(@NotNull MethodCandidateInfo conflict) {
        if (conflict == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflict", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "getPertinentApplicabilityLevel"));
        }
        return conflict.getPertinentApplicabilityLevel();
    }

    private static int getCheckAccessLevel(@NotNull MethodCandidateInfo method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "getCheckAccessLevel"));
        }
        boolean visible = method.isAccessible();
        return visible ? 1 : 0;
    }

    private static int getCheckStaticLevel(@NotNull MethodCandidateInfo method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "getCheckStaticLevel"));
        }
        boolean available = method.isStaticsScopeCorrect();
        return (available ? 1 : 0) << 1 | (method.getCurrentFileResolveScope() instanceof PsiImportStaticStatement ? 0 : 1);
    }

    private int getActualParametersLength() {
        if (this.myActualParameterTypes == null) {
            LOG.assertTrue(this.myArgumentsList instanceof PsiExpressionList, this.myArgumentsList);
            return ((PsiExpressionList)this.myArgumentsList).getExpressions().length;
        }
        return this.myActualParameterTypes.length;
    }

    private static boolean isBoxingHappened(PsiType argType, PsiType parameterType, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isBoxingHappened"));
        }
        if (parameterType instanceof PsiClassType) {
            parameterType = ((PsiClassType)parameterType).setLanguageLevel(languageLevel);
        }
        return argType != null && TypeConversionUtil.boxingConversionApplicable(parameterType, argType);
    }

    private Specifics isMoreSpecific(@NotNull MethodCandidateInfo info1, @NotNull MethodCandidateInfo info2, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel, FactoryMap<MethodCandidateInfo, PsiSubstitutor> map2, @NotNull LanguageLevel languageLevel) {
        boolean varargs2;
        boolean raw2;
        boolean raw1;
        if (info1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isMoreSpecific"));
        }
        if (info2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info2", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isMoreSpecific"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isMoreSpecific"));
        }
        PsiMethod method1 = info1.getElement();
        PsiMethod method2 = info2.getElement();
        PsiClass class1 = method1.getContainingClass();
        PsiClass class2 = method2.getContainingClass();
        PsiParameter[] params1 = method1.getParameterList().getParameters();
        PsiParameter[] params2 = method2.getParameterList().getParameters();
        PsiTypeParameter[] typeParameters1 = method1.getTypeParameters();
        PsiTypeParameter[] typeParameters2 = method2.getTypeParameters();
        PsiSubstitutor classSubstitutor1 = JavaMethodsConflictResolver.getSubstitutor(info1, map2);
        PsiSubstitutor classSubstitutor2 = JavaMethodsConflictResolver.getSubstitutor(info2, map2);
        int argsLength = languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (method1.isVarArgs() || method2.isVarArgs()) ? this.getActualParametersLength() : 0;
        int max = Math.max(Math.max(params1.length, params2.length), argsLength);
        PsiType[] types1 = PsiType.createArray(max);
        PsiType[] types2 = PsiType.createArray(max);
        boolean varargsPosition = applicabilityLevel == 2;
        for (int i = 0; i < max; ++i) {
            PsiType type2;
            ProgressManager.checkCanceled();
            PsiType type1 = params1.length > 0 ? params1[Math.min(i, params1.length - 1)].getType() : null;
            PsiType psiType = type2 = params2.length > 0 ? params2[Math.min(i, params2.length - 1)].getType() : null;
            if (varargsPosition) {
                if (type1 instanceof PsiEllipsisType && type2 instanceof PsiEllipsisType && params1.length == params2.length && class1 != null && (!JavaVersionService.getInstance().isAtLeast(class1, JavaSdkVersion.JDK_1_7) || ((PsiArrayType)type1).getComponentType().equalsToText("java.lang.Object") || ((PsiArrayType)type2).getComponentType().equalsToText("java.lang.Object"))) {
                    type1 = ((PsiEllipsisType)type1).toArrayType();
                    type2 = ((PsiEllipsisType)type2).toArrayType();
                } else {
                    type1 = type1 instanceof PsiEllipsisType ? ((PsiArrayType)type1).getComponentType() : type1;
                    type2 = type2 instanceof PsiEllipsisType ? ((PsiArrayType)type2).getComponentType() : type2;
                }
            }
            types1[i] = type1;
            types2[i] = type2;
        }
        boolean sameBoxing = true;
        int[] boxingHappened = new int[2];
        PsiType[] argTypes1 = this.myActualParameterTypes != null ? this.myActualParameterTypes : info1.getPertinentArgumentTypes();
        PsiType[] argTypes2 = this.myActualParameterTypes != null ? this.myActualParameterTypes : info2.getPertinentArgumentTypes();
        for (int i = 0; i < types1.length; ++i) {
            ProgressManager.checkCanceled();
            PsiType type1 = classSubstitutor1.substitute(types1[i]);
            PsiType type2 = classSubstitutor2.substitute(types2[i]);
            PsiType argType1 = i < this.getActualParametersLength() ? argTypes1[i] : null;
            PsiType argType2 = i < this.getActualParametersLength() ? argTypes2[i] : null;
            boolean boxingInFirst = false;
            if (JavaMethodsConflictResolver.isBoxingHappened(argType1, type1, languageLevel)) {
                boxingHappened[0] = boxingHappened[0] + 1;
                boxingInFirst = true;
            }
            boolean boxingInSecond = false;
            if (JavaMethodsConflictResolver.isBoxingHappened(argType2, type2, languageLevel)) {
                boxingHappened[1] = boxingHappened[1] + 1;
                boxingInSecond = true;
            }
            sameBoxing &= boxingInFirst == boxingInSecond;
        }
        if (boxingHappened[0] == 0 && boxingHappened[1] > 0) {
            return Specifics.FIRST;
        }
        if (boxingHappened[0] > 0 && boxingHappened[1] == 0) {
            return Specifics.SECOND;
        }
        if (sameBoxing) {
            PsiSubstitutor siteSubstitutor1 = info1.getSiteSubstitutor();
            PsiSubstitutor siteSubstitutor2 = info2.getSiteSubstitutor();
            PsiType[] types2AtSite = JavaMethodsConflictResolver.typesAtSite(types2, siteSubstitutor2);
            PsiType[] types1AtSite = JavaMethodsConflictResolver.typesAtSite(types1, siteSubstitutor1);
            PsiSubstitutor methodSubstitutor1 = JavaMethodsConflictResolver.calculateMethodSubstitutor(typeParameters1, method1, siteSubstitutor1, types1, types2AtSite, languageLevel);
            boolean applicable12 = this.isApplicableTo(types2AtSite, method1, languageLevel, varargsPosition, methodSubstitutor1, method2, siteSubstitutor2);
            PsiSubstitutor methodSubstitutor2 = JavaMethodsConflictResolver.calculateMethodSubstitutor(typeParameters2, method2, siteSubstitutor2, types2, types1AtSite, languageLevel);
            boolean applicable21 = this.isApplicableTo(types1AtSite, method2, languageLevel, varargsPosition, methodSubstitutor2, method1, siteSubstitutor1);
            if (!this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                boolean typeArgsApplicable12 = GenericsUtil.isTypeArgumentsApplicable(typeParameters1, methodSubstitutor1, this.myArgumentsList, !applicable21);
                boolean typeArgsApplicable21 = GenericsUtil.isTypeArgumentsApplicable(typeParameters2, methodSubstitutor2, this.myArgumentsList, !applicable12);
                if (!typeArgsApplicable12) {
                    applicable12 = false;
                }
                if (!typeArgsApplicable21) {
                    applicable21 = false;
                }
            }
            if (applicable12 || applicable21) {
                if (applicable12 && !applicable21) {
                    return Specifics.SECOND;
                }
                if (applicable21 && !applicable12) {
                    return Specifics.FIRST;
                }
                boolean abstract1 = method1.hasModifierProperty("abstract");
                boolean abstract2 = method2.hasModifierProperty("abstract");
                if (abstract1 && !abstract2) {
                    return Specifics.SECOND;
                }
                if (abstract2 && !abstract1) {
                    return Specifics.FIRST;
                }
                if (method1.hasModifierProperty("default") && method2.hasModifierProperty("static")) {
                    return Specifics.FIRST;
                }
                if (method2.hasModifierProperty("default") && method1.hasModifierProperty("static")) {
                    return Specifics.SECOND;
                }
            }
        } else if (varargsPosition) {
            PsiType lastParamType1 = classSubstitutor1.substitute(types1[types1.length - 1]);
            PsiType lastParamType2 = classSubstitutor2.substitute(types2[types1.length - 1]);
            boolean assignable1 = TypeConversionUtil.isAssignable(lastParamType2, lastParamType1);
            boolean assignable2 = TypeConversionUtil.isAssignable(lastParamType1, lastParamType2);
            if (assignable1 && !assignable2) {
                return Specifics.FIRST;
            }
            if (assignable2 && !assignable1) {
                return Specifics.SECOND;
            }
        }
        if (class1 != class2) {
            if (class2.isInheritor(class1, true) || class1.isInterface() && !class2.isInterface()) {
                if (JavaMethodsConflictResolver.isSubSignature(method1, method2, classSubstitutor1, classSubstitutor2, boxingHappened)) {
                    return Specifics.SECOND;
                }
            } else if ((class1.isInheritor(class2, true) || class2.isInterface()) && JavaMethodsConflictResolver.isSubSignature(method2, method1, classSubstitutor2, classSubstitutor1, boxingHappened)) {
                return Specifics.FIRST;
            }
        }
        if ((raw1 = PsiUtil.isRawSubstitutor(method1, classSubstitutor1)) ^ (raw2 = PsiUtil.isRawSubstitutor(method2, classSubstitutor2))) {
            return raw1 ? Specifics.SECOND : Specifics.FIRST;
        }
        boolean varargs1 = info1.isVarargs();
        if (varargs1 ^ (varargs2 = info2.isVarargs())) {
            return varargs1 ? Specifics.SECOND : Specifics.FIRST;
        }
        return Specifics.NEITHER;
    }

    private static boolean isSubSignature(PsiMethod method1, PsiMethod method2, PsiSubstitutor classSubstitutor1, PsiSubstitutor classSubstitutor2, int[] boxingHappened) {
        return MethodSignatureUtil.areErasedParametersEqual(method1.getSignature(PsiSubstitutor.EMPTY), method2.getSignature(PsiSubstitutor.EMPTY)) && MethodSignatureUtil.isSubsignature(method1.getSignature(classSubstitutor1), method2.getSignature(classSubstitutor2)) || method1.hasModifierProperty("static") && method2.hasModifierProperty("static") && boxingHappened[0] == 0;
    }

    private boolean isApplicableTo(@NotNull PsiType[] types2AtSite, @NotNull PsiMethod method1, @NotNull LanguageLevel languageLevel, boolean varargsPosition, @NotNull PsiSubstitutor methodSubstitutor1, @NotNull PsiMethod method2, PsiSubstitutor siteSubstitutor1) {
        PsiElement parent;
        if (types2AtSite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types2AtSite", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isApplicableTo"));
        }
        if (method1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isApplicableTo"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isApplicableTo"));
        }
        if (methodSubstitutor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSubstitutor1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isApplicableTo"));
        }
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method2", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isApplicableTo"));
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && method1.getTypeParameters().length > 0 && this.myArgumentsList instanceof PsiExpressionList && (parent = this.myArgumentsList.getParent()) instanceof PsiCallExpression) {
            return InferenceSession.isMoreSpecific(method2, method1, siteSubstitutor1, ((PsiExpressionList)this.myArgumentsList).getExpressions(), this.myArgumentsList, varargsPosition);
        }
        PsiUtil.ApplicabilityChecker applicabilityChecker = languageLevel.isAtLeast(LanguageLevel.JDK_1_8) ? new PsiUtil.ApplicabilityChecker(){

            @Override
            public boolean isApplicable(PsiType left, PsiType right, boolean allowUncheckedConversion, int argId) {
                return JavaMethodsConflictResolver.this.isTypeMoreSpecific(left, right, argId);
            }
        } : PsiUtil.ApplicabilityChecker.ASSIGNABILITY_CHECKER;
        int applicabilityLevel = PsiUtil.getApplicabilityLevel(method1, methodSubstitutor1, types2AtSite, languageLevel, false, varargsPosition, applicabilityChecker);
        return applicabilityLevel > 1;
    }

    private boolean isTypeMoreSpecific(PsiType left, PsiType right, int argId) {
        PsiExpression[] expressions;
        if (TypeConversionUtil.isAssignable(left, right, false)) {
            return true;
        }
        if (this.myArgumentsList instanceof PsiExpressionList && argId < (expressions = ((PsiExpressionList)this.myArgumentsList).getExpressions()).length) {
            Specifics specific = JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(expressions[argId], right, left);
            return Specifics.FIRST.equals((Object)specific);
        }
        return false;
    }

    @NotNull
    private static PsiType[] typesAtSite(@NotNull PsiType[] types1, @NotNull PsiSubstitutor siteSubstitutor1) {
        if (types1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "typesAtSite"));
        }
        if (siteSubstitutor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "siteSubstitutor1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "typesAtSite"));
        }
        PsiType[] types2 = PsiType.createArray(types1.length);
        for (int i = 0; i < types1.length; ++i) {
            types2[i] = siteSubstitutor1.substitute(types1[i]);
        }
        if (types2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "typesAtSite"));
        }
        return types2;
    }

    @NotNull
    private static PsiSubstitutor calculateMethodSubstitutor(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiMethod method, @NotNull PsiSubstitutor siteSubstitutor, @NotNull PsiType[] types1, @NotNull PsiType[] types2, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        if (siteSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "siteSubstitutor", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        if (types1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types1", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types2", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        PsiSubstitutor substitutor2 = PsiResolveHelper.SERVICE.getInstance(method.getProject()).inferTypeArguments(typeParameters, types1, types2, languageLevel);
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(method)) {
            PsiClass aClass;
            PsiType type2;
            ProgressManager.checkCanceled();
            LOG.assertTrue(typeParameter != null);
            if (!substitutor2.getSubstitutionMap().containsKey(typeParameter)) {
                type2 = siteSubstitutor.substitute(typeParameter);
                if (type2 instanceof PsiClassType && typeParameter.getOwner() == method && (aClass = ((PsiClassType)type2).resolve()) instanceof PsiTypeParameter && ((PsiTypeParameter)aClass).getOwner() == method) {
                    type2 = TypeConversionUtil.erasure(type2, siteSubstitutor);
                }
                substitutor2 = substitutor2.put(typeParameter, type2);
                continue;
            }
            type2 = substitutor2.substitute(typeParameter);
            if (!(type2 instanceof PsiClassType) || !((aClass = ((PsiClassType)type2).resolve()) instanceof PsiTypeParameter)) continue;
            substitutor2 = substitutor2.put(typeParameter, JavaPsiFacade.getElementFactory(aClass.getProject()).createType(aClass, siteSubstitutor));
        }
        PsiSubstitutor psiSubstitutor = substitutor2;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "calculateMethodSubstitutor"));
        }
        return psiSubstitutor;
    }

    public void checkPrimitiveVarargs(@NotNull List<CandidateInfo> conflicts, int argumentsCount) {
        PsiType type2;
        PsiType componentType;
        PsiMethod method;
        if (conflicts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "checkPrimitiveVarargs"));
        }
        if (JavaVersionService.getInstance().isAtLeast(this.myArgumentsList, JavaSdkVersion.JDK_1_7)) {
            return;
        }
        CandidateInfo objectVararg = null;
        for (CandidateInfo conflict : conflicts) {
            PsiClassType classType;
            ProgressManager.checkCanceled();
            method = (PsiMethod)conflict.getElement();
            int parametersCount = method.getParameterList().getParametersCount();
            if (!method.isVarArgs() || parametersCount - 1 != argumentsCount || !Comparing.equal(componentType = ((PsiArrayType)(type2 = method.getParameterList().getParameters()[parametersCount - 1].getType())).getComponentType(), classType = PsiType.getJavaLangObject(method.getManager(), GlobalSearchScope.allScope(method.getProject())))) continue;
            objectVararg = conflict;
        }
        if (objectVararg != null) {
            for (CandidateInfo conflict : conflicts) {
                ProgressManager.checkCanceled();
                method = (PsiMethod)conflict.getElement();
                if (method == objectVararg || !method.isVarArgs()) continue;
                int paramsCount = method.getParameterList().getParametersCount();
                type2 = method.getParameterList().getParameters()[paramsCount - 1].getType();
                componentType = ((PsiArrayType)type2).getComponentType();
                if (argumentsCount != paramsCount - 1 || !(componentType instanceof PsiPrimitiveType)) continue;
                conflicts.remove(objectVararg);
                break;
            }
        }
    }

    @NotNull
    private static Specifics isFunctionalTypeMoreSpecific(PsiExpression expr, PsiType sType, PsiType tType) {
        if (expr instanceof PsiParenthesizedExpression) {
            Specifics specifics = JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(((PsiParenthesizedExpression)expr).getExpression(), sType, tType);
            if (specifics == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isFunctionalTypeMoreSpecific"));
            }
            return specifics;
        }
        if (expr instanceof PsiConditionalExpression) {
            Specifics elseSpecifics;
            Specifics thenSpecifics = JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(((PsiConditionalExpression)expr).getThenExpression(), sType, tType);
            Specifics specifics = thenSpecifics == (elseSpecifics = JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(((PsiConditionalExpression)expr).getElseExpression(), sType, tType)) ? thenSpecifics : Specifics.NEITHER;
            if (specifics == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isFunctionalTypeMoreSpecific"));
            }
            return specifics;
        }
        if (expr instanceof PsiFunctionalExpression) {
            if (expr instanceof PsiLambdaExpression && !((PsiLambdaExpression)expr).hasFormalParameterTypes()) {
                Specifics specifics = Specifics.NEITHER;
                if (specifics == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isFunctionalTypeMoreSpecific"));
                }
                return specifics;
            }
            if (expr instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)expr).isExact()) {
                Specifics specifics = Specifics.NEITHER;
                if (specifics == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isFunctionalTypeMoreSpecific"));
                }
                return specifics;
            }
            if (LambdaUtil.isFunctionalType(sType) && LambdaUtil.isFunctionalType(tType) && !TypeConversionUtil.erasure(tType).isAssignableFrom(sType) && !TypeConversionUtil.erasure(sType).isAssignableFrom(tType)) {
                boolean specific12 = InferenceSession.isFunctionalTypeMoreSpecificOnExpression(sType, tType, expr);
                boolean specific21 = InferenceSession.isFunctionalTypeMoreSpecificOnExpression(tType, sType, expr);
                if (specific12 && !specific21) {
                    Specifics specifics = Specifics.FIRST;
                    if (specifics == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isFunctionalTypeMoreSpecific"));
                    }
                    return specifics;
                }
                if (!specific12 && specific21) {
                    Specifics specifics = Specifics.SECOND;
                    if (specifics == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isFunctionalTypeMoreSpecific"));
                    }
                    return specifics;
                }
            }
        }
        Specifics specifics = Specifics.NEITHER;
        if (specifics == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver", "isFunctionalTypeMoreSpecific"));
        }
        return specifics;
    }

    private static enum Specifics {
        FIRST,
        SECOND,
        NEITHER;

    }
}

