/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.js;

import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializedResourcePaths;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class JsPackage$KotlinJavascriptSerializedResourcePaths$e8982634 {
    @NotNull
    static final String PACKAGE_CLASS_NAME_SUFFIX = "Package";
    @NotNull
    static final String DEFAULT_PACKAGE_CLASS_NAME = "_DefaultPackage";
    @NotNull
    static final String DEFAULT_PACKAGE_METAFILE_NAME = "_DefaultPackage.kjsm";

    @NotNull
    public static final String getPACKAGE_CLASS_NAME_SUFFIX() {
        return PACKAGE_CLASS_NAME_SUFFIX;
    }

    @NotNull
    public static final String getDEFAULT_PACKAGE_CLASS_NAME() {
        return DEFAULT_PACKAGE_CLASS_NAME;
    }

    @NotNull
    public static final String getDEFAULT_PACKAGE_METAFILE_NAME() {
        return DEFAULT_PACKAGE_METAFILE_NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPackageClassFqName(@JetValueParameter(name="$receiver") FqName $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.isRoot()) return false;
        FqName fqName2 = $receiver.parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "this.parent()");
        if (!Intrinsics.areEqual(JsPackage$KotlinJavascriptSerializedResourcePaths$e8982634.getPackageClassFqName(fqName2), $receiver)) return false;
        return true;
    }

    public static final boolean isDefaultPackageMetafile(@JetValueParameter(name="fileName") @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return Intrinsics.areEqual(fileName, DEFAULT_PACKAGE_METAFILE_NAME);
    }

    public static final boolean isPackageMetadataFile(@JetValueParameter(name="fileName") @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return Intrinsics.areEqual(KotlinJavascriptSerializedResourcePaths.INSTANCE$.getPackageFilePath(JsPackage$KotlinJavascriptSerializedResourcePaths$e8982634.getPackageFqName(fileName)), fileName);
    }

    public static final boolean isStringTableFile(@JetValueParameter(name="fileName") @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return Intrinsics.areEqual(KotlinJavascriptSerializedResourcePaths.INSTANCE$.getStringTableFilePath(JsPackage$KotlinJavascriptSerializedResourcePaths$e8982634.getPackageFqName(fileName)), fileName);
    }

    public static final boolean isClassesInPackageFile(@JetValueParameter(name="fileName") @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return Intrinsics.areEqual(KotlinJavascriptSerializedResourcePaths.INSTANCE$.getClassesInPackageFilePath(JsPackage$KotlinJavascriptSerializedResourcePaths$e8982634.getPackageFqName(fileName)), fileName);
    }

    @NotNull
    public static final FqName getPackageFqName(@JetValueParameter(name="fileName") @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return new FqName(JsPackage$KotlinJavascriptSerializedResourcePaths$e8982634.getPackageName(fileName));
    }

    @NotNull
    public static final String getPackageName(@JetValueParameter(name="filePath") @NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull(filePath, "filePath");
        return KotlinPackage.indexOf$default(filePath, '/', 0, false, 6) >= 0 ? KotlinPackage.replace$default(KotlinPackage.substringBeforeLast$default(filePath, '/', null, 2), '/', '.', false, 4) : "";
    }

    @NotNull
    public static final FqName getPackageClassFqName(@JetValueParameter(name="packageFQN") @NotNull FqName packageFQN) {
        Intrinsics.checkParameterIsNotNull(packageFQN, "packageFQN");
        FqName fqName2 = packageFQN.child(Name.identifier(JsPackage$KotlinJavascriptSerializedResourcePaths$e8982634.getPackageClassName(packageFQN)));
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageFQN.child(Name.id\u2026geClassName(packageFQN)))");
        return fqName2;
    }

    @NotNull
    public static final String getPackageClassName(@JetValueParameter(name="packageFQN") @NotNull FqName packageFQN) {
        String string;
        Intrinsics.checkParameterIsNotNull(packageFQN, "packageFQN");
        if (packageFQN.isRoot()) {
            string = DEFAULT_PACKAGE_CLASS_NAME;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = packageFQN.shortName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "packageFQN.shortName().asString()");
            string = stringBuilder.append(JsPackage$KotlinJavascriptSerializedResourcePaths$e8982634.capitalizeNonEmptyString(string2)).append(PACKAGE_CLASS_NAME_SUFFIX).toString();
        }
        return string;
    }

    @NotNull
    public static final String capitalizeNonEmptyString(@JetValueParameter(name="s") @NotNull String s) {
        Intrinsics.checkParameterIsNotNull(s, "s");
        return Character.isUpperCase(s.charAt(0)) ? s : KotlinPackage.plus(Character.toUpperCase(s.charAt(0)), KotlinPackage.substring(s, 1));
    }

    static {
        PACKAGE_CLASS_NAME_SUFFIX = PACKAGE_CLASS_NAME_SUFFIX;
        DEFAULT_PACKAGE_CLASS_NAME = "_Default" + PACKAGE_CLASS_NAME_SUFFIX;
        DEFAULT_PACKAGE_METAFILE_NAME = DEFAULT_PACKAGE_CLASS_NAME + "." + KotlinJavascriptSerializationUtil.INSTANCE$.getCLASS_METADATA_FILE_EXTENSION();
    }
}

