/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;

public class VisibilityUtil {
    @NotNull
    public static CallableMemberDescriptor findMemberWithMaxVisibility(@NotNull Queue<CallableMemberDescriptor> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/resolve/VisibilityUtil", "findMemberWithMaxVisibility"));
        }
        CallableMemberDescriptor descriptor2 = descriptors.element();
        for (CallableMemberDescriptor candidate : descriptors) {
            Integer result2 = Visibilities.compare(descriptor2.getVisibility(), candidate.getVisibility());
            if (result2 == null || result2 >= 0) continue;
            descriptor2 = candidate;
        }
        CallableMemberDescriptor callableMemberDescriptor = descriptor2;
        if (callableMemberDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/VisibilityUtil", "findMemberWithMaxVisibility"));
        }
        return callableMemberDescriptor;
    }
}

