/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.repl;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.search.ProjectScope;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.SmartList;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorToString;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.ConfigPackage;
import org.jetbrains.kotlin.cli.jvm.repl.DelegatePackageMemberDeclarationProvider;
import org.jetbrains.kotlin.cli.jvm.repl.EarlierLine;
import org.jetbrains.kotlin.cli.jvm.repl.ReplClassLoader;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.impl.CompositePackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.di.InjectorForReplWithJava;
import org.jetbrains.kotlin.idea.JetLanguage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzerForTopLevel;
import org.jetbrains.kotlin.resolve.ScriptPriorities;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.lazy.ScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.CombinedPackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.PackageMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.utils.UtilsPackage;
import org.jetbrains.org.objectweb.asm.Type;

public class ReplInterpreter {
    private int lineNumber;
    @Nullable
    private JetScope lastLineScope;
    private final List<EarlierLine> earlierLines;
    private final List<String> previousIncompleteLines;
    private final ReplClassLoader classLoader;
    private final PsiFileFactoryImpl psiFileFactory;
    private final BindingTraceContext trace;
    private final ModuleDescriptorImpl module;
    private final TopDownAnalysisContext topDownAnalysisContext;
    private final LazyTopDownAnalyzerForTopLevel topDownAnalyzer;
    private final ResolveSession resolveSession;
    private final ScriptMutableDeclarationProviderFactory scriptDeclarationFactory;

    public ReplInterpreter(@NotNull Disposable disposable, @NotNull CompilerConfiguration configuration) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "<init>"));
        }
        this.lineNumber = 0;
        this.earlierLines = Lists.newArrayList();
        this.previousIncompleteLines = Lists.newArrayList();
        KotlinCoreEnvironment environment = KotlinCoreEnvironment.createForProduction(disposable, configuration, EnvironmentConfigFiles.JVM_CONFIG_FILES);
        Project project = environment.getProject();
        this.psiFileFactory = (PsiFileFactoryImpl)PsiFileFactory.getInstance(project);
        this.trace = new CliLightClassGenerationSupport.NoScopeRecordCliBindingTrace();
        MutableModuleContext moduleContext = TopDownAnalyzerFacadeForJVM.createContextWithSealedModule(project);
        this.module = moduleContext.getModule();
        this.scriptDeclarationFactory = new ScriptMutableDeclarationProviderFactory();
        ScopeProvider.AdditionalFileScopeProvider scopeProvider = new ScopeProvider.AdditionalFileScopeProvider(){

            @Override
            @NotNull
            public List<JetScope> scopes(@NotNull JetFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$1", "scopes"));
                }
                SmartList<JetScope> smartList = ReplInterpreter.this.lastLineScope != null ? new SmartList<JetScope>(ReplInterpreter.this.lastLineScope) : Collections.emptyList();
                if (smartList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$1", "scopes"));
                }
                return smartList;
            }
        };
        InjectorForReplWithJava injector = new InjectorForReplWithJava(moduleContext, this.trace, this.scriptDeclarationFactory, ProjectScope.getAllScope(project), scopeProvider);
        this.topDownAnalysisContext = new TopDownAnalysisContext(TopDownAnalysisMode.LocalDeclarations, DataFlowInfo.EMPTY);
        this.topDownAnalyzer = injector.getLazyTopDownAnalyzerForTopLevel();
        this.resolveSession = injector.getResolveSession();
        moduleContext.initializeModuleContents(new CompositePackageFragmentProvider(Arrays.asList(injector.getResolveSession().getPackageFragmentProvider(), injector.getJavaDescriptorResolver().getPackageFragmentProvider())));
        ArrayList<URL> classpath = Lists.newArrayList();
        for (File file : ConfigPackage.getJvmClasspathRoots(configuration)) {
            try {
                classpath.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw UtilsPackage.rethrow(e);
            }
        }
        this.classLoader = new ReplClassLoader(new URLClassLoader(classpath.toArray(new URL[classpath.size()]), null));
    }

    private static void prepareForTheNextReplLine(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "prepareForTheNextReplLine"));
        }
        c.getScripts().clear();
    }

    @NotNull
    public LineResult eval(@NotNull String line) {
        Object scriptInstance;
        Class<?> scriptClass;
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "eval"));
        }
        ++this.lineNumber;
        FqName scriptFqName = new FqName("Line" + this.lineNumber);
        Type scriptClassType = AsmUtil.asmTypeByFqNameWithoutInnerClasses(scriptFqName);
        StringBuilder fullText = new StringBuilder();
        for (String prevLine : this.previousIncompleteLines) {
            fullText.append(prevLine).append("\n");
        }
        fullText.append(line);
        LightVirtualFile virtualFile = new LightVirtualFile("line" + this.lineNumber + ".kts", JetLanguage.INSTANCE, (CharSequence)fullText.toString());
        virtualFile.setCharset(CharsetToolkit.UTF8_CHARSET);
        JetFile psiFile = (JetFile)this.psiFileFactory.trySetupPsiForFile(virtualFile, JetLanguage.INSTANCE, true, false);
        assert (psiFile != null) : "Script file not analyzed at line " + this.lineNumber + ": " + fullText;
        MessageCollectorToString errorCollector = new MessageCollectorToString();
        AnalyzerWithCompilerReport.SyntaxErrorReport syntaxErrorReport = AnalyzerWithCompilerReport.reportSyntaxErrors(psiFile, errorCollector);
        if (syntaxErrorReport.isHasErrors() && syntaxErrorReport.isAllErrorsAtEof()) {
            this.previousIncompleteLines.add(line);
            LineResult lineResult = LineResult.incomplete();
            if (lineResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "eval"));
            }
            return lineResult;
        }
        this.previousIncompleteLines.clear();
        if (syntaxErrorReport.isHasErrors()) {
            LineResult lineResult = LineResult.error(errorCollector.getString());
            if (lineResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "eval"));
            }
            return lineResult;
        }
        ReplInterpreter.prepareForTheNextReplLine(this.topDownAnalysisContext);
        this.trace.clearDiagnostics();
        psiFile.getScript().putUserData(ScriptPriorities.PRIORITY_KEY, this.lineNumber);
        ScriptDescriptor scriptDescriptor = this.doAnalyze(psiFile, errorCollector);
        if (scriptDescriptor == null) {
            LineResult lineResult = LineResult.error(errorCollector.getString());
            if (lineResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "eval"));
            }
            return lineResult;
        }
        ArrayList<Pair<ScriptDescriptor, Type>> earlierScripts = Lists.newArrayList();
        for (EarlierLine earlierLine : this.earlierLines) {
            earlierScripts.add(Pair.create(earlierLine.getScriptDescriptor(), earlierLine.getClassType()));
        }
        GenerationState state = new GenerationState(psiFile.getProject(), ClassBuilderFactories.BINARIES, this.module, this.trace.getBindingContext(), Collections.singletonList(psiFile));
        ReplInterpreter.compileScript(psiFile.getScript(), scriptClassType, earlierScripts, state, CompilationErrorHandler.THROW_EXCEPTION);
        for (OutputFile outputFile : state.getFactory().asList()) {
            this.classLoader.addClass(JvmClassName.byInternalName(outputFile.getRelativePath().replaceFirst("\\.class$", "")), outputFile.asByteArray());
        }
        try {
            scriptClass = this.classLoader.loadClass(scriptFqName.asString());
            Class[] constructorParams = new Class[this.earlierLines.size()];
            Object[] constructorArgs = new Object[this.earlierLines.size()];
            for (int i = 0; i < this.earlierLines.size(); ++i) {
                constructorParams[i] = this.earlierLines.get(i).getScriptClass();
                constructorArgs[i] = this.earlierLines.get(i).getScriptInstance();
            }
            Constructor<?> scriptInstanceConstructor = scriptClass.getConstructor(constructorParams);
            try {
                scriptInstance = scriptInstanceConstructor.newInstance(constructorArgs);
            }
            catch (Throwable e) {
                LineResult lineResult = LineResult.error(ReplInterpreter.renderStackTrace(e.getCause()));
                if (lineResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "eval"));
                }
                return lineResult;
            }
        }
        catch (Throwable e) {
            PrintWriter writer = new PrintWriter(System.err);
            this.classLoader.dumpClasses(writer);
            writer.flush();
            throw UtilsPackage.rethrow(e);
        }
        Field rvField = scriptClass.getDeclaredField("rv");
        rvField.setAccessible(true);
        Object rv = rvField.get(scriptInstance);
        this.earlierLines.add(new EarlierLine(line, scriptDescriptor, scriptClass, scriptInstance, scriptClassType));
        JetType returnType2 = scriptDescriptor.getScriptCodeDescriptor().getReturnType();
        LineResult lineResult = LineResult.successful(rv, returnType2 != null && KotlinBuiltIns.isUnit(returnType2));
        if (lineResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "eval"));
        }
        return lineResult;
    }

    @NotNull
    private static String renderStackTrace(@NotNull Throwable cause) {
        if (cause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "renderStackTrace"));
        }
        StackTraceElement[] oldTrace = cause.getStackTrace();
        ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
        boolean skip2 = true;
        for (int i = oldTrace.length - 1; i >= 0; --i) {
            StackTraceElement element = oldTrace[i];
            if (element.getMethodName().equals("<init>")) {
                skip2 = false;
            }
            if (skip2) continue;
            newTrace.add(element);
        }
        Collections.reverse(newTrace);
        cause.setStackTrace(newTrace.toArray(new StackTraceElement[newTrace.size()]));
        String string = Throwables.getStackTraceAsString(cause);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "renderStackTrace"));
        }
        return string;
    }

    @Nullable
    private ScriptDescriptor doAnalyze(@NotNull JetFile psiFile, @NotNull MessageCollector messageCollector) {
        boolean hasErrors;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "doAnalyze"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "doAnalyze"));
        }
        this.scriptDeclarationFactory.setDelegateFactory(new FileBasedDeclarationProviderFactory(this.resolveSession.getStorageManager(), Collections.singletonList(psiFile)));
        TopDownAnalysisContext context2 = this.topDownAnalyzer.analyzeDeclarations(this.topDownAnalysisContext.getTopDownAnalysisMode(), Collections.singletonList(psiFile));
        if (this.trace.get(BindingContext.FILE_TO_PACKAGE_FRAGMENT, psiFile) == null) {
            this.trace.record(BindingContext.FILE_TO_PACKAGE_FRAGMENT, psiFile, this.resolveSession.getPackageFragment(FqName.ROOT));
        }
        if (hasErrors = AnalyzerWithCompilerReport.reportDiagnostics(this.trace.getBindingContext().getDiagnostics(), messageCollector)) {
            return null;
        }
        ScriptDescriptor scriptDescriptor = context2.getScripts().get(psiFile.getScript());
        this.lastLineScope = this.trace.get(BindingContext.SCRIPT_SCOPE, scriptDescriptor);
        if (this.lastLineScope == null) {
            throw new IllegalStateException("last line scope is not initialized");
        }
        return scriptDescriptor;
    }

    public void dumpClasses(@NotNull PrintWriter out) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "dumpClasses"));
        }
        this.classLoader.dumpClasses(out);
    }

    private static void registerEarlierScripts(@NotNull GenerationState state, @NotNull List<Pair<ScriptDescriptor, Type>> earlierScripts) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "registerEarlierScripts"));
        }
        if (earlierScripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "earlierScripts", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "registerEarlierScripts"));
        }
        ArrayList<ScriptDescriptor> earlierScriptDescriptors = new ArrayList<ScriptDescriptor>(earlierScripts.size());
        for (Pair<ScriptDescriptor, Type> pair : earlierScripts) {
            ScriptDescriptor earlierDescriptor = (ScriptDescriptor)pair.first;
            Type earlierClassType = (Type)pair.second;
            PsiElement jetScript = DescriptorToSourceUtils.descriptorToDeclaration(earlierDescriptor);
            if (jetScript == null) continue;
            CodegenBinding.registerClassNameForScript(state.getBindingTrace(), (JetScript)jetScript, earlierClassType);
            earlierScriptDescriptors.add(earlierDescriptor);
        }
        state.setEarlierScriptsForReplInterpreter(earlierScriptDescriptors);
    }

    public static void compileScript(@NotNull JetScript script, @NotNull Type classType, @NotNull List<Pair<ScriptDescriptor, Type>> earlierScripts, @NotNull GenerationState state, @NotNull CompilationErrorHandler errorHandler) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "compileScript"));
        }
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "compileScript"));
        }
        if (earlierScripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "earlierScripts", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "compileScript"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "compileScript"));
        }
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter", "compileScript"));
        }
        ReplInterpreter.registerEarlierScripts(state, earlierScripts);
        CodegenBinding.registerClassNameForScript(state.getBindingTrace(), script, classType);
        state.beforeCompile();
        KotlinCodegenFacade.generatePackage(state, script.getContainingJetFile().getPackageFqName(), Collections.singleton(script.getContainingJetFile()), errorHandler);
    }

    private static class ScriptMutableDeclarationProviderFactory
    implements DeclarationProviderFactory {
        private DeclarationProviderFactory delegateFactory;
        private AdaptablePackageMemberDeclarationProvider rootPackageProvider;

        private ScriptMutableDeclarationProviderFactory() {
        }

        public void setDelegateFactory(DeclarationProviderFactory delegateFactory) {
            this.delegateFactory = delegateFactory;
            PackageMemberDeclarationProvider provider = delegateFactory.getPackageMemberDeclarationProvider(FqName.ROOT);
            if (this.rootPackageProvider == null) {
                assert (provider != null);
                this.rootPackageProvider = new AdaptablePackageMemberDeclarationProvider(provider);
            } else {
                this.rootPackageProvider.addDelegateProvider(provider);
            }
        }

        @Override
        @NotNull
        public ClassMemberDeclarationProvider getClassMemberDeclarationProvider(@NotNull JetClassLikeInfo classLikeInfo) {
            if (classLikeInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLikeInfo", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$ScriptMutableDeclarationProviderFactory", "getClassMemberDeclarationProvider"));
            }
            ClassMemberDeclarationProvider classMemberDeclarationProvider = this.delegateFactory.getClassMemberDeclarationProvider(classLikeInfo);
            if (classMemberDeclarationProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$ScriptMutableDeclarationProviderFactory", "getClassMemberDeclarationProvider"));
            }
            return classMemberDeclarationProvider;
        }

        @Override
        @Nullable
        public PackageMemberDeclarationProvider getPackageMemberDeclarationProvider(@NotNull FqName packageFqName) {
            if (packageFqName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$ScriptMutableDeclarationProviderFactory", "getPackageMemberDeclarationProvider"));
            }
            if (packageFqName.isRoot()) {
                return this.rootPackageProvider;
            }
            return this.delegateFactory.getPackageMemberDeclarationProvider(packageFqName);
        }

        public static class AdaptablePackageMemberDeclarationProvider
        extends DelegatePackageMemberDeclarationProvider {
            @NotNull
            private PackageMemberDeclarationProvider delegateProvider;

            public AdaptablePackageMemberDeclarationProvider(@NotNull PackageMemberDeclarationProvider delegateProvider) {
                if (delegateProvider == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateProvider", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$ScriptMutableDeclarationProviderFactory$AdaptablePackageMemberDeclarationProvider", "<init>"));
                }
                super(delegateProvider);
                this.delegateProvider = delegateProvider;
            }

            public void addDelegateProvider(PackageMemberDeclarationProvider provider) {
                this.delegateProvider = new CombinedPackageMemberDeclarationProvider(Lists.newArrayList(provider, this.delegateProvider));
                this.setDelegate(this.delegateProvider);
            }
        }
    }

    public static class LineResult {
        private final Object value;
        private final boolean unit;
        private final String errorText;
        private final LineResultType type;

        private LineResult(Object value, boolean unit, String errorText, @NotNull LineResultType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult", "<init>"));
            }
            this.value = value;
            this.unit = unit;
            this.errorText = errorText;
            this.type = type2;
        }

        @NotNull
        public LineResultType getType() {
            LineResultType lineResultType = this.type;
            if (lineResultType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult", "getType"));
            }
            return lineResultType;
        }

        private void checkSuccessful() {
            if (this.getType() != LineResultType.SUCCESS) {
                throw new IllegalStateException("it is error");
            }
        }

        public Object getValue() {
            this.checkSuccessful();
            return this.value;
        }

        public boolean isUnit() {
            this.checkSuccessful();
            return this.unit;
        }

        @NotNull
        public String getErrorText() {
            String string = this.errorText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult", "getErrorText"));
            }
            return string;
        }

        public static LineResult successful(Object value, boolean unit) {
            return new LineResult(value, unit, null, LineResultType.SUCCESS);
        }

        public static LineResult error(@NotNull String errorText) {
            if (errorText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorText", "org/jetbrains/kotlin/cli/jvm/repl/ReplInterpreter$LineResult", "error"));
            }
            if (errorText.isEmpty()) {
                errorText = "<unknown error>";
            } else if (!errorText.endsWith("\n")) {
                errorText = errorText + "\n";
            }
            return new LineResult(null, false, errorText, LineResultType.ERROR);
        }

        public static LineResult incomplete() {
            return new LineResult(null, false, null, LineResultType.INCOMPLETE);
        }
    }

    public static enum LineResultType {
        SUCCESS,
        ERROR,
        INCOMPLETE;

    }
}

