/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.util.NotNullFunction;
import org.jetbrains.annotations.NotNull;

public class ServiceManager {
    public static <T> T getService(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "com/intellij/openapi/components/ServiceManager", "getService"));
        }
        Object instance = ApplicationManager.getApplication().getPicoContainer().getComponentInstance(serviceClass.getName());
        return (T)instance;
    }

    public static <T> T getService(@NotNull Project project, @NotNull Class<T> serviceClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/components/ServiceManager", "getService"));
        }
        if (serviceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "com/intellij/openapi/components/ServiceManager", "getService"));
        }
        Object instance = project.getPicoContainer().getComponentInstance(serviceClass.getName());
        return (T)instance;
    }

    public static <T> NotNullLazyKey<T, Project> createLazyKey(final @NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "com/intellij/openapi/components/ServiceManager", "createLazyKey"));
        }
        return NotNullLazyKey.create("Service: " + serviceClass.getName(), new NotNullFunction<Project, T>(){

            @Override
            @NotNull
            public T fun(Project project) {
                Object t = ServiceManager.getService(project, serviceClass);
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/ServiceManager$1", "fun"));
                }
                return t;
            }
        });
    }
}

