/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.dart.compiler.backend.js.JsConstructExpressionVisitor;
import com.google.dart.compiler.backend.js.JsFirstExpressionVisitor;
import com.google.dart.compiler.backend.js.JsPrecedenceVisitor;
import com.google.dart.compiler.backend.js.JsRequiresSemiVisitor;
import com.google.dart.compiler.backend.js.ast.HasName;
import com.google.dart.compiler.backend.js.ast.JsArrayAccess;
import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsBreak;
import com.google.dart.compiler.backend.js.ast.JsCase;
import com.google.dart.compiler.backend.js.ast.JsCatch;
import com.google.dart.compiler.backend.js.ast.JsConditional;
import com.google.dart.compiler.backend.js.ast.JsContinue;
import com.google.dart.compiler.backend.js.ast.JsDebugger;
import com.google.dart.compiler.backend.js.ast.JsDefault;
import com.google.dart.compiler.backend.js.ast.JsDoWhile;
import com.google.dart.compiler.backend.js.ast.JsDocComment;
import com.google.dart.compiler.backend.js.ast.JsEmpty;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionStatement;
import com.google.dart.compiler.backend.js.ast.JsFor;
import com.google.dart.compiler.backend.js.ast.JsForIn;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLabel;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsNullLiteral;
import com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsOperator;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsPostfixOperation;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.JsProgram;
import com.google.dart.compiler.backend.js.ast.JsProgramFragment;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsRegExp;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsSwitch;
import com.google.dart.compiler.backend.js.ast.JsSwitchMember;
import com.google.dart.compiler.backend.js.ast.JsThrow;
import com.google.dart.compiler.backend.js.ast.JsTry;
import com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsWhile;
import com.google.dart.compiler.util.TextOutput;
import gnu.trove.THashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JsToStringGenerationVisitor
extends JsVisitor {
    private static final char[] CHARS_BREAK = "break".toCharArray();
    private static final char[] CHARS_CASE = "case".toCharArray();
    private static final char[] CHARS_CATCH = "catch".toCharArray();
    private static final char[] CHARS_CONTINUE = "continue".toCharArray();
    private static final char[] CHARS_DEBUGGER = "debugger".toCharArray();
    private static final char[] CHARS_DEFAULT = "default".toCharArray();
    private static final char[] CHARS_DO = "do".toCharArray();
    private static final char[] CHARS_ELSE = "else".toCharArray();
    private static final char[] CHARS_FALSE = "false".toCharArray();
    private static final char[] CHARS_FINALLY = "finally".toCharArray();
    private static final char[] CHARS_FOR = "for".toCharArray();
    private static final char[] CHARS_FUNCTION = "function".toCharArray();
    private static final char[] CHARS_IF = "if".toCharArray();
    private static final char[] CHARS_IN = "in".toCharArray();
    private static final char[] CHARS_NEW = "new".toCharArray();
    private static final char[] CHARS_NULL = "null".toCharArray();
    private static final char[] CHARS_RETURN = "return".toCharArray();
    private static final char[] CHARS_SWITCH = "switch".toCharArray();
    private static final char[] CHARS_THIS = "this".toCharArray();
    private static final char[] CHARS_THROW = "throw".toCharArray();
    private static final char[] CHARS_TRUE = "true".toCharArray();
    private static final char[] CHARS_TRY = "try".toCharArray();
    private static final char[] CHARS_VAR = "var".toCharArray();
    private static final char[] CHARS_WHILE = "while".toCharArray();
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected boolean needSemi = true;
    private boolean lineBreakAfterBlock = true;
    private Set<JsBlock> globalBlocks = new THashSet<JsBlock>();
    protected final TextOutput p;

    public static CharSequence javaScriptString(String value) {
        return JsToStringGenerationVisitor.javaScriptString(value, false);
    }

    public static CharSequence javaScriptString(CharSequence chars, boolean forceDoubleQuote) {
        int n = chars.length();
        int quoteCount = 0;
        int aposCount = 0;
        block14: for (int i = 0; i < n; ++i) {
            switch (chars.charAt(i)) {
                case '\"': {
                    ++quoteCount;
                    continue block14;
                }
                case '\'': {
                    ++aposCount;
                }
            }
        }
        StringBuilder result2 = new StringBuilder(n + 16);
        char quoteChar = quoteCount < aposCount || forceDoubleQuote ? (char)'\"' : '\'';
        result2.append(quoteChar);
        for (int i = 0; i < n; ++i) {
            int hexSize;
            char c = chars.charAt(i);
            if (' ' <= c && c <= '~' && c != quoteChar && c != '\\') {
                result2.append(c);
                continue;
            }
            int escape = -1;
            switch (c) {
                case '\b': {
                    escape = 98;
                    break;
                }
                case '\f': {
                    escape = 102;
                    break;
                }
                case '\n': {
                    escape = 110;
                    break;
                }
                case '\r': {
                    escape = 114;
                    break;
                }
                case '\t': {
                    escape = 116;
                    break;
                }
                case '\"': {
                    escape = 34;
                    break;
                }
                case '\'': {
                    escape = 39;
                    break;
                }
                case '\\': {
                    escape = 92;
                }
            }
            if (escape >= 0) {
                result2.append('\\');
                result2.append((char)escape);
                continue;
            }
            if (c < ' ' && (i == n - 1 || chars.charAt(i + 1) < '0' || chars.charAt(i + 1) > '9')) {
                result2.append('\\');
                if (c > '\u0007') {
                    result2.append((char)(48 + (7 & c >> 3)));
                }
                result2.append((char)(48 + (7 & c)));
                continue;
            }
            if (c < '\u0100') {
                result2.append("\\x");
                hexSize = 2;
            } else {
                result2.append("\\u");
                hexSize = 4;
            }
            for (int shift = (hexSize - 1) * 4; shift >= 0; shift -= 4) {
                int digit = 0xF & c >> shift;
                result2.append(HEX_DIGITS[digit]);
            }
        }
        result2.append(quoteChar);
        JsToStringGenerationVisitor.escapeClosingTags(result2);
        return result2;
    }

    private static void escapeClosingTags(StringBuilder str) {
        if (str == null) {
            return;
        }
        int index2 = 0;
        while ((index2 = str.indexOf("</", index2)) != -1) {
            str.insert(index2 + 1, '\\');
        }
    }

    public JsToStringGenerationVisitor(TextOutput out) {
        this.p = out;
    }

    @Override
    public void visitArrayAccess(@NotNull JsArrayAccess x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitArrayAccess"));
        }
        this.printPair(x, x.getArrayExpression());
        this.leftSquare();
        this.accept(x.getIndexExpression());
        this.rightSquare();
    }

    @Override
    public void visitArray(@NotNull JsArrayLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitArray"));
        }
        this.leftSquare();
        this.printExpressions(x.getExpressions());
        this.rightSquare();
    }

    private void printExpressions(List<JsExpression> expressions) {
        boolean notFirst = false;
        for (JsExpression expression : expressions) {
            notFirst = this.sepCommaOptSpace(notFirst) && !(expression instanceof JsDocComment);
            boolean isEnclosed = this.parenPushIfCommaExpression(expression);
            this.accept(expression);
            if (!isEnclosed) continue;
            this.rightParen();
        }
    }

    @Override
    public void visitBinaryExpression(@NotNull JsBinaryOperation binaryOperation) {
        boolean isParenOpened;
        if (binaryOperation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryOperation", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitBinaryExpression"));
        }
        JsBinaryOperator operator = binaryOperation.getOperator();
        JsExpression arg1 = binaryOperation.getArg1();
        boolean isExpressionEnclosed = this.parenPush(binaryOperation, arg1, !operator.isLeftAssociative());
        this.accept(arg1);
        if (operator.isKeyword()) {
            this._parenPopOrSpace(binaryOperation, arg1, !operator.isLeftAssociative());
        } else if (operator != JsBinaryOperator.COMMA) {
            if (isExpressionEnclosed) {
                this.rightParen();
            }
            this.spaceOpt();
        }
        this.p.print(operator.getSymbol());
        JsExpression arg2 = binaryOperation.getArg2();
        if (operator == JsBinaryOperator.COMMA) {
            isParenOpened = false;
            this.spaceOpt();
        } else if (arg2 instanceof JsBinaryOperation && ((JsBinaryOperation)arg2).getOperator() == JsBinaryOperator.AND) {
            this.spaceOpt();
            this.leftParen();
            isParenOpened = true;
        } else if (JsToStringGenerationVisitor.spaceCalc(operator, arg2)) {
            isParenOpened = this._parenPushOrSpace(binaryOperation, arg2, operator.isLeftAssociative());
        } else {
            this.spaceOpt();
            isParenOpened = this.parenPush(binaryOperation, arg2, operator.isLeftAssociative());
        }
        this.accept(arg2);
        if (isParenOpened) {
            this.rightParen();
        }
    }

    @Override
    public void visitBlock(@NotNull JsBlock x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitBlock"));
        }
        this.printJsBlock(x, true);
    }

    @Override
    public void visitBoolean(@NotNull JsLiteral.JsBooleanLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitBoolean"));
        }
        if (x.getValue()) {
            this.p.print(CHARS_TRUE);
        } else {
            this.p.print(CHARS_FALSE);
        }
    }

    @Override
    public void visitBreak(@NotNull JsBreak x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitBreak"));
        }
        this.p.print(CHARS_BREAK);
        this.continueOrBreakLabel(x);
    }

    @Override
    public void visitContinue(@NotNull JsContinue x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitContinue"));
        }
        this.p.print(CHARS_CONTINUE);
        this.continueOrBreakLabel(x);
    }

    private void continueOrBreakLabel(JsContinue x) {
        JsNameRef label = x.getLabel();
        if (label != null && label.getIdent() != null) {
            this.space();
            this.p.print(label.getIdent());
        }
    }

    @Override
    public void visitCase(@NotNull JsCase x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitCase"));
        }
        this.p.print(CHARS_CASE);
        this.space();
        this.accept(x.getCaseExpression());
        this._colon();
        this.newlineOpt();
        this.printSwitchMemberStatements(x);
    }

    private void printSwitchMemberStatements(JsSwitchMember x) {
        this.p.indentIn();
        for (JsStatement stmt : x.getStatements()) {
            this.needSemi = true;
            this.accept(stmt);
            if (this.needSemi) {
                this.semi();
            }
            this.newlineOpt();
        }
        this.p.indentOut();
        this.needSemi = false;
    }

    @Override
    public void visitCatch(@NotNull JsCatch x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitCatch"));
        }
        this.spaceOpt();
        this.p.print(CHARS_CATCH);
        this.spaceOpt();
        this.leftParen();
        this.nameDef(x.getParameter().getName());
        JsExpression catchCond = x.getCondition();
        if (catchCond != null) {
            this.space();
            this._if();
            this.space();
            this.accept(catchCond);
        }
        this.rightParen();
        this.spaceOpt();
        this.accept(x.getBody());
    }

    @Override
    public void visitConditional(@NotNull JsConditional x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitConditional"));
        }
        this.printPair(x, x.getTestExpression(), true);
        this.spaceOpt();
        this.p.print('?');
        this.spaceOpt();
        this.printPair(x, x.getThenExpression());
        this.spaceOpt();
        this._colon();
        this.spaceOpt();
        this.printPair(x, x.getElseExpression());
    }

    private void printPair(JsExpression parent, JsExpression expression, boolean wrongAssoc) {
        boolean isNeedParen = JsToStringGenerationVisitor.parenCalc(parent, expression, wrongAssoc);
        if (isNeedParen) {
            this.leftParen();
        }
        this.accept(expression);
        if (isNeedParen) {
            this.rightParen();
        }
    }

    private void printPair(JsExpression parent, JsExpression expression) {
        this.printPair(parent, expression, false);
    }

    @Override
    public void visitDebugger(@NotNull JsDebugger x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitDebugger"));
        }
        this.p.print(CHARS_DEBUGGER);
    }

    @Override
    public void visitDefault(@NotNull JsDefault x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitDefault"));
        }
        this.p.print(CHARS_DEFAULT);
        this._colon();
        this.printSwitchMemberStatements(x);
    }

    @Override
    public void visitWhile(@NotNull JsWhile x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitWhile"));
        }
        this._while();
        this.spaceOpt();
        this.leftParen();
        this.accept(x.getCondition());
        this.rightParen();
        this.nestedPush(x.getBody());
        this.accept(x.getBody());
        this.nestedPop(x.getBody());
    }

    @Override
    public void visitDoWhile(@NotNull JsDoWhile x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitDoWhile"));
        }
        this.p.print(CHARS_DO);
        this.nestedPush(x.getBody());
        this.accept(x.getBody());
        this.nestedPop(x.getBody());
        if (this.needSemi) {
            this.semi();
            this.newlineOpt();
        } else {
            this.spaceOpt();
            this.needSemi = true;
        }
        this._while();
        this.spaceOpt();
        this.leftParen();
        this.accept(x.getCondition());
        this.rightParen();
    }

    @Override
    public void visitEmpty(@NotNull JsEmpty x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitEmpty"));
        }
    }

    @Override
    public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitExpressionStatement"));
        }
        boolean surroundWithParentheses = JsFirstExpressionVisitor.exec(x);
        if (surroundWithParentheses) {
            this.leftParen();
        }
        this.accept(x.getExpression());
        if (surroundWithParentheses) {
            this.rightParen();
        }
    }

    @Override
    public void visitFor(@NotNull JsFor x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitFor"));
        }
        this._for();
        this.spaceOpt();
        this.leftParen();
        if (x.getInitExpression() != null) {
            this.accept(x.getInitExpression());
        } else if (x.getInitVars() != null) {
            this.accept(x.getInitVars());
        }
        this.semi();
        if (x.getCondition() != null) {
            this.spaceOpt();
            this.accept(x.getCondition());
        }
        this.semi();
        if (x.getIncrementExpression() != null) {
            this.spaceOpt();
            this.accept(x.getIncrementExpression());
        }
        this.rightParen();
        this.nestedPush(x.getBody());
        this.accept(x.getBody());
        this.nestedPop(x.getBody());
    }

    @Override
    public void visitForIn(@NotNull JsForIn x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitForIn"));
        }
        this._for();
        this.spaceOpt();
        this.leftParen();
        if (x.getIterVarName() != null) {
            this.var();
            this.space();
            this.nameDef(x.getIterVarName());
            if (x.getIterExpression() != null) {
                this.spaceOpt();
                this.assignment();
                this.spaceOpt();
                this.accept(x.getIterExpression());
            }
        } else {
            this.accept(x.getIterExpression());
        }
        this.space();
        this.p.print(CHARS_IN);
        this.space();
        this.accept(x.getObjectExpression());
        this.rightParen();
        this.nestedPush(x.getBody());
        this.accept(x.getBody());
        this.nestedPop(x.getBody());
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitFunction"));
        }
        this.p.print(CHARS_FUNCTION);
        this.space();
        if (x.getName() != null) {
            this.nameOf(x);
        }
        this.leftParen();
        boolean notFirst = false;
        Iterator<JsParameter> i$ = x.getParameters().iterator();
        while (i$.hasNext()) {
            JsParameter element;
            JsParameter param = element = i$.next();
            notFirst = this.sepCommaOptSpace(notFirst);
            this.accept(param);
        }
        this.rightParen();
        this.space();
        this.lineBreakAfterBlock = false;
        this.accept(x.getBody());
        this.needSemi = true;
    }

    @Override
    public void visitIf(@NotNull JsIf x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitIf"));
        }
        this._if();
        this.spaceOpt();
        this.leftParen();
        this.accept(x.getIfExpression());
        this.rightParen();
        JsStatement thenStmt = x.getThenStatement();
        JsStatement elseStatement = x.getElseStatement();
        if (elseStatement != null && thenStmt instanceof JsIf && ((JsIf)thenStmt).getElseStatement() == null) {
            thenStmt = new JsBlock(thenStmt);
        }
        this.nestedPush(thenStmt);
        this.accept(thenStmt);
        this.nestedPop(thenStmt);
        if (elseStatement != null) {
            if (this.needSemi) {
                this.semi();
                this.newlineOpt();
            } else {
                this.spaceOpt();
                this.needSemi = true;
            }
            this.p.print(CHARS_ELSE);
            boolean elseIf = elseStatement instanceof JsIf;
            if (!elseIf) {
                this.nestedPush(elseStatement);
            } else {
                this.space();
            }
            this.accept(elseStatement);
            if (!elseIf) {
                this.nestedPop(elseStatement);
            }
        }
    }

    @Override
    public void visitInvocation(@NotNull JsInvocation invocation) {
        if (invocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invocation", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitInvocation"));
        }
        this.printPair(invocation, invocation.getQualifier());
        this.leftParen();
        this.printExpressions(invocation.getArguments());
        this.rightParen();
    }

    @Override
    public void visitLabel(@NotNull JsLabel x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitLabel"));
        }
        this.nameOf(x);
        this._colon();
        this.spaceOpt();
        this.accept(x.getStatement());
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        if (nameRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameRef", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitNameRef"));
        }
        JsExpression qualifier = nameRef.getQualifier();
        if (qualifier != null) {
            boolean enclose = qualifier instanceof JsLiteral.JsValueLiteral ? qualifier instanceof JsNumberLiteral : JsToStringGenerationVisitor.parenCalc(nameRef, qualifier, false);
            if (enclose) {
                this.leftParen();
            }
            this.accept(qualifier);
            if (enclose) {
                this.rightParen();
            }
            this.p.print('.');
        }
        this.p.maybeIndent();
        this.beforeNodePrinted(nameRef);
        this.p.print(nameRef.getIdent());
    }

    protected void beforeNodePrinted(JsNode node) {
    }

    @Override
    public void visitNew(@NotNull JsNew x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitNew"));
        }
        this.p.print(CHARS_NEW);
        this.space();
        JsExpression constructorExpression = x.getConstructorExpression();
        boolean needsParens = JsConstructExpressionVisitor.exec(constructorExpression);
        if (needsParens) {
            this.leftParen();
        }
        this.accept(constructorExpression);
        if (needsParens) {
            this.rightParen();
        }
        this.leftParen();
        this.printExpressions(x.getArguments());
        this.rightParen();
    }

    @Override
    public void visitNull(@NotNull JsNullLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitNull"));
        }
        this.p.print(CHARS_NULL);
    }

    @Override
    public void visitInt(@NotNull JsNumberLiteral.JsIntLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitInt"));
        }
        this.p.print(x.value);
    }

    @Override
    public void visitDouble(@NotNull JsNumberLiteral.JsDoubleLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitDouble"));
        }
        this.p.print(x.value);
    }

    @Override
    public void visitObjectLiteral(@NotNull JsObjectLiteral objectLiteral) {
        if (objectLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectLiteral", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitObjectLiteral"));
        }
        this.p.print('{');
        if (objectLiteral.isMultiline()) {
            this.p.indentIn();
        }
        boolean notFirst = false;
        for (JsPropertyInitializer item : objectLiteral.getPropertyInitializers()) {
            if (notFirst) {
                this.p.print(',');
            }
            if (objectLiteral.isMultiline()) {
                this.newlineOpt();
            } else if (notFirst) {
                this.spaceOpt();
            }
            notFirst = true;
            JsExpression labelExpr = item.getLabelExpr();
            if (labelExpr instanceof JsNameRef) {
                this.p.print(((JsNameRef)labelExpr).getIdent());
            } else if (labelExpr instanceof JsStringLiteral) {
                this.p.print(((JsStringLiteral)labelExpr).getValue());
            } else {
                this.accept(labelExpr);
            }
            this._colon();
            this.space();
            JsExpression valueExpr = item.getValueExpr();
            boolean wasEnclosed = this.parenPushIfCommaExpression(valueExpr);
            this.accept(valueExpr);
            if (!wasEnclosed) continue;
            this.rightParen();
        }
        if (objectLiteral.isMultiline()) {
            this.p.indentOut();
            this.newlineOpt();
        }
        this.p.print('}');
    }

    @Override
    public void visitParameter(@NotNull JsParameter x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitParameter"));
        }
        this.nameOf(x);
    }

    @Override
    public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitPostfixOperation"));
        }
        JsUnaryOperator op = x.getOperator();
        JsExpression arg = x.getArg();
        this.printPair(x, arg);
        this.p.print(op.getSymbol());
    }

    @Override
    public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitPrefixOperation"));
        }
        JsUnaryOperator op = x.getOperator();
        this.p.print(op.getSymbol());
        JsExpression arg = x.getArg();
        if (JsToStringGenerationVisitor.spaceCalc(op, arg)) {
            this.space();
        }
        this.printPair(x, arg);
    }

    @Override
    public void visitProgram(@NotNull JsProgram x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitProgram"));
        }
        this.p.print("<JsProgram>");
    }

    @Override
    public void visitProgramFragment(@NotNull JsProgramFragment x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitProgramFragment"));
        }
        this.p.print("<JsProgramFragment>");
    }

    @Override
    public void visitRegExp(@NotNull JsRegExp x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitRegExp"));
        }
        this.slash();
        this.p.print(x.getPattern());
        this.slash();
        String flags = x.getFlags();
        if (flags != null) {
            this.p.print(flags);
        }
    }

    @Override
    public void visitReturn(@NotNull JsReturn x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitReturn"));
        }
        this.p.print(CHARS_RETURN);
        JsExpression expr = x.getExpression();
        if (expr != null) {
            this.space();
            this.accept(expr);
        }
    }

    @Override
    public void visitString(@NotNull JsStringLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitString"));
        }
        this.p.print(JsToStringGenerationVisitor.javaScriptString(x.getValue()));
    }

    @Override
    public void visit(@NotNull JsSwitch x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visit"));
        }
        this.p.print(CHARS_SWITCH);
        this.spaceOpt();
        this.leftParen();
        this.accept(x.getExpression());
        this.rightParen();
        this.spaceOpt();
        this.blockOpen();
        this.acceptList(x.getCases());
        this.blockClose();
    }

    @Override
    public void visitThis(@NotNull JsLiteral.JsThisRef x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitThis"));
        }
        this.p.print(CHARS_THIS);
    }

    @Override
    public void visitThrow(@NotNull JsThrow x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitThrow"));
        }
        this.p.print(CHARS_THROW);
        this.space();
        this.accept(x.getExpression());
    }

    @Override
    public void visitTry(@NotNull JsTry x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitTry"));
        }
        this.p.print(CHARS_TRY);
        this.spaceOpt();
        this.accept(x.getTryBlock());
        this.acceptList(x.getCatches());
        JsBlock finallyBlock = x.getFinallyBlock();
        if (finallyBlock != null) {
            this.p.print(CHARS_FINALLY);
            this.spaceOpt();
            this.accept(finallyBlock);
        }
    }

    @Override
    public void visit(@NotNull JsVars.JsVar var) {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visit"));
        }
        this.nameOf(var);
        JsExpression initExpr = var.getInitExpression();
        if (initExpr != null) {
            this.spaceOpt();
            this.assignment();
            this.spaceOpt();
            boolean isEnclosed = this.parenPushIfCommaExpression(initExpr);
            this.accept(initExpr);
            if (isEnclosed) {
                this.rightParen();
            }
        }
    }

    @Override
    public void visitVars(@NotNull JsVars vars) {
        if (vars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vars", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitVars"));
        }
        this.var();
        this.space();
        boolean sep = false;
        for (JsVars.JsVar var : vars) {
            if (sep) {
                if (vars.isMultiline()) {
                    this.newlineOpt();
                }
                this.p.print(',');
                this.spaceOpt();
            } else {
                sep = true;
            }
            this.accept(var);
        }
    }

    @Override
    public void visitDocComment(@NotNull JsDocComment comment) {
        boolean asSingleLine;
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/google/dart/compiler/backend/js/JsToStringGenerationVisitor", "visitDocComment"));
        }
        boolean bl = asSingleLine = comment.getTags().size() == 1;
        if (!asSingleLine) {
            this.newlineOpt();
        }
        this.p.print("/**");
        if (asSingleLine) {
            this.space();
        } else {
            this.p.newline();
        }
        boolean notFirst = false;
        for (Map.Entry<String, Object> entry : comment.getTags().entrySet()) {
            if (notFirst) {
                this.p.newline();
                this.p.print(' ');
                this.p.print('*');
            } else {
                notFirst = true;
            }
            this.p.print('@');
            this.p.print(entry.getKey());
            Object value = entry.getValue();
            if (value != null) {
                this.space();
                if (value instanceof CharSequence) {
                    this.p.print((CharSequence)value);
                } else {
                    this.visitNameRef((JsNameRef)value);
                }
            }
            if (asSingleLine) continue;
            this.p.newline();
        }
        if (asSingleLine) {
            this.space();
        } else {
            this.newlineOpt();
        }
        this.p.print('*');
        this.p.print('/');
        if (asSingleLine) {
            this.spaceOpt();
        }
    }

    protected final void newlineOpt() {
        if (!this.p.isCompact()) {
            this.p.newline();
        }
    }

    protected void printJsBlock(JsBlock x, boolean finalNewline) {
        boolean needBraces;
        if (!this.lineBreakAfterBlock) {
            finalNewline = false;
            this.lineBreakAfterBlock = true;
        }
        boolean bl = needBraces = !x.isGlobalBlock();
        if (needBraces) {
            this.blockOpen();
        }
        Iterator<JsStatement> iterator2 = x.getStatements().iterator();
        while (iterator2.hasNext()) {
            boolean lastStatement;
            boolean isGlobal = x.isGlobalBlock() || this.globalBlocks.contains(x);
            JsStatement statement = iterator2.next();
            if (statement instanceof JsEmpty) continue;
            this.needSemi = true;
            boolean stmtIsGlobalBlock = false;
            if (isGlobal && statement instanceof JsBlock) {
                stmtIsGlobalBlock = true;
                this.globalBlocks.add((JsBlock)statement);
            }
            this.accept(statement);
            if (stmtIsGlobalBlock) {
                this.globalBlocks.remove(statement);
            }
            if (!this.needSemi) continue;
            boolean functionStmt = statement instanceof JsExpressionStatement && ((JsExpressionStatement)statement).getExpression() instanceof JsFunction;
            boolean bl2 = lastStatement = !iterator2.hasNext() && needBraces && !JsRequiresSemiVisitor.exec(statement);
            if (functionStmt) {
                if (lastStatement) {
                    this.newlineOpt();
                    continue;
                }
                this.p.newline();
                continue;
            }
            if (lastStatement) {
                this.p.printOpt(';');
            } else {
                this.semi();
            }
            this.newlineOpt();
        }
        if (needBraces) {
            this.p.indentOut();
            this.p.print('}');
            if (finalNewline) {
                this.newlineOpt();
            }
        }
        this.needSemi = false;
    }

    private void assignment() {
        this.p.print('=');
    }

    private void blockClose() {
        this.p.indentOut();
        this.p.print('}');
        this.newlineOpt();
    }

    private void blockOpen() {
        this.p.print('{');
        this.p.indentIn();
        this.newlineOpt();
    }

    private void _colon() {
        this.p.print(':');
    }

    private void _for() {
        this.p.print(CHARS_FOR);
    }

    private void _if() {
        this.p.print(CHARS_IF);
    }

    private void leftParen() {
        this.p.print('(');
    }

    private void leftSquare() {
        this.p.print('[');
    }

    private void nameDef(JsName name) {
        this.p.print(name.getIdent());
    }

    private void nameOf(HasName hasName) {
        this.nameDef(hasName.getName());
    }

    private boolean nestedPop(JsStatement statement) {
        boolean pop;
        boolean bl = pop = !(statement instanceof JsBlock);
        if (pop) {
            this.p.indentOut();
        }
        return pop;
    }

    private boolean nestedPush(JsStatement statement) {
        boolean push;
        boolean bl = push = !(statement instanceof JsBlock);
        if (push) {
            this.newlineOpt();
            this.p.indentIn();
        } else {
            this.spaceOpt();
        }
        return push;
    }

    private static boolean parenCalc(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        int childPrec;
        int parentPrec = JsPrecedenceVisitor.exec(parent);
        return parentPrec > (childPrec = JsPrecedenceVisitor.exec(child)) || parentPrec == childPrec && wrongAssoc;
    }

    private boolean _parenPopOrSpace(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        boolean doPop = JsToStringGenerationVisitor.parenCalc(parent, child, wrongAssoc);
        if (doPop) {
            this.rightParen();
        } else {
            this.space();
        }
        return doPop;
    }

    private boolean parenPush(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        boolean doPush = JsToStringGenerationVisitor.parenCalc(parent, child, wrongAssoc);
        if (doPush) {
            this.leftParen();
        }
        return doPush;
    }

    private boolean parenPushIfCommaExpression(JsExpression x) {
        boolean doPush;
        boolean bl = doPush = x instanceof JsBinaryOperation && ((JsBinaryOperation)x).getOperator() == JsBinaryOperator.COMMA;
        if (doPush) {
            this.leftParen();
        }
        return doPush;
    }

    private boolean _parenPushOrSpace(JsExpression parent, JsExpression child, boolean wrongAssoc) {
        boolean doPush = JsToStringGenerationVisitor.parenCalc(parent, child, wrongAssoc);
        if (doPush) {
            this.leftParen();
        } else {
            this.space();
        }
        return doPush;
    }

    private void rightParen() {
        this.p.print(')');
    }

    private void rightSquare() {
        this.p.print(']');
    }

    private void semi() {
        this.p.print(';');
    }

    private boolean sepCommaOptSpace(boolean sep) {
        if (sep) {
            this.p.print(',');
            this.spaceOpt();
        }
        return true;
    }

    private void slash() {
        this.p.print('/');
    }

    private void space() {
        this.p.print(' ');
    }

    private static boolean spaceCalc(JsOperator op, JsExpression arg) {
        if (op.isKeyword()) {
            return true;
        }
        if (arg instanceof JsBinaryOperation) {
            JsBinaryOperation binary = (JsBinaryOperation)arg;
            return binary.getOperator().getPrecedence() > op.getPrecedence() && JsToStringGenerationVisitor.spaceCalc(op, binary.getArg1());
        }
        if (arg instanceof JsPrefixOperation) {
            JsUnaryOperator op2 = ((JsPrefixOperation)arg).getOperator();
            return (op == JsBinaryOperator.SUB || op == JsUnaryOperator.NEG) && (op2 == JsUnaryOperator.DEC || op2 == JsUnaryOperator.NEG) || op == JsBinaryOperator.ADD && op2 == JsUnaryOperator.INC;
        }
        if (arg instanceof JsNumberLiteral && (op == JsBinaryOperator.SUB || op == JsUnaryOperator.NEG)) {
            if (arg instanceof JsNumberLiteral.JsIntLiteral) {
                return ((JsNumberLiteral.JsIntLiteral)arg).value < 0;
            }
            assert (arg instanceof JsNumberLiteral.JsDoubleLiteral);
            return ((JsNumberLiteral.JsDoubleLiteral)arg).value < 0.0;
        }
        return false;
    }

    private void spaceOpt() {
        this.p.printOpt(' ');
    }

    private void var() {
        this.p.print(CHARS_VAR);
    }

    private void _while() {
        this.p.print(CHARS_WHILE);
    }
}

