/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.validation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetCallableReferenceExpression;
import org.jetbrains.kotlin.psi.JetDelegatorToSuperCall;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetStubbedPsiUtil;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.annotations.AnnotationsPackage$AnnotationUtil$31ab6ffa;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0015\f)IB)\u001a9sK\u000e\fG/\u001a3Ts6\u0014w\u000e\u001c,bY&$\u0017\r^8s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u0002:fg>dg/\u001a\u0006\u000bm\u0006d\u0017\u000eZ1uS>t'\u0002F*z[\n|G.V:bO\u00164\u0016\r\\5eCR|'O\u0003\u0004=S:LGO\u0010\u0006\u0010\u0015\u00063\u0016i\u0018#F!J+5)\u0011+F\t*1a)\u001d(b[\u0016TAA\\1nK*9\u0002KU(Q\u000bJ#\u0016lX*F)~{\u0005+\u0012*B)&{ej\u0015\u0006\t)>\\WM\\*fi*\u00191m\\7\u000b\u0011%tG/\u001a7mS*T1\u0001]:j\u0015\u0011!(/Z3\u000b\u000f9{GOT;mY*Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015]Yw\u000e\u001e7j]:Rg/\u001c\u0018QY\u0006$hm\u001c:n)f\u0004XMC\u000ede\u0016\fG/\u001a#faJ,7-\u0019;j_:$\u0015.Y4o_N$\u0018n\u0019\u0006\bK2,W.\u001a8u\u0015)\u00016/[#mK6,g\u000e\u001e\u0006\u000bI\u0016\u001c8M]5qi>\u0014(\"\u0006#fG2\f'/\u0019;j_:$Um]2sSB$xN\u001d\u0006\fI\u0016\u001c8M]5qi>\u00148O\u0003\u0006eKB\u0014XmY1uK\u0012TA#\u00118o_R\fG/[8o\t\u0016\u001c8M]5qi>\u0014(B\u0003#jC\u001etwn\u001d;jG*YA-[1h]>\u001cH/[2t\u0015a\u0001(o\u001c9feRLx)\u001a;uKJ<vN]6be>,h\u000e\u001a\u0006\u0013aJ|\u0007/\u001a:us\u0012+7o\u0019:jaR|'O\u0003\nQe>\u0004XM\u001d;z\t\u0016\u001c8M]5qi>\u0014(\"\u0002;sC\u000e,'\u0002\u0004\"j]\u0012Lgn\u001a+sC\u000e,'BC3yaJ,7o]5p]*!QK\\5u\u001511\u0018\r\\5eCR,7)\u00197m\u0015A!\u0018M]4fi\u0012+7o\u0019:jaR|'O\u0003\nDC2d\u0017M\u00197f\t\u0016\u001c8M]5qi>\u0014(\"\u0005<bY&$\u0017\r^3UsB,Wk]1hK*!2\t\\1tg&4\u0017.\u001a:EKN\u001c'/\u001b9u_JTqdZ3u\t\u0016\u001cG.\u0019:fI\u0012+\u0007O]3dCR,G-\u00118o_R\fG/[8o\u0015]9W\r\u001e#faJ,7-\u0019;fI\u0006sgn\u001c;bi&|gN\u0003\u0003QC&\u0014hR\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\r!!\u0001C\u0002\r\u0001\u0015\u0011A!\u0001\u0005\u0006\u000b\r!9\u0001#\u0003\r\u0001\u0015\u0011Aq\u0001E\u0005\u000b\u0005Ai!\u0002\u0002\u0005\u000b!9QA\u0001C\u0006\u0011\u001f)!\u0001\u0002\u0004\t\u0011\u0015\u0019AQ\u0002\u0005\u0007\u0019\u0001)!\u0001\"\u0001\t\u0013\u0015\u0019Aq\u0002E\t\u0019\u0001)!\u0001\"\u0004\t\r\u0015\u0019AA\u0002\u0005\f\u0019\u0001)!\u0001B\u0001\t\u001a\u0015\u0019A1\u0003\u0005\r\u0019\u0001)!\u0001b\u0005\t\u0013\u0015\u0019AQ\u0003E\u000e\u0019\u0001)!\u0001B\u0001\t\u001e\u0015\u0019Aq\u0003\u0005\u000f\u0019\u0001)!\u0001b\u0006\t\u001d\u0015\u0011AA\u0002\u0005\f\u000b\t!\u0019\u0002\u0003\u0007\u0006\u0005\u0011U\u00012D\u0003\u0004\t'A\u0001\u0003\u0004\u0001\u0006\u0007\u0011\r\u0001\"\u0005\u0007\u0001\u000b\u0005A\u0019!B\u0002\u0005 !\u0011B\u0002A\u0003\u0003\t'A\u0001#\u0002\u0002\u0005\u0004!\tRa\u0001C\n\u0011Oa\u0001!\u0002\u0002\u0005\u0014!\u001dRa\u0001C\n\u0011Sa\u0001!\u0002\u0002\u0005\u0014!%Ra\u0001C\u0010\u0011Ya\u0001!\u0002\u0002\u0005 !1Ba\u0001G\u00033\t)\u0011\u0001C\u0002.\u0017\u0011\tG\u0001\u0007\u0003\"\u0005\u0015\t\u0001\u0002B+\u0004\t\u0015\u0019A\u0001B\u0005\u0002\u0011\u0013iS\u0003B1\u00051\u0017\tC\"B\u0001\t\u000fAMQ3B\u0003\u0002\u0011\u001da\t!U\u0002\u0002\t!\t6!\u0001\u0003\t+\u000e!Qa\u0001C\u0006\u0013\u0005A\t\"\f\u0014\u0005\u0003aQQT\u0002\u0003\u0001\u0011+i!!B\u0001\t\u0013A\u001b\u0001!(\u0004\u0005\u0001!]QBA\u0003\u0002\u0011)\u00016\u0011AO\u0007\t\u0001AQ\"\u0004\u0002\u0006\u0003!Y\u0001kA\u0001\"\u0005\u0015\t\u0001\u0002D)\u0004\u0013\u0011Q\u0011\"\u0001E\r\u001b\u0005AQ\"D\u0001\t\u001c5\t\u0001BD\u0017'\t\u0001Ar\"(\u0004\u0005\u0001!}QBA\u0003\u0002\u0011;\u00016\u0001AO\u0007\t\u0001A\t#\u0004\u0002\u0006\u0003!y\u0001k!\u0001\u001e\u000e\u0011\u0001\u00012E\u0007\u0003\u000b\u0005A\u0011\u0002U\u0002\u0002C\t)\u0011\u0001\u0003\tR\u0007%!q\"C\u0001\u0005\u00015\t\u0001\u0012E\u0007\u0002\u0011Ei\u0011\u0001C\u0007.M\u0011Y\u0001TEO\u0007\t\u0001A1#\u0004\u0002\u0006\u0003!\r\u0002k\u0001\u0001\u001e\u000e\u0011\u0001\u0001\u0012E\u0007\u0003\u000b\u0005Aq\u0002UB\u0001;\u001b!\u0001\u0001#\u0006\u000e\u0005\u0015\t\u0001\"\u0003)\u0004\u0003\u0005\u0012Q!\u0001\u0005\u0011#\u000eIAQE\u0005\u0002\t\u0001i\u0011\u0001\u0003\n\u000e\u0003!\tR\"\u0001\u0005\u000e[\u0019\"1\u0002\u0007\u000b\u001e\u000e\u0011\u0001\u0001bE\u0007\u0003\u000b\u0005A)\u0003U\u0002\u0001;\u001b!\u0001\u0001#\t\u000e\u0005\u0015\t\u0001b\u0004)\u0004\u0002u5A\u0001\u0001E\u000b\u001b\t)\u0011\u0001C\u0005Q\u0007\u0005\t#!B\u0001\t!E\u001b\u0011\u0002\u0002\u000b\n\u0003\u0011\u0001Q\"\u0001\u0005\u0014\u001b\u0005A\u0011#D\u0001\t\u001b5~A!A\u000b\u0003\u000b\u0005A!\u0002G\u000b\"\u0007\u0015\t\u0001b\u0003G\u0001#\u000e)A!F\u0005\u0002\u00119i\u0011\u0001c\u0007.0\u0011\tQCA\u0003\u0002\u0011)AZ#I\u0006\u0006\u0003!\u001d\u0012bA\u0005\u0003\u000b\u0005A1\"C\u0002\n\u0005\u0015\t\u0001B\u0003G\u0001#\u000e)A1F\u0005\u0002\u0011Qi\u0011\u0001c\u00076\u0017\u0015QAa9\u0001\u0019\b\u0005\u0012Q!\u0001E\u0003#\u000e\u0019AqA\u0005\u0002\t\u0001\u0001"})
public final class DeprecatedSymbolValidator
implements SymbolUsageValidator {
    public static final /* synthetic */ KClass $kotlinClass;
    private final FqName JAVA_DEPRECATED = new FqName(Deprecated.class.getName());
    private final TokenSet PROPERTY_SET_OPERATIONS = TokenSet.create(JetTokens.EQ, JetTokens.PLUSEQ, JetTokens.MINUSEQ, JetTokens.MULTEQ, JetTokens.DIVEQ, JetTokens.PERCEQ, JetTokens.PLUSPLUS, JetTokens.MINUSMINUS);

    static {
        $kotlinClass = Reflection.createKotlinClass(DeprecatedSymbolValidator.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validateCall(@JetValueParameter(name="targetDescriptor") @NotNull CallableDescriptor targetDescriptor, @JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="element") @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        Pair<AnnotationDescriptor, DeclarationDescriptor> deprecated2 = this.getDeprecatedAnnotation(targetDescriptor);
        if (deprecated2 != null) {
            void annotation2;
            void target;
            Pair<AnnotationDescriptor, DeclarationDescriptor> pair = deprecated2;
            AnnotationDescriptor annotationDescriptor = pair.component1();
            DeclarationDescriptor declarationDescriptor = pair.component2();
            pair = null;
            trace.report(this.createDeprecationDiagnostic(element, (DeclarationDescriptor)target, (AnnotationDescriptor)annotation2));
        } else if (targetDescriptor instanceof PropertyDescriptor) {
            this.propertyGetterWorkaround((PropertyDescriptor)targetDescriptor, trace, element);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validateTypeUsage(@JetValueParameter(name="targetDescriptor") @NotNull ClassifierDescriptor targetDescriptor, @JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="element") @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(element, "element");
        JetAnnotationEntry annotationEntry = JetStubbedPsiUtil.getPsiOrStubParent(element, JetAnnotationEntry.class, true);
        if (annotationEntry != null && Intrinsics.areEqual(annotationEntry.getCalleeExpression().getConstructorReferenceExpression(), element)) {
            return;
        }
        JetDelegatorToSuperCall superExpression = JetStubbedPsiUtil.getPsiOrStubParent(element, JetDelegatorToSuperCall.class, true);
        if (superExpression != null && Intrinsics.areEqual(superExpression.getCalleeExpression().getConstructorReferenceExpression(), element)) {
            return;
        }
        Pair<AnnotationDescriptor, DeclarationDescriptor> deprecated2 = this.getDeprecatedAnnotation(targetDescriptor);
        if (deprecated2 != null) {
            void annotation2;
            void target;
            Pair<AnnotationDescriptor, DeclarationDescriptor> pair = deprecated2;
            AnnotationDescriptor annotationDescriptor = pair.component1();
            DeclarationDescriptor declarationDescriptor = pair.component2();
            pair = null;
            trace.report(this.createDeprecationDiagnostic(element, (DeclarationDescriptor)target, (AnnotationDescriptor)annotation2));
        }
    }

    private final Pair<AnnotationDescriptor, DeclarationDescriptor> getDeprecatedAnnotation(@JetValueParameter(name="$receiver") DeclarationDescriptor $receiver) {
        DeclarationDescriptor propertyDescriptor;
        AnnotationDescriptor propertyAnnotation;
        AnnotationDescriptor ownAnnotation = this.getDeclaredDeprecatedAnnotation($receiver);
        if (ownAnnotation != null) {
            return KotlinPackage.to(ownAnnotation, $receiver);
        }
        DeclarationDescriptor declarationDescriptor = $receiver;
        if (declarationDescriptor instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)$receiver).getContainingDeclaration();
            AnnotationDescriptor classAnnotation = this.getDeclaredDeprecatedAnnotation(classDescriptor);
            if (classAnnotation != null) {
                return KotlinPackage.to(classAnnotation, classDescriptor);
            }
        } else if (declarationDescriptor instanceof PropertyAccessorDescriptor && (propertyAnnotation = this.getDeclaredDeprecatedAnnotation(propertyDescriptor = ((PropertyAccessorDescriptor)$receiver).getContainingDeclaration())) != null) {
            return KotlinPackage.to(propertyAnnotation, propertyDescriptor);
        }
        return null;
    }

    private final AnnotationDescriptor getDeclaredDeprecatedAnnotation(@JetValueParameter(name="$receiver") DeclarationDescriptor $receiver) {
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.deprecated;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "KotlinBuiltIns.FQ_NAMES.deprecated");
        AnnotationDescriptor annotationDescriptor = annotations2.findAnnotation(fqName2);
        if (annotationDescriptor == null) {
            annotationDescriptor = $receiver.getAnnotations().findAnnotation(this.JAVA_DEPRECATED);
        }
        return annotationDescriptor;
    }

    private final Diagnostic createDeprecationDiagnostic(@JetValueParameter(name="element") PsiElement element, @JetValueParameter(name="descriptor") DeclarationDescriptor descriptor2, @JetValueParameter(name="deprecated") AnnotationDescriptor deprecated2) {
        String message = AnnotationsPackage$AnnotationUtil$31ab6ffa.deprecatedAnnotationMessage(deprecated2);
        return message == null ? Errors.DEPRECATED_SYMBOL.on(element, descriptor2) : Errors.DEPRECATED_SYMBOL_WITH_MESSAGE.on(element, descriptor2, message);
    }

    /*
     * WARNING - void declaration
     */
    public final void propertyGetterWorkaround(@JetValueParameter(name="propertyDescriptor") @NotNull PropertyDescriptor propertyDescriptor, @JetValueParameter(name="trace") @NotNull BindingTrace trace, @JetValueParameter(name="expression") @NotNull PsiElement expression) {
        Unit unit;
        JetUnaryExpression unaryExpression;
        Object expr;
        IElementType operation;
        Intrinsics.checkParameterIsNotNull(propertyDescriptor, "propertyDescriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetBinaryExpression binaryExpression = PsiTreeUtil.getParentOfType(expression, JetBinaryExpression.class);
        if (binaryExpression != null) {
            JetExpression left = binaryExpression.getLeft();
            if (Intrinsics.areEqual(left, expression) && (operation = binaryExpression.getOperationToken()) != null && this.PROPERTY_SET_OPERATIONS.contains(operation)) {
                return;
            }
            JetReferenceExpression[] jetReferenceExpressions = (JetReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)left, JetReferenceExpression.class);
            if (jetReferenceExpressions != null) {
                for (int i = 0; i < jetReferenceExpressions.length; ++i) {
                    IElementType operation2;
                    expr = jetReferenceExpressions[i];
                    if (!Intrinsics.areEqual(expr, expression) || (operation2 = binaryExpression.getOperationToken()) == null || !this.PROPERTY_SET_OPERATIONS.contains(operation2)) continue;
                    return;
                }
            }
        }
        if ((unaryExpression = PsiTreeUtil.getParentOfType(expression, JetUnaryExpression.class)) != null && (operation = unaryExpression.getOperationReference().getReferencedNameElementType()) != null && this.PROPERTY_SET_OPERATIONS.contains(operation)) {
            return;
        }
        JetCallableReferenceExpression callableExpression = PsiTreeUtil.getParentOfType(expression, JetCallableReferenceExpression.class);
        if (callableExpression != null && Intrinsics.areEqual(callableExpression.getCallableReference(), expression)) {
            return;
        }
        PropertyGetterDescriptor propertyGetterDescriptor = propertyDescriptor.getGetter();
        if (propertyGetterDescriptor != null) {
            void $receiver;
            expr = propertyGetterDescriptor;
            PropertyGetterDescriptor it2 = (PropertyGetterDescriptor)$receiver;
            this.validateCall(it2, trace, expression);
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
    }
}

