/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetSuperExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.CallResolverUtil;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"e\u0004)iBK]1ji\u0012+g-Y;mi6+G\u000f[8e\u0007\u0006dGn\u00115fG.,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u001d\u0011Xm]8mm\u0016T1A\u001b<n\u0015\u0015\u0019\u0017\r\u001c7t\u0015!\u0019\u0007.Z2lKJ\u001c(bC\"bY2\u001c\u0005.Z2lKJTa\u0001P5oSRt$\"\u0001$\u000b%\r\u000bG\u000e\\1cY\u0016$Um]2sSB$xN\u001d\u0006\fI\u0016\u001c8M]5qi>\u00148OC\u0003dQ\u0016\u001c7N\u0003\u0007sKN|GN^3e\u0007\u0006dGN\u0003\u0007SKN|GN^3e\u0007\u0006dGNC\u0003n_\u0012,GNC\u0004d_:$X\r\u001f;\u000b5\t\u000b7/[2DC2d'+Z:pYV$\u0018n\u001c8D_:$X\r\u001f;\u000b\tUs\u0017\u000e\u001eD\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0011AA\u0001\u0005\u0004\u000b\t!)\u0001c\u0002\u0006\u0007\u0011\u0019\u0001\u0002\u0001\u0007\u0001\u000b\t!\u0019\u0001C\u0002\u0006\u0005\u0011!\u0001rA\u0003\u0004\t\u0013AA\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001BB\u0003\u0004\t\u0017AY\u0001\u0004\u0001\u0006\u0005\u0011!\u0001\u0002C\u0003\u0004\t\u001bAy\u0001\u0004\u0001\u0006\u0005\u0011!\u0001\u0012C\u0003\u0004\t\u001fA\u0011\u0002\u0004\u0001\u0006\u0003!\rQa\u0001C\t\u0011'a\u0001!\u0002\u0002\u0005\u000e!=QA\u0001C\b\u0011%!1\u0001d\u0002\u001a\u0005\u0015\t\u0001\"BW(\t-\tR\u0001\u0002\u0001\t\u000bU\u0011Q!\u0001\u0005\u00071\u001bi:\u0002\u0002\u0001\t\u000f59Q!\u0001\u0005\b\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001\u0012C\u0007\u0003\u000b\u0005A\u0001\u0002UB\u0001C\t)\u0011\u0001C\u0005R\u0007\u001d!i!C\u0001\u0005\u00015\t\u00012C\u0007\u0002\u0011))4\"\u0002\u0006\u0005G\u0004AJ!\t\u0002\u0006\u0003!\u001d\u0011kA\u0002\u0005\n%\tA\u0001\u0001"})
public final class TraitDefaultMethodCallChecker
implements CallChecker {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(TraitDefaultMethodCallChecker.class);
    }

    @Override
    public <F extends CallableDescriptor> void check(@JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<F> resolvedCall, @JetValueParameter(name="context") @NotNull BasicCallResolutionContext context2) {
        ClassifierDescriptor classifier2;
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        JetSuperExpression jetSuperExpression = CallResolverUtil.getSuperCallExpression(resolvedCall.getCall());
        if (jetSuperExpression == null) {
            return;
        }
        CallableDescriptor targetDescriptor = resolvedCall.getResultingDescriptor().getOriginal();
        DeclarationDescriptor containerDescriptor = targetDescriptor.getContainingDeclaration();
        if (containerDescriptor instanceof JavaClassDescriptor && DescriptorUtils.isTrait(containerDescriptor) && (classifier2 = DescriptorUtils.getParentOfType(((ResolutionContext)context2).scope.getContainingDeclaration(), ClassifierDescriptor.class)) != null && DescriptorUtils.isTrait(classifier2)) {
            ((ResolutionContext)context2).trace.report(ErrorsJvm.TRAIT_CANT_CALL_DEFAULT_METHOD_VIA_SUPER.on(PsiTreeUtil.getParentOfType((PsiElement)resolvedCall.getCall().getCallElement(), JetExpression.class)));
        }
    }
}

