/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationStub;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetDelegationSpecifierList;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetEnumEntrySuperclassReferenceExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetInitializerList;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPrimaryConstructor;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetPropertyDelegate;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeConstraint;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwner;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.SubstitutionUtils;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class DeclarationsChecker {
    private BindingTrace trace;
    private ModifiersChecker modifiersChecker;
    private DescriptorResolver descriptorResolver;

    @Inject
    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "setTrace"));
        }
        this.trace = trace;
    }

    @Inject
    public void setDescriptorResolver(@NotNull DescriptorResolver descriptorResolver) {
        if (descriptorResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorResolver", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "setDescriptorResolver"));
        }
        this.descriptorResolver = descriptorResolver;
    }

    @Inject
    public void setModifiersChecker(@NotNull ModifiersChecker modifiersChecker) {
        if (modifiersChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiersChecker", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "setModifiersChecker"));
        }
        this.modifiersChecker = modifiersChecker;
    }

    public void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        if (bodiesResolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodiesResolveContext", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "process"));
        }
        for (JetFile file : bodiesResolveContext.getFiles()) {
            this.checkModifiersAndAnnotationsInPackageDirective(file);
        }
        Map<JetClassOrObject, ClassDescriptorWithResolutionScopes> classes2 = bodiesResolveContext.getDeclaredClasses();
        for (Map.Entry<JetClassOrObject, ClassDescriptorWithResolutionScopes> entry : classes2.entrySet()) {
            JetClassOrObject classOrObject = entry.getKey();
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = entry.getValue();
            this.checkSupertypesForConsistency(classDescriptorWithResolutionScopes);
            this.checkTypesInClassHeader(classOrObject);
            if (classOrObject instanceof JetClass) {
                JetClass jetClass = (JetClass)classOrObject;
                this.checkClass(bodiesResolveContext, jetClass, classDescriptorWithResolutionScopes);
                this.descriptorResolver.checkNamesInConstraints(jetClass, classDescriptorWithResolutionScopes, classDescriptorWithResolutionScopes.getScopeForClassHeaderResolution(), this.trace);
            } else if (classOrObject instanceof JetObjectDeclaration) {
                this.checkObject((JetObjectDeclaration)classOrObject, classDescriptorWithResolutionScopes);
            }
            this.checkPrimaryConstructor(classOrObject, classDescriptorWithResolutionScopes);
            this.modifiersChecker.checkModifiersForDeclaration(classOrObject, classDescriptorWithResolutionScopes);
        }
        Map<JetNamedFunction, SimpleFunctionDescriptor> functions2 = bodiesResolveContext.getFunctions();
        for (Map.Entry<JetNamedFunction, SimpleFunctionDescriptor> entry : functions2.entrySet()) {
            JetNamedFunction jetNamedFunction = entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = entry.getValue();
            this.checkFunction(jetNamedFunction, functionDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(jetNamedFunction, functionDescriptor);
        }
        Map<JetProperty, PropertyDescriptor> properties2 = bodiesResolveContext.getProperties();
        for (Map.Entry<JetProperty, PropertyDescriptor> entry : properties2.entrySet()) {
            JetProperty property2 = entry.getKey();
            PropertyDescriptor propertyDescriptor = entry.getValue();
            this.checkProperty(property2, propertyDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(property2, propertyDescriptor);
        }
        for (Map.Entry<JetDeclarationStub, CallableMemberDescriptor> entry : bodiesResolveContext.getSecondaryConstructors().entrySet()) {
            ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)entry.getValue();
            JetSecondaryConstructor declaration = (JetSecondaryConstructor)entry.getKey();
            this.checkConstructorDeclaration(constructorDescriptor, declaration);
        }
    }

    private void checkConstructorDeclaration(ConstructorDescriptor constructorDescriptor, JetDeclaration declaration) {
        this.modifiersChecker.reportIllegalModalityModifiers(declaration);
        this.reportErrorIfHasIllegalModifier(declaration);
        this.modifiersChecker.checkModifiersForDeclaration(declaration, constructorDescriptor);
    }

    private void reportErrorIfHasIllegalModifier(JetModifierListOwner declaration) {
        if (declaration.hasModifier(JetTokens.ENUM_KEYWORD)) {
            this.trace.report(Errors.ILLEGAL_ENUM_ANNOTATION.on(declaration));
        }
        if (declaration.hasModifier(JetTokens.ANNOTATION_KEYWORD)) {
            this.trace.report(Errors.ILLEGAL_ANNOTATION_KEYWORD.on(declaration));
        }
    }

    private void checkModifiersAndAnnotationsInPackageDirective(JetFile file) {
        JetPackageDirective packageDirective = file.getPackageDirective();
        if (packageDirective == null) {
            return;
        }
        JetModifierList modifierList = packageDirective.getModifierList();
        if (modifierList == null) {
            return;
        }
        for (JetAnnotationEntry annotationEntry : modifierList.getAnnotationEntries()) {
            JetSimpleNameExpression reference;
            JetConstructorCalleeExpression calleeExpression = annotationEntry.getCalleeExpression();
            if (calleeExpression == null || (reference = calleeExpression.getConstructorReferenceExpression()) == null) continue;
            this.trace.report(Errors.UNRESOLVED_REFERENCE.on(reference, reference));
        }
        ModifiersChecker.reportIllegalModifiers(modifierList, Arrays.asList(JetTokens.MODIFIER_KEYWORDS_ARRAY), this.trace);
    }

    private void checkTypesInClassHeader(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkTypesInClassHeader"));
        }
        for (JetDelegationSpecifier delegationSpecifier : classOrObject.getDelegationSpecifiers()) {
            this.checkBoundsForTypeInClassHeader(delegationSpecifier.getTypeReference());
        }
        if (!(classOrObject instanceof JetClass)) {
            return;
        }
        JetClass jetClass = (JetClass)classOrObject;
        for (JetTypeParameter jetTypeParameter : jetClass.getTypeParameters()) {
            this.checkBoundsForTypeInClassHeader(jetTypeParameter.getExtendsBound());
            this.checkFinalUpperBounds(jetTypeParameter.getExtendsBound());
        }
        for (JetTypeConstraint constraint : jetClass.getTypeConstraints()) {
            this.checkBoundsForTypeInClassHeader(constraint.getBoundTypeReference());
            this.checkFinalUpperBounds(constraint.getBoundTypeReference());
        }
    }

    private void checkBoundsForTypeInClassHeader(@Nullable JetTypeReference typeReference) {
        JetType type2;
        if (typeReference != null && (type2 = this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)) != null) {
            DescriptorResolver.checkBounds(typeReference, type2, this.trace);
        }
    }

    private void checkFinalUpperBounds(@Nullable JetTypeReference typeReference) {
        JetType type2;
        if (typeReference != null && (type2 = this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)) != null) {
            DescriptorResolver.checkUpperBoundType(typeReference, type2, this.trace);
        }
    }

    private void checkSupertypesForConsistency(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkSupertypesForConsistency"));
        }
        Multimap<TypeConstructor, TypeProjection> multimap = SubstitutionUtils.buildDeepSubstitutionMultimap(classDescriptor.getDefaultType());
        for (Map.Entry<TypeConstructor, Collection<TypeProjection>> entry : multimap.asMap().entrySet()) {
            Collection<TypeProjection> projections = entry.getValue();
            if (projections.size() <= 1) continue;
            TypeConstructor typeConstructor2 = entry.getKey();
            ClassifierDescriptor declarationDescriptor = typeConstructor2.getDeclarationDescriptor();
            assert (declarationDescriptor instanceof TypeParameterDescriptor) : declarationDescriptor;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)declarationDescriptor;
            LinkedHashSet<JetType> conflictingTypes = Sets.newLinkedHashSet();
            for (TypeProjection projection : projections) {
                conflictingTypes.add(projection.getType());
            }
            DeclarationsChecker.removeDuplicateTypes(conflictingTypes);
            if (conflictingTypes.size() <= 1) continue;
            DeclarationDescriptor containingDeclaration = typeParameterDescriptor.getContainingDeclaration();
            assert (containingDeclaration instanceof ClassDescriptor) : containingDeclaration;
            JetClassOrObject psiElement = (JetClassOrObject)DescriptorToSourceUtils.getSourceFromDescriptor(classDescriptor);
            assert (psiElement != null);
            JetDelegationSpecifierList delegationSpecifierList = psiElement.getDelegationSpecifierList();
            assert (delegationSpecifierList != null);
            this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on(delegationSpecifierList, typeParameterDescriptor, (ClassDescriptor)containingDeclaration, conflictingTypes));
        }
    }

    private static void removeDuplicateTypes(Set<JetType> conflictingTypes) {
        Iterator<JetType> iterator2 = conflictingTypes.iterator();
        block0: while (iterator2.hasNext()) {
            JetType type2 = iterator2.next();
            for (JetType otherType : conflictingTypes) {
                boolean subtypeOf = JetTypeChecker.DEFAULT.equalTypes(type2, otherType);
                if (type2 == otherType || !subtypeOf) continue;
                iterator2.remove();
                continue block0;
            }
        }
    }

    private void checkObject(JetObjectDeclaration declaration, ClassDescriptor classDescriptor) {
        AnnotationResolver.reportDeprecatedAnnotationSyntax(declaration.getAnnotations(), this.trace);
        this.reportErrorIfHasIllegalModifier(declaration);
        if (declaration.isLocal() && !declaration.isCompanion() && !declaration.isObjectLiteral()) {
            this.trace.report(Errors.LOCAL_OBJECT_NOT_ALLOWED.on(declaration, classDescriptor));
        }
    }

    private void checkClass(BodiesResolveContext c, JetClass aClass, ClassDescriptorWithResolutionScopes classDescriptor) {
        AnnotationResolver.reportDeprecatedAnnotationSyntax(aClass.getAnnotations(), this.trace);
        this.checkOpenMembers(classDescriptor);
        this.checkTypeParameters(aClass);
        if (aClass.isInterface()) {
            ASTNode traitKeyword = aClass.getNode().findChildByType(JetTokens.TRAIT_KEYWORD);
            if (traitKeyword != null) {
                this.trace.report(Errors.DEPRECATED_TRAIT_KEYWORD.on(traitKeyword.getPsi()));
            }
            this.checkTraitModifiers(aClass);
            this.checkConstructorInTrait(aClass);
        } else if (aClass.isAnnotation()) {
            this.checkAnnotationClassWithBody(aClass);
            this.checkValOnAnnotationParameter(aClass);
        } else if (aClass.isEnum()) {
            this.checkEnumModifiers(aClass);
            if (aClass.isLocal()) {
                this.trace.report(Errors.LOCAL_ENUM_NOT_ALLOWED.on(aClass, classDescriptor));
            }
        } else if (aClass instanceof JetEnumEntry) {
            this.checkEnumEntry((JetEnumEntry)aClass, classDescriptor);
        }
    }

    private void checkPrimaryConstructor(JetClassOrObject classOrObject, ClassDescriptor classDescriptor) {
        ConstructorDescriptor primaryConstructor2 = classDescriptor.getUnsubstitutedPrimaryConstructor();
        JetPrimaryConstructor declaration = classOrObject.getPrimaryConstructor();
        if (primaryConstructor2 == null || declaration == null) {
            return;
        }
        for (JetParameter parameter : declaration.getValueParameters()) {
            PropertyDescriptor propertyDescriptor = this.trace.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
            if (propertyDescriptor == null) continue;
            this.modifiersChecker.checkModifiersForDeclaration(parameter, propertyDescriptor);
        }
        if (declaration.getModifierList() != null && !declaration.hasConstructorKeyword()) {
            this.trace.report(Errors.MISSING_CONSTRUCTOR_KEYWORD.on(declaration.getModifierList()));
        }
        if (!(classOrObject instanceof JetClass)) {
            this.trace.report(Errors.CONSTRUCTOR_IN_OBJECT.on(declaration));
        }
        this.checkConstructorDeclaration(primaryConstructor2, declaration);
    }

    private void checkTypeParameters(JetTypeParameterListOwner typeParameterListOwner) {
        for (JetTypeParameter jetTypeParameter : typeParameterListOwner.getTypeParameters()) {
            AnnotationResolver.reportUnsupportedAnnotationForTypeParameter(jetTypeParameter, this.trace);
            TypeParameterDescriptor typeParameter = this.trace.get(BindingContext.TYPE_PARAMETER, jetTypeParameter);
            if (typeParameter == null) continue;
            DescriptorResolver.checkConflictingUpperBounds(this.trace, typeParameter, jetTypeParameter);
        }
    }

    private void checkConstructorInTrait(JetClass klass) {
        JetPrimaryConstructor primaryConstructor2 = klass.getPrimaryConstructor();
        if (primaryConstructor2 != null) {
            this.trace.report(Errors.CONSTRUCTOR_IN_TRAIT.on(primaryConstructor2));
        }
    }

    private void checkTraitModifiers(JetClass aClass) {
        this.reportErrorIfHasIllegalModifier(aClass);
        JetModifierList modifierList = aClass.getModifierList();
        if (modifierList == null) {
            return;
        }
        if (modifierList.hasModifier(JetTokens.FINAL_KEYWORD)) {
            this.trace.report(Errors.TRAIT_CAN_NOT_BE_FINAL.on(aClass));
        }
        if (modifierList.hasModifier(JetTokens.ABSTRACT_KEYWORD)) {
            this.trace.report(Errors.ABSTRACT_MODIFIER_IN_TRAIT.on(aClass));
        }
        if (modifierList.hasModifier(JetTokens.OPEN_KEYWORD)) {
            this.trace.report(Errors.OPEN_MODIFIER_IN_TRAIT.on(aClass));
        }
    }

    private void checkAnnotationClassWithBody(JetClassOrObject classOrObject) {
        if (classOrObject.getBody() != null) {
            this.trace.report(Errors.ANNOTATION_CLASS_WITH_BODY.on(classOrObject.getBody()));
        }
    }

    private void checkValOnAnnotationParameter(JetClass aClass) {
        for (JetParameter parameter : aClass.getPrimaryConstructorParameters()) {
            if (parameter.hasValOrVarNode()) continue;
            this.trace.report(Errors.MISSING_VAL_ON_ANNOTATION_PARAMETER.on(parameter));
        }
    }

    private void checkOpenMembers(ClassDescriptorWithResolutionScopes classDescriptor) {
        if (DescriptorUtils.classCanHaveOpenMembers(classDescriptor)) {
            return;
        }
        for (CallableMemberDescriptor memberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            JetNamedDeclaration member;
            if (memberDescriptor.getKind() != CallableMemberDescriptor.Kind.DECLARATION || (member = (JetNamedDeclaration)DescriptorToSourceUtils.descriptorToDeclaration(memberDescriptor)) == null || !member.hasModifier(JetTokens.OPEN_KEYWORD)) continue;
            this.trace.report(Errors.NON_FINAL_MEMBER_IN_FINAL_CLASS.on(member));
        }
    }

    private void checkProperty(JetProperty property2, PropertyDescriptor propertyDescriptor) {
        this.reportErrorIfHasIllegalModifier(property2);
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            this.checkPropertyAbstractness(property2, propertyDescriptor, (ClassDescriptor)containingDeclaration);
        } else {
            this.modifiersChecker.reportIllegalModalityModifiers(property2);
        }
        this.checkPropertyInitializer(property2, propertyDescriptor);
        this.checkAccessors(property2, propertyDescriptor);
        this.checkDeclaredTypeInPublicMember(property2, propertyDescriptor);
    }

    private void checkDeclaredTypeInPublicMember(JetNamedDeclaration member, CallableMemberDescriptor memberDescriptor) {
        boolean hasDeferredType;
        if (member instanceof JetProperty) {
            hasDeferredType = ((JetProperty)member).getTypeReference() == null && DescriptorResolver.hasBody((JetProperty)member);
        } else {
            assert (member instanceof JetFunction);
            JetFunction function = (JetFunction)member;
            boolean bl = hasDeferredType = function.getTypeReference() == null && function.hasBody() && !function.hasBlockBody();
        }
        if (memberDescriptor.getVisibility().isPublicAPI() && memberDescriptor.getOverriddenDescriptors().size() == 0 && hasDeferredType) {
            this.trace.report(Errors.PUBLIC_MEMBER_SHOULD_SPECIFY_TYPE.on(member));
        }
    }

    private void checkPropertyAbstractness(@NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull ClassDescriptor classDescriptor) {
        ASTNode abstractNode;
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyAbstractness"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyAbstractness"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyAbstractness"));
        }
        JetPropertyAccessor getter2 = property2.getGetter();
        JetPropertyAccessor setter2 = property2.getSetter();
        JetModifierList modifierList = property2.getModifierList();
        ASTNode aSTNode = abstractNode = modifierList != null ? modifierList.getModifierNode(JetTokens.ABSTRACT_KEYWORD) : null;
        if (abstractNode != null) {
            if (!DescriptorUtils.classCanHaveAbstractMembers(classDescriptor)) {
                String name = property2.getName();
                this.trace.report(Errors.ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS.on(property2, name != null ? name : "", classDescriptor));
                return;
            }
            if (classDescriptor.getKind() == ClassKind.INTERFACE) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_TRAIT.on(property2));
            }
        }
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            JetPropertyDelegate delegate2;
            JetExpression initializer = property2.getInitializer();
            if (initializer != null) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_INITIALIZER.on(initializer));
            }
            if ((delegate2 = property2.getDelegate()) != null) {
                this.trace.report(Errors.ABSTRACT_DELEGATED_PROPERTY.on(delegate2));
            }
            if (getter2 != null && getter2.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_GETTER.on(getter2));
            }
            if (setter2 != null && setter2.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_SETTER.on(setter2));
            }
        }
    }

    private void checkPropertyInitializer(@NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor) {
        boolean hasAccessorImplementation;
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyInitializer"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkPropertyInitializer"));
        }
        JetPropertyAccessor getter2 = property2.getGetter();
        JetPropertyAccessor setter2 = property2.getSetter();
        boolean bl = hasAccessorImplementation = getter2 != null && getter2.hasBody() || setter2 != null && setter2.hasBody();
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            if (!property2.hasDelegateExpressionOrInitializer() && property2.getTypeReference() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on(property2));
            }
            return;
        }
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        boolean inTrait = containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.INTERFACE;
        JetExpression initializer = property2.getInitializer();
        JetPropertyDelegate delegate2 = property2.getDelegate();
        boolean backingFieldRequired = Boolean.TRUE.equals(this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor));
        if (inTrait && backingFieldRequired && hasAccessorImplementation) {
            this.trace.report(Errors.BACKING_FIELD_IN_TRAIT.on(property2));
        }
        if (initializer == null && delegate2 == null) {
            boolean error = false;
            if (backingFieldRequired && !inTrait && Boolean.TRUE.equals(this.trace.getBindingContext().get(BindingContext.IS_UNINITIALIZED, propertyDescriptor))) {
                if (!(containingDeclaration instanceof ClassDescriptor) || hasAccessorImplementation) {
                    error = true;
                    this.trace.report(Errors.MUST_BE_INITIALIZED.on(property2));
                } else {
                    error = true;
                    this.trace.report(Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.on(property2));
                }
            }
            if (!error && property2.getTypeReference() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on(property2));
            }
            if (inTrait && property2.hasModifier(JetTokens.FINAL_KEYWORD) && backingFieldRequired) {
                this.trace.report(Errors.FINAL_PROPERTY_IN_TRAIT.on(property2));
            }
            return;
        }
        if (inTrait) {
            if (delegate2 != null) {
                this.trace.report(Errors.DELEGATED_PROPERTY_IN_TRAIT.on(delegate2));
            } else {
                this.trace.report(Errors.PROPERTY_INITIALIZER_IN_TRAIT.on(initializer));
            }
        } else if (delegate2 == null) {
            if (!backingFieldRequired) {
                this.trace.report(Errors.PROPERTY_INITIALIZER_NO_BACKING_FIELD.on(initializer));
            } else if (property2.getReceiverTypeReference() != null) {
                this.trace.report(Errors.EXTENSION_PROPERTY_WITH_BACKING_FIELD.on(initializer));
            }
        }
    }

    protected void checkFunction(JetNamedFunction function, SimpleFunctionDescriptor functionDescriptor) {
        this.reportErrorIfHasIllegalModifier(function);
        DeclarationDescriptor containingDescriptor = functionDescriptor.getContainingDeclaration();
        boolean hasAbstractModifier = function.hasModifier(JetTokens.ABSTRACT_KEYWORD);
        this.checkDeclaredTypeInPublicMember(function, functionDescriptor);
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean hasBody;
            boolean inTrait;
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDescriptor;
            boolean bl = inTrait = classDescriptor.getKind() == ClassKind.INTERFACE;
            if (hasAbstractModifier && !DescriptorUtils.classCanHaveAbstractMembers(classDescriptor)) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS.on(function, functionDescriptor.getName().asString(), classDescriptor));
            }
            if (hasAbstractModifier && inTrait) {
                this.trace.report(Errors.ABSTRACT_MODIFIER_IN_TRAIT.on(function));
            }
            if ((hasBody = function.hasBody()) && hasAbstractModifier) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_WITH_BODY.on(function, functionDescriptor));
            }
            if (!hasBody && function.hasModifier(JetTokens.FINAL_KEYWORD) && inTrait) {
                this.trace.report(Errors.FINAL_FUNCTION_WITH_NO_BODY.on(function, functionDescriptor));
            }
            if (!(hasBody || hasAbstractModifier || inTrait)) {
                this.trace.report(Errors.NON_ABSTRACT_FUNCTION_WITH_NO_BODY.on(function, functionDescriptor));
            }
            return;
        }
        this.modifiersChecker.reportIllegalModalityModifiers(function);
        if (!function.hasBody() && !hasAbstractModifier) {
            this.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on(function, functionDescriptor));
        }
    }

    private void checkAccessors(@NotNull JetProperty property2, @NotNull PropertyDescriptor propertyDescriptor) {
        block8: {
            JetModifierList getterModifierList;
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkAccessors"));
            }
            if (propertyDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkAccessors"));
            }
            for (JetPropertyAccessor accessor : property2.getAccessors()) {
                PropertyAccessorDescriptor propertyAccessorDescriptor;
                PropertyAccessorDescriptor propertyAccessorDescriptor2 = propertyAccessorDescriptor = accessor.isGetter() ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
                assert (propertyAccessorDescriptor != null) : "No property accessor descriptor for " + property2.getText();
                this.modifiersChecker.checkModifiersForDeclaration(accessor, propertyAccessorDescriptor);
                this.modifiersChecker.reportIllegalModalityModifiers(accessor);
            }
            JetPropertyAccessor getter2 = property2.getGetter();
            PropertyGetterDescriptor getterDescriptor = propertyDescriptor.getGetter();
            JetModifierList jetModifierList = getterModifierList = getter2 != null ? getter2.getModifierList() : null;
            if (getterModifierList == null || getterDescriptor == null) break block8;
            Map<JetModifierKeywordToken, ASTNode> nodes = ModifiersChecker.getNodesCorrespondingToModifiers(getterModifierList, Sets.newHashSet(JetTokens.PUBLIC_KEYWORD, JetTokens.PROTECTED_KEYWORD, JetTokens.PRIVATE_KEYWORD, JetTokens.INTERNAL_KEYWORD));
            if (getterDescriptor.getVisibility() != propertyDescriptor.getVisibility()) {
                for (ASTNode node : nodes.values()) {
                    this.trace.report(Errors.GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY.on(node.getPsi()));
                }
            } else {
                for (ASTNode node : nodes.values()) {
                    this.trace.report(Errors.REDUNDANT_MODIFIER_IN_GETTER.on(node.getPsi()));
                }
            }
        }
    }

    private void checkEnumModifiers(JetClass aClass) {
        if (aClass.hasModifier(JetTokens.OPEN_KEYWORD)) {
            this.trace.report(Errors.OPEN_MODIFIER_IN_ENUM.on(aClass));
        }
        if (aClass.hasModifier(JetTokens.ABSTRACT_KEYWORD)) {
            this.trace.report(Errors.ABSTRACT_MODIFIER_IN_ENUM.on(aClass));
        }
    }

    public static boolean enumEntryUsesDeprecatedSuperConstructor(@NotNull JetEnumEntry enumEntry) {
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "enumEntryUsesDeprecatedSuperConstructor"));
        }
        JetInitializerList initializerList = enumEntry.getInitializerList();
        if (initializerList == null) {
            return false;
        }
        JetTypeReference typeReference = initializerList.getInitializers().get(0).getTypeReference();
        if (typeReference == null) {
            return false;
        }
        JetUserType userType = (JetUserType)typeReference.getTypeElement();
        return userType != null && !(userType.getReferenceExpression() instanceof JetEnumEntrySuperclassReferenceExpression);
    }

    @NotNull
    private static String enumEntryExpectedDelimiter(@NotNull JetEnumEntry enumEntry) {
        IElementType nextType;
        PsiElement next;
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "enumEntryExpectedDelimiter"));
        }
        for (next = enumEntry.getNextSibling(); next != null && !(next instanceof JetDeclaration); next = next.getNextSibling()) {
        }
        JetDeclaration nextDeclaration = (JetDeclaration)next;
        next = PsiUtilPackage.getNextSiblingIgnoringWhitespaceAndComments(enumEntry);
        IElementType iElementType = nextType = next != null ? next.getNode().getElementType() : null;
        if (nextDeclaration instanceof JetEnumEntry) {
            String string = nextType != JetTokens.COMMA ? "," : "";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "enumEntryExpectedDelimiter"));
            }
            return string;
        }
        if (nextType == JetTokens.COMMA) {
            nextType = (next = PsiUtilPackage.getNextSiblingIgnoringWhitespaceAndComments(next)) != null ? next.getNode().getElementType() : null;
        }
        String string = nextType != JetTokens.SEMICOLON && nextType != JetTokens.RBRACE ? ";" : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "enumEntryExpectedDelimiter"));
        }
        return string;
    }

    public static boolean enumEntryUsesDeprecatedOrNoDelimiter(@NotNull JetEnumEntry enumEntry) {
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "enumEntryUsesDeprecatedOrNoDelimiter"));
        }
        return !DeclarationsChecker.enumEntryExpectedDelimiter(enumEntry).isEmpty();
    }

    public static boolean enumEntryAfterEnumMember(@NotNull JetEnumEntry enumEntry) {
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "enumEntryAfterEnumMember"));
        }
        for (PsiElement previous = enumEntry.getPrevSibling(); previous != null; previous = previous.getPrevSibling()) {
            if (previous instanceof JetEnumEntry) {
                return false;
            }
            if (!(previous instanceof JetDeclaration)) continue;
            return true;
        }
        return false;
    }

    private void checkEnumEntry(@NotNull JetEnumEntry enumEntry, @NotNull ClassDescriptor classDescriptor) {
        String neededDelimiter;
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkEnumEntry"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/DeclarationsChecker", "checkEnumEntry"));
        }
        DeclarationDescriptor declaration = classDescriptor.getContainingDeclaration();
        assert (DescriptorUtils.isEnumClass(declaration)) : "Enum entry should be declared in enum class: " + classDescriptor;
        ClassDescriptor enumClass = (ClassDescriptor)declaration;
        if (DeclarationsChecker.enumEntryUsesDeprecatedSuperConstructor(enumEntry)) {
            this.trace.report(Errors.ENUM_ENTRY_USES_DEPRECATED_SUPER_CONSTRUCTOR.on(enumEntry, classDescriptor));
        }
        if (!(neededDelimiter = DeclarationsChecker.enumEntryExpectedDelimiter(enumEntry)).isEmpty()) {
            this.trace.report(Errors.ENUM_ENTRY_USES_DEPRECATED_OR_NO_DELIMITER.on(enumEntry, classDescriptor, neededDelimiter));
        }
        if (DeclarationsChecker.enumEntryAfterEnumMember(enumEntry)) {
            this.trace.report(Errors.ENUM_ENTRY_AFTER_ENUM_MEMBER.on(enumEntry, classDescriptor));
        }
        List<JetDelegationSpecifier> delegationSpecifiers = enumEntry.getDelegationSpecifiers();
        ConstructorDescriptor constructor2 = enumClass.getUnsubstitutedPrimaryConstructor();
        if ((constructor2 == null || !constructor2.getValueParameters().isEmpty()) && delegationSpecifiers.isEmpty()) {
            this.trace.report(Errors.ENUM_ENTRY_SHOULD_BE_INITIALIZED.on(enumEntry, enumClass));
        }
        for (JetDelegationSpecifier delegationSpecifier : delegationSpecifiers) {
            JetType type2;
            JetTypeReference typeReference = delegationSpecifier.getTypeReference();
            if (typeReference == null || (type2 = this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)) == null) continue;
            JetType enumType = enumClass.getDefaultType();
            if (type2.getConstructor().equals(enumType.getConstructor())) continue;
            this.trace.report(Errors.ENUM_ENTRY_ILLEGAL_TYPE.on(typeReference, enumClass));
        }
    }
}

