/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.utils.UtilsPackage$collections$1f9e25a3;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\f\u000e)\u0019B)Z2mCJ\fG/[8o%\u0016\u001cx\u000e\u001c<fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0004sKN|GN^3\u000b\u0007\u0005s\u0017P\u0003\u0004=S:LGO\u0010\u0006\byM,G/L ?\u0015I\teN\\8uCRLwN\u001c*fg>dg/\u001a:\u000b'}\u000bgN\\8uCRLwN\u001c*fg>dg/\u001a:\u000b9}\u000bgN\\8uCRLwN\u001c*fg>dg/\u001a:%I\u0016dWmZ1uK*Q\u0001O]8qKJ$\u0018.Z:\u000b#I+\u0017\rZ,sSR,\u0007K]8qKJ$\u0018P\u0003\fhKR|\u0016M\u001c8pi\u0006$\u0018n\u001c8SKN|GN^3s\u0015Y\u0019X\r^0b]:|G/\u0019;j_:\u0014Vm]8mm\u0016\u0014(\u0002\u0004\"j]\u0012Lgn\u001a+sC\u000e,'BB0ue\u0006\u001cWMC\b`iJ\f7-\u001a\u0013eK2,w-\u0019;f\u0015%9W\r^0ue\u0006\u001cWMC\u0005tKR|FO]1dK*\u00192\r[3dWJ+G-Z2mCJ\fG/[8og*\t1M\u0003\fU_B$un\u001e8B]\u0006d\u0017p]5t\u0007>tG/\u001a=u\u0015\u0011)f.\u001b;\u000b;\rDWmY6SK\u0012,7\r\\1sCRLwN\\:J]B\u000b7m[1hKNT!\u0004^8q\u0019\u00164X\r\u001c#fg\u000e\u0014\u0018\u000e\u001d;peB\u0013xN^5eKJT!\u0004V8q\u0019\u00164X\r\u001c#fg\u000e\u0014\u0018\u000e\u001d;peB\u0013xN^5eKJTA\u0001\\1{s*yAo\u001c9MKZ,GNR9OC6,7O\u0003\u0005Nk2$\u0018.\\1q\u0015\r\u0019w.\u001c\u0006\u0007O>|w\r\\3\u000b\r\r|W.\\8o\u0015\u001d\u0019w\u000e\u001c7fGRTaAR9OC6,'\u0002\u00028b[\u0016T!BS3u\u000b2,W.\u001a8u\u0015\r\u00018/\u001b\u0006\u001fO\u0016$Hk\u001c9MKZ,G\u000eR3tGJL\u0007\u000f^8sg\nKh)\u001d(b[\u0016TaAZ9OC6,'bA*fi*)B)Z2mCJ\fG/[8o\t\u0016\u001c8M]5qi>\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNTAA[1wC*!Q\u000f^5m\u0015Q\u0011X\r]8siJ+G-Z2mCJ\fG/[8og*iA-Z:de&\u0004Ho\u001c:NCBTAAT1nK*I\"/Z:pYZ,\u0017I\u001c8pi\u0006$\u0018n\u001c8t\u001f:4\u0015\u000e\\3t\u00155\u00198m\u001c9f!J|g/\u001b3fe*\tb)\u001b7f'\u000e|\u0007/\u001a)s_ZLG-\u001a:\u000b+M,G/\u00118o_R\fG/[8o%\u0016\u001cx\u000e\u001c<fe*\u0011\u0012M\u001c8pi\u0006$\u0018n\u001c8SKN|GN^3s\u0015!\u0019X\r\u001e+sC\u000e,'\"\u0002;sC\u000e,g@\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\r!\u0019\u0001\u0003\u0001\r\u0001\u0015\t\u00012A\u0003\u0004\t\u000bA)\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001\u0002\u0002\u0007\u0001\u000b\t!)\u0001c\u0003\u0006\u0005\u0011!\u0001BB\u0003\u0003\t\u0007AA!B\u0002\u0005\u0004!=A\u0002A\u0003\u0003\t\u0007Ay!B\u0002\u0005\u0004!YA\u0002A\u0003\u0004\t\u000bA9\u0002\u0004\u0001\u0006\u0005\u0011\r\u0001bC\u0003\u0003\t\u0007AY\"B\u0002\u0005\u0011!iA\u0002A\u0003\u0002\u0011=)!\u0001B\u0005\t \u0015\u0011A1\u0003\u0005\u0011\u000b\t!!\u0002#\t\u0006\u0007\u0011U\u0001R\u0004\u0007\u0001\u000b\t!\u0011\u0001c\t\u0006\u0007\u0011]\u0001\"\u0005\u0007\u0001\u000b\t!\u0011\u0001#\n\u0006\u0007\u0011e\u0001B\u0005\u0007\u0001\u000b\t!\u0001\u0002C\u0007\u0006\u0005\u0011U\u0001RD\u0003\u0004\t\u000bAA\u0003\u0004\u0001\u0006\u0005\u0011\t\u0001\"F\u0003\u0004\t=AI\u0003\u0004\u0001\u0006\u0003!-RA\u0001\u0003\u0011\u0011Y)!\u0001\"\t\t)\u0015\u0011Aq\u0003\u0005\u0012\u000b\r!9\u0002c\f\r\u0001\u0015\u0019A\u0001\u0003\u0005\u001a\u0019\u0001)!\u0001\u0002\u0005\t3\u0011\u0019ABA\r\u0003\u000b\u0005A1!,\u0010\u0005\u00034AJ!(\u0004\u0005\u0001!\u001dQBA\u0003\u0002\u0011\u000f\u00016\u0001A\u0011\u0003\u000b\u0005A9\u0001J\u0011)CU\u001ba\"B\u0002\u0005\u000b%\t\u0001\u0012B\u0007\u0004\t\u001bI\u0011\u0001C\u0003\u0012\u000b\u00119\u0011\"\u0001\u0003\u0001\u001b\u0005AQ!,\u0010\u0005\u00034A\u0002\"(\u0004\u0005\u0001!\u001dQBA\u0003\u0002\u0011\u0017\u00016\u0001A\u0011\u0003\u000b\u0005AY\u0001J\u0011)CU\u001ba\"B\u0002\u0005\u0012%\t\u0001\u0012B\u0007\u0004\t%I\u0011\u0001\u0003\u0004\u0012\u000b\u0011M\u0011\"\u0001\u0003\u0001\u001b\u0005Aa!L\n\u0005\u0007aQQT\u0002\u0003\u0001\u0011+i!!B\u0001\t\u000eA\u001b\u0001!\t\u0002\u0006\u0003!9\u0011kA\u0003\u0005\u0015%\tA\u0001A\u0007\u0002\u0011\u001fiK\u0005B\u0002\u0019\u0019u5A\u0001\u0001E\r\u001b\t)\u0011\u0001#\u0005Q\u0007\u0001ij\u0002\u0002\u0001\t\u001d5QQ!\u0001\u0005\f\u0013\rI!!B\u0001\t\u0019%\u0019\u0011BA\u0003\u0002\u00115\u00016\u0011A\u0011\u0003\u000b\u0005Aq!U\u0002\b\t1I\u0011\u0001\u0002\u0001\u000e\u0003!mQ\"\u0001\u0005\u000f[\u0003\"\u0011\u0001G\n\u001e\u000e\u0011\u0001\u0001\u0012D\u0007\u0003\u000b\u0005A\t\u0002U\u0002\u0001;\u001b!\u0001\u0001c\n\u000e\u0005\u0015\t\u0001\u0002\u0004)\u0004\u0002\u00052Q!\u0001E\u000f\u0013\rI!!B\u0001\t E\u001bq\u0001B\n\n\u0003!\tR\"\u0001E\u000e\u001b\u0005A\u0019#L\u000e\u0005\u0003a5RT\u0004\u0003\u0001\u0011]i!\"B\u0001\t\u0017%\u0019\u0011BA\u0003\u0002\u0011II1!\u0003\u0002\u0006\u0003!}\u0001k\u0001\u0001\"\u0005\u0015\t\u0001bB)\u0004\u000b\u00115\u0012\"\u0001\u0003\u0001\u001b\u0005Aa\",\u000f\u0005\u0007aART\u0002\u0003\u0001\u0011+i!!B\u0001\t\u000eA\u001b\u0001!(\u0004\u0005\u0001!ERBA\u0003\u0002\u0011K\u00016\u0011A\u0011\u0003\u000b\u0005Aq!U\u0002\b\taI\u0011\u0001\u0002\u0001\u000e\u0003!=Q\"\u0001\u0005\u0014[M!9\u0001g\r\u001e\u000e\u0011\u0001\u0001BG\u0007\u0003\u000b\u0005A9\u0001U\u0002\u0001C\t)\u0011\u0001C\u0004R\u0007\u0015!\u0019$C\u0001\u0005\u00015\t\u0001\"B\u0017\u0014\t\u000fA*$(\u0004\u0005\u0001!YRBA\u0003\u0002\u0011\u0017\u00016\u0001A\u0011\u0003\u000b\u0005Aq!U\u0002\u0006\tkI\u0011\u0001\u0002\u0001\u000e\u0003!1QgC\u0003\u000b\t\r\b\u0001dA\u0011\u0003\u000b\u0005A!!U\u0002\u0004\t\rI\u0011\u0001\u0002\u0001"})
public final class DeclarationResolver {
    public static final /* synthetic */ KClass $kotlinClass;
    private final ReadWriteProperty<? super Object, AnnotationResolver> _annotationResolver$delegate = Delegates.INSTANCE$.notNull();
    private final ReadWriteProperty<? super Object, BindingTrace> _trace$delegate = Delegates.INSTANCE$.notNull();
    private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;

    static {
        $kotlinClass = Reflection.createKotlinClass(DeclarationResolver.class);
        $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("_annotationResolver"), new PropertyMetadataImpl("_trace")};
    }

    private final AnnotationResolver get_annotationResolver() {
        return this._annotationResolver$delegate.get(this, $propertyMetadata[0]);
    }

    private final void set_annotationResolver(@JetValueParameter(name="<set-?>") AnnotationResolver annotationResolver) {
        this._annotationResolver$delegate.set(this, $propertyMetadata[0], annotationResolver);
    }

    private final BindingTrace get_trace() {
        return this._trace$delegate.get(this, $propertyMetadata[1]);
    }

    private final void set_trace(@JetValueParameter(name="<set-?>") BindingTrace bindingTrace) {
        this._trace$delegate.set(this, $propertyMetadata[1], bindingTrace);
    }

    @Inject
    public final void setAnnotationResolver(@JetValueParameter(name="annotationResolver") @NotNull AnnotationResolver annotationResolver) {
        Intrinsics.checkParameterIsNotNull(annotationResolver, "annotationResolver");
        this.set_annotationResolver(annotationResolver);
    }

    @Inject
    public final void setTrace(@JetValueParameter(name="trace") @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.set_trace(trace);
    }

    public final void resolveAnnotationsOnFiles(@JetValueParameter(name="c") @NotNull TopDownAnalysisContext c, @JetValueParameter(name="scopeProvider") @NotNull FileScopeProvider scopeProvider) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(scopeProvider, "scopeProvider");
        Map filesToScope2 = UtilsPackage$collections$1f9e25a3.keysToMap((Iterable)c.getFiles(), (Function1)new Function1<JetFile, JetScope>(scopeProvider){
            final /* synthetic */ FileScopeProvider $scopeProvider;

            @NotNull
            public final JetScope invoke(@JetValueParameter(name="it") JetFile it2) {
                JetFile jetFile = it2;
                Intrinsics.checkExpressionValueIsNotNull(jetFile, "it");
                return this.$scopeProvider.getFileScope(jetFile);
            }
            {
                this.$scopeProvider = fileScopeProvider;
                super(1);
            }
        });
        Iterator iterator2 = KotlinPackage.iterator(filesToScope2);
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            JetFile file = (JetFile)KotlinPackage.component1(entry);
            JetScope fileScope = (JetScope)KotlinPackage.component2(entry);
            AnnotationResolver.reportDeprecatedAnnotationSyntax(file.getAnnotations(), this.get_trace());
            this.get_annotationResolver().resolveAnnotationsWithArguments(fileScope, file.getAnnotationEntries(), this.get_trace());
            this.get_annotationResolver().resolveAnnotationsWithArguments(fileScope, file.getDanglingAnnotations(), this.get_trace());
        }
    }

    public final void checkRedeclarations(@JetValueParameter(name="c") @NotNull TopDownAnalysisContext c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        for (ClassDescriptorWithResolutionScopes classDescriptor : c.getDeclaredClasses().values()) {
            HashMultimap descriptorMap = HashMultimap.create();
            for (DeclarationDescriptor desc : classDescriptor.getScopeForMemberLookup().getOwnDeclaredDescriptors()) {
                if (!(desc instanceof ClassDescriptor) && !(desc instanceof PropertyDescriptor)) continue;
                descriptorMap.put(desc.getName(), desc);
            }
            Multimap multimap = descriptorMap;
            Intrinsics.checkExpressionValueIsNotNull(multimap, "descriptorMap");
            this.reportRedeclarations(multimap);
        }
    }

    private final void reportRedeclarations(@JetValueParameter(name="descriptorMap") Multimap<Name, DeclarationDescriptor> descriptorMap) {
        HashSet<Pair<PsiElement, Name>> redeclarations = Sets.newHashSet();
        for (Name pair : descriptorMap.keySet()) {
            Collection<DeclarationDescriptor> descriptors = descriptorMap.get(pair);
            if (descriptors.size() <= 1) continue;
            for (DeclarationDescriptor descriptor2 : descriptors) {
                if (!(descriptor2 instanceof ClassDescriptor)) continue;
                for (DeclarationDescriptor descriptor22 : descriptors) {
                    if (descriptor2 == descriptor22) continue;
                    PsiElement psiElement = DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2);
                    if (psiElement == null) {
                        Intrinsics.throwNpe();
                    }
                    redeclarations.add(new Pair<PsiElement, Name>(psiElement, ((ClassDescriptor)descriptor2).getName()));
                    if (!(descriptor22 instanceof PropertyDescriptor)) continue;
                    PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(descriptor22);
                    if (psiElement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    redeclarations.add(new Pair<PsiElement, Name>(psiElement2, ((PropertyDescriptor)descriptor22).getName()));
                }
            }
        }
        for (Pair pair : redeclarations) {
            PsiElement first = (PsiElement)pair.component1();
            Name second = (Name)pair.component2();
            this.get_trace().report(Errors.REDECLARATION.on(first, second.asString()));
        }
    }

    public final void checkRedeclarationsInPackages(@JetValueParameter(name="topLevelDescriptorProvider") @NotNull TopLevelDescriptorProvider topLevelDescriptorProvider, @JetValueParameter(name="topLevelFqNames") @NotNull Multimap<FqName, JetElement> topLevelFqNames) {
        Intrinsics.checkParameterIsNotNull(topLevelDescriptorProvider, "topLevelDescriptorProvider");
        Intrinsics.checkParameterIsNotNull(topLevelFqNames, "topLevelFqNames");
        Iterator<Map.Entry<FqName, Collection<JetElement>>> iterator2 = KotlinPackage.iterator(topLevelFqNames.asMap());
        while (iterator2.hasNext()) {
            Map.Entry<FqName, Collection<JetElement>> entry = iterator2.next();
            FqName fqName2 = KotlinPackage.component1(entry);
            Collection<JetElement> declarationsOrPackageDirectives = KotlinPackage.component2(entry);
            if (fqName2.isRoot()) continue;
            FqName fqName3 = fqName2;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "fqName");
            Set<DeclarationDescriptor> descriptors = this.getTopLevelDescriptorsByFqName(topLevelDescriptorProvider, fqName3);
            if (descriptors.size() <= 1) continue;
            for (JetElement declarationOrPackageDirective : declarationsOrPackageDirectives) {
                PsiElement reportAt = declarationOrPackageDirective instanceof JetPackageDirective ? ((JetPackageDirective)declarationOrPackageDirective).getNameIdentifier() : (PsiElement)declarationOrPackageDirective;
                this.get_trace().report(Errors.REDECLARATION.on(reportAt, fqName2.shortName().asString()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<DeclarationDescriptor> getTopLevelDescriptorsByFqName(@JetValueParameter(name="topLevelDescriptorProvider") TopLevelDescriptorProvider topLevelDescriptorProvider, @JetValueParameter(name="fqName") FqName fqName2) {
        FqName parentFqName = fqName2.parent();
        HashSet<ClassDescriptor> descriptors = new HashSet<ClassDescriptor>();
        FqName fqName3 = parentFqName;
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "parentFqName");
        LazyPackageDescriptor parentFragment = topLevelDescriptorProvider.getPackageFragment(fqName3);
        if (parentFragment != null) {
            void destination;
            void $receiver;
            void $receiver2;
            JetScope jetScope = parentFragment.getMemberScope();
            Name name = fqName2.shortName();
            Intrinsics.checkExpressionValueIsNotNull(name, "fqName.shortName()");
            Iterable iterable = jetScope.getProperties(name);
            HashSet<ClassDescriptor> hashSet = descriptors;
            void var7_8 = $receiver2;
            Collection collection = new ArrayList();
            for (Object element : $receiver) {
                VariableDescriptor it2 = (VariableDescriptor)element;
                if (!(it2.getExtensionReceiverParameter() == null)) continue;
                destination.add(element);
            }
            List list = (List)destination;
            hashSet.addAll(list);
        }
        UtilsPackage$collections$1f9e25a3.addIfNotNull((Collection)descriptors, topLevelDescriptorProvider.getPackageFragment(fqName2));
        descriptors.addAll(topLevelDescriptorProvider.getTopLevelClassDescriptors(fqName2));
        return descriptors;
    }
}

