/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.structure.JavaField;
import org.jetbrains.kotlin.load.java.structure.JavaMember;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.types.JetType;

public interface ExternalSignatureResolver {
    public static final ExternalSignatureResolver DO_NOTHING = new ExternalSignatureResolver(){

        @Override
        @NotNull
        public PropagatedMethodSignature resolvePropagatedSignature(@NotNull JavaMethod method, @NotNull ClassDescriptor owner, @NotNull JetType returnType2, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$1", "resolvePropagatedSignature"));
            }
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$1", "resolvePropagatedSignature"));
            }
            if (returnType2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$1", "resolvePropagatedSignature"));
            }
            if (valueParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$1", "resolvePropagatedSignature"));
            }
            if (typeParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$1", "resolvePropagatedSignature"));
            }
            PropagatedMethodSignature propagatedMethodSignature = new PropagatedMethodSignature(returnType2, receiverType, valueParameters, typeParameters, Collections.<String>emptyList(), false, Collections.<FunctionDescriptor>emptyList());
            if (propagatedMethodSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$1", "resolvePropagatedSignature"));
            }
            return propagatedMethodSignature;
        }

        @Override
        @NotNull
        public AlternativeMethodSignature resolveAlternativeMethodSignature(@NotNull JavaMember methodOrConstructor, boolean hasSuperMethods, @Nullable JetType returnType2, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters, boolean hasStableParameterNames) {
            if (methodOrConstructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodOrConstructor", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$1", "resolveAlternativeMethodSignature"));
            }
            if (valueParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$1", "resolveAlternativeMethodSignature"));
            }
            if (typeParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$1", "resolveAlternativeMethodSignature"));
            }
            AlternativeMethodSignature alternativeMethodSignature = new AlternativeMethodSignature(returnType2, receiverType, valueParameters, typeParameters, Collections.<String>emptyList(), hasStableParameterNames);
            if (alternativeMethodSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$1", "resolveAlternativeMethodSignature"));
            }
            return alternativeMethodSignature;
        }

        @Override
        @NotNull
        public AlternativeFieldSignature resolveAlternativeFieldSignature(@NotNull JavaField field2, @NotNull JetType returnType2, boolean isVar) {
            if (field2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$1", "resolveAlternativeFieldSignature"));
            }
            if (returnType2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$1", "resolveAlternativeFieldSignature"));
            }
            AlternativeFieldSignature alternativeFieldSignature = new AlternativeFieldSignature(returnType2, null);
            if (alternativeFieldSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$1", "resolveAlternativeFieldSignature"));
            }
            return alternativeFieldSignature;
        }

        @Override
        public void reportSignatureErrors(@NotNull CallableMemberDescriptor descriptor2, @NotNull List<String> signatureErrors) {
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$1", "reportSignatureErrors"));
            }
            if (signatureErrors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureErrors", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$1", "reportSignatureErrors"));
            }
            throw new UnsupportedOperationException("Should not be called");
        }
    };

    @NotNull
    public PropagatedMethodSignature resolvePropagatedSignature(@NotNull JavaMethod var1, @NotNull ClassDescriptor var2, @NotNull JetType var3, @Nullable JetType var4, @NotNull List<ValueParameterDescriptor> var5, @NotNull List<TypeParameterDescriptor> var6);

    @NotNull
    public AlternativeMethodSignature resolveAlternativeMethodSignature(@NotNull JavaMember var1, boolean var2, @Nullable JetType var3, @Nullable JetType var4, @NotNull List<ValueParameterDescriptor> var5, @NotNull List<TypeParameterDescriptor> var6, boolean var7);

    @NotNull
    public AlternativeFieldSignature resolveAlternativeFieldSignature(@NotNull JavaField var1, @NotNull JetType var2, boolean var3);

    public void reportSignatureErrors(@NotNull CallableMemberDescriptor var1, @NotNull List<String> var2);

    public static class PropagatedMethodSignature
    extends AlternativeMethodSignature {
        private final List<FunctionDescriptor> superMethods;

        public PropagatedMethodSignature(@Nullable JetType returnType2, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<String> signatureErrors, boolean hasStableParameterNames, @NotNull List<FunctionDescriptor> superMethods) {
            if (valueParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$PropagatedMethodSignature", "<init>"));
            }
            if (typeParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$PropagatedMethodSignature", "<init>"));
            }
            if (signatureErrors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureErrors", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$PropagatedMethodSignature", "<init>"));
            }
            if (superMethods == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethods", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$PropagatedMethodSignature", "<init>"));
            }
            super(returnType2, receiverType, valueParameters, typeParameters, signatureErrors, hasStableParameterNames);
            this.superMethods = superMethods;
        }

        @NotNull
        public List<FunctionDescriptor> getSuperMethods() {
            List<FunctionDescriptor> list = this.superMethods;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$PropagatedMethodSignature", "getSuperMethods"));
            }
            return list;
        }
    }

    public static class AlternativeFieldSignature
    extends MemberSignature {
        private final JetType returnType;

        public AlternativeFieldSignature(@NotNull JetType returnType2, @Nullable String signatureError) {
            if (returnType2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$AlternativeFieldSignature", "<init>"));
            }
            super(signatureError == null ? Collections.emptyList() : Collections.singletonList(signatureError));
            this.returnType = returnType2;
        }

        @NotNull
        public JetType getReturnType() {
            JetType jetType = this.returnType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$AlternativeFieldSignature", "getReturnType"));
            }
            return jetType;
        }
    }

    public static class AlternativeMethodSignature
    extends MemberSignature {
        private final JetType returnType;
        private final JetType receiverType;
        private final List<ValueParameterDescriptor> valueParameters;
        private final List<TypeParameterDescriptor> typeParameters;
        private final boolean hasStableParameterNames;

        public AlternativeMethodSignature(@Nullable JetType returnType2, @Nullable JetType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<String> signatureErrors, boolean hasStableParameterNames) {
            if (valueParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$AlternativeMethodSignature", "<init>"));
            }
            if (typeParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$AlternativeMethodSignature", "<init>"));
            }
            if (signatureErrors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureErrors", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$AlternativeMethodSignature", "<init>"));
            }
            super(signatureErrors);
            this.returnType = returnType2;
            this.receiverType = receiverType;
            this.valueParameters = valueParameters;
            this.typeParameters = typeParameters;
            this.hasStableParameterNames = hasStableParameterNames;
        }

        @Nullable
        public JetType getReturnType() {
            return this.returnType;
        }

        @Nullable
        public JetType getReceiverType() {
            return this.receiverType;
        }

        @NotNull
        public List<ValueParameterDescriptor> getValueParameters() {
            List<ValueParameterDescriptor> list = this.valueParameters;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$AlternativeMethodSignature", "getValueParameters"));
            }
            return list;
        }

        @NotNull
        public List<TypeParameterDescriptor> getTypeParameters() {
            List<TypeParameterDescriptor> list = this.typeParameters;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$AlternativeMethodSignature", "getTypeParameters"));
            }
            return list;
        }

        public boolean hasStableParameterNames() {
            return this.hasStableParameterNames;
        }
    }

    public static abstract class MemberSignature {
        private final List<String> signatureErrors;

        protected MemberSignature(@NotNull List<String> signatureErrors) {
            if (signatureErrors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureErrors", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$MemberSignature", "<init>"));
            }
            this.signatureErrors = signatureErrors;
        }

        @NotNull
        public List<String> getErrors() {
            List<String> list = this.signatureErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/ExternalSignatureResolver$MemberSignature", "getErrors"));
            }
            return list;
        }
    }
}

