/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.lexer.JetToken;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public final class PrimitiveBinaryOperationFIF
extends Enum<PrimitiveBinaryOperationFIF>
implements FunctionIntrinsicFactory {
    public static final /* enum */ PrimitiveBinaryOperationFIF INSTANCE = new PrimitiveBinaryOperationFIF();
    @NotNull
    private static final BinaryOperationInstrinsicBase RANGE_TO_INTRINSIC;
    @NotNull
    private static final BinaryOperationInstrinsicBase CHAR_RANGE_TO_INTRINSIC;
    @NotNull
    private static final BinaryOperationInstrinsicBase INTEGER_DIVISION_INTRINSIC;
    @NotNull
    private static final BinaryOperationInstrinsicBase BUILTINS_COMPARE_TO_INTRINSIC;
    @NotNull
    private static final BinaryOperationInstrinsicBase PRIMITIVE_NUMBER_COMPARE_TO_INTRINSIC;
    @NotNull
    private static final NamePredicate BINARY_OPERATIONS;
    private static final DescriptorPredicate PRIMITIVE_NUMBERS_BINARY_OPERATIONS;
    private static final DescriptorPredicate PRIMITIVE_NUMBERS_COMPARE_TO_OPERATIONS;
    private static final DescriptorPredicate INT_WITH_BIT_OPERATIONS;
    private static final DescriptorPredicate BOOLEAN_OPERATIONS;
    private static final DescriptorPredicate STRING_PLUS;
    private static final ImmutableMap<String, JsBinaryOperator> BINARY_BITWISE_OPERATIONS;
    private static final Predicate<FunctionDescriptor> PREDICATE;
    private static final /* synthetic */ PrimitiveBinaryOperationFIF[] $VALUES;

    public static PrimitiveBinaryOperationFIF[] values() {
        return (PrimitiveBinaryOperationFIF[])$VALUES.clone();
    }

    public static PrimitiveBinaryOperationFIF valueOf(String name) {
        return Enum.valueOf(PrimitiveBinaryOperationFIF.class, name);
    }

    @Override
    @Nullable
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        JsBinaryOperator op;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF", "getIntrinsic"));
        }
        if (PatternBuilder.pattern("Int|Short|Byte|Double|Float.compareTo(Char)").apply(descriptor2)) {
            return new WithCharAsSecondOperandFunctionIntrinsic(PRIMITIVE_NUMBER_COMPARE_TO_INTRINSIC);
        }
        if (PatternBuilder.pattern("Char.compareTo(Int|Short|Byte|Double|Float)").apply(descriptor2)) {
            return new WithCharAsFirstOperandFunctionIntrinsic(PRIMITIVE_NUMBER_COMPARE_TO_INTRINSIC);
        }
        if (PatternBuilder.pattern("Char.rangeTo(Char)").apply(descriptor2)) {
            return CHAR_RANGE_TO_INTRINSIC;
        }
        if (PRIMITIVE_NUMBERS_COMPARE_TO_OPERATIONS.apply(descriptor2)) {
            return PRIMITIVE_NUMBER_COMPARE_TO_INTRINSIC;
        }
        if (JsDescriptorUtils.isBuiltin(descriptor2) && descriptor2.getName().equals(OperatorConventions.COMPARE_TO)) {
            return BUILTINS_COMPARE_TO_INTRINSIC;
        }
        if (!PREDICATE.apply(descriptor2)) {
            return null;
        }
        if (PatternBuilder.pattern("Int|Short|Byte.div(Int|Short|Byte)").apply(descriptor2)) {
            return INTEGER_DIVISION_INTRINSIC;
        }
        if (PatternBuilder.pattern("Char.div(Int|Short|Byte)").apply(descriptor2)) {
            return new WithCharAsFirstOperandFunctionIntrinsic(INTEGER_DIVISION_INTRINSIC);
        }
        if (PatternBuilder.pattern("Int|Short|Byte.div(Char)").apply(descriptor2)) {
            return new WithCharAsSecondOperandFunctionIntrinsic(INTEGER_DIVISION_INTRINSIC);
        }
        if (descriptor2.getName().equals(Name.identifier("rangeTo"))) {
            return RANGE_TO_INTRINSIC;
        }
        if (INT_WITH_BIT_OPERATIONS.apply(descriptor2) && (op = BINARY_BITWISE_OPERATIONS.get(descriptor2.getName().asString())) != null) {
            return new PrimitiveBinaryOperationFunctionIntrinsic(op);
        }
        JsBinaryOperator operator = PrimitiveBinaryOperationFIF.getOperator(descriptor2);
        PrimitiveBinaryOperationFunctionIntrinsic result2 = new PrimitiveBinaryOperationFunctionIntrinsic(operator);
        if (PatternBuilder.pattern("Char.plus|minus|times|div|mod(Int|Short|Byte|Double|Float)").apply(descriptor2)) {
            return new WithCharAsFirstOperandFunctionIntrinsic(result2);
        }
        if (PatternBuilder.pattern("Int|Short|Byte|Double|Float.plus|minus|times|div|mod(Char)").apply(descriptor2)) {
            return new WithCharAsSecondOperandFunctionIntrinsic(result2);
        }
        return result2;
    }

    @NotNull
    private static JsBinaryOperator getOperator(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF", "getOperator"));
        }
        JetToken token = (JetToken)OperatorConventions.BINARY_OPERATION_NAMES.inverse().get(descriptor2.getName());
        if (token == null) {
            token = (JetToken)OperatorConventions.BOOLEAN_OPERATIONS.inverse().get(descriptor2.getName());
        }
        if (token == null) {
            assert (descriptor2.getName().asString().equals("xor"));
            JsBinaryOperator jsBinaryOperator = JsBinaryOperator.BIT_XOR;
            if (jsBinaryOperator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF", "getOperator"));
            }
            return jsBinaryOperator;
        }
        JsBinaryOperator jsBinaryOperator = OperatorTable.getBinaryOperator(token);
        if (jsBinaryOperator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF", "getOperator"));
        }
        return jsBinaryOperator;
    }

    static {
        $VALUES = new PrimitiveBinaryOperationFIF[]{INSTANCE};
        RANGE_TO_INTRINSIC = new BinaryOperationInstrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
                if (left == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$1", "doApply"));
                }
                if (right == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$1", "doApply"));
                }
                if (context2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$1", "doApply"));
                }
                JsExpression jsExpression = JsAstUtils.numberRangeTo(left, right);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$1", "doApply"));
                }
                return jsExpression;
            }
        };
        CHAR_RANGE_TO_INTRINSIC = new BinaryOperationInstrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
                if (left == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$2", "doApply"));
                }
                if (right == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$2", "doApply"));
                }
                if (context2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$2", "doApply"));
                }
                JsExpression jsExpression = JsAstUtils.charRangeTo(left, right);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$2", "doApply"));
                }
                return jsExpression;
            }
        };
        INTEGER_DIVISION_INTRINSIC = new BinaryOperationInstrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
                if (left == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$3", "doApply"));
                }
                if (right == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$3", "doApply"));
                }
                if (context2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$3", "doApply"));
                }
                JsBinaryOperation div = new JsBinaryOperation(JsBinaryOperator.DIV, left, right);
                JsExpression jsExpression = JsAstUtils.toInt32(div);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$3", "doApply"));
                }
                return jsExpression;
            }
        };
        BUILTINS_COMPARE_TO_INTRINSIC = new BinaryOperationInstrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
                if (left == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$4", "doApply"));
                }
                if (right == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$4", "doApply"));
                }
                if (context2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$4", "doApply"));
                }
                JsExpression jsExpression = JsAstUtils.compareTo(left, right);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$4", "doApply"));
                }
                return jsExpression;
            }
        };
        PRIMITIVE_NUMBER_COMPARE_TO_INTRINSIC = new BinaryOperationInstrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
                if (left == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$5", "doApply"));
                }
                if (right == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$5", "doApply"));
                }
                if (context2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$5", "doApply"));
                }
                JsExpression jsExpression = JsAstUtils.primitiveCompareTo(left, right);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$5", "doApply"));
                }
                return jsExpression;
            }
        };
        BINARY_OPERATIONS = new NamePredicate(OperatorConventions.BINARY_OPERATION_NAMES.values());
        PRIMITIVE_NUMBERS_BINARY_OPERATIONS = PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS, BINARY_OPERATIONS);
        PRIMITIVE_NUMBERS_COMPARE_TO_OPERATIONS = PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS, "compareTo");
        INT_WITH_BIT_OPERATIONS = PatternBuilder.pattern("Int.or|and|xor|shl|shr|ushr");
        BOOLEAN_OPERATIONS = PatternBuilder.pattern("Boolean.or|and|xor");
        STRING_PLUS = PatternBuilder.pattern("String.plus");
        BINARY_BITWISE_OPERATIONS = ImmutableMap.builder().put("or", JsBinaryOperator.BIT_OR).put("and", JsBinaryOperator.BIT_AND).put("xor", JsBinaryOperator.BIT_XOR).put("shl", JsBinaryOperator.SHL).put("shr", JsBinaryOperator.SHR).put("ushr", JsBinaryOperator.SHRU).build();
        PREDICATE = Predicates.or(PRIMITIVE_NUMBERS_BINARY_OPERATIONS, BOOLEAN_OPERATIONS, STRING_PLUS, INT_WITH_BIT_OPERATIONS, PRIMITIVE_NUMBERS_COMPARE_TO_OPERATIONS);
    }

    private static class WithCharAsSecondOperandFunctionIntrinsic
    extends BinaryOperationInstrinsicBase {
        @NotNull
        private final BinaryOperationInstrinsicBase functionIntrinsic;

        private WithCharAsSecondOperandFunctionIntrinsic(@NotNull BinaryOperationInstrinsicBase functionIntrinsic) {
            if (functionIntrinsic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionIntrinsic", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$WithCharAsSecondOperandFunctionIntrinsic", "<init>"));
            }
            this.functionIntrinsic = functionIntrinsic;
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
            if (left == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$WithCharAsSecondOperandFunctionIntrinsic", "doApply"));
            }
            if (right == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$WithCharAsSecondOperandFunctionIntrinsic", "doApply"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$WithCharAsSecondOperandFunctionIntrinsic", "doApply"));
            }
            JsExpression jsExpression = this.functionIntrinsic.doApply(left, JsAstUtils.charToInt(right), context2);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$WithCharAsSecondOperandFunctionIntrinsic", "doApply"));
            }
            return jsExpression;
        }
    }

    private static class WithCharAsFirstOperandFunctionIntrinsic
    extends BinaryOperationInstrinsicBase {
        @NotNull
        private final BinaryOperationInstrinsicBase functionIntrinsic;

        private WithCharAsFirstOperandFunctionIntrinsic(@NotNull BinaryOperationInstrinsicBase functionIntrinsic) {
            if (functionIntrinsic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionIntrinsic", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$WithCharAsFirstOperandFunctionIntrinsic", "<init>"));
            }
            this.functionIntrinsic = functionIntrinsic;
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
            if (left == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$WithCharAsFirstOperandFunctionIntrinsic", "doApply"));
            }
            if (right == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$WithCharAsFirstOperandFunctionIntrinsic", "doApply"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$WithCharAsFirstOperandFunctionIntrinsic", "doApply"));
            }
            JsExpression jsExpression = this.functionIntrinsic.doApply(JsAstUtils.charToInt(left), right, context2);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$WithCharAsFirstOperandFunctionIntrinsic", "doApply"));
            }
            return jsExpression;
        }
    }

    private static class PrimitiveBinaryOperationFunctionIntrinsic
    extends BinaryOperationInstrinsicBase {
        @NotNull
        private final JsBinaryOperator operator;

        private PrimitiveBinaryOperationFunctionIntrinsic(@NotNull JsBinaryOperator operator) {
            if (operator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$PrimitiveBinaryOperationFunctionIntrinsic", "<init>"));
            }
            this.operator = operator;
        }

        @Override
        @NotNull
        public JsExpression doApply(@NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context2) {
            if (left == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$PrimitiveBinaryOperationFunctionIntrinsic", "doApply"));
            }
            if (right == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$PrimitiveBinaryOperationFunctionIntrinsic", "doApply"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$PrimitiveBinaryOperationFunctionIntrinsic", "doApply"));
            }
            JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(this.operator, left, right);
            if (jsBinaryOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$PrimitiveBinaryOperationFunctionIntrinsic", "doApply"));
            }
            return jsBinaryOperation;
        }
    }

    private static abstract class BinaryOperationInstrinsicBase
    extends FunctionIntrinsic {
        private BinaryOperationInstrinsicBase() {
        }

        @NotNull
        public abstract JsExpression doApply(@NotNull JsExpression var1, @NotNull JsExpression var2, @NotNull TranslationContext var3);

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context2) {
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$BinaryOperationInstrinsicBase", "apply"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$BinaryOperationInstrinsicBase", "apply"));
            }
            assert (receiver != null);
            assert (arguments2.size() == 1);
            JsExpression jsExpression = this.doApply(receiver, arguments2.get(0), context2);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$BinaryOperationInstrinsicBase", "apply"));
            }
            return jsExpression;
        }
    }
}

