/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.binding;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetStubbedPsiUtil;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.org.objectweb.asm.Type;

public final class PsiCodegenPredictor {
    private PsiCodegenPredictor() {
    }

    public static boolean checkPredictedNameFromPsi(@NotNull DeclarationDescriptor descriptor2, @Nullable Type nameFromDescriptors) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/binding/PsiCodegenPredictor", "checkPredictedNameFromPsi"));
        }
        PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (element instanceof JetDeclaration) {
            String classNameFromPsi = PsiCodegenPredictor.getPredefinedJvmInternalName((JetDeclaration)element);
            assert (classNameFromPsi == null || Type.getObjectType(classNameFromPsi).equals(nameFromDescriptors)) : String.format("Invalid algorithm for getting qualified name from psi! Predicted: %s, actual %s\nElement: %s", classNameFromPsi, nameFromDescriptors, element.getText());
        }
        return true;
    }

    @Nullable
    public static String getPredefinedJvmInternalName(@NotNull JetDeclaration declaration) {
        String parentInternalName;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/codegen/binding/PsiCodegenPredictor", "getPredefinedJvmInternalName"));
        }
        JetDeclaration parentDeclaration = JetStubbedPsiUtil.getContainingDeclaration(declaration);
        if (parentDeclaration != null) {
            parentInternalName = PsiCodegenPredictor.getPredefinedJvmInternalName(parentDeclaration);
            if (parentInternalName == null) {
                return null;
            }
        } else {
            JetFile containingFile = declaration.getContainingJetFile();
            if (declaration instanceof JetNamedFunction) {
                Name name = ((JetNamedFunction)declaration).getNameAsName();
                return name == null ? null : PackagePartClassUtils.getPackagePartInternalName(containingFile) + "$" + name.asString();
            }
            parentInternalName = AsmUtil.internalNameByFqNameWithoutInnerClasses(containingFile.getPackageFqName());
        }
        if (!PsiTreeUtil.instanceOf(declaration, JetClass.class, JetObjectDeclaration.class, JetNamedFunction.class, JetProperty.class) || declaration instanceof JetEnumEntry) {
            return null;
        }
        Name name = ((JetNamedDeclaration)declaration).getNameAsName();
        if (name == null) {
            return null;
        }
        if (declaration instanceof JetNamedFunction && !(parentDeclaration instanceof JetClass) && !(parentDeclaration instanceof JetObjectDeclaration)) {
            return null;
        }
        if (declaration instanceof JetProperty) {
            return parentInternalName + "$" + name.asString();
        }
        if (parentInternalName.isEmpty()) {
            return name.asString();
        }
        return parentInternalName + (parentDeclaration == null ? "/" : "$") + name.asString();
    }
}

