/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetWhenCondition;
import org.jetbrains.kotlin.psi.JetWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilPackage;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;

public final class WhenChecker {
    private WhenChecker() {
    }

    public static boolean mustHaveElse(@NotNull JetWhenExpression expression, @NotNull BindingTrace trace) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "mustHaveElse"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "mustHaveElse"));
        }
        JetType expectedType = trace.get(BindingContext.EXPECTED_EXPRESSION_TYPE, expression);
        boolean isUnit = expectedType != null && KotlinBuiltIns.isUnit(expectedType);
        boolean isStatement = BindingContextUtilPackage.isUsedAsStatement(expression, trace.getBindingContext()) && expectedType == null;
        return !isUnit && !isStatement && !WhenChecker.isWhenExhaustive(expression, trace);
    }

    public static boolean isWhenByEnum(@NotNull JetWhenExpression expression, @NotNull BindingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenByEnum"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenByEnum"));
        }
        return WhenChecker.getClassDescriptorOfTypeIfEnum(WhenChecker.whenSubjectType(expression, context2)) != null;
    }

    @Nullable
    public static ClassDescriptor getClassDescriptorOfTypeIfEnum(@Nullable JetType type2) {
        if (type2 == null) {
            return null;
        }
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        if (classDescriptor == null) {
            return null;
        }
        if (classDescriptor.getKind() != ClassKind.ENUM_CLASS || classDescriptor.getModality().isOverridable()) {
            return null;
        }
        return classDescriptor;
    }

    @Nullable
    private static JetType whenSubjectType(@NotNull JetWhenExpression expression, @NotNull BindingContext context2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "whenSubjectType"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/cfg/WhenChecker", "whenSubjectType"));
        }
        JetExpression subjectExpression = expression.getSubjectExpression();
        return subjectExpression == null ? null : context2.getType(subjectExpression);
    }

    private static boolean isWhenOnBooleanExhaustive(@NotNull JetWhenExpression expression, @NotNull BindingTrace trace) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnBooleanExhaustive"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnBooleanExhaustive"));
        }
        boolean containsFalse = false;
        boolean containsTrue = false;
        for (JetWhenEntry whenEntry : expression.getEntries()) {
            for (JetWhenCondition whenCondition : whenEntry.getConditions()) {
                if (!(whenCondition instanceof JetWhenConditionWithExpression)) continue;
                JetExpression whenExpression = ((JetWhenConditionWithExpression)whenCondition).getExpression();
                if (CompileTimeConstantUtils.canBeReducedToBooleanConstant(whenExpression, trace, true)) {
                    containsTrue = true;
                }
                if (!CompileTimeConstantUtils.canBeReducedToBooleanConstant(whenExpression, trace, false)) continue;
                containsFalse = true;
            }
        }
        return containsFalse && containsTrue;
    }

    public static boolean isWhenOnEnumExhaustive(@NotNull JetWhenExpression expression, @NotNull BindingTrace trace, @NotNull ClassDescriptor enumClassDescriptor) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnEnumExhaustive"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnEnumExhaustive"));
        }
        if (enumClassDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassDescriptor", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenOnEnumExhaustive"));
        }
        assert (DescriptorUtils.isEnumClass(enumClassDescriptor));
        boolean notEmpty = false;
        for (DeclarationDescriptor descriptor2 : enumClassDescriptor.getUnsubstitutedInnerClassesScope().getAllDescriptors()) {
            if (!DescriptorUtils.isEnumEntry(descriptor2)) continue;
            notEmpty = true;
            if (WhenChecker.containsEnumEntryCase(expression, (ClassDescriptor)descriptor2, trace)) continue;
            return false;
        }
        return notEmpty;
    }

    public static boolean isWhenExhaustive(@NotNull JetWhenExpression expression, @NotNull BindingTrace trace) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenExhaustive"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "isWhenExhaustive"));
        }
        JetType type2 = WhenChecker.whenSubjectType(expression, trace.getBindingContext());
        if (type2 == null) {
            return false;
        }
        ClassDescriptor enumClassDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum(type2);
        boolean exhaustive = enumClassDescriptor == null ? (KotlinBuiltIns.isBoolean(TypeUtils.makeNotNullable(type2)) ? WhenChecker.isWhenOnBooleanExhaustive(expression, trace) : false) : WhenChecker.isWhenOnEnumExhaustive(expression, trace, enumClassDescriptor);
        if (exhaustive && (!TypeUtils.isNullableType(type2) || WhenChecker.containsNullCase(expression, trace) || enumClassDescriptor != null && TypesPackage.isFlexible(type2))) {
            trace.record(BindingContext.EXHAUSTIVE_WHEN, expression);
            return true;
        }
        return false;
    }

    private static boolean containsEnumEntryCase(@NotNull JetWhenExpression whenExpression, @NotNull ClassDescriptor enumEntry, @NotNull BindingTrace trace) {
        if (whenExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whenExpression", "org/jetbrains/kotlin/cfg/WhenChecker", "containsEnumEntryCase"));
        }
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/cfg/WhenChecker", "containsEnumEntryCase"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "containsEnumEntryCase"));
        }
        assert (enumEntry.getKind() == ClassKind.ENUM_ENTRY);
        for (JetWhenEntry whenEntry : whenExpression.getEntries()) {
            for (JetWhenCondition condition : whenEntry.getConditions()) {
                if (!(condition instanceof JetWhenConditionWithExpression) || !WhenChecker.isCheckForEnumEntry((JetWhenConditionWithExpression)condition, enumEntry, trace)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsNullCase(@NotNull JetWhenExpression expression, @NotNull BindingTrace trace) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/cfg/WhenChecker", "containsNullCase"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "containsNullCase"));
        }
        for (JetWhenEntry entry : expression.getEntries()) {
            for (JetWhenCondition condition : entry.getConditions()) {
                JetType type2;
                if (!(condition instanceof JetWhenConditionWithExpression) || (type2 = trace.getBindingContext().getType(((JetWhenConditionWithExpression)condition).getExpression())) == null || !KotlinBuiltIns.isNothingOrNullableNothing(type2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCheckForEnumEntry(@NotNull JetWhenConditionWithExpression whenExpression, @NotNull ClassDescriptor enumEntry, @NotNull BindingTrace trace) {
        if (whenExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whenExpression", "org/jetbrains/kotlin/cfg/WhenChecker", "isCheckForEnumEntry"));
        }
        if (enumEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/kotlin/cfg/WhenChecker", "isCheckForEnumEntry"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/cfg/WhenChecker", "isCheckForEnumEntry"));
        }
        JetSimpleNameExpression reference = WhenChecker.getReference(whenExpression.getExpression());
        if (reference == null) {
            return false;
        }
        DeclarationDescriptor target = trace.get(BindingContext.REFERENCE_TARGET, reference);
        return target == enumEntry;
    }

    @Nullable
    private static JetSimpleNameExpression getReference(@Nullable JetExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof JetSimpleNameExpression) {
            return (JetSimpleNameExpression)expression;
        }
        if (expression instanceof JetQualifiedExpression) {
            return WhenChecker.getReference(((JetQualifiedExpression)expression).getSelectorExpression());
        }
        return null;
    }
}

