/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationArgumentVisitor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CompileTimeConstant;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import org.jetbrains.annotations.NotNull;

public abstract class ErrorValue
extends CompileTimeConstant<Void> {
    public ErrorValue() {
        super(null, true, false, false);
    }

    @Override
    @Deprecated
    public Void getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor2, D data2) {
        return visitor2.visitErrorValue(this, data2);
    }

    @NotNull
    public static ErrorValue create(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "kotlin/reflect/jvm/internal/impl/resolve/constants/ErrorValue", "create"));
        }
        ErrorValueWithMessage errorValueWithMessage = new ErrorValueWithMessage(message);
        if (errorValueWithMessage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/resolve/constants/ErrorValue", "create"));
        }
        return errorValueWithMessage;
    }

    public static class ErrorValueWithMessage
    extends ErrorValue {
        private final String message;

        public ErrorValueWithMessage(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "kotlin/reflect/jvm/internal/impl/resolve/constants/ErrorValue$ErrorValueWithMessage", "<init>"));
            }
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
            if (kotlinBuiltIns == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinBuiltIns", "kotlin/reflect/jvm/internal/impl/resolve/constants/ErrorValue$ErrorValueWithMessage", "getType"));
            }
            JetType jetType = ErrorUtils.createErrorType(this.message);
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/resolve/constants/ErrorValue$ErrorValueWithMessage", "getType"));
            }
            return jetType;
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

