/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFieldImpl
extends JavaStubPsiElement<PsiFieldStub>
implements Queryable,
PsiField,
PsiVariableEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiFieldImpl");
    private volatile SoftReference<PsiType> myCachedType = null;
    private volatile Object myCachedInitializerValue = null;

    public PsiFieldImpl(PsiFieldStub stub) {
        this(stub, (IStubElementType)JavaStubElementTypes.FIELD);
    }

    protected PsiFieldImpl(PsiFieldStub stub, IStubElementType type2) {
        super(stub, type2);
    }

    public PsiFieldImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.dropCached();
    }

    private void dropCached() {
        this.myCachedInitializerValue = null;
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiFieldImpl clone = (PsiFieldImpl)super.clone();
        clone.dropCached();
        return clone;
    }

    @Override
    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this, PsiSyntheticClass.class);
    }

    @Override
    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFieldImpl", "getNode"));
        }
        return compositeElement;
    }

    @Override
    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = (PsiIdentifier)this.getNode().findChildByRoleAsPsiElement(9);
        if (psiIdentifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFieldImpl", "getNameIdentifier"));
        }
        return psiIdentifier;
    }

    @Override
    @NotNull
    public String getName() {
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFieldImpl", "getName"));
            }
            return string;
        }
        String string = this.getNameIdentifier().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFieldImpl", "getName"));
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiFieldImpl", "setName"));
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            PsiType psiType;
            PsiType type2 = SoftReference.dereference(this.myCachedType);
            if (type2 != null) {
                PsiType psiType2 = type2;
                if (psiType2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFieldImpl", "getType"));
                }
                return psiType2;
            }
            String typeText = TypeInfo.createTypeText(stub.getType(true));
            try {
                type2 = JavaPsiFacade.getInstance(this.getProject()).getParserFacade().createTypeFromText(typeText, this);
                this.myCachedType = new SoftReference<PsiType>(type2);
                psiType = type2;
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
                if (null == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFieldImpl", "getType"));
                }
                return null;
            }
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFieldImpl", "getType"));
            }
            return psiType;
        }
        this.myCachedType = null;
        PsiType psiType = JavaSharedImplUtil.getType(this.getTypeElement(), this.getNameIdentifier());
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFieldImpl", "getType"));
        }
        return psiType;
    }

    @Override
    public PsiTypeElement getTypeElement() {
        PsiField firstField = this.findFirstFieldInDeclaration();
        if (firstField != this) {
            return firstField.getTypeElement();
        }
        return (PsiTypeElement)this.getNode().findChildByRoleAsPsiElement(10);
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList selfModifierList = this.getSelfModifierList();
        if (selfModifierList != null) {
            PsiModifierList psiModifierList = selfModifierList;
            if (psiModifierList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFieldImpl", "getModifierList"));
            }
            return psiModifierList;
        }
        PsiField firstField = this.findFirstFieldInDeclaration();
        if (firstField == this) {
            if (!this.isValid()) {
                throw new PsiInvalidElementAccessException(this);
            }
            PsiField lastResort = this.findFirstFieldByTree();
            if (lastResort == this) {
                throw new IllegalStateException("Missing modifier list for sequence of fields: '" + this.getText() + "'");
            }
            firstField = lastResort;
        }
        PsiModifierList psiModifierList = firstField.getModifierList();
        if (psiModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFieldImpl", "getModifierList"));
        }
        return psiModifierList;
    }

    @Nullable
    private PsiModifierList getSelfModifierList() {
        return this.getStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiFieldImpl", "hasModifierProperty"));
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    private PsiField findFirstFieldInDeclaration() {
        if (this.getSelfModifierList() != null) {
            return this;
        }
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            List<StubElement> siblings2 = stub.getParentStub().getChildrenStubs();
            int idx = siblings2.indexOf(stub);
            assert (idx >= 0);
            for (int i = idx - 1; i >= 0 && siblings2.get(i) instanceof PsiFieldStub; --i) {
                PsiFieldStub prevField = (PsiFieldStub)siblings2.get(i);
                PsiFieldImpl prevFieldPsi = (PsiFieldImpl)prevField.getPsi();
                if (prevFieldPsi.getSelfModifierList() == null) continue;
                return prevFieldPsi;
            }
        }
        return this.findFirstFieldByTree();
    }

    private PsiField findFirstFieldByTree() {
        CompositeElement treeElement = this.getNode();
        ASTNode modifierList = treeElement.findChildByRole(8);
        if (modifierList == null) {
            ASTNode prevField;
            for (prevField = treeElement.getTreePrev(); prevField != null && prevField.getElementType() != JavaElementType.FIELD; prevField = prevField.getTreePrev()) {
            }
            if (prevField == null) {
                return this;
            }
            return ((PsiFieldImpl)SourceTreeToPsiMap.treeElementToPsi(prevField)).findFirstFieldInDeclaration();
        }
        return this;
    }

    @Override
    public PsiExpression getInitializer() {
        return (PsiExpression)this.getNode().findChildByRoleAsPsiElement(21);
    }

    @Override
    public boolean hasInitializer() {
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            return stub.getInitializerText() != null;
        }
        return this.getInitializer() != null;
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(PlatformIcons.FIELD_ICON, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Nullable
    private Object _computeConstantValue(Set<PsiVariable> visitedVars) {
        PsiExpression initializer;
        Object cachedInitializerValue = this.myCachedInitializerValue;
        if (cachedInitializerValue != null && !(cachedInitializerValue instanceof PsiExpression)) {
            return cachedInitializerValue;
        }
        PsiType type2 = this.getType();
        if (!(type2 instanceof PsiPrimitiveType) && !type2.equalsToText("java.lang.String")) {
            return null;
        }
        if (cachedInitializerValue != null) {
            initializer = (PsiExpression)cachedInitializerValue;
        } else {
            PsiFieldStub stub = (PsiFieldStub)this.getStub();
            if (stub == null) {
                initializer = this.getInitializer();
                if (initializer == null) {
                    return null;
                }
            } else {
                String initializerText = stub.getInitializerText();
                if (StringUtil.isEmpty(initializerText)) {
                    return null;
                }
                if (";INITIALIZER_NOT_STORED;".equals(initializerText)) {
                    return null;
                }
                if (";INITIALIZER_TOO_LONG;".equals(initializerText)) {
                    this.getNode();
                    return this.computeConstantValue(visitedVars);
                }
                PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
                initializer = parserFacade.createExpressionFromText(initializerText, this);
            }
        }
        Object result2 = PsiConstantEvaluationHelperImpl.computeCastTo(initializer, type2, visitedVars);
        this.myCachedInitializerValue = initializer instanceof PsiLiteralExpression ? result2 : initializer;
        return result2;
    }

    @Override
    public Object computeConstantValue() {
        Object cachedInitializerValue = this.myCachedInitializerValue;
        if (cachedInitializerValue != null && !(cachedInitializerValue instanceof PsiExpression)) {
            return cachedInitializerValue;
        }
        return this.computeConstantValue(new HashSet<PsiVariable>(2));
    }

    @Override
    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        if (!this.hasModifierProperty("final")) {
            return null;
        }
        return JavaResolveCache.getInstance(this.getProject()).computeConstantValueWithCaching(this, OurConstValueComputer.INSTANCE, visitedVars);
    }

    @Override
    public boolean isDeprecated() {
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecated() || stub.hasDeprecatedAnnotation() && PsiImplUtil.isDeprecatedByAnnotation(this);
        }
        return PsiImplUtil.isDeprecatedByDocTag(this) || PsiImplUtil.isDeprecatedByAnnotation(this);
    }

    @Override
    public PsiDocComment getDocComment() {
        CompositeElement treeElement = this.getNode();
        if (this.getTypeElement() != null) {
            PsiElement element = treeElement.findChildByRoleAsPsiElement(7);
            return element instanceof PsiDocComment ? (PsiDocComment)element : null;
        }
        ASTNode prevField = treeElement.getTreePrev();
        while (prevField.getElementType() != JavaElementType.FIELD) {
            prevField = prevField.getTreePrev();
        }
        return ((PsiField)SourceTreeToPsiMap.treeElementToPsi(prevField)).getDocComment();
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
        ASTNode nextField;
        ASTNode comma;
        CheckUtil.checkWritable(this);
        PsiTypeElement type2 = this.getTypeElement();
        PsiModifierList modifierList = this.getModifierList();
        ASTNode field2 = SourceTreeToPsiMap.psiElementToTree(type2.getParent());
        while ((comma = PsiImplUtil.skipWhitespaceAndComments(field2.getTreeNext())) != null && comma.getElementType() == JavaTokenType.COMMA && (nextField = PsiImplUtil.skipWhitespaceAndComments(comma.getTreeNext())) != null && nextField.getElementType() == JavaElementType.FIELD) {
            LeafElement semicolon = Factory.createSingleLeafElement(JavaTokenType.SEMICOLON, ";", 0, 1, null, this.getManager());
            CodeEditUtil.addChild(field2, semicolon, null);
            CodeEditUtil.removeChild(comma.getTreeParent(), comma);
            PsiElement typeClone = type2.copy();
            CodeEditUtil.addChild(nextField, SourceTreeToPsiMap.psiElementToTree(typeClone), nextField.getFirstChildNode());
            PsiElement modifierListClone = modifierList.copy();
            CodeEditUtil.addChild(nextField, SourceTreeToPsiMap.psiElementToTree(modifierListClone), nextField.getFirstChildNode());
            field2 = nextField;
        }
        JavaSharedImplUtil.normalizeBrackets(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiFieldImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitField(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/PsiFieldImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/PsiFieldImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/PsiFieldImpl", "processDeclarations"));
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        return true;
    }

    @Override
    public String toString() {
        return "PsiField:" + this.getName();
    }

    @Override
    public PsiElement getOriginalElement() {
        PsiField originalField;
        PsiClass containingClass = this.getContainingClass();
        if (containingClass != null && (originalField = ((PsiClass)containingClass.getOriginalElement()).findFieldByName(this.getName(), false)) != null) {
            return originalField;
        }
        return this;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        JavaSharedImplUtil.setInitializer(this, initializer);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiFieldImpl", "getUseScope"));
        }
        return searchScope;
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/psi/impl/source/PsiFieldImpl", "putInfo"));
        }
        info.put("fieldName", this.getName());
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    private static class OurConstValueComputer
    implements JavaResolveCache.ConstValueComputer {
        private static final OurConstValueComputer INSTANCE = new OurConstValueComputer();

        private OurConstValueComputer() {
        }

        @Override
        public Object execute(@NotNull PsiVariable variable2, Set<PsiVariable> visitedVars) {
            if (variable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/impl/source/PsiFieldImpl$OurConstValueComputer", "execute"));
            }
            return ((PsiFieldImpl)variable2)._computeConstantValue(visitedVars);
        }
    }
}

