/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultJDOMExternalizer {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.DefaultJDOMExternalizer");

    public static void writeExternal(@NotNull Object data2, @NotNull Element parentNode) throws WriteExternalException {
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/util/DefaultJDOMExternalizer", "writeExternal"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/openapi/util/DefaultJDOMExternalizer", "writeExternal"));
        }
        DefaultJDOMExternalizer.writeExternal(data2, parentNode, null);
    }

    public static void writeExternal(@NotNull Object data2, @NotNull Element parentNode, @Nullable(value="null means all elements accepted") JDOMFilter filter) throws WriteExternalException {
        Field[] fields2;
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/util/DefaultJDOMExternalizer", "writeExternal"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/openapi/util/DefaultJDOMExternalizer", "writeExternal"));
        }
        for (Field field2 : fields2 = data2.getClass().getFields()) {
            Element element;
            String value;
            block24: {
                int modifiers;
                if (field2.getName().indexOf(36) >= 0 || !Modifier.isPublic(modifiers = field2.getModifiers()) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || field2.getAnnotation(Transient.class) != null) continue;
                field2.setAccessible(true);
                Class<?> type2 = field2.getType();
                if (filter != null && !filter.isAccept(field2) || field2.getDeclaringClass().getAnnotation(Transient.class) != null) continue;
                value = null;
                try {
                    if (type2.isPrimitive()) {
                        if (type2.equals(Byte.TYPE)) {
                            value = Byte.toString(field2.getByte(data2));
                        } else if (type2.equals(Short.TYPE)) {
                            value = Short.toString(field2.getShort(data2));
                        } else if (type2.equals(Integer.TYPE)) {
                            value = Integer.toString(field2.getInt(data2));
                        } else if (type2.equals(Long.TYPE)) {
                            value = Long.toString(field2.getLong(data2));
                        } else if (type2.equals(Float.TYPE)) {
                            value = Float.toString(field2.getFloat(data2));
                        } else if (type2.equals(Double.TYPE)) {
                            value = Double.toString(field2.getDouble(data2));
                        } else if (type2.equals(Character.TYPE)) {
                            value = String.valueOf(field2.getChar(data2));
                        } else {
                            if (!type2.equals(Boolean.TYPE)) continue;
                            value = Boolean.toString(field2.getBoolean(data2));
                        }
                        break block24;
                    }
                    if (type2.equals(String.class)) {
                        value = DefaultJDOMExternalizer.filterXMLCharacters((String)field2.get(data2));
                        break block24;
                    }
                    if (type2.equals(Color.class)) {
                        Color color = (Color)field2.get(data2);
                        if (color != null) {
                            value = Integer.toString(color.getRGB() & 0xFFFFFF, 16);
                        }
                        break block24;
                    }
                    if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type2)) {
                        element = new Element("option");
                        parentNode.addContent(element);
                        element.setAttribute("name", field2.getName());
                        JDOMExternalizable domValue = (JDOMExternalizable)field2.get(data2);
                        if (domValue == null) continue;
                        Element valueElement = new Element("value");
                        element.addContent(valueElement);
                        domValue.writeExternal(valueElement);
                        continue;
                    }
                    LOG.debug("Wrong field type: " + type2);
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            element = new Element("option");
            parentNode.addContent(element);
            element.setAttribute("name", field2.getName());
            if (value == null) continue;
            element.setAttribute("value", value);
        }
    }

    @Nullable
    public static String filterXMLCharacters(String value) {
        if (value != null) {
            StringBuilder builder = null;
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (Verifier.isXMLCharacter(c)) {
                    if (builder == null) continue;
                    builder.append(c);
                    continue;
                }
                if (builder != null) continue;
                builder = new StringBuilder(value.length() + 5);
                builder.append(value, 0, i);
            }
            if (builder != null) {
                value = builder.toString();
            }
        }
        return value;
    }

    public static void readExternal(@NotNull Object data2, Element parentNode) throws InvalidDataException {
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/util/DefaultJDOMExternalizer", "readExternal"));
        }
        if (parentNode == null) {
            return;
        }
        for (Element o : parentNode.getChildren("option")) {
            Element e = o;
            String fieldName = e.getAttributeValue("name");
            if (fieldName == null) {
                throw new InvalidDataException();
            }
            try {
                List<Element> children;
                Object value;
                Field field2 = data2.getClass().getField(fieldName);
                Class<?> type2 = field2.getType();
                int modifiers = field2.getModifiers();
                if ((modifiers & 1) == 0 || (modifiers & 8) != 0) continue;
                field2.setAccessible(true);
                if ((modifiers & 0x10) != 0) {
                    value = field2.get(data2);
                    if (!JDOMExternalizable.class.isInstance(value)) continue;
                    children = e.getChildren("value");
                    Iterator<Element> i$ = children.iterator();
                    while (i$.hasNext()) {
                        Element child;
                        Element valueTag = child = i$.next();
                        ((JDOMExternalizable)value).readExternal(valueTag);
                    }
                    continue;
                }
                value = e.getAttributeValue("value");
                if (type2.isPrimitive()) {
                    if (value == null) continue;
                    if (type2.equals(Byte.TYPE)) {
                        try {
                            field2.setByte(data2, Byte.parseByte((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Short.TYPE)) {
                        try {
                            field2.setShort(data2, Short.parseShort((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Integer.TYPE)) {
                        int i = DefaultJDOMExternalizer.toInt((String)value);
                        field2.setInt(data2, i);
                        continue;
                    }
                    if (type2.equals(Long.TYPE)) {
                        try {
                            field2.setLong(data2, Long.parseLong((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Float.TYPE)) {
                        try {
                            field2.setFloat(data2, Float.parseFloat((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Double.TYPE)) {
                        try {
                            field2.setDouble(data2, Double.parseDouble((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Character.TYPE)) {
                        if (((String)value).length() != 1) {
                            throw new InvalidDataException();
                        }
                        field2.setChar(data2, ((String)value).charAt(0));
                        continue;
                    }
                    if (type2.equals(Boolean.TYPE)) {
                        if (((String)value).equals("true")) {
                            field2.setBoolean(data2, true);
                            continue;
                        }
                        if (((String)value).equals("false")) {
                            field2.setBoolean(data2, false);
                            continue;
                        }
                        throw new InvalidDataException();
                    }
                    throw new InvalidDataException();
                }
                if (type2.equals(String.class)) {
                    field2.set(data2, value);
                    continue;
                }
                if (type2.equals(Color.class)) {
                    Color color = DefaultJDOMExternalizer.toColor((String)value);
                    field2.set(data2, color);
                    continue;
                }
                if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type2)) {
                    children = e.getChildren("value");
                    if (children.isEmpty()) continue;
                    JDOMExternalizable object = null;
                    Iterator<Element> i$ = children.iterator();
                    while (i$.hasNext()) {
                        Element o1;
                        Element el = o1 = i$.next();
                        object = (JDOMExternalizable)type2.newInstance();
                        object.readExternal(el);
                    }
                    field2.set(data2, object);
                    continue;
                }
                throw new InvalidDataException("wrong type: " + type2);
            }
            catch (NoSuchFieldException ex) {
                LOG.debug(ex);
            }
            catch (SecurityException ex) {
                throw new InvalidDataException();
            }
            catch (IllegalAccessException ex) {
                throw new InvalidDataException(ex);
            }
            catch (InstantiationException ex) {
                throw new InvalidDataException();
            }
        }
    }

    public static int toInt(@NotNull String value) throws InvalidDataException {
        int i;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/DefaultJDOMExternalizer", "toInt"));
        }
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException(value, ex);
        }
        return i;
    }

    public static Color toColor(@Nullable String value) throws InvalidDataException {
        Color color;
        if (value == null) {
            color = null;
        } else {
            try {
                int rgb = Integer.parseInt(value, 16);
                color = new Color(rgb);
            }
            catch (NumberFormatException ex) {
                LOG.debug("Wrong color value: " + value, ex);
                throw new InvalidDataException("Wrong color value: " + value, ex);
            }
        }
        return color;
    }

    public static interface JDOMFilter {
        public boolean isAccept(@NotNull Field var1);
    }
}

