/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extension;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtensionPointImpl<T>
implements ExtensionPoint<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.extensions.impl.ExtensionPointImpl");
    private final LogProvider myLogger;
    private final AreaInstance myArea;
    private final String myName;
    private final String myClassName;
    private final ExtensionPoint.Kind myKind;
    private final List<T> myExtensions;
    private volatile T[] myExtensionsCache;
    private final ExtensionsAreaImpl myOwner;
    private final PluginDescriptor myDescriptor;
    private final Set<ExtensionComponentAdapter> myExtensionAdapters;
    private final List<ExtensionPointListener<T>> myEPListeners;
    private final List<ExtensionComponentAdapter> myLoadedAdapters;
    private Class<T> myExtensionClass;
    private static final StringInterner INTERNER = new StringInterner();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensionPointImpl(@NotNull String name, @NotNull String className, @NotNull ExtensionPoint.Kind kind, @NotNull ExtensionsAreaImpl owner, AreaInstance area, @NotNull LogProvider logger, @NotNull PluginDescriptor descriptor2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "<init>"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "<init>"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "<init>"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "<init>"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "<init>"));
        }
        this.myExtensions = new ArrayList<T>();
        this.myExtensionAdapters = new LinkedHashSet<ExtensionComponentAdapter>();
        this.myEPListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myLoadedAdapters = new ArrayList<ExtensionComponentAdapter>();
        StringInterner stringInterner = INTERNER;
        synchronized (stringInterner) {
            this.myName = INTERNER.intern(name);
        }
        this.myClassName = className;
        this.myKind = kind;
        this.myOwner = owner;
        this.myArea = area;
        this.myLogger = logger;
        this.myDescriptor = descriptor2;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getClassName"));
        }
        return string;
    }

    @NotNull
    public ExtensionPoint.Kind getKind() {
        ExtensionPoint.Kind kind = this.myKind;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getKind"));
        }
        return kind;
    }

    @Override
    public void registerExtension(@NotNull T extension2) {
        if (extension2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtension"));
        }
        this.registerExtension(extension2, LoadingOrder.ANY);
    }

    public synchronized void registerExtension(@NotNull T extension2, @NotNull LoadingOrder order) {
        if (extension2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtension"));
        }
        if (order == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "order", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtension"));
        }
        assert (this.myExtensions.size() == this.myLoadedAdapters.size());
        ObjectComponentAdapter adapter = new ObjectComponentAdapter(extension2, order);
        if (LoadingOrder.ANY == order) {
            ExtensionComponentAdapter lastAdapter;
            int index2 = this.myLoadedAdapters.size();
            if (index2 > 0 && (lastAdapter = this.myLoadedAdapters.get(index2 - 1)).getOrder() == LoadingOrder.LAST) {
                --index2;
            }
            this.registerExtension(extension2, adapter, index2, true);
        } else {
            this.registerExtensionAdapter(adapter);
            this.processAdapters();
        }
    }

    private void registerExtension(@NotNull T extension2, @NotNull ExtensionComponentAdapter adapter, int index2, boolean runNotifications) {
        if (extension2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtension"));
        }
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtension"));
        }
        if (this.myExtensions.contains(extension2)) {
            this.myLogger.error("Extension was already added: " + extension2);
            return;
        }
        Class<T> extensionClass = this.getExtensionClass();
        if (!extensionClass.isInstance(extension2)) {
            this.myLogger.error("Extension " + extension2.getClass() + " does not implement " + extensionClass);
            return;
        }
        this.myExtensions.add(index2, extension2);
        this.myLoadedAdapters.add(index2, adapter);
        if (runNotifications) {
            this.clearCache();
            if (!adapter.isNotificationSent()) {
                if (extension2 instanceof Extension) {
                    try {
                        ((Extension)extension2).extensionAdded(this);
                    }
                    catch (Throwable e) {
                        this.myLogger.error(e);
                    }
                }
                this.notifyListenersOnAdd(extension2, adapter.getPluginDescriptor());
                adapter.setNotificationSent(true);
            }
        }
    }

    private void notifyListenersOnAdd(@NotNull T extension2, PluginDescriptor pluginDescriptor) {
        if (extension2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "notifyListenersOnAdd"));
        }
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            try {
                listener.extensionAdded(extension2, pluginDescriptor);
            }
            catch (Throwable e) {
                this.myLogger.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public T[] getExtensions() {
        Object[] result2 = this.myExtensionsCache;
        if (result2 == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                result2 = this.myExtensionsCache;
                if (result2 == null) {
                    this.processAdapters();
                    Class<T> extensionClass = this.getExtensionClass();
                    Object[] a = (Object[])Array.newInstance(extensionClass, this.myExtensions.size());
                    result2 = this.myExtensions.toArray(a);
                    for (int i = result2.length - 1; i >= 0; --i) {
                        T extension2 = result2[i];
                        if (extension2 == null) {
                            LOG.error(" null extension: " + this.myExtensions + ";\n" + " getExtensionClass(): " + extensionClass + ";\n");
                        }
                        if (i <= 0 || extension2 != result2[i - 1]) continue;
                        LOG.error("Duplicate extension found: " + extension2 + "; " + " Result:      " + Arrays.toString(result2) + ";\n" + " extensions: " + this.myExtensions + ";\n" + " getExtensionClass(): " + extensionClass + ";\n" + " size:" + this.myExtensions.size() + ";" + result2.length);
                    }
                    this.myExtensionsCache = result2;
                }
            }
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getExtensions"));
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAnyExtensions() {
        T[] cache2 = this.myExtensionsCache;
        if (cache2 != null) {
            return cache2.length > 0;
        }
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            return this.myExtensionAdapters.size() + this.myLoadedAdapters.size() > 0;
        }
    }

    private void processAdapters() {
        int totalSize = this.myExtensionAdapters.size() + this.myLoadedAdapters.size();
        if (totalSize != 0) {
            ArrayList<ExtensionComponentAdapter> adapters = ContainerUtil.newArrayListWithCapacity(totalSize);
            adapters.addAll(this.myExtensionAdapters);
            adapters.addAll(this.myLoadedAdapters);
            LoadingOrder.sort(adapters);
            this.myExtensionAdapters.clear();
            this.myExtensionAdapters.addAll(adapters);
            Set<ExtensionComponentAdapter> loaded = ContainerUtil.newHashOrEmptySet(this.myLoadedAdapters);
            this.myExtensions.clear();
            this.myLoadedAdapters.clear();
            for (ExtensionComponentAdapter adapter : adapters) {
                try {
                    Object extension2 = adapter.getExtension();
                    this.registerExtension(extension2, adapter, this.myExtensions.size(), !loaded.contains(adapter));
                    this.myExtensionAdapters.remove(adapter);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error(e);
                    this.myExtensionAdapters.remove(adapter);
                }
            }
        }
    }

    @Override
    public synchronized void unregisterExtension(@NotNull T extension2) {
        if (extension2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "unregisterExtension"));
        }
        int index2 = this.getExtensionIndex(extension2);
        ExtensionComponentAdapter adapter = this.myLoadedAdapters.get(index2);
        Object key = adapter.getComponentKey();
        this.myOwner.getPicoContainer().unregisterComponent(key);
        this.processAdapters();
        this.unregisterExtension(extension2, null);
    }

    private int getExtensionIndex(@NotNull T extension2) {
        if (extension2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getExtensionIndex"));
        }
        int i = this.myExtensions.indexOf(extension2);
        if (i == -1) {
            throw new IllegalArgumentException("Extension to be removed not found: " + extension2);
        }
        return i;
    }

    private void unregisterExtension(@NotNull T extension2, PluginDescriptor pluginDescriptor) {
        if (extension2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "unregisterExtension"));
        }
        int index2 = this.getExtensionIndex(extension2);
        this.myExtensions.remove(index2);
        this.myLoadedAdapters.remove(index2);
        this.clearCache();
        this.notifyListenersOnRemove(extension2, pluginDescriptor);
        if (extension2 instanceof Extension) {
            try {
                ((Extension)extension2).extensionRemoved(this);
            }
            catch (Throwable e) {
                this.myLogger.error(e);
            }
        }
    }

    private void notifyListenersOnRemove(@NotNull T extensionObject, PluginDescriptor pluginDescriptor) {
        if (extensionObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionObject", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "notifyListenersOnRemove"));
        }
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            try {
                listener.extensionRemoved(extensionObject, pluginDescriptor);
            }
            catch (Throwable e) {
                this.myLogger.error(e);
            }
        }
    }

    @Override
    public synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "addExtensionPointListener"));
        }
        this.processAdapters();
        if (this.myEPListeners.add(listener)) {
            for (ExtensionComponentAdapter componentAdapter : this.myLoadedAdapters.toArray(new ExtensionComponentAdapter[this.myLoadedAdapters.size()])) {
                try {
                    Object extension2 = componentAdapter.getExtension();
                    listener.extensionAdded(extension2, componentAdapter.getPluginDescriptor());
                }
                catch (Throwable e) {
                    this.myLogger.error(e);
                }
            }
        }
    }

    @Override
    public void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "removeExtensionPointListener"));
        }
        this.removeExtensionPointListener(listener, true);
    }

    private synchronized void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener, boolean invokeForLoadedExtensions) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "removeExtensionPointListener"));
        }
        if (this.myEPListeners.remove(listener) && invokeForLoadedExtensions) {
            for (ExtensionComponentAdapter componentAdapter : this.myLoadedAdapters.toArray(new ExtensionComponentAdapter[this.myLoadedAdapters.size()])) {
                try {
                    Object extension2 = componentAdapter.getExtension();
                    listener.extensionRemoved(extension2, componentAdapter.getPluginDescriptor());
                }
                catch (Throwable e) {
                    this.myLogger.error(e);
                }
            }
        }
    }

    @NotNull
    public Class<T> getExtensionClass() {
        Class<Object> extensionClass = this.myExtensionClass;
        if (extensionClass == null) {
            try {
                ClassLoader pluginClassLoader = this.myDescriptor.getPluginClassLoader();
                Class<?> extClass = pluginClassLoader == null ? Class.forName(this.myClassName) : Class.forName(this.myClassName, true, pluginClassLoader);
                this.myExtensionClass = extensionClass = extClass;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        Class<T> clazz = extensionClass;
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "getExtensionClass"));
        }
        return clazz;
    }

    public String toString() {
        return this.getName();
    }

    synchronized void registerExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "com/intellij/openapi/extensions/impl/ExtensionPointImpl", "registerExtensionAdapter"));
        }
        this.myExtensionAdapters.add(adapter);
        this.clearCache();
    }

    private void clearCache() {
        this.myExtensionsCache = null;
    }

    final synchronized void notifyAreaReplaced(ExtensionsArea area) {
        for (ExtensionPointListener<T> listener : this.myEPListeners) {
            if (!(listener instanceof ExtensionPointAndAreaListener)) continue;
            ((ExtensionPointAndAreaListener)listener).areaReplaced(area);
        }
    }

    private static class ObjectComponentAdapter
    extends ExtensionComponentAdapter {
        private final Object myExtension;
        private final LoadingOrder myLoadingOrder;

        private ObjectComponentAdapter(@NotNull Object extension2, @NotNull LoadingOrder loadingOrder) {
            if (extension2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter", "<init>"));
            }
            if (loadingOrder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadingOrder", "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter", "<init>"));
            }
            super(extension2.getClass().getName(), null, null, null, false);
            this.myExtension = extension2;
            this.myLoadingOrder = loadingOrder;
        }

        @Override
        public Object getExtension() {
            return this.myExtension;
        }

        @Override
        public LoadingOrder getOrder() {
            return this.myLoadingOrder;
        }

        @Override
        @Nullable
        public String getOrderId() {
            return null;
        }

        @Override
        @NonNls
        public Element getDescribingElement() {
            return new Element("RuntimeExtension: " + this.myExtension);
        }
    }
}

