/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.callUtil;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Sequence;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import kotlin.suppress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteralArgument;
import org.jetbrains.kotlin.psi.JetInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.JetOperationExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.psi.JetValueArgumentList;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage$psiUtils$dd8f5ed3;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage$callUtil$405fae10;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchStatus;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentUnmapped;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.types.JetType;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class CallUtilPackage$callUtil$405fae10 {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final <D extends CallableDescriptor> boolean noErrorsInValueArguments(@JetValueParameter(name="$receiver") ResolvedCall<D> $receiver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterable $receiver2 = $receiver.getCall().getValueArguments();
        Iterator iterator2 = $receiver2.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element = iterator2.next();
            ValueArgument argument = (ValueArgument)element;
            if (argument.getArgumentExpression() == null) return false;
            ValueArgument valueArgument = argument;
            if (valueArgument == null) {
                Intrinsics.throwNpe();
            }
            if ($receiver.getArgumentMapping(valueArgument).isError()) return false;
            bl = true;
        } while (bl);
        return false;
    }

    public static final <D extends CallableDescriptor> boolean hasUnmappedArguments(@JetValueParameter(name="$receiver") ResolvedCall<D> $receiver) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Iterable $receiver2 = $receiver.getCall().getValueArguments();
            for (Object element : $receiver2) {
                ValueArgument argument;
                ValueArgument valueArgument = argument = (ValueArgument)element;
                if (valueArgument == null) {
                    Intrinsics.throwNpe();
                }
                if (!Intrinsics.areEqual($receiver.getArgumentMapping(valueArgument), ArgumentUnmapped.INSTANCE$)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public static final <D extends CallableDescriptor> boolean hasUnmappedParameters(@JetValueParameter(name="$receiver") ResolvedCall<D> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Map<ValueParameterDescriptor, ResolvedValueArgument> parameterToArgumentMap = $receiver.getValueArguments();
        Set<ValueParameterDescriptor> set = parameterToArgumentMap.keySet();
        Collection collection = $receiver.getResultingDescriptor().getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(collection, "getResultingDescriptor().getValueParameters()");
        return !set.containsAll(collection);
    }

    public static final <D extends CallableDescriptor> boolean hasTypeMismatchErrorOnParameter(@JetValueParameter(name="$receiver") ResolvedCall<D> $receiver, @JetValueParameter(name="parameter") @NotNull ValueParameterDescriptor parameter) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Intrinsics.checkParameterIsNotNull(parameter, "parameter");
            ResolvedValueArgument resolvedValueArgument = $receiver.getValueArguments().get(parameter);
            if (resolvedValueArgument == null) {
                return true;
            }
            Iterable $receiver2 = resolvedValueArgument.getArguments();
            for (Object element : $receiver2) {
                ValueArgument argument = (ValueArgument)element;
                ArgumentMapping argumentMapping = $receiver.getArgumentMapping(argument);
                if (!(argumentMapping instanceof ArgumentMatch && Intrinsics.areEqual((Object)((ArgumentMatch)argumentMapping).getStatus(), (Object)ArgumentMatchStatus.TYPE_MISMATCH))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final <D extends CallableDescriptor> ValueParameterDescriptor getParameterForArgument(@JetValueParameter(name="$receiver") ResolvedCall<D> $receiver, @JetValueParameter(name="valueArgument", type="?") @Nullable ValueArgument valueArgument) {
        ArgumentMapping argumentMapping;
        ArgumentMapping argumentMapping2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ValueArgument valueArgument2 = valueArgument;
        if (valueArgument2 != null) {
            ValueArgument $receiver2 = valueArgument2;
            ValueArgument it2 = $receiver2;
            argumentMapping2 = $receiver.getArgumentMapping(it2);
        } else {
            argumentMapping2 = argumentMapping = null;
        }
        if (!(argumentMapping2 instanceof ArgumentMatch)) {
            argumentMapping = null;
        }
        ArgumentMatch argumentMatch = (ArgumentMatch)argumentMapping;
        return argumentMatch != null ? argumentMatch.getValueParameter() : null;
    }

    /*
     * WARNING - void declaration
     */
    public static final <C extends ResolutionContext<C>> boolean hasUnresolvedArguments(@JetValueParameter(name="$receiver") Call $receiver, @JetValueParameter(name="context") @NotNull ResolutionContext<C> context2) {
        boolean bl;
        block4: {
            void destination;
            void $receiver2;
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Intrinsics.checkParameterIsNotNull(context2, "context");
            Iterable $receiver3 = $receiver.getValueArguments();
            Iterable iterable = $receiver3;
            Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault($receiver3, 10));
            for (Object item : $receiver2) {
                void it2;
                ValueArgument valueArgument = (ValueArgument)item;
                void var9_8 = destination;
                JetExpression jetExpression = it2.getArgumentExpression();
                var9_8.add(jetExpression);
            }
            List arguments2 = (List)destination;
            $receiver3 = arguments2;
            for (Object element : $receiver3) {
                boolean bl2;
                JetExpression argument = (JetExpression)element;
                if (argument == null || ArgumentTypeResolver.isFunctionLiteralArgument(argument, context2)) {
                    bl2 = false;
                } else {
                    JetType expressionType;
                    JetElement jetElement = argument;
                    BindingContext bindingContext = context2.trace.getBindingContext();
                    Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.getBindingContext()");
                    MutableResolvedCall resolvedCall = (MutableResolvedCall)CallUtilPackage$callUtil$405fae10.getResolvedCall(jetElement, bindingContext);
                    bl2 = resolvedCall != null && !resolvedCall.hasInferredReturnType() ? false : (expressionType = context2.trace.getBindingContext().getType(argument)) == null || expressionType.isError();
                }
                if (!bl2) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final List<ValueArgument> getValueArgumentsInParentheses(@JetValueParameter(name="$receiver") Call $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return CallUtilPackage$callUtil$405fae10.filterArgsInParentheses($receiver.getValueArguments());
    }

    @NotNull
    public static final List<ValueArgument> getValueArgumentsInParentheses(@JetValueParameter(name="$receiver") JetCallElement $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return CallUtilPackage$callUtil$405fae10.filterArgsInParentheses($receiver.getValueArguments());
    }

    @NotNull
    public static final JetElement getValueArgumentListOrElement(@JetValueParameter(name="$receiver") Call $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        JetValueArgumentList jetValueArgumentList = $receiver.getValueArgumentList();
        JetElement jetElement = jetValueArgumentList != null ? (JetElement)jetValueArgumentList : (JetElement)$receiver.getCalleeExpression();
        if (jetElement == null) {
            jetElement = $receiver.getCallElement();
        }
        return jetElement;
    }

    /*
     * WARNING - void declaration
     */
    @suppress(names={"UNCHECKED_CAST"})
    @NotNull
    public static final List<ValueArgument> filterArgsInParentheses(@JetValueParameter(name="$receiver") List<? extends ValueArgument> $receiver) {
        void var3_3;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Iterable $receiver3 = $receiver;
        Iterable iterable = $receiver3;
        Collection destination = new ArrayList();
        for (Object element : $receiver2) {
            ValueArgument it2 = (ValueArgument)element;
            if (!(!(it2 instanceof JetFunctionLiteralArgument))) continue;
            destination.add(element);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ValueArgument getValueArgumentForExpression(@JetValueParameter(name="$receiver") Call $receiver, @JetValueParameter(name="expression") @NotNull JetExpression expression) {
        Object v1;
        block1: {
            void $receiver2;
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            getValueArgumentForExpression.1 deparenthesizeStructurally$ = getValueArgumentForExpression.1.INSTANCE$;
            Function1<JetElement, Boolean> isParenthesizedExpression$ = new Function1<JetElement, Boolean>(expression){
                final /* synthetic */ JetExpression $expression;

                public final boolean invoke(@JetValueParameter(name="$receiver") JetElement $receiver) {
                    boolean bl;
                    block1: {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        Sequence<JetElement> $receiver2 = KotlinPackage.sequence($receiver, (Function1)getValueArgumentForExpression.1.INSTANCE$);
                        Iterator<T> iterator2 = $receiver2.iterator();
                        while (iterator2.hasNext()) {
                            T element = iterator2.next();
                            JetElement it2 = (JetElement)element;
                            if (!Intrinsics.areEqual(it2, this.$expression)) continue;
                            bl = true;
                            break block1;
                        }
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.$expression = jetExpression;
                    super(1);
                }
            };
            Iterable iterable = $receiver.getValueArguments();
            for (Object element : $receiver2) {
                ValueArgument it2 = (ValueArgument)element;
                Object object = it2;
                if (!(object != null && (object = object.getArgumentExpression()) != null ? isParenthesizedExpression$.invoke((JetElement)object) : false)) continue;
                v1 = element;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public static final JetExpression getCalleeExpressionIfAny(@JetValueParameter(name="$receiver", type="?") JetElement $receiver) {
        JetElement element = $receiver instanceof JetExpression ? (JetElement)JetPsiUtil.deparenthesize((JetExpression)$receiver, false) : $receiver;
        JetElement jetElement = element;
        return jetElement instanceof JetSimpleNameExpression ? (JetExpression)element : (jetElement instanceof JetCallElement ? ((JetCallElement)element).getCalleeExpression() : (jetElement instanceof JetQualifiedExpression ? CallUtilPackage$callUtil$405fae10.getCalleeExpressionIfAny(((JetQualifiedExpression)element).getSelectorExpression()) : (jetElement instanceof JetOperationExpression ? (JetExpression)((JetOperationExpression)element).getOperationReference() : (JetExpression)null)));
    }

    @Nullable
    public static final Call getCall(@JetValueParameter(name="$receiver") JetElement $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        JetExpression reference;
        JetExpression jetExpression;
        JetElement element;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        JetElement jetElement = element = $receiver instanceof JetExpression ? (JetElement)JetPsiUtil.deparenthesize((JetExpression)$receiver) : $receiver;
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JetInstanceExpressionWithLabel) {
            JetExpression jetExpression2 = (JetExpression)parent;
            jetExpression = jetExpression2;
            Intrinsics.checkExpressionValueIsNotNull(jetExpression2, "parent");
        } else if (parent instanceof JetUserType) {
            PsiElement psiElement = ((JetUserType)parent).getParent();
            PsiElement psiElement2 = psiElement != null ? psiElement.getParent() : null;
            if (!(psiElement2 instanceof JetConstructorCalleeExpression)) {
                psiElement2 = null;
            }
            jetExpression = (JetConstructorCalleeExpression)psiElement2;
        } else {
            jetExpression = reference = CallUtilPackage$callUtil$405fae10.getCalleeExpressionIfAny(element);
        }
        if (reference != null) {
            return (Call)context2.get(BindingContext.CALL, reference);
        }
        return (Call)context2.get(BindingContext.CALL, element);
    }

    @Nullable
    public static final Call getParentCall(@JetValueParameter(name="$receiver") JetElement $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2, @JetValueParameter(name="strict") boolean strict) {
        JetElement parent;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Class[] callExpressionTypes = new Class[]{JetSimpleNameExpression.class, JetCallElement.class, JetBinaryExpression.class, JetUnaryExpression.class, JetArrayAccessExpression.class};
        JetElement jetElement = parent = strict ? (JetElement)PsiTreeUtil.getParentOfType((PsiElement)$receiver, callExpressionTypes) : (JetElement)PsiTreeUtil.getNonStrictParentOfType($receiver, callExpressionTypes);
        return jetElement != null ? CallUtilPackage$callUtil$405fae10.getCall(jetElement, context2) : null;
    }

    @Nullable
    public static /* synthetic */ Call getParentCall$default(JetElement jetElement, BindingContext bindingContext, boolean bl, int n) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return CallUtilPackage$callUtil$405fae10.getParentCall(jetElement, bindingContext, bl);
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCall(@JetValueParameter(name="$receiver", type="?") Call $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        return (ResolvedCall)context2.get(BindingContext.RESOLVED_CALL, $receiver);
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCall(@JetValueParameter(name="$receiver", type="?") JetElement $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Object object = $receiver;
        return object != null && (object = CallUtilPackage$callUtil$405fae10.getCall((JetElement)object, context2)) != null ? CallUtilPackage$callUtil$405fae10.getResolvedCall((Call)object, context2) : null;
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> getParentResolvedCall(@JetValueParameter(name="$receiver", type="?") JetElement $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2, @JetValueParameter(name="strict") boolean strict) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Object object = $receiver;
        return object != null && (object = CallUtilPackage$callUtil$405fae10.getParentCall((JetElement)object, context2, strict)) != null ? CallUtilPackage$callUtil$405fae10.getResolvedCall((Call)object, context2) : null;
    }

    @Nullable
    public static /* synthetic */ ResolvedCall getParentResolvedCall$default(JetElement jetElement, BindingContext bindingContext, boolean bl, int n) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return CallUtilPackage$callUtil$405fae10.getParentResolvedCall(jetElement, bindingContext, bl);
    }

    @NotNull
    public static final Call getCallWithAssert(@JetValueParameter(name="$receiver") JetElement $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        Call $receiver2 = CallUtilPackage$callUtil$405fae10.getCall($receiver, context2);
        Call call = $receiver2;
        if (call == null) {
            AssertionError assertionError;
            AssertionError assertionError2 = assertionError;
            AssertionError assertionError3 = assertionError;
            String string = "No call for " + PsiUtilPackage$psiUtils$dd8f5ed3.getTextWithLocation($receiver);
            assertionError2((Object)string);
            throw (Throwable)((Object)assertionError3);
        }
        return call;
    }

    @NotNull
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCallWithAssert(@JetValueParameter(name="$receiver") JetElement $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        ResolvedCall<? extends CallableDescriptor> $receiver2 = CallUtilPackage$callUtil$405fae10.getResolvedCall($receiver, context2);
        ResolvedCall<? extends CallableDescriptor> resolvedCall = $receiver2;
        if (resolvedCall == null) {
            AssertionError assertionError;
            AssertionError assertionError2 = assertionError;
            AssertionError assertionError3 = assertionError;
            String string = "No resolved call for " + PsiUtilPackage$psiUtils$dd8f5ed3.getTextWithLocation($receiver);
            assertionError2((Object)string);
            throw (Throwable)((Object)assertionError3);
        }
        return resolvedCall;
    }

    @NotNull
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCallWithAssert(@JetValueParameter(name="$receiver") Call $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        ResolvedCall<? extends CallableDescriptor> $receiver2 = CallUtilPackage$callUtil$405fae10.getResolvedCall($receiver, context2);
        ResolvedCall<? extends CallableDescriptor> resolvedCall = $receiver2;
        if (resolvedCall == null) {
            AssertionError assertionError;
            AssertionError assertionError2 = assertionError;
            AssertionError assertionError3 = assertionError;
            String string = "No resolved call for " + PsiUtilPackage$psiUtils$dd8f5ed3.getTextWithLocation($receiver.getCallElement());
            assertionError2((Object)string);
            throw (Throwable)((Object)assertionError3);
        }
        return resolvedCall;
    }

    @NotNull
    public static final ResolvedCall<? extends FunctionDescriptor> getFunctionResolvedCallWithAssert(@JetValueParameter(name="$receiver") JetExpression $receiver, @JetValueParameter(name="context") @NotNull BindingContext context2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage$callUtil$405fae10.getResolvedCallWithAssert($receiver, context2);
        boolean value = resolvedCall.getResultingDescriptor() instanceof FunctionDescriptor;
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
            String message = "ResolvedCall for this expression must be ResolvedCall<? extends FunctionDescriptor>: " + PsiUtilPackage$psiUtils$dd8f5ed3.getTextWithLocation($receiver);
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = resolvedCall;
        if (resolvedCall2 == null) {
            throw new TypeCastException("org.jetbrains.kotlin.resolve.calls.model.ResolvedCall<out org.jetbrains.kotlin.descriptors.CallableDescriptor> cannot be cast to org.jetbrains.kotlin.resolve.calls.model.ResolvedCall<out org.jetbrains.kotlin.descriptors.FunctionDescriptor>");
        }
        return resolvedCall2;
    }

    public static final boolean isSafeCall(@JetValueParameter(name="$receiver") Call $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver instanceof CallTransformer.CallForImplicitInvoke && CallUtilPackage$callUtil$405fae10.isExplicitSafeCall(((CallTransformer.CallForImplicitInvoke)$receiver).getOuterCall())) {
            return true;
        }
        return CallUtilPackage$callUtil$405fae10.isExplicitSafeCall($receiver);
    }

    public static final boolean isExplicitSafeCall(@JetValueParameter(name="$receiver") Call $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ASTNode aSTNode = $receiver.getCallOperationNode();
        return Intrinsics.areEqual(aSTNode != null ? aSTNode.getElementType() : null, JetTokens.SAFE_ACCESS);
    }
}

