/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.google.common.collect.Lists;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.JetConstructorDelegationCall;
import org.jetbrains.kotlin.psi.JetConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.resolve.AdditionalCheckerProvider;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilPackage;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CallResolverUtil;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionResultsHandler;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.kotlin.resolve.calls.tasks.TaskPrioritizer;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyForImplicitConstructorDelegationCall;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyForInvoke;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyImpl;
import org.jetbrains.kotlin.resolve.calls.tasks.collectors.CallableDescriptorCollectors;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public class CallResolver {
    private ExpressionTypingServices expressionTypingServices;
    private TypeResolver typeResolver;
    private CandidateResolver candidateResolver;
    private ArgumentTypeResolver argumentTypeResolver;
    private CallCompleter callCompleter;
    private TaskPrioritizer taskPrioritizer;
    private AdditionalCheckerProvider additionalCheckerProvider;

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/calls/CallResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        if (typeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolver", "org/jetbrains/kotlin/resolve/calls/CallResolver", "setTypeResolver"));
        }
        this.typeResolver = typeResolver;
    }

    @Inject
    public void setCandidateResolver(@NotNull CandidateResolver candidateResolver) {
        if (candidateResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateResolver", "org/jetbrains/kotlin/resolve/calls/CallResolver", "setCandidateResolver"));
        }
        this.candidateResolver = candidateResolver;
    }

    @Inject
    public void setArgumentTypeResolver(@NotNull ArgumentTypeResolver argumentTypeResolver) {
        if (argumentTypeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypeResolver", "org/jetbrains/kotlin/resolve/calls/CallResolver", "setArgumentTypeResolver"));
        }
        this.argumentTypeResolver = argumentTypeResolver;
    }

    @Inject
    public void setCallCompleter(@NotNull CallCompleter callCompleter) {
        if (callCompleter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callCompleter", "org/jetbrains/kotlin/resolve/calls/CallResolver", "setCallCompleter"));
        }
        this.callCompleter = callCompleter;
    }

    @Inject
    public void setTaskPrioritizer(@NotNull TaskPrioritizer taskPrioritizer) {
        if (taskPrioritizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskPrioritizer", "org/jetbrains/kotlin/resolve/calls/CallResolver", "setTaskPrioritizer"));
        }
        this.taskPrioritizer = taskPrioritizer;
    }

    @Inject
    public void setAdditionalCheckerProvider(AdditionalCheckerProvider additionalCheckerProvider) {
        this.additionalCheckerProvider = additionalCheckerProvider;
    }

    @NotNull
    public OverloadResolutionResults<VariableDescriptor> resolveSimpleProperty(@NotNull BasicCallResolutionContext context2) {
        CallableDescriptorCollectors<VariableDescriptor> callableDescriptorCollectors;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveSimpleProperty"));
        }
        JetExpression calleeExpression = context2.call.getCalleeExpression();
        assert (calleeExpression instanceof JetSimpleNameExpression);
        JetSimpleNameExpression nameExpression = (JetSimpleNameExpression)calleeExpression;
        Name referencedName = nameExpression.getReferencedNameAsName();
        if (nameExpression.getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER) {
            referencedName = Name.identifier(referencedName.asString().substring(1));
            callableDescriptorCollectors = CallableDescriptorCollectors.PROPERTIES;
        } else {
            callableDescriptorCollectors = CallableDescriptorCollectors.VARIABLES;
        }
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context2, referencedName, nameExpression, callableDescriptorCollectors, CallTransformer.VARIABLE_CALL_TRANSFORMER);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveSimpleProperty"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<CallableDescriptor> resolveCallForMember(@NotNull JetSimpleNameExpression nameExpression, @NotNull BasicCallResolutionContext context2) {
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForMember"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForMember"));
        }
        OverloadResolutionResults<CallableDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context2, nameExpression.getReferencedNameAsName(), nameExpression, CallableDescriptorCollectors.FUNCTIONS_AND_VARIABLES, CallTransformer.MEMBER_CALL_TRANSFORMER);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForMember"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull ExpressionTypingContext context2, @NotNull Call call, @NotNull JetReferenceExpression functionReference, @NotNull Name name) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (functionReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionReference", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context2, call, CheckValueArgumentsMode.ENABLED);
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(callResolutionContext, name, functionReference, CallableDescriptorCollectors.FUNCTIONS_AND_VARIABLES, CallTransformer.FUNCTION_CALL_TRANSFORMER);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithGivenName"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallForInvoke(@NotNull BasicCallResolutionContext context2, @NotNull TracingStrategy tracing) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForInvoke"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForInvoke"));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context2, OperatorConventions.INVOKE, tracing, CallableDescriptorCollectors.FUNCTIONS, CallTransformer.FUNCTION_CALL_TRANSFORMER);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForInvoke"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResults<F> computeTasksAndResolveCall(@NotNull BasicCallResolutionContext context2, @NotNull Name name, @NotNull JetReferenceExpression referenceExpression, @NotNull CallableDescriptorCollectors<D> collectors, @NotNull CallTransformer<D, F> callTransformer) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (collectors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectors", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        TracingStrategy tracing = TracingStrategyImpl.create(referenceExpression, context2.call);
        OverloadResolutionResults<F> overloadResolutionResults = this.computeTasksAndResolveCall(context2, name, tracing, collectors, callTransformer);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResults<F> computeTasksAndResolveCall(@NotNull BasicCallResolutionContext context2, @NotNull Name name, @NotNull TracingStrategy tracing, @NotNull CallableDescriptorCollectors<D> collectors, @NotNull CallTransformer<D, F> callTransformer) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (collectors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectors", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        List tasks = this.taskPrioritizer.computePrioritizedTasks(context2, name, tracing, collectors);
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = this.doResolveCallOrGetCachedResults(context2, tasks, callTransformer, tracing);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksAndResolveCall"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResults<F> computeTasksFromCandidatesAndResolvedCall(@NotNull BasicCallResolutionContext context2, @NotNull JetReferenceExpression referenceExpression, @NotNull Collection<ResolutionCandidate<D>> candidates, @NotNull CallTransformer<D, F> callTransformer) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        OverloadResolutionResults<F> overloadResolutionResults = this.computeTasksFromCandidatesAndResolvedCall(context2, candidates, callTransformer, TracingStrategyImpl.create(referenceExpression, context2.call));
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResults<F> computeTasksFromCandidatesAndResolvedCall(@NotNull BasicCallResolutionContext context2, @NotNull Collection<ResolutionCandidate<D>> candidates, @NotNull CallTransformer<D, F> callTransformer, @NotNull TracingStrategy tracing) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        List prioritizedTasks = this.taskPrioritizer.computePrioritizedTasksFromCandidates(context2, candidates, tracing);
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = this.doResolveCallOrGetCachedResults(context2, prioritizedTasks, callTransformer, tracing);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "computeTasksFromCandidatesAndResolvedCall"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveBinaryCall(ExpressionTypingContext context2, ExpressionReceiver receiver, JetBinaryExpression binaryExpression, Name name) {
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallWithGivenName(context2, CallMaker.makeCall((ReceiverValue)receiver, binaryExpression), binaryExpression.getOperationReference(), name);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveBinaryCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BindingTrace trace, @NotNull JetScope scope2, @NotNull Call call, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, boolean isAnnotationContext) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveFunctionCall(BasicCallResolutionContext.create(trace, scope2, call, expectedType, dataFlowInfo, ContextDependency.INDEPENDENT, CheckValueArgumentsMode.ENABLED, this.additionalCheckerProvider.getCallChecker(), this.additionalCheckerProvider.getSymbolUsageValidator(), this.additionalCheckerProvider.getTypeChecker(), isAnnotationContext));
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BasicCallResolutionContext context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        ProgressIndicatorProvider.checkCanceled();
        JetExpression calleeExpression = context2.call.getCalleeExpression();
        if (calleeExpression instanceof JetSimpleNameExpression) {
            JetSimpleNameExpression expression = (JetSimpleNameExpression)calleeExpression;
            OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context2, expression.getReferencedNameAsName(), expression, CallableDescriptorCollectors.FUNCTIONS_AND_VARIABLES, CallTransformer.FUNCTION_CALL_TRANSFORMER);
            if (overloadResolutionResults == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
            }
            return overloadResolutionResults;
        }
        if (calleeExpression instanceof JetConstructorCalleeExpression) {
            OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallForConstructor(context2, (JetConstructorCalleeExpression)calleeExpression);
            if (overloadResolutionResults == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
            }
            return overloadResolutionResults;
        }
        if (calleeExpression == null) {
            OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context2);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
            }
            return overloadResolutionResultsImpl;
        }
        JetType calleeType = this.expressionTypingServices.safeGetType(context2.scope, calleeExpression, TypeUtils.NO_EXPECTED_TYPE, context2.dataFlowInfo, context2.trace);
        ExpressionReceiver expressionReceiver = new ExpressionReceiver(calleeExpression, calleeType);
        CallTransformer.CallForImplicitInvoke call = new CallTransformer.CallForImplicitInvoke(context2.call.getExplicitReceiver(), expressionReceiver, context2.call);
        TracingStrategyForInvoke tracingForInvoke = new TracingStrategyForInvoke(calleeExpression, call, calleeType);
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallForInvoke(context2.replaceCall(call), tracingForInvoke);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveFunctionCall"));
        }
        return overloadResolutionResults;
    }

    private OverloadResolutionResults<FunctionDescriptor> resolveCallForConstructor(@NotNull BasicCallResolutionContext context2, @NotNull JetConstructorCalleeExpression expression) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForConstructor"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallForConstructor"));
        }
        assert (!context2.call.getExplicitReceiver().exists()) : "Constructor can't be invoked with explicit receiver: " + context2.call.getCallElement().getText();
        JetSimpleNameExpression functionReference = expression.getConstructorReferenceExpression();
        JetTypeReference typeReference = expression.getTypeReference();
        if (functionReference == null || typeReference == null) {
            return this.checkArgumentTypesAndFail(context2);
        }
        JetType constructedType = this.typeResolver.resolveType(context2.scope, typeReference, context2.trace, true);
        if (constructedType.isError()) {
            return this.checkArgumentTypesAndFail(context2);
        }
        ClassifierDescriptor declarationDescriptor = constructedType.getConstructor().getDeclarationDescriptor();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            context2.trace.report(Errors.NOT_A_CLASS.on(expression));
            return this.checkArgumentTypesAndFail(context2);
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        Collection<ConstructorDescriptor> constructors2 = classDescriptor.getConstructors();
        if (constructors2.isEmpty()) {
            context2.trace.report(Errors.NO_CONSTRUCTOR.on(CallUtilPackage.getValueArgumentListOrElement(context2.call)));
            return this.checkArgumentTypesAndFail(context2);
        }
        Collection candidates = this.taskPrioritizer.convertWithImpliedThisAndNoReceiver(context2.scope, constructors2, context2.call);
        return this.computeTasksFromCandidatesAndResolvedCall(context2, functionReference, candidates, CallTransformer.FUNCTION_CALL_TRANSFORMER);
    }

    @Nullable
    public OverloadResolutionResults<FunctionDescriptor> resolveConstructorDelegationCall(@NotNull BindingTrace trace, @NotNull JetScope scope2, @NotNull DataFlowInfo dataFlowInfo, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull JetConstructorDelegationCall call, @NotNull CallChecker callChecker) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (constructorDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorDescriptor", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (callChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callChecker", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        BasicCallResolutionContext context2 = BasicCallResolutionContext.create(trace, scope2, CallMaker.makeCall(ReceiverValue.NO_RECEIVER, null, call), TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, ContextDependency.INDEPENDENT, CheckValueArgumentsMode.ENABLED, callChecker, this.additionalCheckerProvider.getSymbolUsageValidator(), this.additionalCheckerProvider.getTypeChecker(), false);
        if (call.getCalleeExpression() == null) {
            return this.checkArgumentTypesAndFail(context2);
        }
        if (constructorDescriptor.getContainingDeclaration().getKind() == ClassKind.ENUM_CLASS && call.isImplicit()) {
            return null;
        }
        return this.resolveConstructorDelegationCall(context2, call, call.getCalleeExpression(), constructorDescriptor);
    }

    @NotNull
    private OverloadResolutionResults<FunctionDescriptor> resolveConstructorDelegationCall(@NotNull BasicCallResolutionContext context2, @NotNull JetConstructorDelegationCall call, @NotNull JetConstructorDelegationReferenceExpression calleeExpression, @NotNull ConstructorDescriptor calleeConstructor) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (calleeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeExpression", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        if (calleeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calleeConstructor", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        ClassDescriptor currentClassDescriptor = calleeConstructor.getContainingDeclaration();
        boolean isThisCall = calleeExpression.isThis();
        if (currentClassDescriptor.getKind() == ClassKind.ENUM_CLASS && !isThisCall) {
            context2.trace.report(Errors.DELEGATION_SUPER_CALL_IN_ENUM_CONSTRUCTOR.on(calleeExpression));
            OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context2);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
            }
            return overloadResolutionResultsImpl;
        }
        ClassDescriptor delegateClassDescriptor = isThisCall ? currentClassDescriptor : DescriptorUtilPackage.getSuperClassOrAny(currentClassDescriptor);
        Collection<ConstructorDescriptor> constructors2 = delegateClassDescriptor.getConstructors();
        if (!isThisCall && currentClassDescriptor.getUnsubstitutedPrimaryConstructor() != null) {
            if (DescriptorUtils.canHaveDeclaredConstructors(currentClassDescriptor)) {
                context2.trace.report(Errors.PRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED.on((JetConstructorDelegationCall)calleeExpression.getParent()));
            }
            if (call.isImplicit()) {
                OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.nameNotFound();
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
                }
                return overloadResolutionResultsImpl;
            }
        }
        if (constructors2.isEmpty()) {
            context2.trace.report(Errors.NO_CONSTRUCTOR.on(CallUtilPackage.getValueArgumentListOrElement(context2.call)));
            OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context2);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
            }
            return overloadResolutionResultsImpl;
        }
        ArrayList candidates = Lists.newArrayList();
        ReceiverValue constructorDispatchReceiver = !delegateClassDescriptor.isInner() ? ReceiverValue.NO_RECEIVER : ((ClassDescriptor)delegateClassDescriptor.getContainingDeclaration()).getThisAsReceiverParameter().getValue();
        JetType expectedType = isThisCall ? calleeConstructor.getContainingDeclaration().getDefaultType() : DescriptorUtils.getSuperClassType(currentClassDescriptor);
        TypeSubstitutor knownTypeParametersSubstitutor = TypeSubstitutor.create(expectedType);
        for (ConstructorDescriptor descriptor2 : constructors2) {
            candidates.add(ResolutionCandidate.create(context2.call, descriptor2, constructorDispatchReceiver, ReceiverValue.NO_RECEIVER, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, knownTypeParametersSubstitutor));
        }
        TracingStrategy tracing = call.isImplicit() ? new TracingStrategyForImplicitConstructorDelegationCall(call, context2.call) : TracingStrategyImpl.create(calleeExpression, context2.call);
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksFromCandidatesAndResolvedCall(context2, candidates, CallTransformer.FUNCTION_CALL_TRANSFORMER, tracing);
        if (overloadResolutionResults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveConstructorDelegationCall"));
        }
        return overloadResolutionResults;
    }

    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithKnownCandidate(@NotNull Call call, @NotNull TracingStrategy tracing, @NotNull ResolutionContext<?> context2, @NotNull ResolutionCandidate<CallableDescriptor> candidate, @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/kotlin/resolve/calls/CallResolver", "resolveCallWithKnownCandidate"));
        }
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context2, call, CheckValueArgumentsMode.ENABLED, dataFlowInfoForArguments);
        List tasks = this.taskPrioritizer.computePrioritizedTasksFromCandidates(basicCallResolutionContext, Collections.singleton(candidate), tracing);
        return this.doResolveCallOrGetCachedResults(basicCallResolutionContext, tasks, CallTransformer.FUNCTION_CALL_TRANSFORMER, tracing);
    }

    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> doResolveCallOrGetCachedResults(@NotNull BasicCallResolutionContext context2, @NotNull List<ResolutionTask<D, F>> prioritizedTasks, @NotNull CallTransformer<D, F> callTransformer, @NotNull TracingStrategy tracing) {
        ResolutionResultsCache.CachedData data2;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        if (prioritizedTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prioritizedTasks", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCallOrGetCachedResults"));
        }
        Call call = context2.call;
        tracing.bindCall(context2.trace, call);
        OverloadResolutionResultsImpl<Object> results = null;
        TemporaryBindingTrace traceToResolveCall = TemporaryBindingTrace.create(context2.trace, "trace to resolve call", call);
        if (!CallResolverUtil.isInvokeCallOnVariable(call) && (data2 = context2.resolutionResultsCache.get(call)) != null) {
            DelegatingBindingTrace deltasTraceForResolve = data2.getResolutionTrace();
            deltasTraceForResolve.addAllMyDataTo(traceToResolveCall);
            results = data2.getResolutionResults();
        }
        if (results == null) {
            BasicCallResolutionContext newContext = (BasicCallResolutionContext)context2.replaceBindingTrace(traceToResolveCall);
            BindingContextUtilPackage.recordScopeAndDataFlowInfo(newContext, newContext.call.getCalleeExpression());
            results = this.doResolveCall(newContext, prioritizedTasks, callTransformer, tracing);
            DelegatingBindingTrace deltasTraceForTypeInference = results.getTrace();
            if (deltasTraceForTypeInference != null) {
                deltasTraceForTypeInference.addAllMyDataTo(traceToResolveCall);
            }
            this.completeTypeInferenceDependentOnFunctionLiterals(newContext, results, tracing);
            CallResolver.cacheResults(context2, results, traceToResolveCall, tracing);
        }
        traceToResolveCall.commit();
        if (context2.contextDependency == ContextDependency.INDEPENDENT) {
            results = this.callCompleter.completeCall(context2, results, tracing);
        }
        return results;
    }

    private <D extends CallableDescriptor> void completeTypeInferenceDependentOnFunctionLiterals(@NotNull BasicCallResolutionContext context2, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "completeTypeInferenceDependentOnFunctionLiterals"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/calls/CallResolver", "completeTypeInferenceDependentOnFunctionLiterals"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "completeTypeInferenceDependentOnFunctionLiterals"));
        }
        if (CallResolverUtil.isInvokeCallOnVariable(context2.call)) {
            return;
        }
        if (!results.isSingleResult()) {
            if (results.getResultCode() == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE) {
                this.argumentTypeResolver.checkTypesWithNoCallee(context2, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
            }
            return;
        }
        CallCandidateResolutionContext candidateContext = CallCandidateResolutionContext.createForCallBeingAnalyzed(results.getResultingCall(), context2, tracing);
        this.candidateResolver.completeTypeInferenceDependentOnFunctionLiteralsForCall(candidateContext);
    }

    private static <F extends CallableDescriptor> void cacheResults(@NotNull BasicCallResolutionContext context2, @NotNull OverloadResolutionResultsImpl<F> results, @NotNull DelegatingBindingTrace traceToResolveCall, @NotNull TracingStrategy tracing) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "cacheResults"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/calls/CallResolver", "cacheResults"));
        }
        if (traceToResolveCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceToResolveCall", "org/jetbrains/kotlin/resolve/calls/CallResolver", "cacheResults"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "cacheResults"));
        }
        Call call = context2.call;
        if (CallResolverUtil.isInvokeCallOnVariable(call)) {
            return;
        }
        DelegatingBindingTrace deltasTraceToCacheResolve = new DelegatingBindingTrace(BindingContext.EMPTY, "delta trace for caching resolve of", context2.call);
        traceToResolveCall.addAllMyDataTo(deltasTraceToCacheResolve);
        context2.resolutionResultsCache.record(call, results, context2, tracing, deltasTraceToCacheResolve);
    }

    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> checkArgumentTypesAndFail(BasicCallResolutionContext context2) {
        this.argumentTypeResolver.checkTypesWithNoCallee(context2);
        return OverloadResolutionResultsImpl.nameNotFound();
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> doResolveCall(@NotNull BasicCallResolutionContext context2, @NotNull List<ResolutionTask<D, F>> prioritizedTasks, @NotNull CallTransformer<D, F> callTransformer, @NotNull TracingStrategy tracing) {
        OverloadResolutionResultsImpl results;
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (prioritizedTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prioritizedTasks", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        if (context2.checkArguments == CheckValueArgumentsMode.ENABLED) {
            this.argumentTypeResolver.analyzeArgumentsAndRecordTypes(context2);
        }
        ArrayList allCandidates = Lists.newArrayList();
        OverloadResolutionResultsImpl<Object> successfulResults = null;
        TemporaryBindingTrace traceForFirstNonemptyCandidateSet = null;
        OverloadResolutionResultsImpl<Object> resultsForFirstNonemptyCandidateSet = null;
        for (ResolutionTask<D, F> task : prioritizedTasks) {
            boolean updateResults;
            if (task.getCandidates().isEmpty()) continue;
            TemporaryBindingTrace taskTrace = TemporaryBindingTrace.create(context2.trace, "trace to resolve a task for", task.call.getCalleeExpression());
            OverloadResolutionResultsImpl<F> results2 = this.performResolution((ResolutionTask)task.replaceBindingTrace(taskTrace), callTransformer);
            allCandidates.addAll(task.getResolvedCalls());
            if (successfulResults != null) continue;
            if (results2.isSuccess() || results2.isAmbiguity()) {
                taskTrace.commit();
                successfulResults = results2;
            }
            if (results2.getResultCode() == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE) {
                results2.setTrace(taskTrace);
                successfulResults = results2;
            }
            boolean bl = updateResults = traceForFirstNonemptyCandidateSet == null || resultsForFirstNonemptyCandidateSet.getResultCode() == OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER && results2.getResultCode() != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER;
            if (!task.getCandidates().isEmpty() && !results2.isNothing() && updateResults) {
                traceForFirstNonemptyCandidateSet = taskTrace;
                resultsForFirstNonemptyCandidateSet = results2;
            }
            if (successfulResults == null || context2.collectAllCandidates) continue;
            break;
        }
        if (successfulResults != null) {
            results = successfulResults;
        } else if (traceForFirstNonemptyCandidateSet == null) {
            tracing.unresolvedReference(context2.trace);
            this.argumentTypeResolver.checkTypesWithNoCallee(context2, CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
            results = OverloadResolutionResultsImpl.nameNotFound();
        } else {
            traceForFirstNonemptyCandidateSet.commit();
            results = resultsForFirstNonemptyCandidateSet;
        }
        results.setAllCandidates(context2.collectAllCandidates ? allCandidates : null);
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = results;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "doResolveCall"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor, F extends D> OverloadResolutionResultsImpl<F> performResolution(@NotNull ResolutionTask<D, F> task, @NotNull CallTransformer<D, F> callTransformer) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/CallResolver", "performResolution"));
        }
        if (callTransformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callTransformer", "org/jetbrains/kotlin/resolve/calls/CallResolver", "performResolution"));
        }
        for (ResolutionCandidate<D> resolutionCandidate : task.getCandidates()) {
            TemporaryBindingTrace candidateTrace = TemporaryBindingTrace.create(task.trace, "trace to resolve candidate");
            Collection<CallCandidateResolutionContext<D>> contexts = callTransformer.createCallContexts(resolutionCandidate, task, candidateTrace);
            for (CallCandidateResolutionContext<D> context2 : contexts) {
                this.candidateResolver.performResolutionForCandidateCall(context2, task);
                task.tracing.bindReference(context2.candidateCall.getTrace(), context2.candidateCall);
                Collection<MutableResolvedCall<F>> resolvedCalls = callTransformer.transformCall(context2, this, task);
                for (MutableResolvedCall<F> resolvedCall : resolvedCalls) {
                    DelegatingBindingTrace trace = resolvedCall.getTrace();
                    task.tracing.bindReference(trace, resolvedCall);
                    task.tracing.bindResolvedCall(trace, resolvedCall);
                    task.addResolvedCall(resolvedCall);
                }
            }
        }
        OverloadResolutionResultsImpl results = ResolutionResultsHandler.INSTANCE.computeResultAndReportErrors(task, task.getResolvedCalls());
        if (!results.isSingleResult() && !results.isIncomplete()) {
            this.argumentTypeResolver.checkTypesWithNoCallee(task.toBasic());
        }
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = results;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallResolver", "performResolution"));
        }
        return overloadResolutionResultsImpl;
    }
}

