/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.load.kotlin.DeserializationComponentsForJava;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.ErrorReporter;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

public final class DeserializedDescriptorResolver {
    private final ErrorReporter errorReporter;
    private DeserializationComponents components;

    public DeserializedDescriptorResolver(@NotNull ErrorReporter errorReporter) {
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "<init>"));
        }
        this.errorReporter = errorReporter;
    }

    @Inject
    public void setComponents(@NotNull DeserializationComponentsForJava context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "setComponents"));
        }
        this.components = context2.getComponents();
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull KotlinJvmBinaryClass kotlinClass) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "resolveClass"));
        }
        String[] data2 = this.readData(kotlinClass, KotlinClassHeader.Kind.CLASS);
        if (data2 != null) {
            return this.components.getClassDeserializer().deserializeClass(kotlinClass.getClassId(), JvmProtoBufUtil.readClassDataFrom(data2));
        }
        return null;
    }

    @Nullable
    public JetScope createKotlinPackageScope(@NotNull PackageFragmentDescriptor descriptor2, @NotNull KotlinJvmBinaryClass kotlinClass) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        String[] data2 = this.readData(kotlinClass, KotlinClassHeader.Kind.PACKAGE_FACADE);
        if (data2 != null) {
            PackageData packageData = JvmProtoBufUtil.readPackageDataFrom(data2);
            return new DeserializedPackageMemberScope(descriptor2, packageData.getPackageProto(), packageData.getNameResolver(), this.components, (Function0<? extends Collection<? extends Name>>)new Function0<Collection<Name>>(){

                @Override
                public Collection<Name> invoke() {
                    return Collections.emptyList();
                }
            });
        }
        return null;
    }

    @Nullable
    public String[] readData(@NotNull KotlinJvmBinaryClass kotlinClass, @NotNull KotlinClassHeader.Kind expectedKind) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "readData"));
        }
        if (expectedKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedKind", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "readData"));
        }
        KotlinClassHeader header = kotlinClass.getClassHeader();
        if (!header.getIsCompatibleAbiVersion()) {
            this.errorReporter.reportIncompatibleAbiVersion(kotlinClass.getClassId(), kotlinClass.getLocation(), header.getVersion());
        } else if (header.getKind() == expectedKind) {
            return header.getAnnotationData();
        }
        return null;
    }
}

