/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage$psiUtils$dd8f5ed3;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class DiagnosticsPackage$PositioningStrategy$60060ed7 {
    @NotNull
    public static final List<TextRange> markElement(@JetValueParameter(name="element") @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        return KotlinPackage.listOf(new TextRange(DiagnosticsPackage$PositioningStrategy$60060ed7.getStartOffset(element), DiagnosticsPackage$PositioningStrategy$60060ed7.getEndOffset(element)));
    }

    @NotNull
    public static final List<TextRange> markNode(@JetValueParameter(name="node") @NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        PsiElement psiElement = node.getPsi();
        Intrinsics.checkExpressionValueIsNotNull(psiElement, "node.getPsi()");
        return DiagnosticsPackage$PositioningStrategy$60060ed7.markElement(psiElement);
    }

    @NotNull
    public static final List<TextRange> markRange(@JetValueParameter(name="range") @NotNull TextRange range) {
        Intrinsics.checkParameterIsNotNull(range, "range");
        return KotlinPackage.listOf(range);
    }

    @NotNull
    public static final List<TextRange> markRange(@JetValueParameter(name="from") @NotNull PsiElement from, @JetValueParameter(name="to") @NotNull PsiElement to) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(to, "to");
        return DiagnosticsPackage$PositioningStrategy$60060ed7.markRange(new TextRange(DiagnosticsPackage$PositioningStrategy$60060ed7.getStartOffset(from), DiagnosticsPackage$PositioningStrategy$60060ed7.getEndOffset(to)));
    }

    public static final int getStartOffset(@JetValueParameter(name="element") @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        PsiElement child = element.getFirstChild();
        if (child != null) {
            while (child instanceof PsiComment || child instanceof PsiWhiteSpace) {
                child = child.getNextSibling();
            }
            if (child != null) {
                return DiagnosticsPackage$PositioningStrategy$60060ed7.getStartOffset(child);
            }
        }
        return PsiUtilPackage$psiUtils$dd8f5ed3.getStartOffset(element);
    }

    public static final int getEndOffset(@JetValueParameter(name="element") @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        PsiElement child = element.getLastChild();
        if (child != null) {
            while (child instanceof PsiComment || child instanceof PsiWhiteSpace) {
                child = child.getPrevSibling();
            }
            if (child != null) {
                return DiagnosticsPackage$PositioningStrategy$60060ed7.getEndOffset(child);
            }
        }
        return PsiUtilPackage$psiUtils$dd8f5ed3.getEndOffset(element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasSyntaxErrors(@JetValueParameter(name="psiElement") @NotNull PsiElement psiElement) {
        Intrinsics.checkParameterIsNotNull(psiElement, "psiElement");
        if (psiElement instanceof PsiErrorElement) {
            return true;
        }
        PsiElement[] children = psiElement.getChildren();
        if (!KotlinPackage.isNotEmpty((Object[])children)) return false;
        PsiElement psiElement2 = (PsiElement)KotlinPackage.last((Object[])children);
        Intrinsics.checkExpressionValueIsNotNull(psiElement2, "children.last()");
        if (!DiagnosticsPackage$PositioningStrategy$60060ed7.hasSyntaxErrors(psiElement2)) return false;
        return true;
    }
}

